<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Transactions;
use DB;
use Session;
use App\User;
use Illuminate\Routing\Redirector;

class FrontDashboardController extends Controller {

    public function index() {
        try{
            //return view('front.dashboard.index');
            $userId=getUserId();
            $deviceId=getDeviceId();
            $parameters = array("userId" => $userId, "deviceId" => $deviceId);
            $response = getRequestAPI('getProductCategory', $parameters);
      //            dd($response);
      // return redirect('/loginUser')->with('error', 'Please auth!!');
         //   return redirect()->route('loginUser');
          //  setCookie2(config('constants.CART_ITEM_COOKIE_NAME'), base64_encode($response['Result']['cartItemCount']), strtotime(config('constants.CART_ITEM_COOKIE_EXPIRY_TIME')));
            if($response['Status'] == 400){
                return view('front.dashboard.error')->with('message', $response['Message']);
            }
            else
            {
                return view('front.dashboard.index')->with('data', $response['Result']);
            }

      //   $this->redirectToLoginPage();
        }
        catch (Exception $ex)
        {
            return redirect()->back()->with('error', trans('messages.something_went_wrong'));
        }

    }

    public function redirectToLoginPage(Redirector $redirect){
      //  echo ';;;';die;
     //  return redirect()->route('loginUser');
      //  return view('front.dashboard.index')->with('data', array());
         if($response['Status'] == 400){
                return view('front.dashboard.error')->with('message', $response['Message']);
            }
            else
            {
                $redirect->to('loginUser')->send();
            }


    }

    public function menu() {
        try{
            //return view('front.dashboard.index');
            $userId=getUserId();
            $deviceId=getDeviceId();
            $parameters = array("userId" => $userId, "deviceId" => $deviceId);
            $response = getRequestAPI('getProductCategory', $parameters);
          // return redirect('/loginUser')->with('error', 'Please auth!!');
         //   return redirect()->route('loginUser');
         //   setCookie2(config('constants.CART_ITEM_COOKIE_NAME'), base64_encode($response['Result']['cartItemCount']), strtotime(config('constants.CART_ITEM_COOKIE_EXPIRY_TIME')));
            if($response['Status'] == 400){
                return view('front.dashboard.error')->with('message', $response['Message']);
            }
            else
            {
                return view('front.dashboard.menu')->with('data', $response['Result']);
            }
         //   $this->redirectToLoginPage();
        }
        catch (Exception $ex)
        {
            return redirect()->back()->with('error', trans('messages.something_went_wrong'));
        }

    }
  /**
   * Function used to fetch details of About Us
   *
   * @return Json
   */
  public function getAboutUsDetails() {
    try {
      $parameters = array();
      $response = getRequestAPI('aboutUs', $parameters);

      if ($response['Status'] == 200 && $response['Success'] == true) {
        return response()->json(['success' => $response['Result']]);
      } else {
        return response()->json(['errors' => $response['Message']]);
      }
    } catch (\Exception $ex) {
      return response()->json(['error' => $ex->getMessage()]);
    }
  }
  /**
   * Function used to fetch details of Terms And Conditions
   *
   * @return Json
   */
  public function getTermsCons() {
    try {
      $parameters = array('pageId' => '1');
      $response = getRequestAPI('pages', $parameters);

      if ($response['Status'] == 200 && $response['Success'] == true) {
      return response()->json(['success' => $response['Result']]);
      } else {
      return response()->json(['errors' => $response['Message']]);
      }
    } catch (\Exception $ex) {
      return response()->json(['error' => $ex->getMessage()]);
    }
  }

}
