<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ProductController extends Controller {

  public function getSubCategory($id) {
    try {
      $categoryId = base64_decode($id);
      $parameters = array("categoryId" => $categoryId);
      $response = getRequestAPI('getProductSubCategory', $parameters);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.subCategory')->with(['data' => $response['Result'], 'categoryId' => $id]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  public function productOrderOption($catId, $subCatId, $pageNo = 1) {
    try {
      if (!ctype_digit($pageNo) || $pageNo == 0) {
        $pageNo = 1;
      }
      $url = "productOrder";
      $previous = $pageNo - 1;
      $next = $pageNo + 1;
      $catId1 = base64_decode($catId);
      $subCatId1 = base64_decode($subCatId);
      $parameters = array("catId" => $catId1, "subCatId" => $subCatId1, 'page' => $pageNo);
      $response = getRequestAPI('getProducts', $parameters);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.productOrderOption')->with(['data' => $response['Result'], "catId" => $catId, "subCatId" => $subCatId, "url" => $url, "previous" => $previous, "next" => $next]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  public function getProductDetails($productId, Request $request) {
    try {
      if ($request->has('d') && $request->d != '') {
        $dealId = base64_decode($request->d);
      } else {
        $dealId = 0;
      }
      $productId = base64_decode($productId);
      $userId = getUserId();
      $parameters = array("productId" => $productId, "userId" => $userId, "dealId" => $dealId);
      $response = getRequestAPI('getProductDetails', $parameters);
//      dd($response);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.productDetails')->with(['data' => $response['Result'], 'productId' => $productId]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  public function getFeaturedProducts($pageNo = 1) {
    try {
      if (!ctype_digit($pageNo) || $pageNo == 0) {
        $pageNo = 1;
      }
      $url = "featuredProduct";
      $previous = $pageNo - 1;
      $next = $pageNo + 1;
      $parameters = array("page" => $pageNo);
      $response = getRequestAPI('featuredProducts', $parameters);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.featuredProducts')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  public function addFeaturedProductToCart($id) {
    try {
      $productId = base64_decode($id);
      $userId = getUserId();
      $parameters = array("productId" => $productId, "userId" => $userId, "dealId" => 0);
      $response = getRequestAPI('getProductDetails', $parameters);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.productDetails')->with(['data' => $response['Result'], 'productId' => $productId]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  /**
   * Function used to fetch all the gallery items
   * @param Request $request
   * @return Illuminate\Http\Response
   */
  public function fetchGallery($pageNo = 1) {
    try {
      if (!ctype_digit($pageNo) || $pageNo == 0) {
        $pageNo = 1;
      }
      $url = "gallery";
      $previous = $pageNo - 1;
      $next = $pageNo + 1;
      $parameters = array("page" => $pageNo);
      $response = getRequestAPI('gallery', $parameters);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        return view('front.product.gallery')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  /**
   * Function used to fetch all the deals available
   * @param Request $request
   * @return Illuminate\Http\Response
   */
  public function fetchDeals($pageNo = 1) {
    try {
      if (!ctype_digit($pageNo) || $pageNo == 0) {
        $pageNo = 1;
      }
      $url = "deal";
      $previous = $pageNo - 1;
      $next = $pageNo + 1;
      $parameters = array("page" => $pageNo);
//      $parameters = array("page" => '2');
      $response = getRequestAPI('dealsList', $parameters);

//      dd($response);
      if ($response['Status'] == 400) {
        return view('front.dashboard.error')->with('message', $response['Message']);
      } else {
        if (isset($response["Result"])) {
          return view('front.product.deal')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
        } else {
          $response['Result'] = [];
          return view('front.product.deal')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
        }
      }
    } catch (Exception $ex) {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
  }

  /**
   * Function used to fetch the details of a gallery
   * @param Request $request
   * @return Illuminate\Http\Response
   */
  public function fetchGalleryDetail(Request $request) {
    if ($request->has('data') && $request->data != '') {
      $galleryDetail = unserialize($request->data);
//      dd($galleryDetail);
      return view('front.product.galleryDetail')->with(['data' => $galleryDetail]);
    } else {
      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
    }
//    return view('front.product.galleryDetail');
  }

  public function fetchGiftcard(Request $request) {
//      try {
    if ($request->has('pageNo') && $request->pageNo != '') {
      if ($request->pageNo == '0') {
        $pageNo = 1;
      } else {
        $pageNo = $request->pageNo;
      }
      //on ajax call
//**************************************************************************
      try {

//        $url = "giftcards";
//        $previous = $pageNo - 1;
        $next = $pageNo + 1;
//        $userId = getUserId();

        $parameters = array("page" => $pageNo);
        $response = getRequestAPI('getGiftCardList', $parameters);

        if ($response['Status'] == 200 && $response['Success'] == true) {
          return response()->json(['success' => $response['Result'], "next" => $next, 'page' => $pageNo]);
        } else {
          return response()->json(['errors' => $response['Message']]);
        }
      } catch (\Exception $ex) {
        return response()->json(['error' => $ex->getMessage()]);
      }
//**************************************************************************
    } else {
      $pageNo = 1;
      //on direct call
//*********************************************************
      try {
        if (!ctype_digit($pageNo) || $pageNo == 0) {
          $pageNo = 1;
        }
        $url = "giftcards";
        $previous = $pageNo - 1;
        $next = $pageNo + 1;
        $parameters = array("page" => $pageNo);
//      $parameters = array("page" => '2');
        $response = getRequestAPI('getGiftCardList', $parameters);
//      dd($response);

        if ($response['Status'] == 400) {
          return view('front.dashboard.error')->with('message', $response['Message']);
        } else {
          if (isset($response["Result"])) {
            return view('front.product.giftcard')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
          } else {
            $response['Result'] = [];
            return view('front.product.giftcard')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
          }
        }
      } catch (Exception $ex) {
        return redirect()->back()->with('error', trans('messages.something_went_wrong'));
      }
//**************************************************************************
    }
  }

//  public function fetchGiftcard($pageNo = 1) {
//
//    try {
//      if (!ctype_digit($pageNo) || $pageNo == 0) {
//        $pageNo = 1;
//      }
//      $url = "deal";
//      $previous = $pageNo - 1;
//      $next = $pageNo + 1;
//      $parameters = array("page" => $pageNo);
////      $parameters = array("page" => '2');
//      $response = getRequestAPI('getGiftCardList', $parameters);
////      dd($response);
//
//      if ($response['Status'] == 400) {
//        return view('front.dashboard.error')->with('message', $response['Message']);
//      } else {
//        if (isset($response["Result"])) {
//          return view('front.product.giftcard')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
//        } else {
//          $response['Result'] = [];
//          return view('front.product.giftcard')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
//        }
//      }
//    } catch (Exception $ex) {
//      return redirect()->back()->with('error', trans('messages.something_went_wrong'));
//    }
//  }
}
