<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;

class UserController extends Controller {

    public function performActionProductDetails(Request $request) {
        try {
            //   echo 'radio='. $radio = $request->input('radio');

            $addToFavourite = $request->input('add_to_favourite');
            $addToCart = $request->input('add_to_cart');
            $productId = base64_encode($request->input('id'));
            if (isset($addToFavourite)) {
                $response = $this->addToFavourite($request);
                if ($response) {
                    //   print_r($response);
                    if ($response === 2) {
                        //****  guest user cannot mark product as favourite  ****//
                        return redirect('user/productDetails/' . $productId)->with('error', trans('messages.guest_user_cant_add_favourite_product'));
                    } else if ($response == 3) {
                        return view('front.dashboard.error')->with('message', trans('messages.something_went_wrong'));
                    } else {
                        return redirect('user/favouriteProduct')->with('success', trans('messages.product_added_as_favourite'));
                    }
                } else {
                    return redirect()->back()->with('error', trans('messages.something_went_wrong'));
                }
            } else if (isset($addToCart)) {
                $response = $this->addToCart($request);
                if ($response) {
                    if ($response == 2) {
                        return redirect('user/cart')->with('success', trans('messages.something_went_wrong'));
                    } else {
                        return redirect('user/cart')->with('success', trans('messages.product_added_to_cart'));
                    }
                } else {
                    return redirect()->back()->with('error', trans('messages.something_went_wrong'));
                }
            } else {
                return redirect()->back()->with('error', trans('messages.something_went_wrong'));
            }
        } catch (Exception $ex) {
            return redirect()->back()->with('error', trans('messages.something_went_wrong'));
        }
    }

    public function addToFavourite(Request $request) {
        try {
            $productId = $request->input('id');
            $userId = getUserId();
            if (!$userId) {
                return 2;  //****  guest user cannot mark product as favourite  ****//
            } else {
                $status = 1;
                $parameters = array("productId" => $productId, "userId" => $userId, "status" => $status);
                $response = postRequestAPI('favUnFavProduct', $parameters);
                if ($response['Status'] == 400) {
                    return 3;
                } else {
                    return 1;
                }
            }
        } catch (Exception $ex) {
            return false;
        }
    }

    public function addToCart(Request $request) {
        try {
            $json = array();
            $data = array();
            $cartData = array();
            $additionalItemsArray = array();
            $extraItemsArray = array();
            $customizeItemsArray = array();
            $quantity = 1;
            $deviceId = getDeviceId();
            $dealId = "0";
            $userId = getUserId();
            $additionalTotalCost = 0;
            $optionalTotalCost = 0;
            $productId = (integer) $request->input('id');
            $parameters = array('productId' => $productId, 'userId' => $userId, 'dealId' => 0);
            $response = getRequestAPI('getProductDetails', $parameters);
            if ($response['Status'] == 400) {
                return 2;
            }

            $response = $response['Result'];
            $productDetail = $response['productDetail'];
            $additionalItemsDetail = $response['additionalItems'];
            $extraItemsDetail = $response['topextraItems'];
            $customizeTopLabelOptions = $response['customizeTopLabelOptions'];
            $customizeOptionsWithPrice = $response['verticalCustomizeOptionsWithPrice'];
            $basicProductCost = (integer) $productDetail['price'];
            $additionalItems = $request->input('additionalItems');

            if (is_array($additionalItems) && is_array($additionalItemsDetail)) {
                //****  finding price and other details of additional items selected by user  ****//
                foreach ($additionalItems as $selectedItems) {
                    //****  loop for selected additional items from client  ****//
                    foreach ($additionalItemsDetail as $items) {
                        //****  loop for all additional items for product  ****//
                        if ($selectedItems == $items['additionalProductId']) {
                            $additionalTotalCost += $items['price'];
                            $array = array('additionalProductId' => $items['additionalProductId'], 'price' => $items['price'], 'itemName' => $items['itemName']);
                            array_push($additionalItemsArray, $array);
                            break;
                        }
                    }
                }
            }


            $extraItems = $request->input('extraItems');
            if (is_array($extraItems) && is_array($extraItemsDetail)) {
                //****  finding price and other details of extra items  ****//
                foreach ($extraItems as $selectedItems) {
                    //****  loop for selected additional items from client  ****//
                    if ($selectedItems != 0) {
                        //****  checking if item is selected by user ****//
                        foreach ($extraItemsDetail as $items) {
                            //****  loop for all extra items for product  ****//
                            foreach ($items['labelOptions'] as $options) {
                                //****  loop for options of each extra item  ****//
                                if ($selectedItems == $options['labelOptionId']) {
                                    $optionalTotalCost += $options['price'];
                                    $array = array('labelNames' => $items['labelNames'], 'labelOption' => $items['labelOption'], 'labelType' => $items['labelType'], 'topLabelId' => $items['topLabelId'], 'labelOptions' => array("labelOptionId" => $options["labelOptionId"], "labelId" => $options["labelId"], "optionName" => $options["optionName"], "price" => $options["price"]));
                                    array_push($extraItemsArray, $array);
                                    break 2; //break from 2 foreach loops
                                }
                            }
                        }
                    }
                }
            }

            $customizeItems = $request->input('customizeItems');
            if (is_array($customizeOptionsWithPrice)) {
                //****  finding details of customize options selected by user  ****//

                foreach ($customizeOptionsWithPrice as $allOptions) {
                    // echo '1';
                    //****  loop for all customized options available  ****//
                    $selectedOption = array();
                    $array = array();
                    $array2 = array('custlabelOptionId' => $allOptions['custlabelOptionId'], 'labelNames' => $allOptions['labelNames']);
                    $j = 0;
                    $count = count($allOptions['prices']);
                    foreach ($allOptions['prices'] as $optionPrice) {
                        //****  loop for each checkbox option  ****//
                        // echo '2';
                        $j++;
                        $isSelected = 0;
                        if (is_array($customizeItems) && count($customizeItems) > 0) {
                            //  echo 'eeeeeeeeeeeeeee';
                            foreach ($customizeItems as $selectedOptions) {
                                //****  loop for selected options by user   ****//
                                //      echo '3';
                                $optionValue = $allOptions['custlabelOptionId'] . '-' . $optionPrice['labelNames'];
                                //     echo 'selected = '.$selectedOptions.' found='.$optionValue;
                                if ($optionValue == $selectedOptions) {
                                    //****  checking if user selected checkbox  ****//
                                    //   echo 'y';
                                    $isSelected = 1;
                                    array_push($selectedOption, array('labelNames' => $optionPrice['labelNames'], 'isSelected' => $isSelected));
                                    //   echo '<pre>';print_r($selectedOption);
                                    break;
                                    //array_push($selectedOption, array("labelNames" => $optionPrice['labelNames'], "isSelected" => 1));
                                }

                                //     break;
                                // else{
                                //array_push($selectedOption, array("labelNames" => $optionPrice['labelNames'], "isSelected" => 0));
                                //  }
                            }
                            if ($isSelected == 0) {
                                //   echo 'n';
                                array_push($selectedOption, array('labelNames' => $optionPrice['labelNames'], 'isSelected' => $isSelected));
                                //    echo '<pre>';print_r($selectedOption);
                                //   echo 'complete';
                            }
                        } else {
                            //  echo 'aqqqqqqqqqqqqqqqqq';
                            array_push($selectedOption, array('labelNames' => $optionPrice['labelNames'], 'isSelected' => $isSelected));
                        }

                        //array_push($selectedOption, array("labelNames" => $optionPrice['labelNames'], "isSelected" => $isSelected));
                        // $array['selectedOption']=$selectedOption;
                        //  echo 'finish<pre>';print_r($selectedOption);
                        //  echo 'insert444444444';

                        if ($j == $count) {
                            //$selectedOptionArray = array("selectedOption" => $selectedOption);
                            //array_push($array2, $selectedOptionArray);
                            $array2['selectedOption'] = $selectedOption;
                            //   echo '9999999999999';
                            //  echo '<pre>';print_r($array2);
                            // array_push($array, $array2);
                            // echo '<pre>';print_r($array);
                            array_push($customizeItemsArray, $array2);
                        }
                    }
                    // echo '3333333333';
                }
                //array_push($customizeItemsArray, $array);
            }

            //    $productDetail['dealId'] = $dealId;
            $data['orderItemDetail'] = $productDetail;
            $data['additionalItems'] = $additionalItemsArray;
            $data['topextraItems'] = $extraItemsArray;
            $data['customizeTopLabelOptions'] = $customizeTopLabelOptions;
            $data['verticalCustomizeOptionsWithPrice'] = $customizeItemsArray;
            $json['data'] = $data;
            $subTotal = $basicProductCost + $additionalTotalCost + $optionalTotalCost;


//            $cartData['json'] = $json;
//            $cartData['dealId'] = $dealId;
//            $cartData['deviceId'] = $deviceId;
//            $cartData['quantity'] = $quantity;
//            $cartData['userId'] = $userId;
//            $cartData['additionalTotal'] = $additionalTotalCost;
//            $cartData['optionalTotal'] = $optionalTotalCost;
//            $cartData['basicProductCost'] = $basicProductCost;
//            $cartData['productId'] = $productId;
//            $cartData['subTotal'] = $subTotal;
            //  echo '<pre>';print_r($cartData);
            // dd($response);
            //  dd(request()->all());
            // echo 'ggggggg'.gettype($subTotal);
            $cartJSON_Data = json_encode($json);
            $parameters = array('productId' => $productId, 'userId' => $userId, 'json' => $cartJSON_Data, 'quantity' => $quantity, 'basicProductCost' => $basicProductCost, 'optionalTotal' => $optionalTotalCost, 'additionalTotal' => $additionalTotalCost, 'subTotal' => $subTotal, 'deviceId' => $deviceId, 'dealId' => $dealId);
            $response = postRequestAPI('addItemToCart', $parameters);
            if ($response['Status'] == 400) {
                return 2;
            } else {
                return 1;
            }
        } catch (Exception $ex) {
            return false;
        }
    }

    public function getFavouriteProduct(Request $request, $pageNo = 1) {
        try {
            if (!ctype_digit($pageNo) || $pageNo == 0) {
                $pageNo = 1;
            }
            $url = "favouriteProduct";
            $previous = $pageNo - 1;
            $next = $pageNo + 1;
            $userId = getUserId();
            $parameters = array("userId" => $userId, "page" => $pageNo);
            $response = getRequestAPI('favouriteProducts', $parameters);
            if ($response['Status'] == 400) {
                return view('front.dashboard.error')->with('message', $response['Message']);
            } else {
                return view('front.user.favouriteProducts')->with(['data' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next]);
            }
        } catch (Exception $ex) {
            return redirect()->back()->with('error', trans('messages.something_went_wrong'));
        }
    }

    public function userCart(Request $request) {
        $userId = getUserId();
        $deviceId = getDeviceId();
        $parameters = array("userId" => $userId, "deviceId" => $deviceId);
        $response = getRequestAPI('getCartItemList', $parameters);
        if ($response['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $response['Message']);
        }

        // dd($response['Result']);

        if (count($response['Result']['data']) > 0) {
            $productId = '';
            foreach ($response['Result']['data'] as $product) {
                $productId = $productId . $product['jsonData']['data']['orderItemDetail']['productId'] . ',';
            }
            $productId = rtrim($productId, ',');
        } else {
            $productId = 0;   //since some ID is required
        }
        $pageNo = 1;

        $parameters = array("productId" => $productId, "pageNo" => $pageNo);
        $response2 = getRequestAPI('getSuggestedProducts', $parameters);
        if ($response2['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $response2['Message']);
        } else {
            return view('front.user.usercart')->with(['data' => $response['Result'], 'data2' => $response2['Result']]);
            // return view('front.user.cart')->with(['data' => $response['Result'], 'data2' => $response2['Result']]);
        }
    }

    public function updateCartItemCount(Request $request) {
        try {
//            $validator = Validator::make($request->all(), [
//                'orderItemId' => 'required|integer',
//                'quantity' => 'required|integer',
//            ]);
//
//            if($validator->fails()){
//                echo 0;
//            }
//            else
//            {
            $productId = (integer) base64_decode($request->input('orderItemId'));
            $quantity = (integer) $request->input('quantity');
            //}

            $userId = getUserId();
            $deviceId = getDeviceId();
            $parameters = array("orderItemId" => $productId, "userId" => $userId, "deviceId" => $deviceId, "quantity" => $quantity);
            $response = putRequestAPI('updateCartItem', $parameters);
            if ($response['Status'] == 400) {
                $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
                echo json_encode($array);
            } else {
                echo json_encode($response);
            }
        } catch (Exception $ex) {
            $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
            echo json_encode($array);
        }
    }

    public function deleteCartItem(Request $request) {
        try {
            $itemId = (integer) base64_decode($request->input('orderItemId'));
            $userId = getUserId();
            $deviceId = getDeviceId();
            $parameters = array("orderItemId" => $itemId, "userId" => $userId, "deviceId" => $deviceId);
            $response = putRequestAPI('deleteCartItem', $parameters);
            if ($response['Status'] == 400) {
                $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
                echo json_encode($array);
            } else {
                echo json_encode($response);
            }
        } catch (Exception $ex) {
            $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
            echo json_encode($array);
        }
    }

    public function getCartItemDetails($id) {
        $id = base64_decode($id);
        $userId = getUserId();
        $deviceId = getDeviceId();
        $parameters = array("userId" => $userId, "deviceId" => $deviceId);
        $response = getRequestAPI('getCartItemList', $parameters);
        if ($response['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $response['Message']);
        }

        $cartItemData = $response['Result']['data'];
        if (count($cartItemData) > 0) {
            foreach ($cartItemData as $itemDetails) {
                if ($itemDetails['orderItemId'] == $id) {
                    return view('front.user.cartItemDetails')->with(['data' => $itemDetails['jsonData']['data']]);
                    break;
                }
            }
            return redirect()->back()->with('error', trans('messages.item_not_found_in_cart'));
        } else {
            return redirect()->back()->with('error', trans('messages.item_not_found_in_cart'));
        }
    }

    /**
     * Function used to remove a product from Favourite products list
     * @param Request $request
     * @return Json
     */
    public function removeFromFavourite(Request $request) {

        if ($request->has('prodId') && $request->prodId != '') {
            try {
                $productId = $request->prodId;
                $userId = getUserId();
                $status = 0; //unfavourite the product
                $parameters = array("productId" => $productId, "userId" => $userId, "status" => $status);
                $response = postRequestAPI('favUnFavProduct', $parameters);

                if ($response['Status'] == 200 && $response['Success'] == true) {
                    $request->session()->flash('success', $response['Message']);
                    return response()->json(['success' => $response['Message']]);
                } else {
                    $request->session()->flash('error', $response['Message']);
                    return response()->json(['errors' => $response['Message']]);
                }
            } catch (\Exception $ex) {
                $request->session()->flash('error', $ex->getMessage());
                return response()->json(['error' => $ex->getMessage()]);
            }
        } else {
            $request->session()->flash('error', 'No id found');
            return response()->json(['error' => 'No id found']);
        }
    }

    /**
     * Function used to send feedback to the user
     * @param Request $request
     * @return Json
     */
    public function sendFeedback(Request $request) {
        $rules = array(
            'email' => 'required|email',
            'feedback' => 'required'
        );
        $messages = array(
            'email.required' => 'The email field is required.',
            'feedback.required' => 'The feedback field is required.'
        );
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->all()]);
        } else {
            try {
                $email = $request->email;
                $feedback = $request->feedback;
                $parameters = array("email" => $email, "feedback" => $feedback);
                $response = postRequestAPI('userFeedback', $parameters);

                if ($response['Status'] == 200 && $response['Success'] == true) {
                    $request->session()->flash('success', $response['Message']);
                    return response()->json(['success' => $response['Message']]);
                } else {
                    return response()->json(['error' => $response['Message']]);
                }
            } catch (\Exception $ex) {
                return response()->json(['fbError' => $ex->getMessage()]);
            }
        }
    }

    public function applyPromoCheck(Request $request) {
        try {
            if ($request->session()->has('id')) {
                $code = $request->input('code');
                $type = $request->input('type');
                $userId = getUserId();
                $userMail = session('email');
                $parameters = array("code" => $code, "userId" => $userId, "type" => $type, "userMail" => $userMail);
                $response = postRequestAPI('giftCardpromoCheck', $parameters);
                if ($response['Status'] == 400) {
                    $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
                    echo json_encode($array);
                } else if ($response["Status"] == 409) {
                    echo json_encode($response);
                } else {
                    echo json_encode($response);
                }
            } else {
                $array = array("Success" => false, "Status" => 401, "Message" => trans('messages.something_went_wrong'));
                echo json_encode($array);
            }
        } catch (Exception $ex) {
            $array = array("Success" => false, "Status" => 400, "Message" => trans('messages.something_went_wrong'));
            echo json_encode($array);
        }
    }

    /**
     * Function used to get the details of a user
     * @param Request $request
     * @return Json
     */
    public function getMyAccountDetails(Request $request) {
        try {
            $userId = getUserId();
            $deviceToken = getDeviceToken();
            $parameters = array("userId" => $userId, "deviceToken" => $deviceToken);
            $response = getRequestAPI('myAccount', $parameters);

            if ($response['Status'] == 200 && $response['Success'] == true) {
                return response()->json(['success' => $response['Result'][0]]);
            } else {
                return response()->json(['errors' => $response['Message']]);
            }
        } catch (\Exception $ex) {
            return response()->json(['error' => $ex->getMessage()]);
        }
    }

    /**
     * Function used to change the password of a user
     * @param Request $request
     * @return Json
     */
    public function changePassword(Request $request) {
        $rules = array(
            'old_pwd' => 'required|min:8',
            'new_pwd' => 'required|min:8',
            'conf_pwd' => 'required|same:new_pwd'
        );
        $messages = array(
            'old_pwd.required' => 'The old password field is required.',
            'old_pwd.min' => 'The old password must be at least 8 characters',
            'new_pwd.required' => 'The new password field is required.',
            'new_pwd.min' => 'The new password must be at least 8 characters',
            'conf_pwd.required' => 'The confirm password field is required.',
            'conf_pwd.same' => 'The confirm password and new password must match.'
        );
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->all()]);
        } else {
            $parameters = array(
                'userId' => getUserId(),
                'oldPassword' => $request->old_pwd,
                'newPassword' => $request->new_pwd
            );
            $response = postRequestAPI('changePassword', $parameters);
            if ($response['Status'] == 200 && $response['Success'] == true) {
                $data = $response['Result'];
                $request->session()->flash('success', $response['Message']);
                return response()->json(['success' => $data]);
            } else {
                return response()->json(['pwdError' => $response['Message']]);
            }
        }
    }

    /**
     * Function used to update a user profile
     * @param Request $request
     * @return Json
     */
    public function updateProfile(Request $request) {
        $rules = array(
            'f_name' => 'required',
            'l_name' => 'required',
            'dob' => 'required|date_format:"Y-m-d"'
        );
        $messages = array(
            'f_name.required' => 'The first name field is required.',
            'l_name.required' => 'The last name field is required.',
            'dob.required' => 'The birthday field is required.'
        );
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->all()]);
        } else {
            $parameters = array(
                'userId' => getUserId(),
                'firstName' => $request->f_name,
                'lastName' => $request->l_name,
                'dob' => $request->dob,
                'profilePic' => ''
            );
            $response = postRequestAPI('updateProfile', $parameters);
            if ($response['Status'] == 200 && $response['Success'] == true) {
                $data = $response['Result'];
                $request->session()->flash('success', $response['Message']);
                return response()->json(['success' => $data, 'msg' => $response['Message']]);
            } else {
                return response()->json(['epfError' => $response['Message']]);
            }
        }
    }

    /**
     * Function used to get the notifications of the user
     * @param Request $request
     * @return Json
     */
    public function fetchNotifications(Request $request) {
        try {
            if ($request->has('pageNo') && $request->pageNo != '') {
                if ($request->pageNo == '0') {
                    $pageNo = 1;
                } else {
                    $pageNo = $request->pageNo;
                }
            } else {
                $pageNo = 1;
            }
            $url = "orderHistory";
            $previous = $pageNo - 1;
            $next = $pageNo + 1;
            $userId = getUserId();

            $parameters = array("userId" => $userId, "page" => $pageNo);
            $response = getRequestAPI('getNotifications', $parameters);

            if ($response['Status'] == 200 && $response['Success'] == true) {
                return response()->json(['success' => $response['Result'], "url" => $url, "previous" => $previous, "next" => $next, 'page' => $pageNo]);
            } else {
                return response()->json(['errors' => $response['Message']]);
            }
        } catch (\Exception $ex) {
            return response()->json(['error' => $ex->getMessage()]);
        }
    }

    /**
     * Function used to clear all the notifications of a user
     * @return Json
     */
    public function clearNotifications() {
        try {
            $userId = getUserId();
            $parameters = array("userId" => $userId);
            $response = postRequestAPI('notificationDelete', $parameters);

            if ($response['Status'] == 200 && $response['Success'] == true) {
                return response()->json(['success' => $response['Result']]);
            } else {
                return response()->json(['errors' => $response['Message']]);
            }
        } catch (\Exception $ex) {
            return response()->json(['error' => $ex->getMessage()]);
        }
    }

    public function deliveryType(Request $request) {
        $userId = getUserId();
        $deviceId = getDeviceId();
        return view('front.user.deliveryType')->with([]);
    }

    public function userAddress(Request $request) {
        //saveUserAddress api to save new address
        $userId = getUserId();
        $deviceId = getDeviceId();
        $parameters = array("userId" => $userId, "deviceId" => $deviceId);
        $response = getRequestAPI('getUserAddressList', $parameters);
        if ($response['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $response['Message']);
        }
        $cartResponse = getRequestAPI('getCartItemList', $parameters);
        if ($cartResponse['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $cartResponse['Message']);
        }
        $userResponse = getRequestAPI('myAccount', $parameters);
        if ($userResponse['Status'] == 400) {
            return view('front.dashboard.error')->with('message', $userResponse['Message']);
        }
//        echo "<pre>";        print_r($userResponse); exit;
        return view('front.user.userAddress')->with(['data' => $response['Result'],'order'=>$cartResponse['Result'],'user'=>$userResponse['Result']]);
    }

    public function updatedeliveryType(Request $request) {
        $deliveryType = $request->input('deliveryType');
        // $_SESSION['deliveryType']=$deliveryType;
        $request->session()->put('deliveryType', $request);
        echo $deliveryType;
        exit;
    }

}
