<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Validator;
use Auth;

class UserLoginController extends Controller {

  public function showLogin(Request $request) {
    if ($request->session()->has('id')) {
      return redirect('user/home');
    } else {
      return view('front.login.index');
    }
  }

  public function showLogin2(Request $request) {

    return view('front.login.index');
  }

  public function doLogin(Request $request) {
    $validator = Validator::make($request->all(), [
          'email' => 'required|email',
          'password' => 'required',
    ]);

    if ($validator->fails()) {
      return redirect()->back()->with("signInError", $validator->errors()->first());
    } else {
      $userId = getUserId();
      $deviceId = getDeviceId();
      $email = $request->input('email');
      $password = $request->input('password');
      // $deviceToken=config('constants.USER_DEVICE_TOKEN');
      $deviceToken = getDeviceToken();
      $deviceType = config('constants.USER_DEVICE_TYPE');
      $parameters = array("email" => $email, "password" => $password, 'userId' => $userId, 'deviceId' => $deviceId, 'deviceType' => $deviceType, 'deviceToken' => $deviceToken);
      $response = postRequestAPI('signIn', $parameters);
      if($response['Status'] == 400){
            return redirect()->back()->with("signInError", $response['Message']);
        }

      if ($response['Status'] == 200 && $response['Success'] == true) {
        $data = $response['Result'][0];
        $request->session()->put('id', $data['userId']);
        $request->session()->put('email', $data['email']);
        $request->session()->put('name', $data['firstName'] . ' ' . $data['lastName']);
        $request->session()->put('membershipId', $data['membershipId']);
        $request->session()->put('rewardPoints', $data['rewards']);
        return redirect('user/home');
      } else {
        return redirect()->back()->with("signInError", $response['Message']);
      }
    }
  }

  public function userLogout(Request $request) {
    Auth::logout();
    $request->session()->flush();
    return redirect('user/login');
  }

  /**
   * Function used to register a new user through signup form
   * @param Request $request
   * @return Json
   * @author TechAhead
   */
  public function doRegister(Request $request) {
    $rules = array('f_n' => 'required',
        'l_n' => 'required',
        'dob' => 'required|date',
        'mob' => 'required|numeric',
        'email' => 'required|email',
        'pwd' => 'required|min:8',
        'c_pwd' => 'required|same:pwd',
        'c_code' => 'required'
    );
    $messages = array(
        'f_n.required' => 'The first name field is required.',
        'l_n.required' => 'The last name field is required.',
        'dob.required' => 'The birthday field is required.',
        'email.required' => 'The email field is required.',
        'email.email' => 'The email field should be of type email.',
        'mob.required' => 'The mobile no. field is required.',
        'mob.numeric' => 'The mobile no. field should be numeric',
        'pwd.required' => 'The password field is required.',
        'pwd.min' => 'The password must be at least 8 characters',
        'c_pwd.required' => 'The confirm password field is required.',
        'c_pwd.same' => 'The confirm password and password must match.',
        'c_code.required' => 'The country code field is required.'
    );
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
      return response()->json(['error' => $validator->errors()->all()]);

    } else {
      $parameters = array('firstName' => $request->f_n,
          'lastName' => $request->l_n,
          'dob' => $request->dob,
          'email' => $request->email,
          'phone' => $request->mob,
          'password' => $request->pwd,
          'profilePic' => '',
          'cpassword' => $request->c_pwd,
          'deviceToken' => getDeviceToken(),
          'deviceType' => '3',
          'countryCode' => $request->c_code,
          'deviceId' => getDeviceId());

      $response = postRequestAPI('signUp', $parameters);

      if ($response['Status'] == 200 && $response['Success'] == true) {
        $data = $response['Result'][0];
        $request->session()->put('otp', $data['otp']);
        $request->session()->put('phone', $data['phone']);
        $request->session()->put('countryCode', $data['countryCode']);

        return response()->json(['success' => $data]);
      } else {
        return response()->json(['signUpError' => $response['Message']]);
      }
    }
  }

  /**
   * Function used to verify  mobile number of new user
   * @param Request $request
   * @return Json
   * @author TechAhead
   */
  public function verifyOtp(Request $request) {
    $user_otp = $request->otp;
    $otp = (string) $request->session()->get('otp');
    if ($otp == $user_otp) {
      $countryCode = $request->session()->get('countryCode');
      $phone = $request->session()->get('phone');
      $parameters = array('phone' => $phone, 'countryCode' => $countryCode, 'otp' => $otp);
      $response = postRequestAPI('verifyOtp', $parameters);
      if($response['Status'] == 400){
            $request->session()->flash('signUpError', $response['Message']);
            return response()->json([$response, $user_otp, $otp]);
        }

      if ($response['Status'] == 200 && $response['Success'] == true) {
        $data = $response['Result'][0];
        $request->session()->put('id', $data['userId']);
        $request->session()->put('email', $data['email']);
        $request->session()->put('name', $data['firstName'] . ' ' . $data['lastName']);
        $request->session()->pull('otp');
        $request->session()->pull('phone');
        $request->session()->pull('countryCode');
        $request->session()->flash('success', 'Successfully registered!Welcome to CafeJavas!');
        return response()->json(['success' => $data]);
      } else {
        return response()->json(['error' => $response['Message']]);
      }
    } else {
      return response()->json(['error' => 'Not a valid Otp']);
    }
  }

  /**
   * Function used to send new password for a user email
   * @param Request $request
   * @return Json
   * @author TechAhead
   */
  public function forgotPassword(Request $request) {

    if ($request->has('email') && $request->email != '') {
      $user_email = $request->email;
      $parameters = array('email' => $user_email);
      $response = postRequestAPI('forgotPassword', $parameters);
      if($response['Status'] == 400){
            $request->session()->flash('forgotPasswordError', $response['Message']);
            return response()->json(['errors' => $response['Message']]);
        }

      if ($response['Status'] == 200 && $response['Success'] == true) {

        $request->session()->flash('success', $response['Message']);
        return response()->json(['success' => $response['Message']]);
      } else {
        return response()->json(['error' => $response['Message']]);
      }
    } else {
      return response()->json(['error' => 'No email found']);
    }
  }

  /**
   * Function used to resend otp of new user
   * @param Request $request
   * @return Json
   * @author TechAhead
   */
  public function resendOtp(Request $request) {
    if ($request->session()->has('countryCode') && $request->session()->get('countryCode') != '' && $request->session()->has('phone') && $request->session()->get('phone') != '') {

      $countryCode = $request->session()->get('countryCode');
      $phone = $request->session()->get('phone');

      $parameters = array('phone' => $phone, 'countryCode' => $countryCode);
      $response = postRequestAPI('sendOtp', $parameters);
      if ($response['Status'] == 200 && $response['Success'] == true) {
        $data = $response['Result'][0];
        $request->session()->pull('otp');
        $request->session()->put('otp', $data['otp']);

        return response()->json(['success' => 'New otp is sent !']);
      } else {
        return response()->json(['error' => $response['Message']]);
      }
    } else {
      return response()->json(['error' => 'Not valid inputs!']);
    }
  }

}
