'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var OUTPUT_STRING = exports.OUTPUT_STRING = 'OUTPUT_STRING';
var OUTPUT_TYPED_ARRAY = exports.OUTPUT_TYPED_ARRAY = 'OUTPUT_TYPED_ARRAY';

var arr2str = function arr2str(arr) {
  return String.fromCharCode.apply(null, arr);
};

exports.default = function (base64Str) {
  var outputEncoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : OUTPUT_STRING;
  return outputEncoding === OUTPUT_STRING ? arr2str(decode(base64Str)) : decode(base64Str);
};

function decode(base64Str) {
  var iOut = 0;
  var arr = new Uint8Array(Math.ceil(base64Str.length * 3 / 4));

  for (var i = 0, len = base64Str.length, validBits = 0, bitsSoFar = 0; i < len; i++) {
    var bits = void 0;
    var c = base64Str.charCodeAt(i);
    if (c >= 0x41 && c <= 0x5a) {
      // [A-Z]
      bits = c - 0x41;
    } else if (c >= 0x61 && c <= 0x7a) {
      // [a-z]
      bits = c - 0x61 + 0x1a;
    } else if (c >= 0x30 && c <= 0x39) {
      // [0-9]
      bits = c - 0x30 + 0x34;
    } else if (c === 0x2b) {
      // +
      bits = 0x3e;
    } else if (c === 0x2f) {
      // /
      bits = 0x3f;
    } else if (c === 0x3d) {
      // =
      validBits = 0;
      continue;
    } else {
      // ignore all other characters!
      continue;
    }
    bitsSoFar = bitsSoFar << 6 | bits;
    validBits += 6;
    if (validBits >= 8) {
      validBits -= 8;
      arr[iOut++] = bitsSoFar >> validBits;
      if (validBits === 2) {
        bitsSoFar &= 0x03;
      } else if (validBits === 4) {
        bitsSoFar &= 0x0f;
      }
    }
  }

  return iOut < arr.length ? arr.subarray(0, iOut) : arr;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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