/*! firebase-admin v4.2.1
    https://firebase.google.com/terms/ */
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var messaging_1 = require("./messaging");
var firebase = require("../default-namespace");
/**
 * Factory function that creates a new Messaging service.
 *
 * @param {Object} app The app for this service.
 * @param {function(Object)} extendApp An extend function to extend the app namespace.
 *
 * @return {Messaging} The Messaging service for the specified app.
 */
function serviceFactory(app, extendApp) {
    return new messaging_1.Messaging(app);
}
/**
 * Handles app life-cycle events.
 *
 * @param {string} event The app event that is occurring.
 * @param {FirebaseApp} app The app for which the app hook is firing.
 */
var appHook = function (event, app) {
    return;
};
function default_1() {
    return firebase.INTERNAL.registerService('messaging', serviceFactory, { Messaging: messaging_1.Messaging }, appHook);
}
exports.default = default_1;
