define({ "api": [
  {
    "type": "post",
    "url": "/driverLogout/",
    "title": "driver logout.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "driverLogout",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"User Logout Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": []\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "post",
    "url": "/driverSignIn/",
    "title": "driver app sign in",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "driverSignIn",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>user email.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>user password.</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "deviceType",
            "description": "<p>user device type (1 for iOS 2 for Android).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceToken",
            "description": "<p>user device token.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"userId\": 42,\n        \"firstName\": \"nitin\",\n        \"lastName\": \"abcd\",\n        \"email\": \"sfasdfa@sfa.com\",\n        \"phone\": \"234242444445\",\n        \"profilePic\": \"\",\n        \"userType\": \"1\",\n        \"tokenExpirationTime\": 1800\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "get",
    "url": "/getDriverOrderDetail/",
    "title": "driver order details",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getDriverOrderDetail",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order id</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n   {\n   \"order_id\": 234,\n   \"status\": \"1\",\n   \"total\": 30000,\n   \"latitude\": \"12.1221\",\n   \"longitude\": \"4.4545\",\n   \"mobile_number\": \"9645454545\",\n   \"house_number\": \"house no 11\",\n   \"location\": \"XYZ\",\n   \"landmark\": \"ABCD\",\n   \"firstName\": \"Shivammm\",\n   \"lastName\": \"Shrivastavvv\"\n   }\n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "get",
    "url": "/getDriverOrderHistory/",
    "title": "driver order history",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getDriverOrderHistory",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pageNo",
            "description": "<p>page number(starts with 1)</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": \n    {\n     \"total\": 1,\n   \"data\": [\n   {\n   \"order_id\":1,\n   \"order_num\": \"CAFEJAVAS_234\",\n   \"total\": 30000,\n   \"branch_name\": \"BOMBO ROAD\",\n   \"firstName\": \"Shivammm\",\n   \"lastName\": \"Shrivastavvv\",\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   }\n   ]\n   }\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "get",
    "url": "/getDriverOrderList/",
    "title": "driver order list",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getDriverOrderList",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pageNo",
            "description": "<p>page number(starts with 1)</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": \n    {\n     \"total\": 1,\n   \"data\": [\n   {\n   \"order_id\":1,\n   \"order_num\": \"CAFEJAVAS_234\",\n   \"total\": 30000,\n   \"branch_name\": \"BOMBO ROAD\",\n   \"firstName\": \"Shivammm\",\n   \"lastName\": \"Shrivastavvv\",\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   }\n   ]\n   }\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "get",
    "url": "/getDriverProfile/",
    "title": "driver profile details",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getDriverProfile",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n    {\n        \"firstName\": \"driver1\",\n        \"lastName\": \"abcd\",\n   \"email\": \"driver@gmail.com\",\n   \"phone\": \"9999999999\",\n   \"profilePic\": \"\"\n   }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "put",
    "url": "/orderStatusChangeByDriver/",
    "title": "driver change order status",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "orderStatusChangeByDriver",
    "group": "Driver",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order id</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "status",
            "description": "<p>(3 =&gt; food on the way, 4 =&gt; food delivered)</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": \n    {\n   \n   }\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Driver"
  },
  {
    "type": "get",
    "url": "/gallery/",
    "title": "Get gallery images.",
    "version": "1.0.0",
    "name": "gallery",
    "group": "Gallery",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>Page number for pagination (start with page number 1).</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"Success\": true,\n          \"Status\": 200,\n          \"Message\": \"Success\",\n          \"AppVersion\": \"1.0.0\",\n          \"Result\": [\n              {\n                  \"galleryId\": 2,\n                  \"title\": \"CAFE JAVAS - NAMIREMBE ROAD\",\n                  \"description\": \"\",\n                 \"imageUrl\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_gallery_img_21585286.jpg\",\n                 }\n                     \n               \n              },\n              {\n                  \"galleryId\": 7,\n                  \"title\": \"CAFE JAVAS - OASIS MALL\",\n                  \"description\": \"\",\n                   \"imageUrl\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_gallery_img_21585286.jpg\",\n                 }\n              },\n              {\n                  \"galleryId\": 8,\n                  \"title\": \"CAFE JAVAS - BOMBO ROAD\",\n                  \"description\": \"\",\n                  \"images\": ''\n              }\n          ]\n      }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Gallery"
  },
  {
    "type": "get",
    "url": "/pages/",
    "title": "Get information pages content.",
    "version": "1.0.0",
    "name": "GetPagesContent",
    "group": "Info_Pages",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pageId",
            "description": "<p>user page id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n [ \n  {\n   \"pageId\": 2,\n   \"title\": \"About us\",\n   \"description\": \"dummy content\"\n }\n]",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Info_Pages"
  },
  {
    "type": "get",
    "url": "/aboutUs",
    "title": "About us details.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "aboutUs",
    "group": "Info_Pages",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "  HTTP/1.1 200 OK\n  {\n  \"Success\": true,\n  \"Status\": 200,\n  \"Message\": \"Success\",\n  \"AppVersion\": \"1.0.0\",\n  \"Result\": {\n    \"description\": \"Whether in Kampala or Entebbe, you're always close to a cafe Javas, thanks to our growing network.You're welcome to drop by or call to make your order and we'll be more than happt to serve you.\",\n    \"openingHours\": [\n     {\n        \"day\": \"Monday - Thursday\",\n        \"time\": \"6:00 AM to 11:00 PM\"\n      },\n      {\n        \"day\": \"Friday - Saturday\",\n        \"time\": \"6:00 AM to 12:00 PM\"\n      },\n      {\n        \"day\": \"Sunday\",\n        \"time\": \"6:00 AM to 10:00 PM\"\n      }\n    ],\n    \"deliveryFee\": \"UGX 20\",\n    \"minimumOrder\": \"UGX 200\",\n    \"branches\": [\n      {\n        \"name\": \"BOMBO ROAD\",\n        \"address\": \"Kampala Road, Plot 24/26\",\n        \"contactNumber\": \"+256 392 177284 / 0414 581911\",\n        \"email\": \"javas.downtown@cafejavas.co.ug\"\n      },\n      {\n        \"name\": \"CAERGEN HOUSE\",\n        \"address\": \"Parliamentary Avenue\",\n        \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n        \"email\": \"javas.cargen@cafejavas.co.ug\"\n      },\n      {\n     \"name\": \"Shivam HOUSE\",\n     \"address\": \"Parliamentary Avenue\",\n     \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n     \"email\": \"javas.cargen@cafejavas.co.ug\"\n     },\n     {\n     \"name\": \"Ayush HOUSE\",\n     \"address\": \"Parliamentary Avenue\",\n     \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n     \"email\": \"javas.cargen@cafejavas.co.ug\"\n     },\n     {\n     \"name\": \"Kapil HOUSE\",\n     \"address\": \"Parliamentary Avenue\",\n     \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n     \"email\": \"javas.cargen@cafejavas.co.ug\"\n     }\n    ]\n  }\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Info_Pages"
  },
  {
    "type": "get",
    "url": "/getBranchesDistanceWise",
    "title": "Get list of branches on basis of user location",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getBranchesDistanceWise",
    "group": "Info_Pages",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "latitude",
            "description": "<p>latitude of user</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "longitude",
            "description": "<p>longitude of user</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "  HTTP/1.1 200 OK\n  {\n  \"Success\": true,\n  \"Status\": 200,\n  \"Message\": \"Success\",\n  \"AppVersion\": \"1.0.0\",\n  \"Result\": \n  [\n     {\n     \"branch_id\": 2,\n     \"name\": \"CAERGEN HOUSE\",\n     \"address\": \"Parliamentary Avenue\",\n     \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n     \"email\": \"javas.cargen@cafejavas.co.ug\",\n     \"latitude\": \"28.6150932\",\n     \"longitude\": \"77.3572304\",\n     \"distanceInKM\": \"3.690\"\n     },\n     {\n     \"branch_id\": 1,\n     \"name\": \"BOMBO ROAD\",\n     \"address\": \"Kampala Road, Plot 24/26\",\n     \"contactNumber\": \"+256 392 177284 / 0414 581911\",\n     \"email\": \"javas.downtown@cafejavas.co.ug\",\n     \"latitude\": \"28.6208276\",\n     \"longitude\": \"77.3627677\",\n     \"distanceInKM\": \"4.470\"\n     }\n     ]\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Info_Pages"
  },
  {
    "type": "get",
    "url": "/getBranchesForMap",
    "title": "Get list of branches",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getBranchesForMap",
    "group": "Info_Pages",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "  HTTP/1.1 200 OK\n  {\n  \"Success\": true,\n  \"Status\": 200,\n  \"Message\": \"Success\",\n  \"AppVersion\": \"1.0.0\",\n  \"Result\": \n  \n     [\n     {\n     \"name\": \"BOMBO ROAD\",\n     \"address\": \"Kampala Road, Plot 24/26\",\n     \"contactNumber\": \"+256 392 177284 / 0414 581911\",\n     \"email\": \"javas.downtown@cafejavas.co.ug\",\n     \"latitude\": \"28.6208276\",\n     \"longitude\": \"77.3627677\"\n     },\n     {\n     \"name\": \"CAERGEN HOUSE\",\n     \"address\": \"Parliamentary Avenue\",\n     \"contactNumber\": \"+256 200 930000 / 0393 000020\",\n     \"email\": \"javas.cargen@cafejavas.co.ug\",\n     \"latitude\": \"28.6150932\",\n     \"longitude\": \"77.3572304\"\n     }\n     ]\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Info_Pages"
  },
  {
    "type": "post",
    "url": "/addItemToCart",
    "title": "Add item to cart",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "addItemToCart",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "json",
            "description": "<p>JSON data having item details.( { &quot;data&quot;: { &quot;orderItemDetail&quot;: { &quot;isFavourite&quot;: 0, &quot;image&quot;: &quot;https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg&quot;, &quot;productId&quot;: 1, &quot;catId&quot;: 1, &quot;subCatId&quot;: 1, &quot;productName&quot;: &quot;sd&quot;, &quot;description&quot;: &quot;asdfasdf&quot;, &quot;price&quot;: &quot;60&quot; }, &quot;topextraItems&quot;: [ { &quot;topLabelId&quot;: 1, &quot;labelNames&quot;: &quot;Temp1&quot;, &quot;labelType&quot;: 1, &quot;labelOption&quot;: 1, &quot;labelOptions&quot;: [ { &quot;price&quot;: &quot;50&quot;, &quot;labelOptionId&quot;: 1, &quot;labelId&quot;: 1, &quot;optionName&quot;: &quot;Option 1&quot; } ] }, { &quot;topLabelId&quot;: 5, &quot;labelNames&quot;: &quot;Temp2&quot;, &quot;labelType&quot;: 1, &quot;labelOption&quot;: 2, &quot;labelOptions&quot;: [ { &quot;price&quot;: &quot;50&quot;, &quot;labelOptionId&quot;: 5, &quot;labelId&quot;: 5, &quot;optionName&quot;: &quot;Option 5&quot; } ] } ], &quot;additionalItems&quot;: [ { &quot;additionalProductId&quot;: 1, &quot;itemName&quot;: &quot;sdfa&quot;, &quot;price&quot;: &quot;40&quot; }, { &quot;additionalProductId&quot;: 2, &quot;itemName&quot;: &quot;Bacon Crumble&quot;, &quot;price&quot;: &quot;60&quot; } ], &quot;customizeTopLabelOptions&quot;: [ { &quot;custLabelId&quot;: 1, &quot;labelNames&quot;: &quot;Toppings&quot; }, { &quot;custLabelId&quot;: 2, &quot;labelNames&quot;: &quot;Size&quot; }, { &quot;custLabelId&quot;: 3, &quot;labelNames&quot;: &quot;Extra&quot; } ], &quot;verticalCustomizeOptionsWithPrice&quot;: [ { &quot;custlabelOptionId&quot;: 7, &quot;labelNames&quot;: &quot;Bacon Crumble&quot;, &quot;selectedOption&quot;: [ { &quot;labelNames&quot;: &quot;Size&quot;, &quot;isSelected&quot;: 1 }, { &quot;labelNames&quot;: &quot;Extra&quot;, &quot;isSelected&quot;: 0 } ] }, { &quot;custlabelOptionId&quot;: 8, &quot;labelNames&quot;: &quot;Green Onions&quot;, &quot;selectedOption&quot;: [ { &quot;labelNames&quot;: &quot;Extra&quot;, &quot;isSelected&quot;: 1 }, { &quot;labelNames&quot;: &quot;Size&quot;, &quot;isSelected&quot;: 1 } ] } ] } }</p> <pre><code> )</code></pre>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "quantity",
            "description": "<p>Quantity of item user want to purchase</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "productId",
            "description": "<p>product id</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "basicProductCost",
            "description": "<p>Price of product</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "optionalTotal",
            "description": "<p>Price of optional items selected by user</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "additionalTotal",
            "description": "<p>Price of additional items selected by user</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "subTotal",
            "description": "<p>Sum of basicProductCost,optionalTotal and additionalTotal</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n   \"cartItemCount\" : 2\n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/createOrder",
    "title": "createOrder",
    "description": "<p>Insert order details</p>",
    "group": "Orders",
    "name": "createOrder________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id(0 in case of guest user)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>device id(unique device id of user)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "pickUpType",
            "description": "<p>order pick up type(0 in case of delivery, 1 in case of take away)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "Number",
            "optional": false,
            "field": "addressId",
            "description": "<p>address id</p>"
          },
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "paymentMode",
            "description": "<p>payment Mode (1 in case of online, 2 in case of cash)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "giftcardId",
            "description": "<p>gift card id (0 in case it is not applicable)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "String",
            "optional": false,
            "field": "promocodeId",
            "description": "<p>promo code id (0 in case it is not applicable)</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\n           \"orderNumber\": \"CAFEJAVAS_20\",\n           \"orderId\" : 1,\n           \"pickUpType\" : 1,\n           \"totalAmount\" : 100\n        }\n   }",
          "type": "json"
        }
      ]
    },
    "version": "0.0.1",
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "put",
    "url": "/deleteCartItem",
    "title": "Delete cart item",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "deleteCartItem",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "orderItemId",
            "description": "<p>Unique order item ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n   \"totalPrice\": 35,\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalSuggestedProducts\":2\n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getCartItemList",
    "title": "Get list of items saved in cart",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getCartItemList",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n   \"data\": [\n   {\n   \"jsonData\": {\n   \"data\": {\n   \"orderItemDetail\": {\n   \"isFavourite\": 0,\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\",\n   \"productId\": 1,\n   \"catId\": 1,\n   \"subCatId\": 1,\n   \"productName\": \"sd\",\n   \"description\": \"asdfasdf\",\n   \"price\": \"60\"\n   },\n   \"topextraItems\": [\n   {\n   \"topLabelId\": 1,\n   \"labelNames\": \"Temp1\",\n   \"labelType\": 1,\n   \"labelOption\": 1,\n   \"labelOptions\": [\n   {\n   \"price\": \"50\",\n   \"labelOptionId\": 1,\n   \"labelId\": 1,\n   \"optionName\": \"Option 1\"\n   }\n   ]\n   },\n   {\n   \"topLabelId\": 5,\n   \"labelNames\": \"Temp2\",\n   \"labelType\": 1,\n   \"labelOption\": 2,\n   \"labelOptions\": [\n   {\n   \"price\": \"50\",\n   \"labelOptionId\": 5,\n   \"labelId\": 5,\n   \"optionName\": \"Option 5\"\n   }\n   ]\n   }\n   ],\n   \"additionalItems\": [\n   {\n   \"additionalProductId\": 1,\n   \"itemName\": \"sdfa\",\n   \"price\": \"40\"\n   },\n   {\n   \"additionalProductId\": 2,\n   \"itemName\": \"Bacon Crumble\",\n   \"price\": \"60\"\n   }\n   ],\n   \"customizeTopLabelOptions\": [\n   {\n   \"custLabelId\": 1,\n   \"labelNames\": \"Toppings\"\n   },\n   {\n   \"custLabelId\": 2,\n   \"labelNames\": \"Size\"\n   },\n   {\n   \"custLabelId\": 3,\n   \"labelNames\": \"Extra\"\n   }\n   ],\n   \"verticalCustomizeOptionsWithPrice\": [\n   {\n   \"custlabelOptionId\": 7,\n   \"labelNames\": \"Bacon Crumble\",\n   \"selectedOption\": [\n   {\n   \"labelNames\": \"Size\",\n   \"isSelected\": 1\n   },\n   {\n   \"labelNames\": \"Extra\",\n   \"isSelected\": 0\n   }\n   ]\n   },\n   {\n   \"custlabelOptionId\": 8,\n   \"labelNames\": \"Green Onions\",\n   \"selectedOption\": [\n   {\n   \"labelNames\": \"Extra\",\n   \"isSelected\": 1\n   },\n   {\n   \"labelNames\": \"Size\",\n   \"isSelected\": 1\n   }\n   ]\n   }\n   ]\n   }\n   },\n   \"quantity\": 1,\n   \"basicProductCost\": 10,\n   \"optionalTotal\": 0.5,\n   \"additionalTotal\": 0.5,\n   \"subTotal\": 11,\n   \"orderItemId\": 5,\n   \"isAvailable\": 0\n   },\n   {\n   \"jsonData\": {\n   \"data\": {\n   \"orderItemDetail\": {\n   \"isFavourite\": 0,\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\",\n   \"productId\": 1,\n   \"catId\": 1,\n   \"subCatId\": 1,\n   \"productName\": \"sd\",\n   \"description\": \"asdfasdf\",\n   \"price\": \"60\"\n   },\n   \"topextraItems\": [\n   {\n   \"topLabelId\": 1,\n   \"labelNames\": \"Temp1\",\n   \"labelType\": 1,\n   \"labelOption\": 1,\n   \"labelOptions\": [\n   {\n   \"price\": \"50\",\n   \"labelOptionId\": 1,\n   \"labelId\": 1,\n   \"optionName\": \"Option 1\"\n   }\n   ]\n   },\n   {\n   \"topLabelId\": 5,\n   \"labelNames\": \"Temp2\",\n   \"labelType\": 1,\n   \"labelOption\": 2,\n   \"labelOptions\": [\n   {\n   \"price\": \"50\",\n   \"labelOptionId\": 5,\n   \"labelId\": 5,\n   \"optionName\": \"Option 5\"\n   }\n   ]\n   }\n   ],\n   \"additionalItems\": [\n   {\n   \"additionalProductId\": 1,\n   \"itemName\": \"sdfa\",\n   \"price\": \"40\"\n   },\n   {\n   \"additionalProductId\": 2,\n   \"itemName\": \"Bacon Crumble\",\n   \"price\": \"60\"\n   }\n   ],\n   \"customizeTopLabelOptions\": [\n   {\n   \"custLabelId\": 1,\n   \"labelNames\": \"Toppings\"\n   },\n   {\n   \"custLabelId\": 2,\n   \"labelNames\": \"Size\"\n   },\n   {\n   \"custLabelId\": 3,\n   \"labelNames\": \"Extra\"\n   }\n   ],\n   \"verticalCustomizeOptionsWithPrice\": [\n   {\n   \"custlabelOptionId\": 7,\n   \"labelNames\": \"Bacon Crumble\",\n   \"selectedOption\": [\n   {\n   \"labelNames\": \"Size\",\n   \"isSelected\": 1\n   },\n   {\n   \"labelNames\": \"Extra\",\n   \"isSelected\": 0\n   }\n   ]\n   },\n   {\n   \"custlabelOptionId\": 8,\n   \"labelNames\": \"Green Onions\",\n   \"selectedOption\": [\n   {\n   \"labelNames\": \"Extra\",\n   \"isSelected\": 1\n   },\n   {\n   \"labelNames\": \"Size\",\n   \"isSelected\": 1\n   }\n   ]\n   }\n   ]\n   }\n   },\n   \"quantity\": 2,\n   \"basicProductCost\": 10,\n   \"optionalTotal\": 0.5,\n   \"additionalTotal\": 0.5,\n   \"subTotal\": 22,\n   \"orderItemId\": 6,\n   \"isAvailable\": 1\n   }\n   ],\n   \"totalPrice\": 44,\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalSuggestedProducts\" : 2\n   }\n   }\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getCartItemSummary",
    "title": "Get summary of items saved in cart",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getCartItemSummary",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"Success\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": {\n   \"data\": [\n   {\n   \"quantity\": 1,\n   \"product_name\": \"sd\",\n   \"price\": 11,\n   \"isAvailable\": 0\n   },\n   {\n   \"quantity\": 2,\n   \"product_name\": \"Product 2\",\n   \"price\": 22,\n   \"isAvailable\": 1\n   }\n   ],\n   \"totalPrice\": 44\n   }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getOrderHistory",
    "title": "Get order history",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getOrderHistory",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pageNo",
            "description": "<p>page number(starts with 1)</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\": {\n\"data\": [\n   {\n   \"order_number\": \"CAFEJAVAS_20\",\n   \"order_id\" : 1,\n   \"order_date\": \"2018-06-11 15:07:33\",\n   \"status\": 4,\n   \"payment_mode\": \"Online\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 33,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   },\n   {\n   \"order_number\": \"CAFEJAVAS_13\",\n   \"order_id\" : 2,\n   \"order_date\": \"2018-06-07 20:00:15\",\n   \"status\": 5,\n   \"payment_mode\": \"Online\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 0,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   },\n   {\n   \"order_number\": \"CAFEJAVAS_8\",\n   \"order_id\" : 3,\n   \"order_date\": \"2018-06-07 19:43:18\",\n   \"status\": 4,\n   \"payment_mode\": \"Cash\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 0,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   }\n   ],\n   \"total\": 3\n\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getOrderHistoryDetails",
    "title": "Get order details",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getOrderHistoryDetails",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "orderId",
            "description": "<p>ID of order</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"Success\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": {\n   \"data\": [\n   {\n   \"quantity\": 1,\n   \"subtotal\": 21000,\n   \"json\": {\n   \"data\": {\n   \"additionalItems\": [],\n   \"customizeTopLabelOptions\": [],\n   \"orderItemDetail\": {\n   \"catId\": 10,\n   \"description\": \"Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.\",\n   \"image\": \"http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg\",\n   \"isFavourite\": 1,\n   \"price\": \"20000\",\n   \"productId\": 86,\n   \"productName\": \"Dosa\",\n   \"subCatId\": 48\n   },\n   \"topextraItems\": [\n   {\n   \"labelNames\": \"one\",\n   \"labelOption\": 1,\n   \"labelOptions\": [\n   {\n   \"labelId\": 32,\n   \"labelOptionId\": 49,\n   \"optionName\": \"dosa\",\n   \"price\": \"1000\"\n   }\n   ],\n   \"labelType\": 1,\n   \"topLabelId\": 32\n   }\n   ],\n   \"verticalCustomizeOptionsWithPrice\": []\n   }\n   }\n   },\n   {\n   \"quantity\": 6,\n   \"subtotal\": 150000,\n   \"json\": {\n   \"data\": {\n   \"additionalItems\": [],\n   \"customizeTopLabelOptions\": [],\n   \"orderItemDetail\": {\n   \"catId\": 10,\n   \"description\": \"Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.\",\n   \"image\": \"http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg\",\n   \"isFavourite\": 1,\n   \"price\": \"20000\",\n   \"productId\": 86,\n   \"productName\": \"Dosa\",\n   \"subCatId\": 48\n   },\n   \"topextraItems\": [\n   {\n   \"labelNames\": \"premium\",\n   \"labelOption\": 2,\n   \"labelOptions\": [\n   {\n   \"labelId\": 33,\n   \"labelOptionId\": 50,\n   \"optionName\": \"mix dosa\",\n   \"price\": \"5000\"\n   }\n   ],\n   \"labelType\": 1,\n   \"topLabelId\": 33\n   }\n   ],\n   \"verticalCustomizeOptionsWithPrice\": []\n   }\n   }\n   }\n   ],\n   \"order_date\": \"2018-06-27 18:28:30\",\n   \"order_num\":\"CAFEJAVAS_1\",\n   \"payment_mode\": \"Payment Not Done\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 171000\n   }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getQrImage/",
    "title": "QR Image.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getQrImage",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>userId</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>orderId</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"QR code Image\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": \"<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 23 23\"><path d=\"M1 1h7v7h-7zM11 1h2v2h1v1h-1v1h1v6h-1v-2h-1v-1h1v-2h-1v-3h-1v3h-1v3h-1v-6h1v-1h1zM15 1h7v7h-7zM2 2v5h5v-5zM16 2v5h5v-5zM3 3h3v3h-3zM17 3h3v3h-3zM11 7h1v1h-1zM1 9h1v1h-1zM3 9h5v1h-2v1h3v-1h1v-1h2v2h-2v1h-5v-2h-1v1h-1zM15 9h5v3h1v1h-3v-1h1v-2h-4zM21 10h1v1h-1zM1 11h1v1h-1zM12 11h1v1h-1zM14 11h1v3h-1zM3 12h2v2h-4v-1h2zM16 12h1v2h2v1h-2v1h-2v-1h1zM6 13h3v1h-3zM10 13h3v1h1v5h-1v-2h-2v-1h2v-1h-1v-1h-1v2h-1v-1h-1v-1h1zM21 13h1v1h-1zM1 15h7v7h-7zM19 15h2v1h-1v1h-2v-1h1zM2 16v5h5v-5zM9 16h1v3h1v1h-2zM21 16h1v2h-1zM3 17h3v3h-3zM15 17h1v1h-1zM11 18h1v1h-1zM16 18h3v2h1v1h-1v1h-1v-1h-2v-1h2v-1h-2zM12 19h1v1h-1zM14 19h1v1h-1zM9 21h2v1h-2zM12 21h1v1h-1zM20 21h1v1h-1z\"/></svg>\"\n   }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/getRecentOrderHistory",
    "title": "Get recent order history",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getRecentOrderHistory",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\": \n   [\n   {\n   \"order_number\": \"CAFEJAVAS_20\",\n   \"order_id\" : 1,\n   \"order_date\": \"2018-06-11 15:07:33\",\n   \"payment_mode\": \"Online\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 33,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   },\n   {\n   \"order_number\": \"CAFEJAVAS_13\",\n   \"order_id\" : 2,\n   \"order_date\": \"2018-06-07 20:00:15\",\n   \"payment_mode\": \"Online\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 0,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   },\n   {\n   \"order_number\": \"CAFEJAVAS_8\",\n   \"order_id\" : 3,\n   \"order_date\": \"2018-06-07 19:43:18\",\n   \"payment_mode\": \"Cash\",\n   \"serviceFee\": 0,\n   \"deliveryFee\": 0,\n   \"totalPrice\": 0,\n   \"image\" : \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg\"\n   }\n   ]\n\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/giftCardpromoCheck",
    "title": "check user giftcard or promocod",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "giftCardpromoCheck",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userMail",
            "description": "<p>user Mail who is logged in .</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "code",
            "description": "<p>giftcard or promo code.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "type",
            "description": "<p>(1=giftcard, 2=promo).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\n        \"amountRemaining\" : 100,\n        \"couponId\": \"1\"\n        }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/giftcardPurchase",
    "title": "save user giftcard purchase transaction",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "giftcardPurchase",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id if it is guest user send 0.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "giftcardId",
            "description": "<p>giftcard ID.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "isGuestuser",
            "description": "<p>(0=NO, 1=Yes).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userMail",
            "description": "<p>Sender mail id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "receiverMail",
            "description": "<p>Receiver mail id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "price",
            "description": "<p>gift card amount.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "message",
            "description": "<p>message by sender.</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\n        \"transactionId\" : 1\n        }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "put",
    "url": "/orderStatusChangescanner/",
    "title": "store change order status by scanner",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "orderStatusChangescanner",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order id</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "paymentMode",
            "description": "<p>(0 =&gt; Payment Not Done,1 =&gt; online, 2 =&gt; Cash)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "status",
            "description": "<p>(4 =&gt; food delivered)</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": \n    {\n   \n   }\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/ordersByDriver",
    "title": "ordersByDriver",
    "description": "<p>Get order list for driver</p>",
    "group": "Orders",
    "name": "ordersByDriver________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "id",
            "description": "<p>first_name (user email)</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "response",
            "description": "<p>response object</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "response.status",
            "description": "<p>response status ( 0 for error, 1 for success )</p>"
          },
          {
            "group": "Success 200",
            "type": "string",
            "optional": true,
            "field": "response.message",
            "defaultValue": "null",
            "description": "<p>error message</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": true,
            "field": "response.data",
            "defaultValue": "null",
            "description": "<p>response data</p> <hr>"
          }
        ]
      }
    },
    "version": "0.0.1",
    "filename": "routes/v1/driver.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/ordersByDriver",
    "title": "ordersByDriver",
    "description": "<p>Get order list for driver</p>",
    "group": "Orders",
    "name": "ordersByDriver________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "id",
            "description": "<p>first_name (user email)</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "response",
            "description": "<p>response object</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "response.status",
            "description": "<p>response status ( 0 for error, 1 for success )</p>"
          },
          {
            "group": "Success 200",
            "type": "string",
            "optional": true,
            "field": "response.message",
            "defaultValue": "null",
            "description": "<p>error message</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": true,
            "field": "response.data",
            "defaultValue": "null",
            "description": "<p>response data</p> <hr>"
          }
        ]
      }
    },
    "version": "0.0.1",
    "filename": "routes/v1/driver.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/ordersDetail",
    "title": "ordersDetail",
    "description": "<p>Get order details by order Id and  user Id</p>",
    "group": "Orders",
    "name": "ordersDetail________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "order_id",
            "description": "<p>order_id (Order Id)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "user_id",
            "description": "<p>order_id (Order Id)</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "response",
            "description": "<p>response object</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "response.status",
            "description": "<p>response status ( 0 for error, 1 for success )</p>"
          },
          {
            "group": "Success 200",
            "type": "string",
            "optional": true,
            "field": "response.message",
            "defaultValue": "null",
            "description": "<p>error message</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": true,
            "field": "response.data",
            "defaultValue": "null",
            "description": "<p>response data</p> <hr>"
          }
        ]
      }
    },
    "version": "0.0.1",
    "filename": "routes/v1/order.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/reorder",
    "title": "Reorder",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "reorder",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order id</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n   \"cartItemCount\" : 2\n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/trackOrder",
    "title": "track order",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "trackOrder",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user (0 in case of guest_user)</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "deviceId",
            "description": "<p>ID of device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "  HTTP/1.1 200 OK\n     {\n\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\": {\n\"data\": [\n  {\n\"quantity\": 1,\n\"subtotal\": 21000,\n\"json\": {\n\"data\": {\n\"additionalItems\": [],\n\"customizeTopLabelOptions\": [],\n\"orderItemDetail\": {\n\"catId\": 10,\n\"description\": \"Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.\",\n\"image\": \"http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg\",\n\"isFavourite\": 1,\n\"price\": \"20000\",\n\"productId\": 86,\n\"productName\": \"Dosa\",\n\"subCatId\": 48\n},\n\"topextraItems\": [\n  {\n\"labelNames\": \"one\",\n\"labelOption\": 1,\n\"labelOptions\": [\n  {\n\"labelId\": 32,\n\"labelOptionId\": 49,\n\"optionName\": \"dosa\",\n\"price\": \"1000\"\n}\n],\n\"labelType\": 1,\n\"topLabelId\": 32\n}\n],\n\"verticalCustomizeOptionsWithPrice\": []\n}\n}\n},\n  {\n\"quantity\": 6,\n\"subtotal\": 150000,\n\"json\": {\n\"data\": {\n\"additionalItems\": [],\n\"customizeTopLabelOptions\": [],\n\"orderItemDetail\": {\n\"catId\": 10,\n\"description\": \"Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.\",\n\"image\": \"http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg\",\n\"isFavourite\": 1,\n\"price\": \"20000\",\n\"productId\": 86,\n\"productName\": \"Dosa\",\n\"subCatId\": 48\n},\n\"topextraItems\": [\n  {\n\"labelNames\": \"premium\",\n\"labelOption\": 2,\n\"labelOptions\": [\n  {\n\"labelId\": 33,\n\"labelOptionId\": 50,\n\"optionName\": \"mix dosa\",\n\"price\": \"5000\"\n}\n],\n\"labelType\": 1,\n\"topLabelId\": 33\n}\n],\n\"verticalCustomizeOptionsWithPrice\": []\n}\n}\n}\n],\n\"order_date\": \"2018-06-27 18:28:30\",\n\"order_num\":\"CAFEJAVAS_1\",\n\"payment_mode\": \"Payment Not Done\",\n\"serviceFee\": 0,\n\"deliveryFee\": 0,\n\"totalPrice\": 171000,\n\"pickUpType\":\"0\",\n\"orderId\":212    \n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/transaction",
    "title": "save user transaction",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "transaction",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order ID.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "totalAmount",
            "description": "<p>order total amount.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "itemDesc",
            "description": "<p>item description ex - Food or giftcard.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "isGuestuser",
            "description": "<p>(0=NO, 1=Yes).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "type",
            "description": "<p>(1=Food, 2=giftcard)</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\n        \"transactionId\" : 1\n        }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "put",
    "url": "/updateCartItem",
    "title": "Update cart item",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "updateCartItem",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "orderItemId",
            "description": "<p>Unique order item ID</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "quantity",
            "description": "<p>Number of items user want for this particular product</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n\"totalPrice\":100,\n\"serviceFee\":0,\n\"deliveryFee\":0,\n\"itemSubtotal\":20\n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Orders"
  },
  {
    "type": "get",
    "url": "/favouriteProducts",
    "title": "Favourite Products Listing.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "favouriteProducts",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user Id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>page number (start with page number 1).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"productId\": 1,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"userId\":1,\n        \"productName\": \"Marinara\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\":\"50\"\n      },\n      {\n        \"productId\": 2,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"userId\":1,\n        \"productName\": \"Margherita\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\": \"60\"\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/user.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/featuredProducts",
    "title": "List of featured products.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "featuredProducts",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>Page number for pagination (start with page number 1).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"productId\": 1,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"productName\": \"Marinara\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\":\"50\",\n        \"isNewProduct\":\"1\" (1:Yes,0:No)\n      },\n      {\n        \"productId\": 2,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"productName\": \"Margherita\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\": \"60\",\n        \"isNewProduct\": \"0\" (1:Yes,0:No)\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getGiftCardList",
    "title": "List of gift cards.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getGiftCardList",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>Page number for pagination (start with page number 1).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n {\n \"Success\": true,\n\"Status\": 200,\n \"Message\": \"Success\",\n \"AppVersion\": \"1.0.0\",\n \"Result\": [\n   {\n \"gift_card_id\": 1,\n \"title\": \"Gift Card\",\n \"card_image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_giftcard_img_48976034.jpg\",\n \"giftCardImage\": []\n },\n   {\n \"gift_card_id\": 2,\n \"title\": \"Birthday card\",\n \"card_image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg\",\n \"giftCardImage\": [\n   {\n \"card_image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg\"\n },\n   {\n \"card_image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg\"\n },\n   {\n \"card_image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg\"\n }\n ]\n }\n ]\n }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getProductCategory/",
    "title": "Product Category.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getProductCategory",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>ID of user(0 in case of guest user)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>Unique device ID of user's device</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": {\n   \"header\": \"asdfsadf\",\n   \"data\": [\n   {\n   \"catId\": 18,\n   \"name\": \"checkCat1\",\n   \"image\": \"http://localhost/restaurant/admin/public/upload/1526468033.jpg\",\n   \"description\": null,\n   \"created_on\": \"2018-05-16 16:23:53\"\n   },\n   {\n   \"catId\": 16,\n   \"name\": \"sdfsadfa\",\n   \"image\": \"http://localhost/restaurant/admin/public/upload/1526399252.jpg\",\n   \"description\": null,\n   \"created_on\": \"2018-05-15 21:17:32\"\n   },\n   {\n   \"catId\": 12,\n   \"name\": \"asdfdf\",\n   \"image\": \"http://localhost/restaurant/admin/public/upload/1526398630.jpg\",\n   \"description\": null,\n   \"created_on\": \"2018-05-15 21:07:10\"\n   },\n   {\n   \"catId\": 11,\n   \"name\": \"BBBBASDSD\",\n   \"image\": \"http://localhost/restaurant/admin/public/upload/1526398271.jpg\",\n   \"description\": null,\n   \"created_on\": \"2018-05-15 21:01:11\"\n   },\n   {\n   \"catId\": 2,\n   \"name\": \"CAKES\",\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_category_img_69883192.jpg\",\n   \"description\": \"Bring Smile on face of your loved ones with the delicious cakes.\",\n   \"created_on\": \"2018-03-05 16:13:39\"\n   },\n   {\n   \"catId\": 1,\n   \"name\": \"Coffee\",\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_category_img_25780904.jpg\",\n   \"description\": \"Coffee is a brewed drink prepared from roasted coffee beans, which are the seeds of berries from the Coffea plant. The genus Coffea is native to tropical Africa, and Madagascar, the Comoros, Mauritius and Réunion in the Indian Ocean.\",\n   \"created_on\": \"2018-03-05 16:13:39\"\n   }\n   ],\n   \"cartItemCount\": 2\n   }\n   }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getProductDetails?productId=1",
    "title": "Product Details.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getProductDetails",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "productId",
            "description": "<p>product Id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user Id.</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n    \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Success\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": {\n    \"productDetail\": {\n    \"isFavourite\": 0,\n    \"image\": \"\",\n    \"productId\": 1,\n    \"catId\": 1,\n    \"subCatId\": 1,\n    \"productName\": \"sd\",\n    \"description\": \"asdfasdf\",\n    \"price\": \"50\"\n    },\n    \"topextraItems\": [\n    {\n    \"topLabelId\": 1,\n    \"productId\": 1,\n    \"labelNames\": \"Temp1\",\n    \"labelType\": 1,\n    \"labelOption\": 1,\n    \"labelOptions\": [\n    {\n    \"price\": \"50\",\n    \"labelOptionId\": 1,\n    \"labelId\": 1,\n    \"productId\": 1,\n    \"optionName\": \"Option 1\"\n    },\n    {\n    \"price\": \"40\",\n    \"labelOptionId\": 2,\n    \"labelId\": 1,\n    \"productId\": 1,\n    \"optionName\": \"Option 2\"\n    }\n    ]\n    },\n    {\n    \"topLabelId\": 5,\n    \"productId\": 1,\n    \"labelNames\": \"Temp2\",\n    \"labelType\": 1,\n    \"labelOption\": 2,\n    \"labelOptions\": [\n    {\n    \"price\": \"50\",\n    \"labelOptionId\": 5,\n    \"labelId\": 5,\n    \"productId\": 1,\n    \"optionName\": \"Option 5\"\n    },\n    {\n    \"price\": \"50\",\n    \"labelOptionId\": 6,\n    \"labelId\": 5,\n    \"productId\": 1,\n    \"optionName\": \"Option 6\"\n    }\n    ]\n    }\n    ],\n    \"additionalItems\": [\n    {\n    \"additionalProductId\": 1,\n    \"productId\": 1,\n    \"itemName\": \"sdfa\",\n    \"price\": \"40\"\n    }\n    ],\n    \"customizeTopLabelOptions\": [\n    {\n    \"custLabelId\": 1,\n    \"productId\": 1,\n    \"labelNames\": \"Toppings\"\n    },\n    {\n    \"custLabelId\": 2,\n    \"productId\": 1,\n    \"labelNames\": \"Size\"\n    },\n    {\n    \"custLabelId\": 3,\n    \"productId\": 1,\n    \"labelNames\": \"Extra\"\n    }\n    ],\n    \"verticalCustomizeOptionsWithPrice\": [\n    {\n    \"custlabelOptionId\": 7,\n    \"productId\": 1,\n    \"labelNames\": \"Bacon Crumble\",\n    \"prices\": [\n    {\n    \"labelNames\": \"Size\",\n    \"custlabelOptionPriceId\": 1,\n    \"productId\": 1,\n    \"amount\": \"0\",\n    \"custLabelId\": 2,\n    \"custlabelOptionId\": 7\n    },\n    {\n    \"labelNames\": \"Extra\",\n    \"custlabelOptionPriceId\": 2,\n    \"productId\": 1,\n    \"amount\": \"0\",\n    \"custLabelId\": 3,\n    \"custlabelOptionId\": 7\n    }\n    ]\n    },\n    {\n    \"custlabelOptionId\": 8,\n    \"productId\": 1,\n    \"labelNames\": \"Green Onions\",\n    \"prices\": [\n    {\n    \"labelNames\": \"Extra\",\n    \"custlabelOptionPriceId\": 3,\n    \"productId\": 1,\n    \"amount\": \"0\",\n    \"custLabelId\": 3,\n    \"custlabelOptionId\": 8\n    },\n    {\n    \"labelNames\": \"Size\",\n    \"custlabelOptionPriceId\": 4,\n    \"productId\": 1,\n    \"amount\": \"0\",\n    \"custLabelId\": 2,\n    \"custlabelOptionId\": 8\n    }\n    ]\n    },\n    {\n    \"custlabelOptionId\": 9,\n    \"productId\": 1,\n    \"labelNames\": \"Red Chillies\"\n    }\n    ]\n    }\n    }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getProductSubCategory?categoryId=1",
    "title": "Product Sub Category.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getProductSubCategory",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "categoryId",
            "description": "<p>product category Id.</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"subCatId\": 1,\n        \"subCatname\": \"Marinara\",\n        \"description\":\"\",\n        \"image\": \"\"\n      },\n      {\n        \"subCatId\": 2,\n        \"subCatname\": \"Margherita\",\n        \"description\":\"\",\n        \"subCatimage\": \"\"\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getProducts?subCatId=1",
    "title": "List of products.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getProducts",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "catId",
            "description": "<p>Category Id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "subCatId",
            "description": "<p>Subcategory Id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>Page number for pagination (start with page number 1).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"productId\": 1,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"productName\": \"Marinara\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\":\"50\",\n        \"isNewProduct\":\"1\" (1:Yes,0:No)\n      },\n      {\n        \"productId\": 2,\n        \"catId\": 1,\n        \"subCatId\": 1,\n        \"productName\": \"Margherita\",\n        \"description\":\"\",\n        \"image\": \"\",\n        \"price\": \"60\",\n        \"isNewProduct\": \"0\" (1:Yes,0:No)\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/product.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/getSuggestedProducts",
    "title": "List of suggested products.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getSuggestedProducts",
    "group": "Products",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "productId",
            "description": "<p>product Id.(Id will be comma separated like 1,2,3)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "pageNo",
            "description": "<p>Page number for pagination (start with page number 1).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"Success\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": {\n   \"products\": [\n   {\n   \"image\": \"https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_65235993.jpg\",\n   \"productId\": 7,\n   \"catId\": 18,\n   \"subCatId\": 3,\n   \"productName\": \"sfsdf\",\n   \"description\": \"Desc one\",\n   \"price\": \"333\",\n   \"isNewProduct\": \"0\"\n   },\n   {\n   \"image\": \"\",\n   \"productId\": 3,\n   \"catId\": 18,\n   \"subCatId\": 3,\n   \"productName\": \"product one\",\n   \"description\": \"Desc\",\n   \"price\": \"2000\",\n   \"isNewProduct\": \"0\"\n   }\n   ],\n   \"total\": 2\n   }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Products"
  },
  {
    "type": "get",
    "url": "/restaurantsMaster/",
    "title": "Get list of restaurants.",
    "version": "1.0.0",
    "name": "restaurantsMaster",
    "group": "Restaurants_Master",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"Success\": true,\n          \"Status\": 200,\n          \"Message\": \"Success\",\n          \"AppVersion\": \"1.0.0\",\n          \"Result\": [\n              {\n                  \"restaurantId\": 1,\n                  \"restaurantName\": \"McDonalds\",\n                  \"address\": \"\",\n                  \"latitude\": \"\",\n                  \"longitude\": \"\",\n                  \"phone\": \"\",\n               },\n               {\n                  \"restaurantId\": 2,\n                  \"restaurantName\": \"Pizza Hut\",\n                  \"address\": \"\",\n                  \"latitude\": \"\",\n                  \"longitude\": \"\",\n                  \"phone\": \"\",\n               }\n           ]",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Restaurants_Master"
  },
  {
    "type": "post",
    "url": "/changePassword/",
    "title": "Change Password",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "changePassword",
    "group": "Users_API__After_Login_",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "oldPassword",
            "description": "<p>User Old Passowrd.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "newPassword",
            "description": "<p>User New Passowrd.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Password Changed Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n                  \n              ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/user.js",
    "groupTitle": "Users_API__After_Login_"
  },
  {
    "type": "post",
    "url": "/favUnFavProduct",
    "title": "Favourite and unfavourite product.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "favUnFavProduct",
    "group": "Users_API__After_Login_",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "productId",
            "description": "<p>product Id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>userId.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "status",
            "description": "<p>favourite or unfavourite status (1:Favourite,0:Unfavourite).</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Successfully added as Favourite !\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\"status\":\"1\"}\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/user.js",
    "groupTitle": "Users_API__After_Login_"
  },
  {
    "type": "get",
    "url": "/myAccount/",
    "title": "User Profile Information.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "myAccount",
    "group": "Users_API__After_Login_",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Setting updated Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n                  {\n                      \"isNotification\": 1,\n                      \"userId\": 86,\n                      \"profilePic\": \"xyz\",\n                      \"firstName\": \"Ajay\",\n                      \"lastName\": \"Singh\",\n                      \"email\": \"ss.sharma@gmail.com\",\n                      \"dob\": \"1994-03-06\",\n                      \"countryCode\": \"+91\",\n                      \"phone\": \"86461634454\",\n                      \"rewards\": 0,\n                      \"deviceToken\": \"\",\n                      \"deviceType\": \"1\",\n                      \"deviceId\": \"8341f8f5ba42747\",\n                      \"userType\": \"1\",\n                      \"otp\": 1234\n                  }\n              ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/user.js",
    "groupTitle": "Users_API__After_Login_"
  },
  {
    "type": "post",
    "url": "/updateProfile/",
    "title": "Update User Profile.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "updateProfile",
    "group": "Users_API__After_Login_",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "firstName",
            "description": "<p>First Name.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "lastName",
            "description": "<p>Last Name.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dob",
            "description": "<p>Date of Birth.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "profilePic",
            "description": "<p>Profile Pic.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Profile updated Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n                  {\n                      \"isNotification\": 1,\n                      \"userId\": 86,\n                      \"profilePic\": \"xyz\",\n                      \"firstName\": \"Ajay\",\n                      \"lastName\": \"Singh\",\n                      \"email\": \"ss.sharma@gmail.com\",\n                      \"dob\": \"1994-03-06\",\n                      \"countryCode\": \"+91\",\n                      \"phone\": \"86461634454\",\n                      \"rewards\": 0,\n                      \"deviceToken\": \"\",\n                      \"deviceType\": \"1\",\n                      \"deviceId\": \"8341f8f5ba42747\",\n                      \"userType\": \"1\",\n                      \"otp\": 1234\n                  }\n              ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/user.js",
    "groupTitle": "Users_API__After_Login_"
  },
  {
    "type": "post",
    "url": "/updateSetting/",
    "title": "update user setting.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "updateSetting",
    "group": "Users_API__After_Login_",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "isNotification",
            "description": "<p>Notification toggle (1:Active,0:Inactive).</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "  HTTP/1.1 200 OK\n  {\n     \"Success\": true,\n      \"Status\": 200,\n      \"Message\": \"Setting updated Successfully\",\n      \"AppVersion\": \"1.0.0\",\n      \"Result\": [ { isNotification: '1', userId: '98' }\n]\n    }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/user.js",
    "groupTitle": "Users_API__After_Login_"
  },
  {
    "type": "post",
    "url": "/addAddress",
    "title": "addAddress",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          }
        ]
      }
    },
    "description": "<p>addAddress user into the app.</p>",
    "group": "Users",
    "name": "addAddress________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "first_name",
            "description": "<p>first_name (user email)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "last_name",
            "description": "<p>last_name</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "email",
            "description": "<p>email</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "password",
            "description": "<p>password</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "device_token",
            "description": "<p>device_token</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "device_type",
            "description": "<p>device_type</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "response",
            "description": "<p>response object</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "response.status",
            "description": "<p>response status ( 0 for error, 1 for success )</p>"
          },
          {
            "group": "Success 200",
            "type": "string",
            "optional": true,
            "field": "response.message",
            "defaultValue": "null",
            "description": "<p>error message</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": true,
            "field": "response.data",
            "defaultValue": "null",
            "description": "<p>response data</p> <hr>"
          }
        ]
      }
    },
    "version": "0.0.1",
    "filename": "routes/v1/user.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/changePhoneNumber/",
    "title": "Change Phone Number.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "changePhoneNumber",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>mobile number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "countryCode",
            "description": "<p>country code.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n   {\n   \"otp\": 9274\n   }\n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "get",
    "url": "/countrymobilecodes/",
    "title": "mobile country code.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "countrymobilecodes",
    "group": "Users",
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n   \"Status\": 200,\n   \"Message\": \"\",\n   \"AppVersion\": \"1.0.0\",\n   \"Result\": [\n        {\n                 \"id\": 1,\n                 \"country\": \"India\",\n                 \"mcode\": \"+91\"\n             }\n         ]\n }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "put",
    "url": "/deleteUserAddress",
    "title": "Delete address saved by user",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "deleteUserAddress",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "addressId",
            "description": "<p>Unique address ID</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Success\",\n\"AppVersion\": \"1.0.0\",\n\"Result\":  {\n\"addressType\": \"1\"\n}\n}",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/forgotPassword/",
    "title": "forgot password.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "forgotPassword",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>user email.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Password has been sent to your email.\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  []\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "get",
    "url": "/getNotifications/",
    "title": "Notifications.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getNotifications",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>userId</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "page",
            "description": "<p>page number (start with page number 1).</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"id\": 1,\n        \"message\": \"pizza\"\n      },\n      {\n        \"id\": 2,\n        \"message\": \"Drinks\"\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "get",
    "url": "/getUserAddressList",
    "title": "get user address list for delivery",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "getUserAddressList",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>user mobile's unique id.</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": [\n        {\n       \"address_id\": 1,\n   \"userId\": 1,\n   \"mobile_number\": \"9645454545\",\n   \"address_type\": \"1\",\n   \"house_number\": \"house no 11\",\n   \"location\": \"XYZ\",\n   \"landmark\": \"ABCD\"\n   },\n   {\n   \"address_id\": 2,\n   \"userId\": 1,\n   \"mobile_number\": \"96478874554\",\n   \"address_type\": \"2\",\n   \"house_number\": \"house no 12\",\n   \"location\": \"XYZ\",\n   \"landmark\": \"ABCD\"\n   }\n   ]\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/logout/",
    "title": "user logout.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "logout",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>device id.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": []\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/saveGuestUser",
    "title": "save guest user",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "saveGuestUser",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "firstName",
            "description": "<p>first name.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "lastName",
            "description": "<p>last name.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>email.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "mobileNumber",
            "description": "<p>mobile number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>device id of user mobile.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceToken",
            "description": "<p>device token of user mobile.</p>"
          },
          {
            "group": "Parameter",
            "type": "Number",
            "optional": false,
            "field": "deviceType",
            "description": "<p>type of user device.(1 for IOS, 2 for android)</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {}\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/saveUserAddress",
    "title": "save user address for delivery",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-userid",
            "description": "<p>send userid which using the api</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "x-cafejavas-token",
            "description": "<p>send jwt token</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "saveUserAddress",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>user id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "mobileNumber",
            "description": "<p>mobile number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>user mobile's unique id.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "landmark",
            "description": "<p>landmark.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "location",
            "description": "<p>location.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "houseNumber",
            "description": "<p>house number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "addressType",
            "description": "<p>type of address.(1=home, 2=office, 3=other)</p>"
          }
        ]
      }
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n   {\n        \"Success\": true,\n        \"Status\": 200,\n        \"Message\": \"Success\",\n        \"AppVersion\": \"1.0.0\",\n        \"Result\": {\n        \"addressId\" : 1\n        }\n   }",
          "type": "json"
        }
      ]
    },
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/sendOtp/",
    "title": "sendOtp.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "sendOtp",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>mobile number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "countryCode",
            "description": "<p>country code.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n   {\n   \"otp\": 9274\n   }\n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/signIn/",
    "title": "Login User (SignIn).",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "signIn",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>user email.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>user password.</p>"
          },
          {
            "group": "Parameter",
            "type": "string",
            "optional": false,
            "field": "deviceType",
            "description": "<p>user device type (1 for iOS 2 for Android).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceToken",
            "description": "<p>user device token.     *</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "guestUserId",
            "description": "<p>guest user id (if available).     *</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>device id of user's mobile</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\": [\n      {\n        \"userId\": 42,\n        \"firstName\": \"nitin\",\n        \"lastName\": \"shukla\",\n        \"email\": \"sfasdfa@sfa.com\",\n        \"dob\": \"1994-12-31T18:30:00.000Z\",\n        \"countryCode\": \"91\",\n        \"phone\": \"123sdfa\",\n        \"profilePic\": \"\",\n        \"rewards\": 0,\n        \"deviceToken\": \"sdfasdf\",\n        \"deviceType\": \"1\",\n        \"userType\": \"1\",\n        \"guestUserId\":\"2\",\n        \"isNotification\": \"1\" (0:Inactive,1: Active),\n        \"tokenExpirationTime\":360,\n        \"isMobileVerified\": \"1\" (0:Inactive,1: Active),\n      }\n    ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/signUp",
    "title": "signUp",
    "description": "<p>register user into the app.</p>",
    "group": "Users",
    "name": "signUp________________________________________________________________________________________________________________________________________________________________",
    "parameter": {
      "fields": {
        "Expected parameters": [
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "firstName",
            "description": "<p>firstName</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "lastName",
            "description": "<p>lastName</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "dob",
            "description": "<p>dob (1994-01-01)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "email",
            "description": "<p>email</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "phone",
            "description": "<p>phone</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "password",
            "description": "<p>password</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "profilePic",
            "description": "<p>profilePic</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "cpassword",
            "description": "<p>cpassword</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "deviceToken",
            "description": "<p>deviceToken</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "deviceType",
            "description": "<p>deviceType (1:iOS,2:android)</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "countryCode",
            "description": "<p>countryCode</p>"
          },
          {
            "group": "Expected parameters",
            "type": "string",
            "optional": false,
            "field": "deviceId",
            "description": "<p>deviceId</p> <hr>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "response",
            "description": "<p>response object</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "response.status",
            "description": "<p>response status ( 0 for error, 1 for success )</p>"
          },
          {
            "group": "Success 200",
            "type": "string",
            "optional": true,
            "field": "response.message",
            "defaultValue": "null",
            "description": "<p>error message</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": true,
            "field": "response.data",
            "defaultValue": "null",
            "description": "<p>response data</p> <hr>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "    {\n\"Success\": true,\n\"Status\": 200,\n\"Message\": \"Sign Up Successfully\",\n\"AppVersion\": \"1.0.0\",\n\"Result\": [\n{\n\"userId\": 45,\n\"firstName\": \"nitin\",\n\"lastName\": \"shukla\",\n\"email\": \"dsfasd5fa@sfa.com\",\n\"dob\": \"1994-12-31T18:30:00.000Z\",\n\"profilePic\": \"\",\n\"password\": \"123456\",\n\"countryCode\": \"91\",\n\"phone\": \"125d3sdfa\",\n\"rewards\": 0,\n\"deviceToken\": \"sfdasdfa\",\n\"deviceType\": \"1\",\n\"deviceId\": \"sfasfa3d24sf\",\n\"userType\": \"1\",\n\"otp\": 6042,\n\"isNotification\": \"1\" (0:Inactive,1: Active),\n\"tokenExpirationTime\":360\n}\n],\n}",
          "type": "json"
        }
      ]
    },
    "version": "0.0.1",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/userFeedback/",
    "title": "User Feedback",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "userFeedback",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>email.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "feedback",
            "description": "<p>user feedback.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Feedback sent Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n   \n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/userRating",
    "title": "User Rating",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "userRating",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "foodRate",
            "description": "<p>food rate.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "driverRate",
            "description": "<p>driver rate (if not applicable send 0).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "userId",
            "description": "<p>(user id if it is not guest user else send 0).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "orderId",
            "description": "<p>order ID.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "isGuestuser",
            "description": "<p>(0=NO, 1=Yes).</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "review",
            "description": "<p>user review.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "deviceId",
            "description": "<p>user deviceId</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"Review Saved Successfully\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n   \n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  },
  {
    "type": "post",
    "url": "/verifyOtp/",
    "title": "verifyOtp.",
    "header": {
      "fields": {
        "Header": [
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "Content-Type",
            "description": "<p>multipart/form-data.</p>"
          },
          {
            "group": "Header",
            "type": "String",
            "optional": false,
            "field": "language",
            "description": "<p>send language flag</p>"
          }
        ]
      }
    },
    "version": "1.0.0",
    "name": "verifyOtp",
    "group": "Users",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>mobile number.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "countryCode",
            "description": "<p>country code.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "otp",
            "description": "<p>otp code.</p>"
          }
        ]
      }
    },
    "success": {
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "Success",
            "description": "<p>Success status either true or false.</p>"
          },
          {
            "group": "Success 200",
            "type": "Number",
            "optional": false,
            "field": "Status",
            "description": "<p>status code.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Message",
            "description": "<p>string.</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "Response",
            "description": "<p>data.</p>"
          }
        ]
      },
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"Success\": true,\n    \"Status\": 200,\n    \"Message\": \"\",\n    \"AppVersion\": \"1.0.0\",\n    \"Result\":  [\n   {\n   \"userId\": 45,\n   \"firstName\": \"nitin\",\n   \"lastName\": \"shukla\",\n   \"email\": \"dsfasd5fa@sfa.com\",\n   \"dob\": \"1994-12-31T18:30:00.000Z\",\n   \"profilePic\": \"\",\n   \"password\": \"123456\",\n   \"countryCode\": \"91\",\n   \"phone\": \"125d3sdfa\",\n   \"rewards\": 0,\n   \"deviceToken\": \"sfdasdfa\",\n   \"deviceType\": \"1\",\n   \"deviceId\": \"sfasfa3d24sf\",\n   \"userType\": \"1\",\n   \"otp\": 6042,\n   \"isNotification\": \"1\" (0:Inactive,1: Active),\n   \"tokenExpirationTime\":360\n   }\n   ]\n  }",
          "type": "json"
        }
      ]
    },
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i http://staging.techaheadcorp.com:3000/api/v1",
        "type": "curl"
      }
    ],
    "filename": "routes/v1/index.js",
    "groupTitle": "Users"
  }
] });
