"use strict";
//tracer

var logger = require("tracer").colorConsole({
  format: [
    "{{timestamp}} (in line: {{line}}) >> {{message}}", //default format
    {
      error:
        "{{timestamp}} <{{title}}> {{message}} (in {{file}}:{{line}})\nCall Stack:\n{{stack}}", // error format
    },
  ],
  dateformat: "HH:MM:ss.L",
  preprocess: function (data) {
    data.title = data.title.toUpperCase();
  },
});
var appVersion = "1.0.0";
var languages = require("../../locales/languages"),
  _ = require("lodash");
/**** Export API V1 ****/
var lang;

/**** Export API V1 ****/

module.exports = function (
  app,
  express,
  connection,
  inspector,
  successStatus,
  status,
  message,
  appVersion,
  data,
  Utils
) {
  //connection.connect();
  var driver = express.Router();
  driver.use(function (req, res, next) {
    lang = req.headers["language"];
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }
    next();
  });

  /**** Route not need to check access token ****/

  driver.get("/", function (req, res, next) {
    res.status(200).send("Welcome to the Cafe java server!");
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {post} /ordersByDriver ordersByDriver
   * @apiDescription Get order list for driver
   * @apiGroup Orders
   * @apiName ordersByDriver
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string} 			id 					first_name (user email)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}  						response       						response object
   * @apiSuccess {Number=0,1}  						response.status   				response status ( 0 for error, 1 for success )
   * @apiSuccess {string}  							[response.message=null]   		error message
   * @apiSuccess {Object}  							[response.data=null]   			response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */
  driver.get("/ordersByDriver/:id", function (req, res, next) {
    var driver_id = req.params.id;
    var query =
      "SELECT ord.*,inv.price,inv.final_price,inv.discount_price,inv.delivery_charges,inv.transection_id,inv.transection_date,inv.payment_method FROM `orders` ord LEFT JOIN invoice inv on(ord.order_id=inv.order_id) WHERE ord.driver_id=?";

    connection.query(query, [driver_id], function (err, rows, fields) {
      if (!err) {
        if (rows.length > 0) {
          successStatus = true;
          status = 200;
          data = rows;
          message = "Records found successfully.";
        } else {
          successStatus = false;
          status = 404;
          data = "";
          message = "No record found!";
        }
      } else {
        successStatus = false;
        status = 404;
        data = "";
        message = "" + err;
      }
      Utils.makeResponse(res, successStatus, status, message, appVersion, data);
    });
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {post} /ordersByDriver ordersByDriver
   * @apiDescription Get order list for driver
   * @apiGroup Orders
   * @apiName ordersByDriver
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string} 			id 					first_name (user email)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}  						response       						response object
   * @apiSuccess {Number=0,1}  						response.status   				response status ( 0 for error, 1 for success )
   * @apiSuccess {string}  							[response.message=null]   		error message
   * @apiSuccess {Object}  							[response.data=null]   			response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */
  driver.put("/updateOrderStatusByDriver/", function (req, res, next) {
    var order = req.body;

    var query = "update orders set status=? where order_id=?";

    connection.query(
      query,
      [order.status, order.order_id],
      function (err, rows, fields) {
        if (rows) {
          var is_guest = 0;
          var order_status = "";
          var user_id = Utils.getUserIdByOrderId(connection, order.order_id);
          if (user_id == 0) {
            is_guest = 1;
          }

          if (order.status == 3) {
            order_status = "On the way";
          } else if (order.status == 4) {
            order_status = "Delivered";
          }

          var query1 =
            "INSERT INTO customers_order_status_logs SET order_id = ?,customer_id = ?,is_guest = ?, order_status = ?, created_at, updated_at = now()";
          connection.query(
            query1,
            [order.order_id, user_id, is_guest, order_status],
            function (err1, rows1, fields1) {}
          );

          // Update driver availability if order status is delivered
          if (order.status == 4) {
            var driver_id = Utils.getDriverIdByOrderId(
              connection,
              order.order_id
            );
            var query2 =
              "INSERT INTO tbl_driver SET is_available = 1 WHERE id = ?";
            connection.query(
              query2,
              [driver_id],
              function (err2, rows2, fields2) {}
            );
          }

          successStatus = true;
          status = 200;
          message = "Records updated successfully.";
        }
        console.log(status);
        Utils.makeResponse(
          res,
          successStatus,
          status,
          message,
          appVersion,
          data
        );
      }
    );
  });

  return driver;
};
