"use strict";

/**** Get the packages we need ****/
//tracer

var logger = require("tracer").colorConsole({
  format: [
    "{{timestamp}} (in line: {{line}}) >> {{message}}", //default format
    {
      error:
        "{{timestamp}} <{{title}}> {{message}} (in {{file}}:{{line}})\nCall Stack:\n{{stack}}", // error format
    },
  ],
  dateformat: "HH:MM:ss.L",
  preprocess: function (data) {
    data.title = data.title.toUpperCase();
  },
});

var appVersion = "1.0.0";
var languages = require("../../locales/languages"),
  _ = require("lodash"),
  config = require("../../config/config.js"),
  synceach = require("sync-each"),
  Auth = require("../../util/Auth");
// Auth        = require("../../util/Auth");
var qr = require("qr-image");
var pageLimit = config.CONSTANTS.pageLimit;
/**** Export API V1 ****/
var lang;
var moment = require("moment");
var Request = require("request");
var distance = require("google-distance-matrix");
var crypto = require("crypto");
const bcrypt = require("bcrypt");
const saltRounds = 10;

module.exports = function (app, express, connection, inspector, Utils) {
  //connection.connect();
  var api = express.Router();

  api.use(function (req, res, next) {
    lang = req.headers["language"];
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }
    next();
  });

  api.get("/", function (req, res, next) {
    res
      .status(200)
      .send(
        "<center><h3>Start creating your amazing application!</h3></center>"
      );
  });

  api.get("/orderFoodReady", function (req, res) {
    logger.info('EXPRESS: get("/orderFoodReady") --> RECEIVED'.event);

    logger.log("%O", req.query);
    var orderReq = req.query;

    var schema = {
      type: "object",
      properties: {
        orderNum: { type: "any" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, orderReq);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var orderType = orderReq.orderNum.substring(0, 13);
      if (orderType == "CAFEJAVAS_CC_") {
        console.log("Callcenter Order");
        var ccOrder = "SELECT * FROM callcenter_orders where order_num=?";
        connection.query(
          ccOrder,
          [orderReq.orderNum],
          function (err, resporder) {
            if (err) {
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else if (resporder.length > 0) {
              if (resporder[0]["status"] == "0") {
                message = "Order not approved";
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else if (resporder[0]["status"] == "4") {
                message = "Order already delivered";
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else if (resporder[0]["status"] == "5") {
                message = "Order cancelled";
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                var updateccOrder = `update callcenter_orders set status = '2',updated_at = NOW() where order_id=?`;
                connection.query(
                  updateccOrder,
                  [resporder[0]["order_id"]],
                  function (err, result) {
                    if (err) {
                      message = languages.something_went_wrong[lang];
                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    } else {
                      var checkccOrderLog = `select * from callcenter_order_status_logs where order_id = ? and order_status = ?`;
                      connection.query(
                        checkccOrderLog,
                        [resporder[0]["order_id"], "Food is Ready"],
                        function (err, res) {
                          if (res.length == 0) {
                            var insertccOrderLog = `insert into callcenter_order_status_logs set order_id = ?,order_status = ?,created_at = NOW(),updated_at = NOW()`;
                            connection.query(
                              insertccOrderLog,
                              [resporder[0]["order_id"], "Food is Ready"],
                              function (err, result) { }
                            );
                          }
                        }
                      );
                      message = "Callcenter Order Status Updated";
                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        data
                      );
                    }
                  }
                );
              }
            } else {
              message = "Order not found";
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            }
          }
        );
      } else if (orderReq.orderNum.substring(0, 10) == "CAFEJAVAS_") {
        console.log("Normal Order");
        var order = "SELECT * FROM orders where order_num=?";
        connection.query(order, [orderReq.orderNum], function (err, resporder) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (resporder.length > 0) {
            if (resporder[0]["status"] == "0") {
              message = "Order not approved";
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else if (resporder[0]["status"] == "4") {
              message = "Order already delivered";
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else if (resporder[0]["status"] == "5") {
              message = "Order cancelled";
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else {
              var updateccOrder = `update orders set status = '2',updated_at = NOW() where order_id=?`;
              connection.query(
                updateccOrder,
                [resporder[0]["order_id"]],
                function (err, result) {
                  if (err) {
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    var checkccOrderLog = `select * from customers_order_status_logs where order_id = ? and order_status = ?`;
                    connection.query(
                      checkccOrderLog,
                      [resporder[0]["order_id"], "Food is Ready"],
                      function (err, res) {
                        if (res.length == 0) {
                          var insertccOrderLog = `insert into customers_order_status_logs set order_id = ?,customer_id = ?,is_guest = ?,order_status = ?,created_at = NOW(),updated_at = NOW()`;
                          connection.query(
                            insertccOrderLog,
                            [
                              resporder[0]["order_id"],
                              resporder[0]["user_id"],
                              resporder[0]["is_guest_user"],
                              "Food is Ready",
                            ],
                            function (err, result) { }
                          );
                        }
                      }
                    );
                    message = "Order Status Updated";
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              );
            }
          } else {
            message = "Order not found";
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
        });
      } else {
        console.log("Improper Order Number");
        message = "Improper Order Number";
        Utils.makeResponse(res, false, 400, message, appVersion, data);
      }
    }
  });

  function getBranchAvailableDriver(branchId) {
    return new Promise(function (resolve, reject) {
      var qry =
        "SELECT * FROM tbl_driver WHERE branch_id = ? AND status = '1' AND user_type = '1' AND is_delete = '0' AND is_available = 1 AND shift_start_time IS NOT NULL AND shift_end_time IS NOT NULL";
      connection.query(qry, [branchId], function (err, rows, fields) {
        if (err) {
          resolve(0);
        } else {
          if (rows.length > 0) {
            var DriverId;
            var idArray = [];
            synceach(
              rows,
              function (item, next) {
                var start = moment(item.shift_start_time, ["h:mm A"]).format(
                  "HH:mm:ss"
                );
                var end = moment(item.shift_end_time, ["h:mm A"]).format(
                  "HH:mm:ss"
                );
                var currentTime = moment().add(3, "hours").format("HH:mm:ss");
                console.log("Driver ID : ", item.id);
                console.log("Start Time : ", start);
                console.log("End Time : ", end);
                console.log("Current Time : ", currentTime);
                var orderCount =
                  "SELECT count(order_id) as orderCount from orders where driver_id = ? and status != '4' and status != '5'";
                connection.query(
                  orderCount,
                  [item.id],
                  function (error, orderRows, fields) {
                    // console.log("Driver Order Count : ", orderRows[0].orderCount)
                    if (
                      currentTime > start &&
                      currentTime < end &&
                      orderRows[0].orderCount == 0
                    ) {
                      idArray.push(item.id);
                    }
                    next();
                  }
                );
              },
              function (err, transformedItems) {
                console.log("idArray : ", idArray);
                if (idArray.length > 0) {
                  DriverId =
                    idArray[Math.floor(Math.random() * idArray.length)];
                  // console.log("Random Driver ID : ", DriverId);
                } else {
                  DriverId = 0;
                  // console.log("Random Driver ID : ", DriverId);
                }
                resolve(DriverId);
              }
            );
          } else {
            resolve(0);
          }
        }
      });
    });
  }

  function getEstimateDeliveryTime(branchId, addressId) {
    return new Promise(function (resolve, reject) {
      var defaultTime = "01:00:00";
      var deliveryTime;
      var qry =
        "SELECT latitude,longitude FROM tbl_branches where branch_id = ?";
      connection.query(qry, [branchId], function (err, rows, fields) {
        if (err) {
          resolve(defaultTime);
        } else {
          if (rows.length > 0) {
            var qry2 =
              "SELECT latitude,longitude FROM user_address where id = ?";
            connection.query(
              qry2,
              [addressId],
              function (err2, rows2, fields2) {
                if (err2) {
                  resolve(defaultTime);
                } else {
                  if (rows2.length > 0) {
                    var origins = [rows[0].latitude + "," + rows[0].longitude];
                    var destinations = [
                      rows2[0].latitude + "," + rows2[0].longitude,
                    ];

                    distance.key(config.CONSTANTS.GOOGLE_DISTANCE_KEY);
                    distance.units("metric");

                    distance.matrix(
                      origins,
                      destinations,
                      function (err, distances) {
                        if (err) {
                          resolve(defaultTime);
                        }
                        if (!distances) {
                          resolve(defaultTime);
                        }
                        if (distances.status == "OK") {
                          if (distances.rows[0].elements[0].status == "OK") {
                            var distance =
                              distances.rows[0].elements[0].distance.value /
                              1000;
                            if (distance <= 5) {
                              deliveryTime = "00:40:00";
                            } else if ($distance > 5 && $distance <= 9) {
                              deliveryTime = "00:50:00";
                            } else {
                              deliveryTime = "01:00:00";
                            }
                            resolve(deliveryTime);
                          } else {
                            resolve(defaultTime);
                          }
                        }
                      }
                    );
                  } else {
                    resolve(defaultTime);
                  }
                }
              }
            );
          } else {
            resolve(defaultTime);
          }
        }
      });
    });
  }

  function assignPendingOrder(branchId, driverId) {
    return new Promise(function (resolve, reject) {
      var qry =
        "SELECT count(order_id) as orderCount from orders where driver_id = ? and status != '4' and status != '5'";
      connection.query(qry, [driverId], function (err, rows, fields) {
        if (err) {
          resolve(0);
        } else {
          if (rows.length > 0) {
            if (rows[0].orderCount == 0) {
              var qry1 =
                "select order_id from orders where branch_id = ? and driver_id = 0 and status NOT IN('0','4','5') and pickup_type = '0' limit 1";
              connection.query(
                qry1,
                [branchId],
                function (err1, rows1, fields1) {
                  if (err1) {
                    resolve(0);
                  } else {
                    if (rows1.length > 0) {
                      var updateStatus =
                        "update orders set driver_id = ?, status = '2' where order_id = ?";
                      connection.query(
                        updateStatus,
                        [driverId, rows1[0].order_id],
                        function (err2, Data) {
                          if (err2) {
                            resolve(0);
                          } else {
                            connection.query(
                              "select id, user_type, device_type, device_token from tbl_driver where id =?",
                              [driverId],
                              function (err, result) {
                                if (err) {
                                  resolve(0);
                                } else {
                                  var device_token = result[0].device_token;
                                  var title = "CafeJavas";
                                  var message =
                                    " You have 1 new order to deliver.";
                                  var customData = {
                                    notification_type: "11", //Assigned to Driver
                                    order_id: rows1[0].order_id,
                                    user_id: result[0].id,
                                  };
                                  var notificationParams = {
                                    notification_type: "11", //Assigned to Driver
                                    message: message,
                                    order_id: rows1[0].order_id,
                                    user_id: result[0].id,
                                    send_to: "3",
                                  };

                                  if (result[0].device_type == "1") {
                                    //CODE FOR IOS PUSH NOTIFICATION

                                    Utils.sendiOSPush(
                                      connection,
                                      notificationParams,
                                      device_token,
                                      config.CONSTANTS.BUNDLE_ID,
                                      title,
                                      message,
                                      customData
                                    ).then(function (pushResult, pushError) {
                                      if (pushError) {
                                        console.log("iOS errrorr");
                                      } else {
                                        console.log(
                                          "herer++++++++++********************"
                                        );
                                      }
                                    });
                                  } else {
                                    //CODE FOR ANDROID PUSH NOTIFICATION

                                    Utils.sendAndroidPush(
                                      connection,
                                      notificationParams,
                                      device_token,
                                      title,
                                      message,
                                      customData
                                    ).then(function (error, response) {
                                      if (error) {
                                        console.log("Android errrorr");
                                      } else {
                                        //do nothing
                                        console.log("else true customer");
                                        var data = {},
                                          success = true,
                                          status = 200,
                                          message = custom_message;
                                        Util.makeResponse(
                                          res,
                                          success,
                                          status,
                                          message,
                                          appVersion,
                                          data
                                        );
                                      }
                                    });
                                  }
                                  resolve(0);
                                }
                              }
                            );
                          }
                        }
                      );
                    } else {
                      resolve(0);
                    }
                  }
                }
              );
            } else {
              resolve(0);
            }
          } else {
            resolve(0);
          }
        }
      });
    });
  }

  function getDriverDetails(driverId) {
    return new Promise(function (resolve, reject) {
      var driverqry = "select vehicle_no from tbl_driver where id = ?";
      connection.query(driverqry, [driverId], function (err, rows, fields) {
        if (err) {
          console.log(err);
          resolve(0);
        } else {
          if (rows.length > 0) {
            resolve(rows[0].vehicle_no);
          } else {
            resolve(0);
          }
        }
      });
    });
  }

  function getJimiAccessToken() {
    return new Promise(function (resolve, reject) {
      var qry = "select * from gps_token where id = 1";
      connection.query(qry, [], function (err, rows, fields) {
        if (err) {
          console.log(err);
          resolve(0);
        } else {
          if (rows.length > 0) {
            resolve(rows[0]);
          } else {
            resolve(0);
          }
        }
      });
    });
  }

  function genJimiRefreshToken(accessToken, refreshToken) {
    return new Promise(function (resolve, reject) {
      let queryString = "";
      queryString = "accessToken" + accessToken + "refreshToken" + refreshToken;

      queryString = `appSecrect${queryString}appSecrect`;
      const hash = crypto.createHash("md5").update(queryString).digest("hex");
      const d = new Date();
      const month = d.getUTCMonth() + 1;
      const day = d.getUTCDate();
      const year = d.getUTCFullYear();
      const hours = d.getUTCHours();
      const mintues = d.getUTCMinutes() + 10;
      const seconds = d.getUTCSeconds();
      const timestamp =
        year +
        "-" +
        month +
        "-" +
        day +
        " " +
        hours +
        ":" +
        mintues +
        ":" +
        seconds;
      const refreshTokenData = {
        method: "jimi.oauth.token.refresh",
        access_token: accessToken,
        refresh_token: refreshToken,
        timestamp: timestamp,
        expires_in: 7200,
        app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
        format: "json",
        v: 0.9,
        sign: hash,
        sign_method: "md5",
      };
      Request(
        {
          url: "http://open.10000track.com/route/rest",
          form: refreshTokenData,
          method: "POST",
        },
        function (error, response, body) {
          if (!error && response.statusCode == 200) {
            resolve(response);
          } else {
            resolve(0);
          }
        }
      );
    });
  }

  function genJimiFreshToken() {
    return new Promise(function (resolve, reject) {
      let queryString = "";
      queryString =
        "user_idcjsfooddeliveryuser_pwd_md5bdb8dff48c0bd1f714c610079f143298expires_in7200";

      queryString = `appSecrect${queryString}appSecrect`;
      const hash = crypto.createHash("md5").update(queryString).digest("hex");
      const pass = crypto.createHash("md5").update("Cjs@2019").digest("hex");
      const d = new Date();
      const month = d.getUTCMonth() + 1;
      const day = d.getUTCDate();
      const year = d.getUTCFullYear();
      const hours = d.getUTCHours();
      const mintues = d.getUTCMinutes() + 10;
      const seconds = d.getUTCSeconds();
      const timestamp =
        year +
        "-" +
        month +
        "-" +
        day +
        " " +
        hours +
        ":" +
        mintues +
        ":" +
        seconds;
      let data = [];
      const postData = {
        method: "jimi.oauth.token.get",
        app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
        sign: hash,
        sign_method: "md5",
        user_id: "cjsfooddelivery",
        user_pwd_md5: pass,
        expires_in: 7200,
        timestamp: timestamp,
        v: 0.9,
        format: "json",
        app_secret: "49f9b86049434633b3ec2da1f8a675f3",
      };
      let message = languages.bad_request[lang];
      Request(
        {
          url: "http://open.10000track.com/route/rest",
          form: postData,
          method: "POST",
        },
        function (error, response, body) {
          if (!error && response.statusCode == 200) {
            body = JSON.parse(body);
            if (body.code === 0) {
              resolve(body);
            } else {
              resolve(0);
            }
          } else {
            resolve(0);
          }
        }
      );
    });
  }

  function getJimiLiveLocation(accessToken, imei) {
    return new Promise(function (resolve, reject) {
      let queryString = "";
      queryString = "accessToken" + accessToken + "imeis" + imei;

      queryString = `appSecrect${queryString}appSecrect`;
      const hash = crypto.createHash("md5").update(queryString).digest("hex");
      const d = new Date();
      const month = d.getUTCMonth() + 1;
      const day = d.getUTCDate();
      const year = d.getUTCFullYear();
      const hours = d.getUTCHours();
      const mintues = d.getUTCMinutes() + 10;
      const seconds = d.getUTCSeconds();
      const timestamp =
        year +
        "-" +
        month +
        "-" +
        day +
        " " +
        hours +
        ":" +
        mintues +
        ":" +
        seconds;
      const deviceGetData = {
        method: "jimi.device.location.get",
        access_token: accessToken,
        imeis: imei,
        map_type: "GOOGLE",
        app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
        timestamp: timestamp,
        format: "json",
        v: 0.9,
        sign: hash,
        sign_method: "md5",
      };

      Request(
        {
          url: "http://open.10000track.com/route/rest",
          form: deviceGetData,
          method: "POST",
        },
        function (error, response, body) {
          if (!error && response.statusCode == 200) {
            resolve(body);
          } else {
            resolve(0);
          }
        }
      );
    });
  }

  api.get("/getDriverLocation", function (req, res) {
    logger.info('EXPRESS: post("/getDriverLocation") --> RECEIVED'.event);

    var user = req.query;
    var data = [];
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        driverId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];
      logger.log(validationresult.format());
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      getDriverDetails(user.driverId)
        .then((vehicleNo) => {
          if (vehicleNo != 0) {
            getJimiAccessToken().then((dbToken) => {
              if (dbToken != 0) {
                var currTime = moment().format("YYYY-MM-DD HH:mm:ss");
                var expTime = dbToken.expiresIn;
                if (currTime > expTime) {
                  genJimiRefreshToken(
                    dbToken.accessToken,
                    dbToken.refreshToken
                  ).then((refToken) => {
                    if (refToken != 0) {
                      var refDataObj = JSON.parse(refToken.body);

                      let exp = moment(refDataObj.result.time)
                        .add(2, "hours")
                        .format("YYYY-MM-DD HH:mm:ss");
                      var updateqry =
                        "update gps_token set accessToken = ?, refreshToken = ?, expiresIn = ? where id = 1";
                      connection.query(
                        updateqry,
                        [
                          refDataObj.result.accessToken,
                          refDataObj.result.refreshToken,
                          exp,
                        ],
                        function (err, RespData) { }
                      );

                      var qry1 =
                        "select imei from vehicles where vehicle_no = ? and is_deleted = 0 order by id desc";
                      connection.query(
                        qry1,
                        [vehicleNo],
                        function (err, result) {
                          if (err) {
                            var message = "Vehicle IMEI not determined";
                            finalData.driverLat = 0;
                            finalData.driverLong = 0;
                            Utils.makeResponse(
                              res,
                              false,
                              400,
                              message,
                              appVersion,
                              finalData
                            );
                          } else {
                            getJimiLiveLocation(
                              refDataObj.result.accessToken,
                              result[0].imei
                            ).then((liveData) => {
                              if (liveData != 0) {
                                var message = "Driver Live Coordinates";
                                var liveDataObj = JSON.parse(liveData);
                                finalData.driverLat = liveDataObj.result[0].lat;
                                finalData.driverLong =
                                  liveDataObj.result[0].lng;
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  finalData
                                );
                              } else {
                                var message = "Location not determined";
                                finalData.driverLat = 0;
                                finalData.driverLong = 0;
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  finalData
                                );
                              }
                            });
                          }
                        }
                      );
                    } else {
                      genJimiFreshToken().then((newToken) => {
                        if (newToken != 0) {
                          let exp = moment(newToken.result.time)
                            .add(2, "hours")
                            .format("YYYY-MM-DD HH:mm:ss");
                          var updateqry =
                            "update gps_token set accessToken = ?, refreshToken = ?, expiresIn = ? where id = 1";
                          connection.query(
                            updateqry,
                            [
                              newToken.result.accessToken,
                              newToken.result.refreshToken,
                              exp,
                            ],
                            function (err, RespData) { }
                          );

                          var qry1 =
                            "select imei from vehicles where vehicle_no = ? and is_deleted = 0 order by id desc";
                          connection.query(
                            qry1,
                            [vehicleNo],
                            function (err, result) {
                              if (err) {
                                var message = "Vehicle IMEI not determined";
                                finalData.driverLat = 0;
                                finalData.driverLong = 0;
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  finalData
                                );
                              } else {
                                getJimiLiveLocation(
                                  newToken.result.accessToken,
                                  result[0]["imei"]
                                ).then((liveData) => {
                                  if (liveData != 0) {
                                    var message = "Driver Live Coordinates";
                                    var liveDataObj = JSON.parse(liveData);
                                    finalData.driverLat =
                                      liveDataObj.result[0].lat;
                                    finalData.driverLong =
                                      liveDataObj.result[0].lng;
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      finalData
                                    );
                                  } else {
                                    var message = "Location not determined";
                                    finalData.driverLat = 0;
                                    finalData.driverLong = 0;
                                    Utils.makeResponse(
                                      res,
                                      false,
                                      400,
                                      message,
                                      appVersion,
                                      finalData
                                    );
                                  }
                                });
                              }
                            }
                          );
                        } else {
                          var message = "New token not generated";
                          finalData.driverLat = 0;
                          finalData.driverLong = 0;
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      });
                    }
                  });
                } else {
                  var qry1 =
                    "select imei from vehicles where vehicle_no = ? and is_deleted = 0 order by id desc";
                  connection.query(qry1, [vehicleNo], function (err, result) {
                    if (err) {
                      var message = "Vehicle IMEI not determined";
                      finalData.driverLat = 0;
                      finalData.driverLong = 0;
                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        finalData
                      );
                    } else {
                      getJimiLiveLocation(
                        dbToken.accessToken,
                        result[0]["imei"]
                      ).then((liveData) => {
                        if (liveData != 0) {
                          var message = "Driver Live Coordinates";
                          var liveDataObj = JSON.parse(liveData);
                          finalData.driverLat = liveDataObj.result[0].lat;
                          finalData.driverLong = liveDataObj.result[0].lng;
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            finalData
                          );
                        } else {
                          var message = "Location not determined";
                          finalData.driverLat = 0;
                          finalData.driverLong = 0;
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      });
                    }
                  });
                }
              } else {
                finalData.driverLat = 0;
                finalData.driverLong = 0;
                var message = languages.something_went_wrong[lang];
                Utils.makeResponse(
                  res,
                  false,
                  400,
                  message,
                  appVersion,
                  finalData
                );
              }
            });
          } else {
            finalData.driverLat = 0;
            finalData.driverLong = 0;
            var message = "Vehicle Number not found";
            Utils.makeResponse(res, false, 400, message, appVersion, finalData);
          }
        })
        .catch(function (err) {
          console.log("errorProductcheck" + err);
          finalData.driverLat = 0;
          finalData.driverLong = 0;
          var message = "Driver details not found";
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        });
    }
  });

  api.post("/driverrfCheck", function (req, res) {
    logger.info('EXPRESS: post("/driverrfCheck") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var rfReq = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        antennaID: { type: "any" },
        tagID: { type: "string" },
        seenTime: { type: "string" },
        tagSeenCount: { type: "any" },
        relativeDistance: { type: "any" },
        zoneID: { type: "any" },
        zoneName: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, rfReq);

    if (!validationresult.valid) {
      //message = languages.bad_request[lang];
      message = "error1";

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var rfReqQuery = `insert into tbl_driver_rf set antennaID=?,tagID=?,seenTime=?,tagSeenCount=?,relativeDistance=?,zoneID=?,zoneName=?`;

      connection.query(
        rfReqQuery,
        [
          rfReq.antennaID,
          rfReq.tagID,
          rfReq.seenTime,
          rfReq.tagSeenCount,
          rfReq.relativeDistance,
          rfReq.zoneID,
          rfReq.zoneName,
        ],
        function (err, rfRespData) {
          if (err) {
            //message = languages.something_went_wrong[lang];
            message = "error2";
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (rfRespData) {
            var qry =
              "select d.id, d.first_name, d.is_available, d.branch_id, v.vehicle_no from vehicles as v join tbl_driver as d on v.vehicle_no = d.vehicle_no where v.rf_id = ? and v.is_deleted = 0";
            connection.query(qry, [rfReq.tagID], function (err, RespData) {
              if (err) {
                //message = languages.something_went_wrong[lang];
                message = "error2";
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else if (RespData) {
                if (RespData.length > 0) {
                  if (RespData[0]["is_available"] == "1") {
                    var availability = "0";
                  } else {
                    var availability = "1";
                  }
                  var updateStatus =
                    "update tbl_driver set is_available = ? where id = ?";
                  connection.query(
                    updateStatus,
                    [availability, RespData[0]["id"]],
                    function (err, Data) {
                      if (err) {
                        //message = languages.something_went_wrong[lang];
                        message = "error2";
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      } else if (Data) {
                        if (availability == "1") {
                          assignPendingOrder(
                            RespData[0]["branch_id"],
                            RespData[0]["id"]
                          ).then((result) => {
                            var status = 200;
                            var successStatus = true;
                            message = "Driver Availability Updated";
                            data = [];
                            Utils.makeResponse(
                              res,
                              successStatus,
                              status,
                              message,
                              appVersion,
                              data
                            );
                          });
                        } else {
                          var status = 200;
                          var successStatus = true;
                          message = "Driver Availability Updated";
                          data = [];
                          Utils.makeResponse(
                            res,
                            successStatus,
                            status,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    }
                  );
                } else {
                  var status = 200;
                  var successStatus = true;
                  message = languages.rfsaved_successfully[lang];
                  data = [];
                  Utils.makeResponse(
                    res,
                    successStatus,
                    status,
                    message,
                    appVersion,
                    data
                  );
                }
              }
            });
          }
        }
      );
    }
  });

  api.post("/jimi-token", function (req, res) {
    const requestData = req.body;
    let queryString = "";
    Object.keys(requestData)
      .sort()
      .forEach(function (key) {
        queryString += key;
        queryString += requestData[key];
      });
    queryString = `appSecrect${queryString}appSecrect`;
    const hash = crypto.createHash("md5").update(queryString).digest("hex");
    const pass = crypto.createHash("md5").update("Cjs@2019").digest("hex");
    const d = new Date();
    const month = d.getUTCMonth() + 1;
    const day = d.getUTCDate();
    const year = d.getUTCFullYear();
    const hours = d.getUTCHours();
    const mintues = d.getUTCMinutes() + 10;
    const seconds = d.getUTCSeconds();
    const timestamp =
      year +
      "-" +
      month +
      "-" +
      day +
      " " +
      hours +
      ":" +
      mintues +
      ":" +
      seconds;
    let data = [];
    const postData = {
      method: "jimi.oauth.token.get",
      app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
      sign: hash,
      sign_method: "md5",
      user_id: "cjsfooddelivery",
      user_pwd_md5: pass,
      expires_in: 7200,
      timestamp: timestamp,
      v: 0.9,
      format: "json",
      app_secret: "49f9b86049434633b3ec2da1f8a675f3",
    };
    let message = languages.bad_request[lang];
    Request(
      {
        url: "http://open.10000track.com/route/rest",
        form: postData,
        method: "POST",
      },
      function (error, response, body) {
        if (!error && response.statusCode == 200) {
          body = JSON.parse(body);
          if (body.code === 0) {
            console.log(body);
            return Utils.makeResponse(
              res,
              true,
              200,
              "Access Token",
              appVersion,
              body
            );
          } else {
            return Utils.makeResponse(res, false, 500, error, appVersion, data);
          }
        } else {
          return Utils.makeResponse(res, false, 500, error, appVersion, data);
        }
      }
    );
  });

  api.post("/live-tracking", function (req, res) {
    const requestData = req.body;
    let queryString = "";
    Object.keys(requestData)
      .sort()
      .forEach(function (key) {
        queryString += key;
        queryString += requestData[key];
      });
    queryString = `appSecrect${queryString}appSecrect`;
    const hash = crypto.createHash("md5").update(queryString).digest("hex");
    const d = new Date();
    const month = d.getUTCMonth() + 1;
    const day = d.getUTCDate();
    const year = d.getUTCFullYear();
    const hours = d.getUTCHours();
    const mintues = d.getUTCMinutes() + 10;
    const seconds = d.getUTCSeconds();
    const timestamp =
      year +
      "-" +
      month +
      "-" +
      day +
      " " +
      hours +
      ":" +
      mintues +
      ":" +
      seconds;
    const deviceGetData = {
      method: "jimi.device.location.get",
      access_token: requestData.accessToken,
      imeis: requestData.imeis,
      map_type: "GOOGLE",
      app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
      timestamp: timestamp,
      format: "json",
      v: 0.9,
      sign: hash,
      sign_method: "md5",
    };

    Request(
      {
        url: "http://open.10000track.com/route/rest",
        form: deviceGetData,
        method: "POST",
      },
      function (error, response, body) {
        if (!error && response.statusCode == 200) {
          console.log("Location Getting From Server", body);
          return Utils.makeResponse(
            res,
            true,
            200,
            "Live Coordinates",
            appVersion,
            body
          );
        } else {
          console.log("Getting Error On device Location", error);
          return res.send(body);
        }
      }
    );
  });

  api.post("/jimi-refresh-token", function (req, res) {
    console.log(JSON.stringify(req.body));
    const requestData = req.body;
    let queryString = "";
    Object.keys(requestData)
      .sort()
      .forEach(function (key) {
        queryString += key;
        queryString += requestData[key];
      });
    queryString = `appSecrect${queryString}appSecrect`;
    const hash = crypto.createHash("md5").update(queryString).digest("hex");
    const d = new Date();
    const month = d.getUTCMonth() + 1;
    const day = d.getUTCDate();
    const year = d.getUTCFullYear();
    const hours = d.getUTCHours();
    const mintues = d.getUTCMinutes() + 10;
    const seconds = d.getUTCSeconds();
    const timestamp =
      year +
      "-" +
      month +
      "-" +
      day +
      " " +
      hours +
      ":" +
      mintues +
      ":" +
      seconds;
    const refreshTokenData = {
      method: "jimi.oauth.token.refresh",
      access_token: requestData.accessToken,
      refresh_token: requestData.refreshToken,
      timestamp: timestamp,
      expires_in: 7200,
      app_key: "8FB345B8693CCD00DBD86BAB5D49CCEF",
      format: "json",
      v: 0.9,
      sign: hash,
      sign_method: "md5",
    };
    console.log("srbguerbgubreubeurgg", JSON.stringify(refreshTokenData));
    Request(
      {
        url: "http://open.10000track.com/route/rest",
        form: refreshTokenData,
        method: "POST",
      },
      function (error, response, body) {
        if (!error && response.statusCode == 200) {
          console.log("Location Getting From Server", body);
          return Utils.makeResponse(
            res,
            true,
            200,
            "Refresh Access Token",
            appVersion,
            body
          );
        } else {
          console.log("Getting Error On device Location", error);
          return res.send(body);
        }
      }
    );
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
     * @api {post} /signUp signUp
     * @apiDescription register user into the app.
     * @apiGroup Users
     * @apiName signUp
     * ***************************************************************************************************************************************************************
     * @apiParam (Expected parameters) {string}             firstName                   firstName
     * @apiParam (Expected parameters) {string}             lastName                    lastName
     * @apiParam (Expected parameters) {string}             dob                     dob (1994-01-01)
     * @apiParam (Expected parameters) {string}             email                                           email
     * @apiParam (Expected parameters) {string}             phone                                           phone
     * @apiParam (Expected parameters) {string}             password                    password
     * @apiParam (Expected parameters) {string}             profilePic                  profilePic
     * @apiParam (Expected parameters) {string}             cpassword                   cpassword
     * @apiParam (Expected parameters) {string}             deviceToken                     deviceToken
     * @apiParam (Expected parameters) {string}             deviceType                  deviceType (1:iOS,2:android)
     * @apiParam (Expected parameters) {string}             countryCode                     countryCode 
     * @apiParam (Expected parameters) {string}             deviceId                    deviceId 
     *****************************************************************************************************************************************************************
     * @apiSuccess {Object}                         response                            response object
     * @apiSuccess {Number=0,1}                         response.status                 response status ( 0 for error, 1 for success )
     * @apiSuccess {string}                             [response.message=null]         error message
     * @apiSuccess {Object}                             [response.data=null]            response data
     ****************************************************************************************************************************************************************
     * @apiVersion 0.0.1
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample {json} Success-Response:
     *          {
     "Success": true,
     "Status": 200,
     "Message": "Sign Up Successfully",
     "AppVersion": "1.0.0",
     "Result": [
     {
     "userId": 45,
     "firstName": "nitin",
     "lastName": "shukla",
     "email": "dsfasd5fa@sfa.com",
     "dob": "1994-12-31T18:30:00.000Z",
     "profilePic": "",
     "password": "123456",
     "countryCode": "91",
     "phone": "125d3sdfa",
     "rewards": 0,
     "deviceToken": "sfdasdfa",
     "deviceType": "1",
     "deviceId": "sfasfa3d24sf",
     "userType": "1",
     "otp": 6042,
     "isNotification": "1" (0:Inactive,1: Active),
     "tokenExpirationTime":360
     }
     ],
     }  
     */

  api.post("/signUp", function (req, res) {
    logger.info('EXPRESS: post("/signUp") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        firstName: { type: "string" },
        lastName: { type: "string" },
        dob: { type: "string" },
        email: { type: "string", pattern: "email" },
        password: { type: "string" },
        cpassword: { type: "string", equals: user.password },
        phone: { type: "string" },
        countryCode: { type: "string", minLength: 1 },
        deviceType: { type: "string" },
        deviceToken: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkEmail =
        'SELECT *  FROM users where (email=? or phone=?) and is_delete = "0"';

      connection.query(
        checkEmail,
        [user.email, user.phone],
        function (errd, checkuserdata) {
          if (errd) {
            //                     logger.log(errd);
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (checkuserdata.length <= 0) {
            var mobileotp = Utils.getRandomInteger(1000, 9999);
            var otp = mobileotp;
            //otp = '1234';
            // query to insert user data and fetch records last inserted user data
            connection.query(
              "call registration(?,?,?,?,?,?,?,?,?,?,?,?,?)",
              [
                user.firstName,
                user.lastName,
                user.email,
                user.password,
                user.dob,
                user.countryCode,
                user.deviceToken,
                user.deviceType,
                "2",
                user.phone,
                otp,
                user.deviceId,
                user.profilePic,
              ],
              function (err, userdata) {
                if (err) {
                  //                                                 logger.log(err);

                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  console.log(userdata[0][0]);

                  connection.query(
                    "INSERT INTO T_MEMBER_DATA_MOBILE SET UID=?,FIRST_NAME=?,LAST_NAME=?,MOBILE=?,EMAIL_ID=?,BIRTH_DATE=?",
                    [
                      userdata[0][0].userId,
                      user.firstName,
                      user.lastName,
                      user.phone,
                      user.email,
                      user.dob,
                    ],
                    function (err, userdata1) {
                      if (err) {
                        console.log(err);
                        //                                                         logger.log(err);
                        message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        var status = 200;
                        var successStatus = true;
                        message = languages.signUp_successfully[lang];
                        userdata[0][0].tokenExpirationTime =
                          config.CONSTANTS.JWT_EXPIRATION_TIME;

                        data = userdata[0];
                        Utils.sendOtpToMobile(user.phone, otp);

                        //mail
                        //var mailHtml = "Hello your OTP is :" + otp;
                        //Utils.sendMail(user.email, 'OTP verification email', mailHtml);
                        Utils.makeResponse(
                          res,
                          successStatus,
                          status,
                          message,
                          appVersion,
                          data
                        );
                      }
                    }
                  );
                }
              }
            );
          } else {
            if (checkuserdata[0].is_mobile_verified == "1") {
              message = languages.email_mobile_exist[lang];
              Utils.makeResponse(res, false, 200, message, appVersion, data);
            } else {
              var updateQry =
                "DELETE users , T_MEMBER_DATA_MOBILE FROM users INNER JOIN T_MEMBER_DATA_MOBILE WHERE users.user_id = T_MEMBER_DATA_MOBILE.UID AND users.user_id = ?";
              connection.query(
                updateQry,
                [otp, checkuserdata[0].user_id],
                function (errd, checkuser) {
                  if (errd) {
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    var mobileotp = Utils.getRandomInteger(1000, 9999);
                    var otp = mobileotp;
                    //otp = '1234';
                    // query to insert user data and fetch records last inserted user data
                    connection.query(
                      "call registration(?,?,?,?,?,?,?,?,?,?,?,?,?)",
                      [
                        user.firstName,
                        user.lastName,
                        user.email,
                        user.password,
                        user.dob,
                        user.countryCode,
                        user.deviceToken,
                        user.deviceType,
                        "2",
                        user.phone,
                        otp,
                        user.deviceId,
                        user.profilePic,
                      ],
                      function (err, userdata) {
                        if (err) {
                          //                                                 logger.log(err);

                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        } else {
                          console.log(userdata[0][0]);

                          connection.query(
                            "INSERT INTO T_MEMBER_DATA_MOBILE SET UID=?,FIRST_NAME=?,LAST_NAME=?,MOBILE=?,EMAIL_ID=?,BIRTH_DATE=?",
                            [
                              userdata[0][0].userId,
                              user.firstName,
                              user.lastName,
                              user.phone,
                              user.email,
                              user.dob,
                            ],
                            function (err, userdata1) {
                              if (err) {
                                console.log(err);
                                //                                                         logger.log(err);
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                var status = 200;
                                var successStatus = true;
                                message = languages.signUp_successfully[lang];
                                userdata[0][0].tokenExpirationTime =
                                  config.CONSTANTS.JWT_EXPIRATION_TIME;

                                data = userdata[0];
                                Utils.sendOtpToMobile(user.phone, otp);

                                //mail
                                //var mailHtml = "Hello your OTP is :" + otp;
                                //Utils.sendMail(user.email, 'OTP verification email', mailHtml);
                                Utils.makeResponse(
                                  res,
                                  successStatus,
                                  status,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        }
                      }
                    );
                  }
                }
              );
            }
          }
        }
      );
    }
  });

  /**
   * @api {post} /signIn/ Login User (SignIn).
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName signIn
   * @apiGroup Users
   * @apiParam {String} email user email.
   * @apiParam {String} password user password.
   * @apiParam {string} deviceType user device type (1 for iOS 2 for Android).
   * @apiParam {String} deviceToken user device token.     *
   * @apiParam {String} guestUserId guest user id (if available).     *
   * @apiParam {String} deviceId device id of user's mobile
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "userId": 42,
   *           "firstName": "nitin",
   *           "lastName": "shukla",
   *           "email": "sfasdfa@sfa.com",
   *           "dob": "1994-12-31T18:30:00.000Z",
   *           "countryCode": "91",
   *           "phone": "123sdfa",
   *           "profilePic": "",
   *           "rewards": 0,
   *           "deviceToken": "sdfasdf",
   *           "deviceType": "1",
   *           "userType": "1",
   *           "guestUserId":"2",
   *           "isNotification": "1" (0:Inactive,1: Active),
   *           "tokenExpirationTime":360,
   *           "isMobileVerified": "1" (0:Inactive,1: Active),
   *           "membershipId": "123",
   *         }
   *       ]
   *     }
   *
   */

  api.post("/signIn", function (req, res) {
    logger.info('EXPRESS: post("/signIn") --> RECEIVED'.event);
    logger.log("%O", req.body);
    var user = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        email: { type: "string", pattern: "email" },
        password: { type: "string" },
        deviceType: { type: "string" },
        deviceToken: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);
    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var validateUserEmail =
        'SELECT user_id FROM users WHERE email = ? and is_delete = "0" ';
      var validateuser =
        'SELECT profile_pic as profilePic,`user_id` as userId, `first_name` as firstName, `last_name` as lastName, `email`,status,`dob` as dob, `country_code` as countryCode, `phone`, `reward_points` as rewards, `device_token` as deviceToken, `device_type` as deviceType, `user_type` as userType,is_mobile_verified as isMobileVerified FROM `users` WHERE email = ? and password = md5(?) and user_verified = "1" and is_delete = "0" ';

      connection.query(
        validateUserEmail,
        [user.email],
        function (errValidate, userValidate) {
          console.log(userValidate);
          if (errValidate) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (userValidate.length > 0) {
            var validateUserPassword =
              'SELECT user_id FROM users WHERE email = ? and password = md5(?) and is_delete = "0" ';
            connection.query(
              validateUserPassword,
              [user.email, user.password],
              function (errValidate2, userValidate2) {
                if (errValidate2) {
                  logger.log(errValidate2);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else if (userValidate2.length > 0) {
                  connection.query(
                    validateuser,
                    [user.email, user.password],
                    function (errlogin, userdata1) {
                      console.log("heree", userdata1);
                      if (errlogin) {
                        logger.log(errlogin);
                        message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      } else if (userdata1.length > 0) {
                        if (userdata1[0].status == "1") {
                          var guestuserid = "0";
                          if (user.guestUserId) guestuserid = user.guestUserId;

                          //                    logger.log(userdata);
                          var insertUser =
                            'update users set is_logged_in="1",device_token=?,device_type=? where user_id=?';
                          connection.query(
                            insertUser,
                            [
                              user.deviceToken,
                              user.deviceType,
                              userdata1[0].userId,
                            ],
                            function (erru, updateuser) {
                              if (!erru) {
                                //****  setting device_id=0 so that guest user will not see previous saved item  ****//
                                var insertUser =
                                  "update orders set user_id=?,device_id=0 where device_id=? and user_id=0";
                                connection.query(
                                  insertUser,
                                  [userdata1[0].userId, user.deviceId],
                                  function (erru, updateuser1) {
                                    if (!erru) {
                                      // Generate JWT Token

                                      //                            Auth.generateJWTToken(userdata[0].userId,userdata[0].email,userdata[0].phone).then(function (tokenresp) {
                                      //                                logger.log(tokenresp);
                                      //                            });
                                      connection.query(
                                        "update order_items set user_id=?,device_id=0 where device_id=? and user_id=0",
                                        [userdata1[0].userId, user.deviceId],
                                        function (erruser1, updateuser2) {
                                          if (!erruser1) {
                                            // Generate JWT Token

                                            //                            Auth.generateJWTToken(userdata[0].userId,userdata[0].email,userdata[0].phone).then(function (tokenresp) {
                                            //                                logger.log(tokenresp);
                                            //                            });
                                            console.log(userdata1[0].userId);
                                            connection.query(
                                              "call getUserDetailById(?)",
                                              [userdata1[0].userId],
                                              function (erruser, userdata) {
                                                if (userdata) {
                                                  connection.query(
                                                    "select MEMBERSHIP_ID from T_MEMBER_DATA_MOBILE where UID = ?",
                                                    [userdata1[0].userId],
                                                    function (
                                                      erruser3,
                                                      userdata2
                                                    ) {
                                                      if (!erruser3) {
                                                        if (
                                                          userdata2.length > 0
                                                        ) {
                                                          var membershipId =
                                                            userdata2[0]
                                                              .MEMBERSHIP_ID;
                                                        } else {
                                                          var membershipId = "";
                                                        }
                                                        userdata[0][0].guestUserId =
                                                          guestuserid;
                                                        userdata[0][0].tokenExpirationTime =
                                                          config.CONSTANTS.JWT_EXPIRATION_TIME; // add jwt expiration time
                                                        userdata[0][0].membershipId =
                                                          membershipId;

                                                        data = userdata[0];
                                                        Utils.makeResponse(
                                                          res,
                                                          true,
                                                          200,
                                                          "",
                                                          appVersion,
                                                          data
                                                        );
                                                      } else {
                                                        message =
                                                          languages
                                                            .something_went_wrong[
                                                          lang
                                                          ];
                                                        Utils.makeResponse(
                                                          res,
                                                          false,
                                                          400,
                                                          message,
                                                          appVersion,
                                                          data
                                                        );
                                                      }
                                                    }
                                                  );
                                                } else {
                                                  console.log("adsd");
                                                }
                                              }
                                            );
                                          } else {
                                            message =
                                              languages.something_went_wrong[
                                              lang
                                              ];
                                            Utils.makeResponse(
                                              res,
                                              false,
                                              400,
                                              message,
                                              appVersion,
                                              data
                                            );
                                          }
                                        }
                                      );
                                    } else {
                                      message =
                                        languages.something_went_wrong[lang];
                                      Utils.makeResponse(
                                        res,
                                        false,
                                        400,
                                        message,
                                        appVersion,
                                        data
                                      );
                                    }
                                  }
                                );
                              } else {
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        } else {
                          message = languages.user_deactivated[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      } else {
                        message = languages.invalid_userID_or_password[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    }
                  );
                } else {
                  message = languages.password_verification_failed[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    200,
                    message,
                    appVersion,
                    data
                  );
                }
              }
            );
          } else {
            message = languages.email_verification_failed[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/

  /**
   * @api {post} /logout/ user logout.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName logout
   * @apiGroup Users
   * @apiParam {String} userId user id.
   * @apiParam {String} deviceId device id.
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": []
   *     }
   *
   */

  api.post("/logout", function (req, res) {
    logger.info('EXPRESS: post("/logout") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
        deviceId: { type: "any" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        "SELECT count(user_id) as totaluser FROM users where user_id=?";

      connection.query(checkuser, [user.userId], function (err, countuser) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (countuser[0]["totaluser"] > 0) {
          var insertUser =
            'update users set is_logged_in="0",device_token=? where user_id=?';
          connection.query(
            insertUser,
            ["", user.userId],
            function (err, sucmessage) {
              //****  setting device_id=0 so that guest user will not see previous order history  ****//
              var updateOrderQr =
                "update orders set device_id=0 where device_id=? and user_id!=0";
              connection.query(
                insertUser,
                [user.deviceId],
                function (erru, row1) {
                  if (!erru) {
                    connection.query(
                      "update order_items set device_id=0 where device_id=? and user_id!=0",
                      [user.deviceId],
                      function (erruser1, row2) {
                        if (!erruser1) {
                          message = languages.user_logout[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        } else {
                          console.log(
                            "error while updating order items" + erruser1
                          );
                          message = languages.user_logout[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  } else {
                    console.log("error while updating orders" + erru);
                    message = languages.user_logout[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              );
            }
          );
        } else {
          message = languages.user_does_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  /**
     * @api {post} /sendOtp/ sendOtp.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName sendOtp
     * @apiGroup Users     
     * @apiParam {String} phone mobile number.    
     * @apiParam {String} countryCode country code.    
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     {
     "otp": 9274
     }
     ]
     *     }
     *
     */
  api.post("/sendOtp", function (req, res) {
    logger.info('EXPRESS: post("/logout") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        countryCode: { type: "string" },
        phone: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        'SELECT count(user_id) as totaluser,email FROM users where phone=?  and is_delete = "0"';

      connection.query(checkuser, [user.phone], function (err, countuser) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (countuser[0]["totaluser"] > 0) {
          var updateUser = "update users set otp=? where phone=?";
          var mobileotp = Utils.getRandomInteger(1000, 9999);
          var otp = mobileotp;
          //otp = '1234';
          connection.query(
            updateUser,
            [otp, user.phone],
            function (err, lastInsertId, fields) {
              Utils.sendOtpToMobile(user.phone, otp);
              //mail
              //var mailHtml = "Hello your OTP is :" + otp;
              //Utils.sendMail(countuser[0]['email'], 'OTP verification email', mailHtml);

              message = languages.otp_sent[lang];
              data = [{ otp: otp }];
              Utils.makeResponse(res, true, 200, message, appVersion, data);
            }
          );
        } else {
          message = languages.mobile_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  /**
     * @api {post} /changePhoneNumber/ Change Phone Number.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName changePhoneNumber
     * @apiGroup Users     
     * @apiParam {String} phone mobile number.    
     * @apiParam {String} countryCode country code.    
     * @apiParam {String} userId user id.    
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     {
     "otp": 9274
     }
     ]
     *     }
     *
     */
  api.post("/changePhoneNumber", function (req, res) {
    logger.info('EXPRESS: post("/logout") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        countryCode: { type: "string" },
        phone: { type: "string" },
        userId: { type: "string" },
        emailAddress: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      logger.log(validationresult.format());
      console.log("ddd");
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      console.log("aaa");
      var checkuser =
        'SELECT count(user_id) as totaluser FROM users where country_code = ? and phone=? and user_id!=?  and is_delete = "0"';

      connection.query(
        checkuser,
        [user.countryCode, user.phone, user.userId],
        function (err, countuser) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (countuser[0]["totaluser"] < 1) {
            var updateUser =
              "update users set otp=?,country_code = ?, phone=? where user_id=?";
            var mobileotp = Utils.getRandomInteger(1000, 9999);
            var otp = mobileotp;

            connection.query(
              updateUser,
              [otp, user.countryCode, user.phone, user.userId],
              function (err, lastInsertId, fields) {
                Utils.sendOtpToMobile(user.phone, otp);
                message = languages.otp_sent[lang];
                data = [{ otp: otp }];

                //mail
                //var mailHtml = "Hello your OTP is :" + otp;
                //Utils.sendMail(user.emailAddress, 'OTP verification email', mailHtml);

                Utils.makeResponse(res, true, 200, message, appVersion, data);
              }
            );
          } else {
            message = languages.mobile_already_exists[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
     * @api {post} /verifyOtp/ verifyOtp.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName verifyOtp
     * @apiGroup Users     
     * @apiParam {String} phone mobile number.    
     * @apiParam {String} countryCode country code.    
     * @apiParam {String} otp otp code.    
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     {
     "userId": 45,
     "firstName": "rahul",
     "lastName": "pandey",
     "email": "dsfasd5fa@sfa.com",
     "dob": "1994-12-31T18:30:00.000Z",
     "profilePic": "",
     "password": "123456",
     "countryCode": "91",
     "phone": "125d3sdfa",
     "rewards": 0,
     "deviceToken": "sfdasdfa",
     "deviceType": "1",
     "deviceId": "sfasfa3d24sf",
     "userType": "1",
     "otp": 6042,
     "isNotification": "1" (0:Inactive,1: Active),
     "tokenExpirationTime":360
     }
     ]
     *     }
     *
     */

  api.post("/verifyOtp", function (req, res) {
    logger.info('EXPRESS: post("/verifyOtp") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        phone: { type: "string" },
        countryCode: { type: "string" },
        otp: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        'SELECT user_id  FROM users where phone=? and country_code = ? and otp=?  and is_delete = "0"';

      var q = connection.query(
        checkuser,
        [user.phone, user.countryCode, user.otp],
        function (err, countuser) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (countuser.length > 0) {
            var updateUser =
              "update users set is_mobile_verified=? where phone=?";
            connection.query(
              updateUser,
              ["1", user.phone],
              function (err, lastInsertId, fields) {
                connection.query(
                  "call getUserDetailById(?)",
                  [countuser[0].user_id],
                  function (err, userdata) {
                    message = languages.otp_verified[lang];

                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      userdata[0]
                    );
                  }
                );
              }
            );
          } else {
            message = languages.incorrect_otp[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
   * @api {post} /forgotPassword/ forgot password.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName forgotPassword
   * @apiGroup Users
   * @apiParam {String} email user email.
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "Password has been sent to your email.",
   *       "AppVersion": "1.0.0",
   *       "Result":  []
   *     }
   *
   */

  api.post("/forgotPassword", function (req, res) {
    logger.info('EXPRESS: post("/forgotPassword") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        email: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        'SELECT count(user_id) as totaluser FROM users where email=? and user_verified = "1" and is_delete = "0"';

      connection.query(checkuser, [user.email], function (err, countuser) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (countuser[0]["totaluser"] > 0) {
          var password = Utils.getRandomInteger(10000000, 99999999);
          console.log("new password=" + password);
          var updateUser =
            'update users set password=md5("' + password + '") where email=?';
          connection.query(
            updateUser,
            [user.email],
            function (err, lastInsertId, fields) {
              var mailHtml = "Hello your new password is :" + password;
              Utils.sendMail(user.email, "Forgot password", mailHtml);
              message = languages.password_sent[lang];
              Utils.makeResponse(res, true, 200, message, appVersion, data);
            }
          );
        } else {
          message = languages.email_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  api.post("/callcenterForgotPassword", function (req, res) {
    logger.info(
      'EXPRESS: post("/callcenterForgotPassword") --> RECEIVED'.event
    );
    logger.log("%O", req.body);
    var user = req.body;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        email: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        'SELECT count(id) as totaluser FROM callcenter_agent where email=? and is_active = "1" and is_delete = "0"';

      connection.query(checkuser, [user.email], function (err, countuser) {
        console.log(countuser);
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (countuser[0]["totaluser"] > 0) {
          var password = Utils.getRandomInteger(10000000, 99999999);
          bcrypt.genSalt(saltRounds, function (err, salt) {
            bcrypt.hash(password.toString(), salt, function (err, hash) {
              // Store hash in your password DB.
              var updateUser =
                "update callcenter_agent set password=? where email=?";
              connection.query(
                updateUser,
                [hash, user.email],
                function (err, lastInsertId, fields) {
                  var mailHtml = "Hello your new password is :" + password;
                  Utils.sendMail(user.email, "Forgot password", mailHtml);
                  message = languages.password_sent[lang];
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              );
            });
          });
        } else {
          message = languages.email_not_exist[lang];
          Utils.makeResponse(res, false, 200, message, appVersion, data);
        }
      });
    }
  });

  /**
   * @api {get} /countrymobilecodes/ mobile country code.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName countrymobilecodes
   * @apiGroup Users
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *      "Status": 200,
   *      "Message": "",
   *      "AppVersion": "1.0.0",
   *      "Result": [
   *           {
   *                    "id": 1,
   *                    "country": "India",
   *                    "mcode": "+91"
   *                }
   *            ]
   *    }
   *
   */

  api.get("/countrymobilecodes", function (req, res) {
    logger.info('EXPRESS: post("/countrymobilecodes") --> RECEIVED'.event);

    var user = req.body;
    var message = "";
    var data = [];

    var mobilecodes =
      "SELECT `id`, `country`, `mcode` FROM `tbl_country_mobile_code` ";

    connection.query(mobilecodes, function (err, codes) {
      if (err) {
        message = languages.something_went_wrong[lang];
        Utils.makeResponse(res, false, 400, message, appVersion, data);
      } else {
        data = codes;

        Utils.makeResponse(res, true, 200, message, appVersion, data);
      }
    });
  });

  /**
   * @api {get} /pages/ Get information pages content.
   * @apiVersion 1.0.0
   * @apiName GetPagesContent
   * @apiGroup Info Pages
   * @apiParam {String}   pageId user page id.
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   *
   * @apiSuccessExample Success-Response:
   *     HTTP/1.1 200 OK
   *     [
   *      {
   *       "pageId": 2,
   *       "title": "About us",
   *       "description": "dummy content"
   *     }
   *    ]
   *
   */

  api.get("/pages", function (req, res, next) {
    logger.log("%O", req.body);
    var pagedata = req.query;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        pageId: { type: "string" },
      },
    };
    var validationresult = inspector.validate(schema, pagedata);
    if (!validationresult.valid) {
      logger.log(validationresult.format());
      message = languages.bad_request[lang];
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var query =
        "SELECT `page_id` as pageId, `title`, `description` FROM `tbl_pages` WHERE page_id = ?";

      connection.query(query, [pagedata.pageId], function (err, rows, fields) {
        if (!err) {
          if (rows.length > 0) {
            data = rows;
            message = languages.success[lang];
          } else {
            message = languages.no_record_found[lang];
          }
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        } else {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        }
      });
    }
  });

  /* Gallery images API */

  /**
   * @api {get} /gallery/ Get gallery images.
   * @apiVersion 1.0.0
   * @apiName gallery
   * @apiGroup  Gallery
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *
   * @apiSuccessExample Success-Response:
   *     HTTP/1.1 200 OK
   *     {
   *               "Success": true,
   *               "Status": 200,
   *               "Message": "Success",
   *               "AppVersion": "1.0.0",
   *               "Result": [
   *                   {
   *                       "galleryId": 2,
   *                       "title": "CAFE JAVAS - NAMIREMBE ROAD",
   *                       "description": "",
   *                      "imageUrl": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_gallery_img_21585286.jpg",
   *                      }
   *
   *
   *                   },
   *                   {
   *                       "galleryId": 7,
   *                       "title": "CAFE JAVAS - OASIS MALL",
   *                       "description": "",
   *                        "imageUrl": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_gallery_img_21585286.jpg",
   *                      }
   *                   },
   *                   {
   *                       "galleryId": 8,
   *                       "title": "CAFE JAVAS - BOMBO ROAD",
   *                       "description": "",
   *                       "images": ''
   *                   }
   *               ]
   *           }
   *
   */

  api.get("/gallery", function (req, res, next) {
    logger.info('EXPRESS: post("/gallery") --> RECEIVED'.event);

    logger.log("%O", req.query);
    var imagedata = req.query;
    var message = "";
    var data = [];
    var schema = {
      type: "object",
      properties: {
        page: { type: "string" },
      },
    };
    var validationresult = inspector.validate(schema, imagedata);
    if (!validationresult.valid) {
      logger.log(validationresult.format());
      message = languages.bad_request[lang];
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 11;
      if (imagedata.page == "1") offset = 0;
      else offset = (imagedata.page - 1) * limit;
      var query =
        'SELECT `id` as galleryId,image_path as imageUrl,  `title`, `description` FROM `tbl_gallery` where is_deleted = "0" limit ?,?';
      connection.query(query, [offset, limit], function (err, rows, fields) {
        if (!err) {
          if (rows.length > 0) {
            message = languages.success[lang];
            data = rows;
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          } else {
            message = languages.no_record_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        } else {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        }
      });
    }
  });

  /* Master of restaurants */

  /**
   * @api {get} /restaurantsMaster/ Get list of restaurants.
   * @apiVersion 1.0.0
   * @apiName restaurantsMaster
   * @apiGroup Restaurants Master
   *
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *
   * @apiSuccessExample Success-Response:
   *     HTTP/1.1 200 OK
   *     {
   *               "Success": true,
   *               "Status": 200,
   *               "Message": "Success",
   *               "AppVersion": "1.0.0",
   *               "Result": [
   *                   {
   *                       "restaurantId": 1,
   *                       "restaurantName": "McDonalds",
   *                       "address": "",
   *                       "latitude": "",
   *                       "longitude": "",
   *                       "phone": "",
   *                    },
   *                    {
   *                       "restaurantId": 2,
   *                       "restaurantName": "Pizza Hut",
   *                       "address": "",
   *                       "latitude": "",
   *                       "longitude": "",
   *                       "phone": "",
   *                    }
   *                ]
   *
   */

  api.get("/restaurantsMaster", function (req, res, next) {
    var message = "";
    var data = [];
    var query =
      "SELECT `id` as restaurantId, `restaurant_name` as restaurantName, `address`, `latitude`, `longitude`, `phone` FROM `tbl_restaurants_master` ";
    connection.query(query, function (err, rows, fields) {
      if (!err) {
        if (rows.length > 0) {
          message = languages.success[lang];
          data = rows;
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        } else {
          message = languages.no_record_found[lang];
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      } else {
        message = languages.something_went_wrong[lang];
        Utils.makeResponse(res, false, 400, message, appVersion, data);
      }
    });
  });

  /**
     * @api {post} /userFeedback/ User Feedback
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag 
     * @apiVersion 1.0.0
     * @apiName userFeedback
     * @apiGroup Users
     * @apiParam {String} email email.  
     * @apiParam {String} feedback user feedback.            
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Feedback sent Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     
     ]
     *     }
     *
     */

  api.post("/userFeedback", function (req, res) {
    logger.info('EXPRESS: post("/userFeedback") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        email: { type: "any" },
        feedback: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      // update profile query
      var feedback =
        "INSERT INTO `tbl_feedback`(`email`, `feedback`) VALUES (?,?)";
      connection.query(
        feedback,
        [user.email, user.feedback],
        function (errd, successdata) {
          if (errd) {
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            message = languages.sent_feedback[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
     * @api {get} /getQrImage/ QR Image.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getQrImage
     * @apiGroup Orders
     * @apiParam {String} userId userId   
     * @apiParam {String} orderId orderId     
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     "Success": true,
     "Status": 200,
     "Message": "QR code Image",
     "AppVersion": "1.0.0",
     "Result": "<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 23 23"><path d="M1 1h7v7h-7zM11 1h2v2h1v1h-1v1h1v6h-1v-2h-1v-1h1v-2h-1v-3h-1v3h-1v3h-1v-6h1v-1h1zM15 1h7v7h-7zM2 2v5h5v-5zM16 2v5h5v-5zM3 3h3v3h-3zM17 3h3v3h-3zM11 7h1v1h-1zM1 9h1v1h-1zM3 9h5v1h-2v1h3v-1h1v-1h2v2h-2v1h-5v-2h-1v1h-1zM15 9h5v3h1v1h-3v-1h1v-2h-4zM21 10h1v1h-1zM1 11h1v1h-1zM12 11h1v1h-1zM14 11h1v3h-1zM3 12h2v2h-4v-1h2zM16 12h1v2h2v1h-2v1h-2v-1h1zM6 13h3v1h-3zM10 13h3v1h1v5h-1v-2h-2v-1h2v-1h-1v-1h-1v2h-1v-1h-1v-1h1zM21 13h1v1h-1zM1 15h7v7h-7zM19 15h2v1h-1v1h-2v-1h1zM2 16v5h5v-5zM9 16h1v3h1v1h-2zM21 16h1v2h-1zM3 17h3v3h-3zM15 17h1v1h-1zM11 18h1v1h-1zM16 18h3v2h1v1h-1v1h-1v-1h-2v-1h2v-1h-2zM12 19h1v1h-1zM14 19h1v1h-1zM9 21h2v1h-2zM12 21h1v1h-1zM20 21h1v1h-1z"/></svg>"
     }
     *
     */

  api.get("/getQrImage", function (req, res) {
    logger.info('EXPRESS: post("/QRImage") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;

    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        orderId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      //result

      var qr_svg = qr.image("userId:1-orderId:2", { type: "svg" });
      qr_svg.pipe(require("fs").createWriteStream("i_love_qr.svg"));
      var svg_string = qr.imageSync("userId:1-orderId:2", { type: "svg" });

      message = languages.your_qr_code[lang];
      Utils.makeResponse(res, true, 200, message, appVersion, svg_string);
    }
  });

  /**
   * @api {get} /getNotifications/ Notifications.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName getNotifications
   * @apiGroup Users
   * @apiParam {String} userId userId
   * @apiParam {String} page page number (start with page number 1).
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "id": 1,
   *           "message": "pizza"
   *         },
   *         {
   *           "id": 2,
   *           "message": "Drinks"
   *         }
   *       ]
   *     }
   *
   */

  api.get("/getNotifications", function (req, res) {
    logger.info('EXPRESS: post("/getNotifications") --> RECEIVED'.event);

    var getrequests = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, getrequests);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 5;
      if (getrequests.page == "1") offset = 0;
      else offset = (getrequests.page - 1) * limit;

      var userId = getrequests.userId;
      var notifications =
        'SELECT `id` as notificationId, `message` as message FROM `notifications` WHERE user_id = ? and is_delete = "0" order by created_at desc limit ?,?';

      connection.query(
        notifications,
        [userId, offset, limit],
        function (err, rows, fields) {
          if (err) {
            logger.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            data = rows;

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
     * @api {get} /aboutUs About us details.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName aboutUs
     * @apiGroup Info Pages       
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result": {
     *     "description": "Whether in Kampala or Entebbe, you're always close to a cafe Javas, thanks to our growing network.You're welcome to drop by or call to make your order and we'll be more than happt to serve you.",
     *     "openingHours": [
     *      {
     *         "day": "Monday - Thursday",
     *         "time": "6:00 AM to 11:00 PM"
     *       },
     *       {
     *         "day": "Friday - Saturday",
     *         "time": "6:00 AM to 12:00 PM"
     *       },
     *       {
     *         "day": "Sunday",
     *         "time": "6:00 AM to 10:00 PM"
     *       }
     *     ],
     *     "deliveryFee": "UGX 20",
     *     "minimumOrder": "UGX 200",
     *     "branches": [
     *       {
     *         "name": "BOMBO ROAD",
     *         "address": "Kampala Road, Plot 24/26",
     *         "contactNumber": "+256 392 177284 / 0414 581911",
     *         "email": "javas.downtown@cafejavas.co.ug"
     *       },
     *       {
     *         "name": "CAERGEN HOUSE",
     *         "address": "Parliamentary Avenue",
     *         "contactNumber": "+256 200 930000 / 0393 000020",
     *         "email": "javas.cargen@cafejavas.co.ug"
     *       },
     *       {
     "name": "Shivam HOUSE",
     "address": "Parliamentary Avenue",
     "contactNumber": "+256 200 930000 / 0393 000020",
     "email": "javas.cargen@cafejavas.co.ug"
     },
     {
     "name": "Ayush HOUSE",
     "address": "Parliamentary Avenue",
     "contactNumber": "+256 200 930000 / 0393 000020",
     "email": "javas.cargen@cafejavas.co.ug"
     },
     {
     "name": "Kapil HOUSE",
     "address": "Parliamentary Avenue",
     "contactNumber": "+256 200 930000 / 0393 000020",
     "email": "javas.cargen@cafejavas.co.ug"
     }
     *     ]
     *   }
     * }
     *
     */
  api.get("/aboutUs", function (req, res) {
    logger.info('EXPRESS: get("/aboutUs") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        // userId: {type: 'string'}
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var branchesQr =
        "select name,address,contact_number as contactNumber,email, latitude, longitude from tbl_branches where is_deleted ='0' and is_active='1' order by name ";
      connection.query(branchesQr, function (err, rows, fields) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (rows.length > 0) {
          var openingHours = [];
          var day1 = {
            day: "Monday - Thursday",
            time: "6:00 AM to 11:00 PM",
          };
          var day2 = {
            day: "Friday - Saturday",
            time: "6:00 AM to 12:00 AM",
          };
          var day3 = {
            day: "Sunday",
            time: "6:00 AM to 11:00 PM",
          };
          openingHours.push(day1);
          openingHours.push(day2);
          openingHours.push(day3);
          var description =
            "Welcome to Cafe Javas, is a full-service, quick-casual restaurant specialized in delivering a relaxed and memorable dining experience. We’re currently in 14 locations; 8 in Kampala, 1 in Entebbe and 5 in Nairobi. Whether in Kampala or Entebbe, you're always close to a cafe Javas, thanks to our growing network.You're welcome to drop by or call to make your order and we'll be more than happy to serve you. Each location features a unique ambience with tasteful décor, specially designed for your comfort. To make you feel more at home, we’ve carefully selected a unique theme for each location. We have over 300 carefully selected, mouthwatering menu items. Whatever your taste, it’s well catered for. We value you. That’s why you’ll always be served with excellence by each member of our highly skilled team members. Eager to serve you, our experienced wait staff greet you at the door and lead you to the table of your choice in the well thought out seating arrangement. The rich aroma of freshly ground coffee is the handiwork of our skilled baristas, adept in latte art. This ensures you get a freshly prepared cup of coffee as the beans are roasted on site. To ensure you always enjoy a special dining experience, we constantly improve our signature world-class innovations. We’re growing and may soon open a location closer to you. We look forward to serving you, You’re more than welcome to Find us here. Cafe Javas is part of Mandela Group of companies, the parent company to Cafe Javas, City Tyres, City Oil, City Lubes, City World, Savers, and Mandela Auto Spare";
          var deliveryFee = "0";
          var minimumOrder = "KSH 950";
          var branches = [];
          //                    var branch1Details={"name":"BOMBO ROAD",
          //                                        "address":"Kampala Road, Plot 24/26",
          //                                        "contactNumber":"+256 392 177284 / 0414 581911",
          //                                        "email":"javas.downtown@cafejavas.co.ug"};
          //                    var branch2Details={"name":"CAERGEN HOUSE",
          //                                        "address":"Parliamentary Avenue",
          //                                        "contactNumber":"+256 200 930000 / 0393 000020",
          //                                        "email":"javas.cargen@cafejavas.co.ug"};
          //                    var branch3Details={"name":"Shivam HOUSE",
          //                        "address":"Parliamentary Avenue",
          //                        "contactNumber":"+256 200 930000 / 0393 000020",
          //                        "email":"javas.cargen@cafejavas.co.ug"};
          //                    var branch4Details={"name":"Ayush HOUSE",
          //                        "address":"Parliamentary Avenue",
          //                        "contactNumber":"+256 200 930000 / 0393 000020",
          //                        "email":"javas.cargen@cafejavas.co.ug"};
          //                    var branch5Details={"name":"Kapil HOUSE",
          //                        "address":"Parliamentary Avenue",
          //                        "contactNumber":"+256 200 930000 / 0393 000020",
          //                        "email":"javas.cargen@cafejavas.co.ug"};
          //                    branches.push(branch1Details);
          //                    branches.push(branch2Details);
          //                    branches.push(branch3Details);
          //                    branches.push(branch4Details);
          //                    branches.push(branch5Details);
          message = languages.success[lang];
          var data = {
            description: description,
            openingHours: openingHours,
            deliveryFee: deliveryFee,
            minimumOrder: minimumOrder,
            branches: rows,
          };
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      });
    }
  });

  function getGiftCardImage(giftCardId) {
    return new Promise(function (resolve, reject) {
      var products =
        "select card_image from gift_card_image where gift_card_id=? and is_deleted ='0'";
      //            console.log(products);
      connection.query(products, [giftCardId], function (err, rows, fields) {
        //console.log(rows[0].user_id);
        if (err) {
          reject(false);
        } else {
          resolve(rows);
        }
      });
    });
  }

  /**
     * @api {post} /addItemToCart Add item to cart
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName addItemToCart
     * @apiGroup Orders    
     * @apiParam {String} json JSON data having item details.(
     * {
     "data": {
     "orderItemDetail": {
     "isFavourite": 0,
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg",
     "productId": 1,
     "catId": 1,
     "subCatId": 1,
     "productName": "sd",
     "description": "asdfasdf",
     "price": "60"
     },
     "topextraItems": [
     {
     "topLabelId": 1,
     "labelNames": "Temp1",
     "labelType": 1,
     "labelOption": 1,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 1,
     "labelId": 1,
     "optionName": "Option 1"
     }
     ]
     },
     {
     "topLabelId": 5,
     "labelNames": "Temp2",
     "labelType": 1,
     "labelOption": 2,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 5,
     "labelId": 5,
     "optionName": "Option 5"
     }
     ]
     }
     ],
     "additionalItems": [
     {
     "additionalProductId": 1,
     "itemName": "sdfa",
     "price": "40"
     },
     {
     "additionalProductId": 2,
     "itemName": "Bacon Crumble",
     "price": "60"
     }
     ],
     "customizeTopLabelOptions": [
     {
     "custLabelId": 1,
     "labelNames": "Toppings"
     },
     {
     "custLabelId": 2,
     "labelNames": "Size"
     },
     {
     "custLabelId": 3,
     "labelNames": "Extra"
     }
     ],
     "verticalCustomizeOptionsWithPrice": [
     {
     "custlabelOptionId": 7,
     "labelNames": "Bacon Crumble",
     "selectedOption": [
     {
     "labelNames": "Size",
     "isSelected": 1
     },
     {
     "labelNames": "Extra",
     "isSelected": 0
     }
     ]
     },
     {
     "custlabelOptionId": 8,
     "labelNames": "Green Onions",
     "selectedOption": [
     {
     "labelNames": "Extra",
     "isSelected": 1
     },
     {
     "labelNames": "Size",
     "isSelected": 1
     }
     ]
     }
     ]
     }
     }
     
     )      
     * @apiParam {Number} quantity Quantity of item user want to purchase
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {Number} productId product id
     * @apiParam {Number} basicProductCost Price of product
     * @apiParam {Number} optionalTotal Price of optional items selected by user
     * @apiParam {Number} additionalTotal Price of additional items selected by user
     * @apiParam {Number} subTotal Sum of basicProductCost,optionalTotal and additionalTotal
     * @apiParam {String} deviceId Unique device ID of user's device
     * @apiParam {String} dealId  deal id applied . (0 in case of no deal) 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result":  {
     *      "cartItemCount" : 2
     *   }
     *   }
     *
     */
  api.post("/addItemToCart", function (req, res) {
    var requestData = req.body;
    //console.log(requestData);
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "String" },
        quantity: { type: "number" },
        productId: { type: "number" },
        basicProductCost: { type: "number" },
        optionalTotal: { type: "number" },
        additionalTotal: { type: "number" },
        subTotal: { type: "number" },
        dealId: { type: "string" },
        json: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var currentHour = moment().add(3, "hours").format("HH"); // Current Hour (HRS) in Uganda
      console.log(
        "***********************************************************************************"
      );
      console.log(requestData);
      console.log(
        "***********************************************************************************"
      );
      console.log(requestData.json);
      console.log(
        "***********************************************************************************"
      );

      var x = JSON.parse(requestData.json);
      console.log("Current Hour", currentHour);
      console.log("   x", x.data.orderItemDetail.catId);

      if (
        x.data.orderItemDetail.catId != 55 &&
        x.data.orderItemDetail.catId != 59
      ) {
        var productDetail =
          "select tp.group_id,rp.count from tbl_products_items tp left join reward_product_group as rp on tp.group_id = rp.id where tp.product_id = ? and tp.is_deleted = '0' and tp.status='1' ";
        connection.query(
          productDetail,
          [requestData.productId],
          function (err, rows0, fields) {
            if (err) {
              console.log(err);
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else {
              rewardProductcheck(requestData.userId, rows0[0].count)
                .then(function (rewardcheck) {
                  if (rewardcheck) {
                    if (rewardcheck == 1) {
                      var freeReward = "1";
                      var basicCost = requestData.basicProductCost;
                      var subTotal = requestData.subTotal;
                    } else {
                      var freeReward = "0";
                      var basicCost = requestData.basicProductCost;
                      var subTotal = requestData.subTotal;
                    }
                    var orderItem =
                      "insert into order_items(order_id,product_id,payment_status,quantity,device_id,user_id,basic_product_cost,optional_total,additional_total,subtotal,json,deal_id,group_id,is_free_reward,created_on) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,now())";
                    connection.query(
                      orderItem,
                      [
                        "0",
                        requestData.productId,
                        "0",
                        requestData.quantity,
                        requestData.deviceId,
                        requestData.userId,
                        basicCost,
                        requestData.optionalTotal,
                        requestData.additionalTotal,
                        subTotal,
                        requestData.json,
                        requestData.dealId,
                        rows0[0].group_id,
                        freeReward,
                      ],
                      function (err, rows, fields) {
                        if (err) {
                          console.log(err);
                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        } else {
                          if (requestData.userId == 0) {
                            var orderItemQr =
                              "select count(*) as total from order_items where device_id=? and order_id='0' and is_delete='0'";
                            var paramArray = [requestData.deviceId];
                          } else {
                            var orderItemQr =
                              "select count(*) as total from order_items where user_id=? and order_id='0' and is_delete='0'";
                            var paramArray = [requestData.userId];
                          }

                          connection.query(
                            orderItemQr,
                            paramArray,
                            function (err1, rows1, fields) {
                              if (err1) {
                                data.cartItemCount = 0;
                                data.freeReward = freeReward;
                                var message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                data.cartItemCount = rows1[0].total;
                                data.freeReward = freeReward;
                                var message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        }
                      }
                    );
                  } else {
                    console.log("ff");

                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  }
                })
                .catch(function (err) {
                  console.log("errorProductcheck" + err);
                  var message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                });
            }
          }
        );
      } else {
        if (x.data.orderItemDetail.catId == 55) {
          if (currentHour < 12) {
            var productDetail =
              "select tp.group_id,rp.count from tbl_products_items tp left join reward_product_group as rp on tp.group_id = rp.id where tp.product_id = ? and tp.is_deleted = '0' and tp.status='1' ";
            connection.query(
              productDetail,
              [requestData.productId],
              function (err, rows0, fields) {
                if (err) {
                  console.log(err);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  rewardProductcheck(requestData.userId, rows0[0].count)
                    .then(function (rewardcheck) {
                      if (rewardcheck) {
                        if (rewardcheck == 1) {
                          var freeReward = "1";
                          var basicCost = 0;
                          var subTotal =
                            requestData.subTotal - requestData.basicProductCost;
                        } else {
                          var freeReward = "0";
                          var basicCost = requestData.basicProductCost;
                          var subTotal = requestData.subTotal;
                        }
                        var orderItem =
                          "insert into order_items(order_id,product_id,payment_status,quantity,device_id,user_id,basic_product_cost,optional_total,additional_total,subtotal,json,deal_id,group_id,is_free_reward,created_on) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,now())";
                        connection.query(
                          orderItem,
                          [
                            "0",
                            requestData.productId,
                            "0",
                            requestData.quantity,
                            requestData.deviceId,
                            requestData.userId,
                            basicCost,
                            requestData.optionalTotal,
                            requestData.additionalTotal,
                            subTotal,
                            requestData.json,
                            requestData.dealId,
                            rows0[0].group_id,
                            freeReward,
                          ],
                          function (err, rows, fields) {
                            if (err) {
                              console.log(err);
                              message = languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              if (requestData.userId == 0) {
                                var orderItemQr =
                                  "select count(*) as total from order_items where device_id=? and order_id='0' and is_delete='0'";
                                var paramArray = [requestData.deviceId];
                              } else {
                                var orderItemQr =
                                  "select count(*) as total from order_items where user_id=? and order_id='0' and is_delete='0'";
                                var paramArray = [requestData.userId];
                              }

                              connection.query(
                                orderItemQr,
                                paramArray,
                                function (err1, rows1, fields) {
                                  if (err1) {
                                    data.cartItemCount = 0;
                                    data.freeReward = freeReward;
                                    var message = languages.success[lang];
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    data.cartItemCount = rows1[0].total;
                                    data.freeReward = freeReward;
                                    var message = languages.success[lang];
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  }
                                }
                              );
                            }
                          }
                        );
                      } else {
                        console.log("ff");

                        var message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      }
                    })
                    .catch(function (err) {
                      console.log("errorProductcheck" + err);
                      var message = languages.something_went_wrong[lang];
                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    });
                }
              }
            );
          } else {
            var message = "Product Available Before 12PM.";
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        } else if (x.data.orderItemDetail.catId == 59) {
          if (currentHour > 11) {
            var productDetail =
              "select tp.group_id,rp.count from tbl_products_items tp left join reward_product_group as rp on tp.group_id = rp.id where tp.product_id = ? and tp.is_deleted = '0' and tp.status='1' ";
            connection.query(
              productDetail,
              [requestData.productId],
              function (err, rows0, fields) {
                if (err) {
                  console.log(err);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  rewardProductcheck(requestData.userId, rows0[0].count)
                    .then(function (rewardcheck) {
                      if (rewardcheck) {
                        if (rewardcheck == 1) {
                          var freeReward = "1";
                          var basicCost = 0;
                          var subTotal =
                            requestData.subTotal - requestData.basicProductCost;
                        } else {
                          var freeReward = "0";
                          var basicCost = requestData.basicProductCost;
                          var subTotal = requestData.subTotal;
                        }
                        var orderItem =
                          "insert into order_items(order_id,product_id,payment_status,quantity,device_id,user_id,basic_product_cost,optional_total,additional_total,subtotal,json,deal_id,group_id,is_free_reward,created_on) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,now())";
                        connection.query(
                          orderItem,
                          [
                            "0",
                            requestData.productId,
                            "0",
                            requestData.quantity,
                            requestData.deviceId,
                            requestData.userId,
                            basicCost,
                            requestData.optionalTotal,
                            requestData.additionalTotal,
                            subTotal,
                            requestData.json,
                            requestData.dealId,
                            rows0[0].group_id,
                            freeReward,
                          ],
                          function (err, rows, fields) {
                            if (err) {
                              console.log(err);
                              message = languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              if (requestData.userId == 0) {
                                var orderItemQr =
                                  "select count(*) as total from order_items where device_id=? and order_id='0' and is_delete='0'";
                                var paramArray = [requestData.deviceId];
                              } else {
                                var orderItemQr =
                                  "select count(*) as total from order_items where user_id=? and order_id='0' and is_delete='0'";
                                var paramArray = [requestData.userId];
                              }

                              connection.query(
                                orderItemQr,
                                paramArray,
                                function (err1, rows1, fields) {
                                  if (err1) {
                                    data.cartItemCount = 0;
                                    data.freeReward = freeReward;
                                    var message = languages.success[lang];
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    data.cartItemCount = rows1[0].total;
                                    data.freeReward = freeReward;
                                    var message = languages.success[lang];
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  }
                                }
                              );
                            }
                          }
                        );
                      } else {
                        console.log("ff");

                        var message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      }
                    })
                    .catch(function (err) {
                      console.log("errorProductcheck" + err);
                      var message = languages.something_went_wrong[lang];
                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    });
                }
              }
            );
          } else {
            var message = "Product Available After 12PM.";
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      }
    }
  });

  //*** to check for reward product and price ***//

  function rewardProductcheck(userId, count) {
    return new Promise(function (resolve, reject) {
      if (count > 0 && userId != 0) {
        console.log("dddddddddd");
        var getUsercount = "select reward_points from users where user_id =?";
        connection.query(getUsercount, [userId], function (err, rows, fields) {
          if (err) {
            reject(false);
          } else {
            if (count <= rows[0].reward_points) {
              var getCartRewardcount =
                "select count(oi.ID) as rewardOrderCount from order_items as oi,tbl_products_items as tpi left join reward_product_group as rpw on rpw.id=tpi.group_id and rpw.is_active='1' and rpw.is_deleted='0' where oi.product_id=tpi.product_id and oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and oi.is_free_reward='1'";
              connection.query(
                getCartRewardcount,
                [userId],
                function (err, rows1, fields) {
                  if (err) {
                    reject(false);
                  } else {
                    if (
                      rows1[0].rewardOrderCount &&
                      rows1[0].rewardOrderCount > 0
                    ) {
                      // condition if there is already an item in cart with reward product

                      console.log("bbbb");
                      resolve(2);
                    } else {
                      console.log("aaaa");
                      resolve(1);
                    }
                  }
                }
              );
            } else {
              //****  Case if group count is less then user reward point count  ****//
              console.log("bbbb");
              resolve(2);
            }
          }
        });
      } else {
        //****  Case if user is guest user OR product is not reward product  ****//
        console.log("cccc");
        resolve(2);
      }
    });
  }

  function getGuestUserId(userId, deviceId, loyaltyAmount) {
    return new Promise(function (resolve, reject) {
      if (userId != 0) {
        //****  Case if user is not guest user  ****//
        if (loyaltyAmount > 0) {
          Utils.loyaltyCashBurner(userId, loyaltyAmount).then(function (
            error,
            response
          ) {
            if (error) {
              resolve(userId);
            } else {
              //do nothing
              resolve(userId);
            }
          });
        } else {
          resolve(userId);
        }
      } else {
        var getUserIdQr =
          "select id from tbl_guest_user where device_id=? order by id desc limit 1";
        connection.query(getUserIdQr, [deviceId], function (err, rows, fields) {
          if (err) {
            reject(false);
          } else {
            resolve(rows[0].id);
          }
        });
      }
    });
  }

  function getGiftdeduction(giftcardId, giftcardAmount, paymentMode, userId) {
    return new Promise(function (resolve, reject) {
      if (giftcardId == 0 || paymentMode == 1 || userId == 0) {
        //****  Case if user is not guest user  ****//
        console.log("bbbb");
        resolve(1);
      } else {
        console.log("dddddddddd");
        var getUsermail = "select email from users where user_id =?";
        connection.query(getUsermail, [userId], function (err, rows, fields) {
          if (err) {
            reject(false);
          } else {
            var selectGiftpurchase =
              "select * from gift_card_purchase where ID =? and receiver_mail=? and status != '4'";
            connection.query(
              selectGiftpurchase,
              [giftcardId, rows[0].email],
              function (err, rows1, fields) {
                if (err) {
                  reject(false);
                } else {
                  var amount_remaining =
                    rows1[0].amount_remaining - giftcardAmount;
                  if (amount_remaining > 0) {
                    var updateGiftpurchase =
                      "update gift_card_purchase set amount_remaining=?,status='3',updated_at=now() where ID =? and receiver_mail=? and status != '4'";
                  } else {
                    var updateGiftpurchase =
                      "update gift_card_purchase set amount_remaining=?,status='4',updated_at=now() where ID =? and receiver_mail=? and status != '4'";
                  }
                  connection.query(
                    updateGiftpurchase,
                    [amount_remaining, giftcardId, rows[0].email],
                    function (err, rows2, fields) {
                      if (err) {
                        reject(false);
                      } else {
                        resolve(1);
                      }
                    }
                  );
                  //   resolve(rows[0].id);
                }
              }
            );
          }
        });
      }
    });
  }

  function getpromodeduction(
    promocodeId,
    promocodeAmount,
    paymentMode,
    userId
  ) {
    return new Promise(function (resolve, reject) {
      if (promocodeId == 0 || paymentMode == 1 || userId == 0) {
        //****  Case if user is not guest user  ****//
        resolve(1);
      } else {
        var updatePromopurchase =
          "update promocode_users set is_claimed='1',claimed_date=now(),updated_at=now() where id =? and user_id=? and is_claimed = '0'";

        connection.query(
          updatePromopurchase,
          [promocodeId, userId],
          function (err, rows2, fields) {
            if (err) {
              reject(false);
            } else {
              resolve(1);
            }
          }
        );
        //   resolve(rows[0].id);
      }
    });
  }

  function updateRewardcount(orderId, userId, status) {
    return new Promise(function (resolve, reject) {
      if (userId == 0) {
        //****  Case if user is  guest user  ****//
        console.log("test");
        resolve(1);
      } else {
        if (status == "4") {
          console.log(userId);
          var orderItemQr =
            "select quantity,group_id,is_free_reward from order_items where order_id=?";
          connection.query(
            orderItemQr,
            [orderId],
            function (err, rows, fields) {
              if (err) {
                console.log("rewardcheck1");
                console.log(err);
                reject(false);
              } else {
                var rewardcount = 0;
                synceach(
                  rows,
                  function (item, next) {
                    if (item.group_id > 0 && item.is_free_reward == "0") {
                      rewardcount = rewardcount + item.quantity;
                    } else if (
                      item.group_id > 0 &&
                      item.is_free_reward == "1"
                    ) {
                      var updateUser1 =
                        "update users set reward_points= 0,updated_at=now() where user_id =?";

                      connection.query(
                        updateUser1,
                        [userId],
                        function (err, rows1, fields) {
                          if (err) {
                            reject(false);
                          } else {
                            //next(null, item);
                          }
                        }
                      );
                    } else {
                    }
                    next(null, item);
                  },
                  function (err, transformedItems) {
                    var updateUser =
                      "update users set reward_points= reward_points+?,updated_at=now() where user_id =?";

                    connection.query(
                      updateUser,
                      [rewardcount, userId],
                      function (err, rows2, fields) {
                        if (err) {
                          console.log("rewardcheck2");
                          console.log(err);
                          reject(false);
                        } else {
                          resolve(1);
                        }
                      }
                    );
                  }
                );
              }
            }
          );
        }
      }
    });
  }

  /**
   * @api {post} /saveUserAddress save user address for delivery
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName saveUserAddress
   * @apiGroup Users
   * @apiParam {String} userId user id.
   * @apiParam {String} mobileNumber mobile number.
   * @apiParam {String} deviceId user mobile's unique id.
   * @apiParam {String} landmark landmark.
   * @apiParam {String} location location.
   * @apiParam {String} houseNumber house number.
   * @apiParam {String} addressType type of address.(1=home, 2=office, 3=other)
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           "addressId" : 1
   *           }
   *      }
   *
   */

  api.post("/saveUserAddress", function (req, res) {
    var requestParams = req.body;
    //console.log("data="+JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        mobileNumber: { type: "string" },
        location: { type: "string" },
        latitude: { type: "string" },
        longitude: { type: "string" },
        addressType: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      checkIsDeliverable(requestParams.latitude, requestParams.longitude).then(
        function (result1) {
          if (result1) {
            var query =
              "insert into user_address(userId,latitude,longitude,device_id,mobile_number,address_type,house_number,location,landmark,is_delete,created_at)values(?,?,?,?,?,?,?,?,?,'0',now())";
            connection.query(
              query,
              [
                requestParams.userId,
                requestParams.latitude,
                requestParams.longitude,
                requestParams.deviceId,
                requestParams.mobileNumber,
                requestParams.addressType,
                requestParams.houseNumber,
                requestParams.location,
                requestParams.landmark,
              ],
              function (err, rows, fields) {
                if (err) {
                  console.log("error : " + err);
                  var message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  data.addressId = rows.insertId;
                  data.is_delivarble = 1;
                  var message = languages.success[lang];
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              }
            );
          } else {
            data.is_delivarble = 0;
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
      //var query="call saveUserAddress(?,?,?,?,?,?,?,?,?)";
    }
  });

  /**
     * @api {get} /getUserAddressList get user address list for delivery
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiHeader {String} x-cafejavas-userid send userid which using the api
     * @apiHeader {String} x-cafejavas-token send jwt token
     * @apiVersion 1.0.0
     * @apiName getUserAddressList
     * @apiGroup Users
     * @apiParam {String} userId user id.
     * @apiParam {String} deviceId user mobile's unique id.
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *      {
     *           "Success": true,
     *           "Status": 200,
     *           "Message": "Success",
     *           "AppVersion": "1.0.0",
     *           "Result": [
     *           {
     *          "address_id": 1,
     "userId": 1,
     "mobile_number": "9645454545",
     "address_type": "1",
     "house_number": "house no 11",
     "location": "XYZ",
     "landmark": "ABCD"
     },
     {
     "address_id": 2,
     "userId": 1,
     "mobile_number": "96478874554",
     "address_type": "2",
     "house_number": "house no 12",
     "location": "XYZ",
     "landmark": "ABCD"
     }
     ]
     *      }
     *
     */

  api.get("/getUserAddressList", function (req, res) {
    var requestParams = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      connection.query(
        "call getUserAddressList(?,?)",
        [requestParams.userId, requestParams.deviceId],
        function (err, rows, fields) {
          if (err) {
            console.log("error : " + err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            console.log(rows[0].length);
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, rows[0]);
          }
        }
      );
    }
  });

  /**
   * @api {post} /saveGuestUser save guest user
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName saveGuestUser
   * @apiGroup Users
   * @apiParam {String} firstName first name.
   * @apiParam {String} lastName last name.
   * @apiParam {String} email email.
   * @apiParam {String} mobileNumber mobile number.
   * @apiParam {String} deviceId device id of user mobile.
   * @apiParam {String} deviceToken device token of user mobile.
   * @apiParam {Number} deviceType type of user device.(1 for IOS, 2 for android)
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {}
   *      }
   *
   */

  api.post("/saveGuestUser", function (req, res) {
    var requestParams = req.body;
    console.log("data=" + JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        firstName: { type: "string" },
        mobileNumber: { type: "string" },
        email: { type: "string" },
        deviceId: { type: "string" },
        deviceToken: { type: "string" },
        deviceType: { type: "number" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      connection.query(
        "call saveGuestUser(?,?,?,?,?,?,?)",
        [
          requestParams.firstName,
          requestParams.lastName,
          requestParams.email,
          requestParams.mobileNumber,
          requestParams.deviceId,
          requestParams.deviceToken,
          requestParams.deviceType,
        ],
        function (err, rows, fields) {
          if (err) {
            console.log("error : " + err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
   * @api {put} /deleteUserAddress Delete address saved by user
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName deleteUserAddress
   * @apiGroup Users
   * @apiParam {Number} addressId Unique address ID
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *   "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result":  {
   *   "addressType": "1"
   *   }
   *   }
   *
   */
  api.put("/deleteUserAddress", function (req, res) {
    var requestData = req.body;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        addressId: { type: "number" },
      },
    };
    console.log(JSON.stringify(requestData));
    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var deleteAddressDetailsQr =
        "select address_type from user_address where id=?";
      connection.query(
        deleteAddressDetailsQr,
        [requestData.addressId],
        function (err0, rows0, fields) {
          if (err0) {
            console.log(err0);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            if (rows0.length > 0) {
              var deleteAddressQr = "call deleteAddress(?)";
              connection.query(
                deleteAddressQr,
                [requestData.addressId],
                function (err, rows, fields) {
                  if (err) {
                    console.log(err);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    data.addressType = rows0[0].address_type;
                    var message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              );
            } else {
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            }
          }
        }
      );
    }
  });

  /**
     * @api {get} /getOrderHistory Get order history
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getOrderHistory
     * @apiGroup Orders       
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiParam {String} pageNo page number(starts with 1)
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result": {
     *   "data": [
     {
     "order_number": "CAFEJAVAS_20",
     "order_id" : 1,
     "order_date": "2018-06-11 15:07:33",
     "status": 4,
     "payment_mode": "Online",
     "deliveryFee": 0,
     "totalPrice": 33,
     "giftamount":0,
     "Promoamount":0,
     "subtotal":0,
     "vatAmount":0,
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     },
     {
     "order_number": "CAFEJAVAS_13",
     "order_id" : 2,
     "order_date": "2018-06-07 20:00:15",
     "status": 5,
     "payment_mode": "Online",
     "deliveryFee": 0,
     "totalPrice": 0,
     "giftamount":0,
     "Promoamount":0,
     "subtotal":0,
     "vatAmount":0,
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     },
     {
     "order_number": "CAFEJAVAS_8",
     "order_id" : 3,
     "order_date": "2018-06-07 19:43:18",
     "status": 4,
     "payment_mode": "Cash",
     "deliveryFee": 0,
     "totalPrice": 0,
     "giftamount":0,
     "Promoamount":0,
     "subtotal":0,
     "vatAmount":0,
     "loyaltyAmount":0,
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     }
     ],
     "total": 3
     *   
     *   }
     *
     */
  api.get("/getOrderHistory", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        pageNo: { type: "String" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      var pageNo = requestData.pageNo || 1;
      var offset = (pageNo - 1) * pageLimit;

      //**** getting orders of user  ****//
      if (requestData.userId == 0) {
        var orderQr =
          "select order_id,order_num,status,service_fee,delivery_fee,subtotal,total as totalPrice, gift_amount,promo_amount,loyalty_amount,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders where device_id=? and order_id !='0' and (status = '4' or status = '5') order by order_id desc limit ? offset ?";
        var paramArray = [requestData.deviceId, pageLimit, offset];
        var orderCountQr =
          "select order_id from orders where device_id=? and order_id !='0' and (status = '4' or status = '5')";
        var paramArray2 = [requestData.deviceId];
      } else {
        var orderQr =
          "select order_id,order_num,status,service_fee,delivery_fee,subtotal,total as totalPrice, gift_amount,promo_amount,loyalty_amount,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders where user_id=? and order_id !='0' and (status = '4' or status = '5') order by order_id desc limit ? offset ?";
        var paramArray = [requestData.userId, pageLimit, offset];
        var orderCountQr =
          "select order_id from orders where user_id=? and order_id !='0' and (status = '4' or status = '5')";
        var paramArray2 = [requestData.userId];
      }
      var giftamount = 0;
      var Promoamount = 0;
      var subtotal = 0;
      var vatAmount = 0;
      var loyaltyAmount = 0;
      connection.query(
        orderCountQr,
        paramArray2,
        function (err0, rows0, fields) {
          if (err0) {
            console.log(err0);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, finalData);
          } else {
            connection.query(orderQr, paramArray, function (err, rows, fields) {
              if (err) {
                console.log(err);
                message = languages.something_went_wrong[lang];
                Utils.makeResponse(
                  res,
                  false,
                  400,
                  message,
                  appVersion,
                  finalData
                );
              } else {
                if (rows.length > 0) {
                  var allOrderItems = [];
                  //****  getting total cost of order  ****//
                  synceach(
                    rows,
                    function (item, next) {
                      var orderItemQr =
                        "select quantity,subtotal,json from order_items where order_id=?";
                      connection.query(
                        orderItemQr,
                        [item.order_id],
                        function (err1, rows1, fields) {
                          if (err1) {
                            console.log(err1);
                            var nullObj = {};
                            next(null, nullObj);
                          } else {
                            var orderItemData = {};
                            var totalPrice = 0;
                            var serviceFee = 0;
                            var deliveryFee = item.delivery_fee;
                            var paymentMode = item.payment_mode;
                            var order_id = item.order_id;
                            var order_num = item.order_num;
                            var status = item.status;
                            var created_at = item.created_at;
                            var giftamount = item.gift_amount;
                            var Promoamount = item.promo_amount;
                            var subtotal = item.subtotal;
                            var vatAmount = item.service_fee;
                            var loyaltyAmount = item.loyalty_amount;
                            if (rows1.length > 0) {
                              //****  order items found  ****//
                              synceach(
                                rows1,
                                function (item, next) {
                                  var itemTotalCost =
                                    item.quantity * item.subtotal;
                                  totalPrice = totalPrice + itemTotalCost;
                                  next(null, item);
                                },
                                function (err, transformedItems) {
                                  if (rows1[0].json != "") {
                                    var jsonData = JSON.parse(rows1[0].json);
                                    var orderImage =
                                      jsonData.data.orderItemDetail.image;
                                  } else {
                                    var orderImage = "";
                                  }
                                  console.log(orderImage);
                                  orderItemData.image = orderImage;
                                  orderItemData.order_id = order_id;
                                  orderItemData.order_number = order_num;
                                  orderItemData.status = status;
                                  orderItemData.order_date = created_at;
                                  orderItemData.payment_mode = paymentMode;
                                  orderItemData.deliveryFee = deliveryFee;
                                  orderItemData.totalPrice =
                                    totalPrice +
                                    deliveryFee -
                                    (giftamount + Promoamount + loyaltyAmount);
                                  orderItemData.giftamount = giftamount;
                                  orderItemData.Promoamount = Promoamount;
                                  orderItemData.subtotal = subtotal;
                                  orderItemData.vatAmount = vatAmount;
                                  orderItemData.loyaltyAmount = loyaltyAmount;
                                  allOrderItems.push(orderItemData);
                                  next(null, item);
                                }
                              );
                            } else {
                              //****  order items not found  ****//
                              orderItemData.image = "";
                              orderItemData.order_id = order_id;
                              orderItemData.order_number = order_num;
                              orderItemData.status = status;
                              orderItemData.order_date = created_at;
                              orderItemData.payment_mode = paymentMode;
                              orderItemData.deliveryFee = deliveryFee;
                              orderItemData.totalPrice =
                                totalPrice -
                                (giftamount + Promoamount + loyaltyAmount);
                              orderItemData.giftamount = giftamount;
                              orderItemData.Promoamount = Promoamount;
                              orderItemData.subtotal = subtotal;
                              orderItemData.vatAmount = vatAmount;
                              orderItemData.loyaltyAmount = loyaltyAmount;
                              allOrderItems.push(orderItemData);
                              next(null, item);
                            }
                          }
                        }
                      );
                    },
                    function (err, transformedItems) {
                      finalData.data = allOrderItems;
                      finalData.total = rows0.length;
                      message = languages.success[lang];

                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  );
                } else {
                  finalData.data = rows;
                  finalData.total = 0;
                  var message = languages.success[lang];
                  Utils.makeResponse(
                    res,
                    true,
                    200,
                    message,
                    appVersion,
                    finalData
                  );
                }
              }
            });
          }
        }
      );
    }
  });
  api.get("/searchOrderHistory", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        pageNo: { type: "String" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      var pageNo = requestData.pageNo || 1;
      var offset = (pageNo - 1) * pageLimit;

      //**** getting orders of user  ****//
      if (requestData.userId == 0) {
        var orderQr =
          "select user_address.*,order_id,order_num,status,service_fee,subtotal,gift_amount,promo_amount,loyalty_amount,orders.created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders JOIN user_address on user_address.id=orders.address_id where device_id=? and order_id !='0' and (status = '4' or status = '5')and mobile_number like ? order by order_id desc limit ? offset ?";
        var paramArray = [
          requestData.deviceId,
          "%" + requestData.phone + "%",
          pageLimit,
          offset,
        ];
        var orderCountQr =
          "select order_id from orders where device_id=? and order_id !='0' and (status = '4' or status = '5')";
        var paramArray2 = [requestData.deviceId];
      } else {
        console.log(requestData);
        var orderQr =
          "select user_address.*, order_id,order_num,status,service_fee,subtotal,gift_amount,promo_amount,loyalty_amount,orders.created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders JOIN user_address on user_address.id=orders.address_id where user_id=? and order_id !='0' and (status = '4' or status = '5') and mobile_number like ? order by order_id desc limit ? offset ?";
        var paramArray = [
          requestData.userId,
          "%" + requestData.phone + "%",
          pageLimit,
          offset,
        ];
        var orderCountQr =
          "select order_id from orders where user_id=? and order_id !='0' and (status = '4' or status = '5')";
        var paramArray2 = [requestData.userId];
      }
      console.log(orderQr);
      var giftamount = 0;
      var Promoamount = 0;
      var subtotal = 0;
      var vatAmount = 0;
      var loyaltyAmount = 0;
      console.log("query", orderCountQr);
      connection.query(
        orderCountQr,
        paramArray2,
        function (err0, rows0, fields) {
          if (err0) {
            console.log(err0);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, finalData);
          } else {
            connection.query(orderQr, paramArray, function (err, rows, fields) {
              console.log(paramArray);
              if (err) {
                message = languages.something_went_wrong[lang];
                Utils.makeResponse(
                  res,
                  false,
                  400,
                  message,
                  appVersion,
                  finalData
                );
              } else {
                console.log(rows);
                if (rows.length > 0) {
                  var allOrderItems = [];
                  //****  getting total cost of order  ****//
                  synceach(
                    rows,
                    function (item, next) {
                      var orderItemQr =
                        "select quantity,subtotal,json from order_items where order_id=?";
                      connection.query(
                        orderItemQr,
                        [item.order_id],
                        function (err1, rows1, fields) {
                          if (err1) {
                            console.log(err1);
                            var nullObj = {};
                            next(null, nullObj);
                          } else {
                            var orderItemData = {};
                            var totalPrice = 0;
                            var serviceFee = 0;
                            var deliveryFee = 0;
                            var paymentMode = item.payment_mode;
                            var order_id = item.order_id;
                            var order_num = item.order_num;
                            var status = item.status;
                            var created_at = item.created_at;
                            var giftamount = item.gift_amount;
                            var Promoamount = item.promo_amount;
                            var subtotal = item.subtotal;
                            var vatAmount = item.service_fee;
                            var loyaltyAmount = item.loyalty_amount;
                            if (rows1.length > 0) {
                              //****  order items found  ****//
                              synceach(
                                rows1,
                                function (item, next) {
                                  var itemTotalCost =
                                    item.quantity * item.subtotal;
                                  totalPrice = totalPrice + itemTotalCost;
                                  next(null, item);
                                },
                                function (err, transformedItems) {
                                  if (rows1[0].json != "") {
                                    var jsonData = JSON.parse(rows1[0].json);
                                    var orderImage =
                                      jsonData.data.orderItemDetail.image;
                                  } else {
                                    var orderImage = "";
                                  }
                                  console.log(orderImage);
                                  orderItemData.image = orderImage;
                                  orderItemData.order_id = order_id;
                                  orderItemData.order_number = order_num;
                                  orderItemData.status = status;
                                  orderItemData.order_date = created_at;
                                  orderItemData.payment_mode = paymentMode;
                                  orderItemData.deliveryFee = deliveryFee;
                                  orderItemData.totalPrice =
                                    totalPrice -
                                    (giftamount + Promoamount + loyaltyAmount);
                                  orderItemData.giftamount = giftamount;
                                  orderItemData.Promoamount = Promoamount;
                                  orderItemData.subtotal = subtotal;
                                  orderItemData.vatAmount = vatAmount;
                                  orderItemData.loyaltyAmount = loyaltyAmount;
                                  allOrderItems.push(orderItemData);
                                  next(null, item);
                                }
                              );
                            } else {
                              //****  order items not found  ****//
                              orderItemData.image = "";
                              orderItemData.order_id = order_id;
                              orderItemData.order_number = order_num;
                              orderItemData.status = status;
                              orderItemData.order_date = created_at;
                              orderItemData.payment_mode = paymentMode;
                              orderItemData.deliveryFee = deliveryFee;
                              orderItemData.totalPrice =
                                totalPrice -
                                (giftamount + Promoamount + loyaltyAmount);
                              orderItemData.giftamount = giftamount;
                              orderItemData.Promoamount = Promoamount;
                              orderItemData.subtotal = subtotal;
                              orderItemData.vatAmount = vatAmount;
                              orderItemData.loyaltyAmount = loyaltyAmount;
                              allOrderItems.push(orderItemData);
                              next(null, item);
                            }
                          }
                        }
                      );
                    },
                    function (err, transformedItems) {
                      finalData.data = allOrderItems;
                      finalData.total = rows0.length;
                      message = languages.success[lang];

                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  );
                } else {
                  finalData.data = rows;
                  finalData.total = 0;
                  var message = languages.success[lang];
                  Utils.makeResponse(
                    res,
                    true,
                    200,
                    message,
                    appVersion,
                    finalData
                  );
                }
              }
            });
          }
        }
      );
    }
  });

  /**
     * @api {get} /getRecentOrderHistory Get recent order history
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getRecentOrderHistory
     * @apiGroup Orders       
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result": 
     [
     {
     "order_number": "CAFEJAVAS_20",
     "order_id" : 1,
     "order_date": "2018-06-11 15:07:33",
     "payment_mode": "Online",
     "deliveryFee": 0,
     "subtotal": 10000,
     "totalPrice": 0,
     "giftamount": 0,
     "Promoamount": 0,
     "vatAmount":0,
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     },
     {
     "order_number": "CAFEJAVAS_13",
     "order_id" : 2,
     "order_date": "2018-06-07 20:00:15",
     "payment_mode": "Online",
     "deliveryFee": 0,
     "subtotal": 10000,
     "totalPrice": 0,
     "giftamount": 0,
     "Promoamount": 0,
     "vatAmount":0,
     
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     },
     {
     "order_number": "CAFEJAVAS_8",
     "order_id" : 3,
     "order_date": "2018-06-07 19:43:18",
     "payment_mode": "Cash",
     "deliveryFee": 0,
     "subtotal": 10000,
     "totalPrice": 0,
     "giftamount": 0,
     "Promoamount": 0,
     "vatAmount":0,
     "image" : "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     }
     ]
     *   
     *   }
     *
     */
  api.get("/getRecentOrderHistory", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {},
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      //**** getting orders of user  ****//
      if (requestData.userId == 0) {
        var orderQr =
          "select order_id,order_num,service_fee,delivery_fee,subtotal,gift_amount,promo_amount,loyalty_amount,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders where device_id=? and order_id !='0' and status ='4' order by order_id desc limit 5";
        var paramArray = [requestData.deviceId];
      } else {
        var orderQr =
          "select order_id,order_num,service_fee,delivery_fee,subtotal,gift_amount,promo_amount,loyalty_amount,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from orders where user_id=? and order_id !='0' and status ='4' order by order_id desc limit 5";
        var paramArray = [requestData.userId];
      }
      var giftamount = 0;
      var Promoamount = 0;
      var subtotal = 0;
      var vatAmount = 0;
      var loyaltyAmount = 0;

      connection.query(orderQr, paramArray, function (err, rows, fields) {
        if (err) {
          console.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          var allOrderItems = [];
          if (rows.length > 0) {
            //****  getting total cost of order  ****//
            giftamount = rows[0].gift_amount;
            Promoamount = rows[0].promo_amount;
            loyaltyAmount = rows[0].loyalty_amount;
            subtotal = rows[0].subtotal;
            synceach(
              rows,
              function (item, next) {
                var orderItemQr =
                  "select quantity,subtotal,json from order_items where order_id=?";
                connection.query(
                  orderItemQr,
                  [item.order_id],
                  function (err1, rows1, fields) {
                    if (err1) {
                      console.log(err1);
                      var nullObj = {};
                      next(null, nullObj);
                    } else {
                      var orderItemData = {};
                      var totalPrice = 0;
                      var deliveryFee = item.delivery_fee;
                      var paymentMode = item.payment_mode;
                      var order_id = item.order_id;
                      var order_num = item.order_num;
                      var created_at = item.created_at;
                      var vatAmount = item.service_fee;
                      if (rows1.length > 0) {
                        //****  order items found  ****//
                        synceach(
                          rows1,
                          function (item, next) {
                            var itemTotalCost = item.quantity * item.subtotal;
                            totalPrice = totalPrice + itemTotalCost;
                            next(null, item);
                          },
                          function (err, transformedItems) {
                            if (rows1[0].json != "") {
                              var jsonData = JSON.parse(rows1[0].json);
                              var orderImage =
                                jsonData.data.orderItemDetail.image;
                            } else {
                              var orderImage = "";
                            }
                            orderItemData.image = orderImage;
                            orderItemData.order_id = order_id;
                            orderItemData.order_number = order_num;
                            orderItemData.order_date = created_at;
                            orderItemData.payment_mode = paymentMode;
                            orderItemData.deliveryFee = deliveryFee;
                            orderItemData.subtotal = subtotal;
                            orderItemData.totalPrice =
                              totalPrice +
                              deliveryFee -
                              (giftamount + Promoamount + loyaltyAmount);
                            orderItemData.giftamount = giftamount;
                            orderItemData.Promoamount = Promoamount;
                            orderItemData.vatAmount = vatAmount;
                            allOrderItems.push(orderItemData);
                            next(null, item);
                          }
                        );
                      } else {
                        //****  order items not found  ****//
                        orderItemData.image = "";
                        orderItemData.order_id = order_id;
                        orderItemData.order_number = order_num;
                        orderItemData.order_date = created_at;
                        orderItemData.payment_mode = paymentMode;
                        orderItemData.deliveryFee = deliveryFee;
                        orderItemData.subtotal = subtotal;
                        orderItemData.totalPrice =
                          totalPrice +
                          deliveryFee -
                          (giftamount + Promoamount + loyaltyAmount);
                        orderItemData.giftamount = giftamount;
                        orderItemData.Promoamount = Promoamount;
                        orderItemData.vatAmount = vatAmount;
                        allOrderItems.push(orderItemData);
                        next(null, item);
                      }
                    }
                  }
                );
              },
              function (err, transformedItems) {
                message = languages.success[lang];

                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  allOrderItems
                );
              }
            );
          } else {
            var message = languages.success[lang];
            Utils.makeResponse(
              res,
              true,
              200,
              message,
              appVersion,
              allOrderItems
            );
          }
        }
      });
    }
  });

  /**
     * @api {get} /getSuggestedProducts List of suggested products.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getSuggestedProducts
     * @apiGroup Products  
     * @apiParam {String} productId product Id.(Id will be comma separated like 1,2,3)
     * @apiParam {String} pageNo Page number for pagination (start with page number 1).   
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     {
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "products": [
     {
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_65235993.jpg",
     "productId": 7,
     "catId": 18,
     "subCatId": 3,
     "productName": "sfsdf",
     "description": "Desc one",
     "price": "333",
     "isNewProduct": "0"
     },
     {
     "image": "",
     "productId": 3,
     "catId": 18,
     "subCatId": 3,
     "productName": "product one",
     "description": "Desc",
     "price": "2000",
     "isNewProduct": "0"
     }
     ],
     "total": 2
     }
     }
     *
     */

  api.get("/getSuggestedProducts", function (req, res) {
    logger.info('EXPRESS: post("/getSuggestedProducts") --> RECEIVED'.event);
    var requestData = req.query;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        productId: { type: "string" },
        pageNo: { type: "string" },
      },
    };
    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var totalProducts =
        "SELECT COUNT(DISTINCT ts.suggested_product_id) as total from tbl_suggestion as ts,tbl_products_items as tpi where ts.product_id in(?) and ts.product_id=tpi.product_id and ts.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
      connection.query(
        totalProducts,
        [requestData.productId],
        function (err, rows, fields) {
          if (err) {
            console.log("errrr" + err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            console.log(requestData.productId);
            var pageNo = requestData.pageNo || 1;
            var offset = (pageNo - 1) * pageLimit;
            var suggestedProducts =
              "SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,'',(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,ts.suggested_product_id as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price`, (case when DATE_ADD(tpi.created_at, INTERVAL 1 DAY) > now() then '1' else '0' end) as isNewProduct  FROM `tbl_products_items` as tpi, tbl_suggestion as ts WHERE ts.suggested_product_id=tpi.product_id and ts.product_id in(" +
              requestData.productId +
              ") and ts.is_delete = '0' and tpi.is_deleted = '0' and tpi.status='1' group by ts.suggested_product_id order by ts.created_at desc limit ? offset ?";
            connection.query(
              suggestedProducts,
              [pageLimit, offset],
              function (err1, rows1, fields) {
                if (err1) {
                  console.log("erroe" + err1);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else if (rows1.length > 0) {
                  message = languages.success[lang];

                  data.products = rows1;
                  data.total = rows[0].total;
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                } else {
                  data.products = [];
                  data.total = 0;
                  message = languages.no_product_found[lang];
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              }
            );
          }
        }
      );
    }
  });

  function getDistanceFromLatLon(lat1, lon1, lat2, lon2) {
    return new Promise(function (resolve, reject) {
      var latitudeDiff = lat2 - lat1;
      var longitudeDiff = lon2 - lon1;

      var R = 6371; // Radius of the earth in km
      //console.log("lat diff="+latitudeDiff);
      //console.log("long diff="+longitudeDiff);
      deg2rad(latitudeDiff, longitudeDiff, lat1, lat2)
        .then(function (data) {
          if (data) {
            console.log("array=" + data);
            var dLat = data[0];
            var dLon = data[1];
            var value1 = data[2];
            var value2 = data[3];
            var a =
              Math.sin(dLat / 2) * Math.sin(dLat / 2) +
              Math.cos(value1) *
              Math.cos(value2) *
              Math.sin(dLon / 2) *
              Math.sin(dLon / 2);
            var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            var d = R * c; // Distance in km
            //   console.log("distance="+d);
            resolve(d);
          } else {
            reject(false);
          }
        })
        .catch(function (err) {
          reject(err);
        });
    });
  }

  function deg2rad(deg1, deg2, deg3, deg4) {
    return new Promise(function (resolve, reject) {
      var data = [];
      data[0] = deg1 * (Math.PI / 180);
      data[1] = deg2 * (Math.PI / 180);
      data[2] = deg3 * (Math.PI / 180);
      data[3] = deg4 * (Math.PI / 180);
      resolve(data);
    });
  }

  function updateCartItemPrice(jsonData, productId, userId) {
    return new Promise(function (resolve, reject) {
      // console.log("JSON====="+JSON.stringify(jsonData));
      var productDetailsQr =
        'SELECT checkProductIsFavourite(?,?) as isFavourite,if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image, `price`, is_deleted,status FROM `tbl_products_items` as tpi WHERE product_id = ? ';
      connection.query(
        productDetailsQr,
        [productId, userId, productId],
        function (err, rows, fields) {
          if (err) {
            console.log("ERERER==" + err);
            reject(false);
          } else if (rows.length == 1) {
            var newData = [];
            //                    if(rows[0].is_deleted=='1' || rows[0].status=='0' )
            //                    {
            //                        //****  Product is not available now  ****//
            //                        newData[0]=0;
            //                        newData[1]=jsonData;
            //                        resolve(newData);
            //                    }
            //                    else
            //                    {

            newData[0] = 1;
            //     console.log("product ==="+JSON.stringify(rows[0]));
            jsonData.data.orderItemDetail.isFavourite = rows[0].isFavourite;
            jsonData.data.orderItemDetail.price = rows[0].price;
            jsonData.data.orderItemDetail.image = rows[0].image;
            newData[1] = jsonData;
            newData[2] = parseFloat(rows[0].price);
            var itemTotalPrice = newData[2];
            //     console.log("finalJSON====="+JSON.stringify(jsonData));
            //****  code to grt total of additional total  ****//
            getTotalAdditionalPrice(jsonData.data.additionalItems)
              .then(function (additionalItemsPrice) {
                if (additionalItemsPrice || additionalItemsPrice == 0) {
                  newData[3] = additionalItemsPrice;
                  itemTotalPrice += parseFloat(additionalItemsPrice);
                  getTotalOptionalPrice(jsonData.data.topextraItems)
                    .then(function (optionalItemsPrice) {
                      if (optionalItemsPrice || optionalItemsPrice == 0) {
                        newData[4] = optionalItemsPrice;
                        itemTotalPrice += parseFloat(optionalItemsPrice);
                        newData[5] = itemTotalPrice;
                        resolve(newData);
                      } else {
                        console.log("11111111111111111111");
                        reject(false);
                      }
                    })
                    .catch(function (err) {
                      console.log("222222222222222222222" + err);
                      reject(err);
                    });
                } else {
                  reject(false);
                  console.log("333333333333333333");
                }
              })
              .catch(function (err) {
                reject(err);
                console.log("4444444444444444444" + err);
              });

            //    }
          } else {
            console.log("dddddddddddddddddddddd");
            reject(false);
          }
        }
      );
    });
  }

  function getTotalAdditionalPrice(additionalPriceData) {
    return new Promise(function (resolve, reject) {
      console.log("additionalPriceData====" + additionalPriceData);
      var totalPrice = 0;
      if (additionalPriceData == undefined) {
        //****  Case if key is not present in JSON response  ****//
        resolve(totalPrice);
      } else {
        if (additionalPriceData.length > 0) {
          synceach(
            additionalPriceData,
            function (item, next) {
              totalPrice += parseFloat(item.price);
              next(null, item);
            },
            function (err, transformedItems) {
              resolve(totalPrice);
            }
          );
        } else {
          resolve(totalPrice);
        }
      }
    });
  }

  function getTotalOptionalPrice(optionalPriceData) {
    return new Promise(function (resolve, reject) {
      var totalPrice = 0;
      console.log("optionalPriceData=======" + optionalPriceData);
      if (optionalPriceData == undefined) {
        //****  Case if key is not present in JSON response  ****//
        resolve(totalPrice);
      } else {
        if (optionalPriceData.length > 0) {
          synceach(
            optionalPriceData,
            function (item, next) {
              totalPrice += parseFloat(item.labelOptions.price);
              next(null, item);
            },
            function (err, transformedItems) {
              resolve(totalPrice);
            }
          );
        } else {
          resolve(totalPrice);
        }
      }
    });
  }

  /**
   * @api {post} /driverSignIn/ driver app sign in
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName driverSignIn
   * @apiGroup Driver
   * @apiParam {String} email user email.
   * @apiParam {String} password user password.
   * @apiParam {string} deviceType user device type (1 for iOS 2 for Android).
   * @apiParam {String} deviceToken user device token.
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "userId": 42,
   *           "firstName": "nitin",
   *           "lastName": "abcd",
   *           "email": "sfasdfa@sfa.com",
   *           "phone": "234242444445",
   *           "profilePic": "",
   *           "userType": "1",
   *           "tokenExpirationTime": 1800
   *         }
   *       ]
   *     }
   *
   */

  api.post("/driverSignIn", function (req, res) {
    logger.log("%O", req.body);
    var user = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        email: { type: "string", pattern: "email" },
        password: { type: "string" },
        deviceType: { type: "string" },
        deviceToken: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var validateUserEmail =
        'SELECT id FROM tbl_driver WHERE email = ? and is_delete = "0" ';
      var validateuser =
        'SELECT image as profilePic,id, first_name as firstName,last_name as lastName, email,phone,user_type as userType FROM tbl_driver WHERE email = ? and password = md5(?) and is_delete = "0" ';

      connection.query(
        validateUserEmail,
        [user.email],
        function (errValidate, userValidate) {
          if (errValidate) {
            logger.log(errValidate);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (userValidate.length > 0) {
            var validateUserPassword =
              'SELECT id FROM tbl_driver WHERE password = md5(?) and is_delete = "0" ';
            connection.query(
              validateUserPassword,
              [user.password],
              function (errValidate2, userValidate2) {
                if (errValidate2) {
                  logger.log(errValidate2);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else if (userValidate2.length > 0) {
                  connection.query(
                    validateuser,
                    [user.email, user.password],
                    function (errlogin, userdata1) {
                      if (errlogin) {
                        logger.log(errlogin);
                        message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      } else if (userdata1.length > 0) {
                        console.log(
                          user.deviceToken +
                          "   " +
                          user.deviceType +
                          "   " +
                          userdata1[0].id
                        );
                        var insertUser =
                          "update tbl_driver set device_token=?,device_type=? where id=?";
                        connection.query(
                          insertUser,
                          [user.deviceToken, user.deviceType, userdata1[0].id],
                          function (erru, updateuser) {
                            if (!erru) {
                              userdata1[0].tokenExpirationTime =
                                config.CONSTANTS.JWT_EXPIRATION_TIME; // add jwt expiration time
                              Utils.makeResponse(
                                res,
                                true,
                                200,
                                "",
                                appVersion,
                                userdata1
                              );
                            } else {
                              message = languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                            }
                          }
                        );
                      } else {
                        message = languages.invalid_userID_or_password[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    }
                  );
                } else {
                  message = languages.password_verification_failed[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    200,
                    message,
                    appVersion,
                    data
                  );
                }
              }
            );
          } else {
            message = languages.email_verification_failed[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /driverLogout ************************************************************************/

  /**
   * @api {post} /driverLogout/ driver logout.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName driverLogout
   * @apiGroup Driver
   * @apiParam {String} userId user id.
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "User Logout Successfully",
   *       "AppVersion": "1.0.0",
   *       "Result": []
   *     }
   *
   */

  api.post("/driverLogout", function (req, res) {
    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        "SELECT count(id) as totaluser FROM tbl_driver where id=?";

      connection.query(checkuser, [user.userId], function (err, countuser) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (countuser[0]["totaluser"] > 0) {
          var insertUser = "update tbl_driver set device_token=? where id=?";
          connection.query(
            insertUser,
            ["", user.userId],
            function (err, sucmessage) {
              message = languages.user_logout[lang];
              Utils.makeResponse(res, true, 200, message, appVersion, data);
            }
          );
        } else {
          message = languages.user_does_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /getDriverProfile ************************************************************************/

  /**
     * @api {get} /getDriverProfile/ driver profile details
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getDriverProfile
     * @apiGroup Driver
     * @apiParam {String} userId user id.   
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": [
     *       {
     *           "firstName": "driver1",
     *           "lastName": "abcd",
     "email": "driver@gmail.com",
     "phone": "9999999999",
     "profilePic": ""
     }
     *       ]
     *     }
     *
     */

  api.get("/getDriverProfile", function (req, res) {
    logger.log("%O", req.query);
    var user = req.query;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        "SELECT first_name as firstName,last_name as lastName,email,phone,image as profilePic FROM tbl_driver where id=? and is_delete='0' and status='1'";

      connection.query(checkuser, [user.userId], function (err, userData) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (userData.length > 0) {
          var qry =
            "select COALESCE(sum(incentive),0) as totalIncentive from orders where status = '4' and driver_id= ? and (MONTH(NOW())=MONTH(created_at )  or (MONTH(NOW())-1)=MONTH(created_at ))";
          connection.query(qry, [user.userId], function (err, result) {
            if (err) {
              console.log(err);
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else {
              getDriverDeliveryCount(user.userId).then(function (result1) {
                if (result1) {
                  userData[0].totalIncentive = result[0].totalIncentive;
                  userData[0].total_orders = result1.total_orders;
                  userData[0].delivered_orders = result1.delivered_orders;
                  userData[0].canceled_orders = result1.canceled_orders;
                  userData[0].delayed_orders = result1.delayed_orders;
                  userData[0].ontime_orders =
                    result1.delivered_orders - result1.delayed_orders;
                  console.log(result1);
                  message = languages.success[lang];
                  Utils.makeResponse(
                    res,
                    true,
                    200,
                    message,
                    appVersion,
                    userData
                  );
                } else {
                  message = languages.success[lang];
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              });
            }
          });
        } else {
          message = languages.user_does_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  api.get("/getDriverAvailiability", function (req, res) {
    logger.log("%O", req.query);
    var driver = req.query;

    var schema = {
      type: "object",
      properties: {
        driver_id: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, driver);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var query = "select is_available from tbl_driver where id = ?";

      connection.query(query, [driver.driver_id], function (err, rows, fields) {
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (rows.length > 0) {
          message = languages.success[lang];
          Utils.makeResponse(res, true, 200, message, appVersion, {
            is_available: rows[0]["is_available"],
          });
        } else {
          message = languages.user_does_not_exist[lang];
          Utils.makeResponse(res, false, 412, message, appVersion, data);
        }
      });
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /updateDriverAvailiability ************************************************************************/
  /**
   * @api {post} /updateDriverAvailiability updateDriverAvailiability
   * @apiDescription Update Driver Availiability
   * @apiGroup Drivers
   * @apiName updateDriverAvailiability
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string}             id                  first_name (user email)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}                         response                            response object
   * @apiSuccess {Number=0,1}                         response.status                 response status ( 0 for error, 1 for success )
   * @apiSuccess {string}                             [response.message=null]         error message
   * @apiSuccess {Object}                             [response.data=null]            response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */
  api.put("/updateDriverAvailiability/", function (req, res, next) {
    var driver = req.body;

    // Check if driver has any assigned order which is not delivered yet
    var query1 =
      'select order_id from orders where driver_id = ? and status != "4" ';
    connection.query(
      query1,
      [driver.driver_id],
      function (err1, rows1, fields1) {
        console.log(query1);
        if (rows1.length > 0) {
          console.log("Ifffffff");
          console.log("Rows", rows1);
          var message = "You've remaining assigned order";
          Utils.makeResponse(res, true, 200, message, appVersion, {
            is_available: driver.is_available,
          });
        } else {
          console.log("Elssssssseeeeeeeeee");

          var query = "update tbl_driver set is_available = ? where id = ?";

          connection.query(
            query,
            [driver.is_available, driver.driver_id],
            function (err, rows, fields) {
              if (rows) {
                var status = 200;
                var message = "Records updated successfully.";
              }
              console.log(status);
              Utils.makeResponse(res, true, 200, message, appVersion, {
                is_available: driver.is_available,
              });
            }
          );
        }
      }
    );
  });

  api.post("/saveContact", function (req, res) {
    logger.info('EXPRESS: post("/saveContact") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        email: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      // update profile query
      var feedback = "INSERT INTO `usercontact`(`email`) VALUES (?)";
      connection.query(feedback, [user.email], function (errd, successdata) {
        if (errd) {
          message = languages.something_went_wrong[lang];

          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          message = languages.sent_review[lang];
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      });
    }
  });

  /**
     * @api {get} /getDriverOrderList/ driver order list
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getDriverOrderList
     * @apiGroup Driver
     * @apiParam {String} userId user id.   
     * @apiParam {String} pageNo page number(starts with 1)
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": 
     *       {
     *        "total": 1,
     "data": [
     {
     "order_id":1,
     "order_num": "CAFEJAVAS_234",
     "subtotal": 20000;
     "total": 30000,
     "gift_amount": 100,
     "promo_amount": 1000,
     "branch_name": "BOMBO ROAD",
     "firstName": "Shivammm",
     "lastName": "Shrivastavvv",
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     }
     ]
     }
     *     }
     *
     */

  api.get("/getDriverOrderList", function (req, res) {
    logger.log("%O", req.query);
    var user = req.query;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        pageNo: { type: "string" },
      },
    };
    var data = {};
    var driverAvailiability = "";
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var getOrderListCount =
        "SELECT SUM(total) FROM ( SELECT count(o.order_id) as total from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status !='4' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') UNION SELECT count(co.order_id) as total from callcenter_orders co join tbl_branches as tbco on co.branch_id=tbco.branch_id and co.driver_id=? and co.status !='4' left outer join users uco on(uco.user_id=co.user_id and is_guest_user='0') left outer join tbl_guest_user tguco on(tguco.id=co.user_id and is_guest_user='1')) as total";

      connection.query(
        getOrderListCount,
        [user.userId, user.userId],
        function (err, userData) {
          if (err) {
            console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var pageNo = user.pageNo || 1;
            var offset = (pageNo - 1) * pageLimit;
            var getOrderList =
              "SELECT 'users_orders' as orderKey, order_id,order_num,subtotal,delivery_fee,incentive,SUM(delivery_fee+subtotal-promo_amount) as totalPrice,total,gift_amount,promo_amount,loyalty_amount,tb.name as branch_name,IFNULL(u.first_name,tgu.first_name) as firstName,IFNULL(u.last_name,tgu.last_name) as lastName,dr.is_available, o.created_at from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status !='4'  and o.status != '5' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') LEFT JOIN tbl_driver AS dr ON dr.id = o.driver_id GROUP BY o.order_id UNION SELECT 'callcenter_orders' as orderKey, order_id, order_num, subtotal, delivery_fee, incentive, SUM(delivery_fee + subtotal) AS totalPrice, total, gift_amount, promo_amount, loyalty_amount, tb.name AS branch_name, IFNULL(u.first_name, tgu.first_name) AS firstName, IFNULL(u.last_name, tgu.last_name) AS lastName, codr.is_available, co.created_at FROM callcenter_orders co JOIN tbl_branches AS tb ON co.branch_id = tb.branch_id AND co.driver_id=? AND co.status != '4'  and co.status != '5' LEFT OUTER JOIN users u ON ( u.user_id = co.user_id AND is_guest_user = '0' ) LEFT OUTER JOIN tbl_guest_user tgu ON ( tgu.id = co.user_id AND is_guest_user = '1' ) LEFT JOIN tbl_driver AS codr ON codr.id = co.driver_id GROUP BY co.order_id order by created_at desc limit ? offset ?";
            connection.query(
              getOrderList,
              [user.userId, user.userId, pageLimit, offset],
              function (err1, userData1) {
                if (err1) {
                  console.log(err1);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  console.log("userData1.length===" + userData1.length);
                  if (userData1.length > 0) {
                    //****  getting total cost of order  ****//
                    synceach(
                      userData1,
                      function (item, next) {
                        console.log("order id-=" + item.order_id);
                        var orderKey = item.orderKey;
                        if (orderKey == "callcenter_orders") {
                          var orderItemQr =
                            "select json from callcenter_order_items where order_id=? order by ID desc limit 1";
                        } else {
                          var orderItemQr =
                            "select json from order_items where order_id=? order by ID desc limit 1";
                        }

                        connection.query(
                          orderItemQr,
                          [item.order_id],
                          function (err1, rows1, fields) {
                            if (err1) {
                              console.log(err1);
                              item.image = "";
                              var nullObj = {};
                              next(null, nullObj);
                            } else {
                              if (rows1.length > 0) {
                                //****  order items found  ****//
                                if (rows1[0].json != "") {
                                  var jsonData = JSON.parse(rows1[0].json);
                                  item.image =
                                    jsonData.data.orderItemDetail.image;
                                  next(null, item);
                                } else {
                                  item.image = "";
                                  next(null, item);
                                }
                              } else {
                                item.image = "";
                                next(null, item);
                              }
                            }
                          }
                        );
                      },
                      function (err, transformedItems) {
                        data.total = userData[0].total;
                        data.data = userData1;
                        message = languages.success[lang];
                        data.driverAvailiability = userData1[0].is_available;
                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    );
                  } else {
                    var driver_query =
                      "SELECT is_available FROM tbl_driver where id = ?";
                    connection.query(
                      driver_query,
                      [user.userId],
                      function (driver_query_error, driver_query) {
                        if (driver_query_error) {
                          console.log(driver_query_error);
                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        } else {
                          data.total = userData[0].total;
                          data.data = userData1;
                          message = languages.success[lang];
                          data.driverAvailiability =
                            driver_query[0].is_available;
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  }
                }
              }
            );
          }
        }
      );
    }
  });

  /**
     * @api {get} /getDriverOrderDetail/ driver order details
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getDriverOrderDetail
     * @apiGroup Driver
     * @apiParam {String} orderId order id
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": [
     {
     "order_id": 234,
     "status": "1",
     "subtotal": 20000,   
     "total": 30000,
     "gift_amount": 300,
     "promo_amount": 300,
     "service_fee": 300,
     "loyaltyAmount":0,
     "latitude": "12.1221",
     "longitude": "4.4545",
     "mobile_number": "9645454545",
     "house_number": "house no 11",
     "location": "XYZ",
     "landmark": "ABCD",
     "firstName": "Shivammm",
     "lastName": "Shrivastavvv"
     }
     ]
     
     *     }
     *
     */

  api.get("/getDriverOrderDetail", function (req, res) {
    logger.log("%O", req.query);
    var user = req.query;

    var schema = {
      type: "object",
      properties: {
        orderId: { type: "string" },
      },
    };
    var data = {};
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      if (user.orderKey == "callcenter_orders") {
        var getOrderList =
          "SELECT order_id,o.status,service_fee,delivery_fee,subtotal,total,SUM(delivery_fee+subtotal-promo_amount) as totalPrice,gift_amount,promo_amount,loyalty_amount as loyaltyAmount,o.customer_name as firstName, '' as lastName ,IFNULL(o.address,'') as location, o.customer_lat as latitude, o.customer_long as longitude, `landmark`,`phone` as mobile_number, `plot_no` as house_number from callcenter_orders o where o.order_id=?";
      } else {
        var getOrderList =
          "SELECT order_id,o.status,service_fee,delivery_fee,subtotal,total,SUM(delivery_fee+subtotal-promo_amount) as totalPrice,gift_amount,promo_amount,loyalty_amount as loyaltyAmount,ad.latitude,ad.longitude,ad.mobile_number,ad.house_number,ad.location,ad.landmark,IFNULL(u.first_name,tgu.first_name) as firstName,IFNULL(u.last_name,tgu.last_name) as lastName from orders o join user_address as ad on o.address_id=ad.id and o.order_id=? left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') ";
      }

      connection.query(
        getOrderList,
        [user.orderId],
        function (err1, userData1) {
          if (err1) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(
              res,
              false,
              400,
              message + err1,
              appVersion,
              data
            );
          } else {
            //                    if (userData1[0].status == '1') {
            //                        userData1[0].status = '1';
            //                    } else if (userData1[0].status == '6') {
            //                        userData1[0].status = '2';
            //                    } else if (userData1[0].status == '3') {
            //                        userData1[0].status = '3';
            //                    } else if (userData1[0].status == '4') {
            //                        userData1[0].status = '4';
            //                    }

            //userData1[0].latitude = '28.582061';
            userData1[0].total = userData1[0].total + userData1[0].delivery_fee;
            data = userData1;
            message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
     * @api {get} /getDriverOrderHistory/ driver order history
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getDriverOrderHistory
     * @apiGroup Driver
     * @apiParam {String} userId user id.   
     * @apiParam {String} pageNo page number(starts with 1)
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": 
     *       {
     *        "total": 1,
     "data": [
     {
     "order_id":1,
     "order_num": "CAFEJAVAS_234",
     "subtotal": 20000,
     "total": 30000,
     "gift_amount": 300,
     "promo_amount": 300,
     "loyaltyAmount": 0,
     "branch_name": "BOMBO ROAD",
     "firstName": "Shivammm",
     "lastName": "Shrivastavvv",
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg"
     }
     ]
     }
     *     }
     *
     */

  api.get("/getDriverOrderHistory", function (req, res) {
    logger.log("%O", req.query);
    var user = req.query;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        pageNo: { type: "string" },
      },
    };
    var data = {};
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var getOrderListCount =
        "SELECT SUM(total) FROM ( SELECT count(o.order_id) as total from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status ='4' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') UNION SELECT count(co.order_id) as total from callcenter_orders co join tbl_branches as tbco on co.branch_id=tbco.branch_id and co.driver_id=? and co.status ='4' left outer join users uco on(uco.user_id=co.user_id and is_guest_user='0') left outer join tbl_guest_user tguco on(tguco.id=co.user_id and is_guest_user='1')) as total";
      //            var getOrderListCount = "SELECT count(o.order_id) as total from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status ='4' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') where DATE(o.created_at) = CURDATE()";
      console.log(getOrderListCount);
      connection.query(
        getOrderListCount,
        [user.userId, user.userId],
        function (err, userData) {
          if (err) {
            console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var pageNo = user.pageNo || 1;
            var offset = (pageNo - 1) * pageLimit;
            //                    var getOrderList = "SELECT order_id,order_num,subtotal,delivery_fee,incentive,total, total as totalPrice ,gift_amount,promo_amount,loyalty_amount as loyaltyAmount,tb.name as branch_name,IFNULL(u.first_name,tgu.first_name) as firstName,IFNULL(u.last_name,tgu.last_name) as lastName from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status ='4' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') where DATE(o.created_at) = CURDATE() order by o.order_id desc limit ? offset ?";
            var getOrderList =
              "SELECT 'users_orders' as orderKey, order_id,order_num,subtotal,delivery_fee,incentive, SUM(delivery_fee + subtotal) AS totalPrice,total, gift_amount,promo_amount,loyalty_amount as loyaltyAmount,tb.name as branch_name,IFNULL(u.first_name,tgu.first_name) as firstName,IFNULL(u.last_name,tgu.last_name) as lastName , codr.is_available from orders o join tbl_branches as tb on o.branch_id=tb.branch_id and o.driver_id=? and o.status ='4' left outer join users u on(u.user_id=o.user_id and is_guest_user='0') left outer join tbl_guest_user tgu on(tgu.id=o.user_id and is_guest_user='1') LEFT JOIN tbl_driver AS codr ON codr.id = o.driver_id where DATE(o.created_at) = CURDATE() GROUP BY o.order_id UNION SELECT 'callcenter_orders' as orderKey, order_id, order_num, subtotal, delivery_fee, incentive, SUM(delivery_fee + subtotal) AS totalPrice, total, gift_amount, promo_amount, loyalty_amount as loyaltyAmount, tb.name AS branch_name, IFNULL(u.first_name, tgu.first_name) AS firstName, IFNULL(u.last_name, tgu.last_name) AS lastName, codr.is_available FROM callcenter_orders co JOIN tbl_branches AS tb ON co.branch_id = tb.branch_id AND co.driver_id=? AND co.status = '4'  LEFT OUTER JOIN users u ON ( u.user_id = co.user_id AND is_guest_user = '0' ) LEFT OUTER JOIN tbl_guest_user tgu ON ( tgu.id = co.user_id AND is_guest_user = '1' ) LEFT JOIN tbl_driver AS codr ON codr.id = co.driver_id where DATE(co.created_at) = CURDATE()  GROUP BY co.order_id order by order_id desc limit ? offset ?";
            console.log(getOrderList);
            connection.query(
              getOrderList,
              [user.userId, user.userId, pageLimit, offset],
              function (err1, userData1) {
                if (err1) {
                  console.log(err1);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  console.log("userData1.length===" + userData1.length);
                  if (userData1.length > 0) {
                    //****  getting total cost of order  ****//
                    synceach(
                      userData1,
                      function (item, next) {
                        console.log("order id-=" + item.order_id);
                        item.total = item.total + item.delivery_fee;
                        var orderKey = item.orderKey;
                        if (orderKey == "callcenter_orders") {
                          var orderItemQr =
                            "select json from callcenter_order_items where order_id=? order by ID desc limit 1";
                        } else {
                          var orderItemQr =
                            "select json from order_items where order_id=? order by ID desc limit 1";
                        }
                        console.log(orderItemQr);
                        connection.query(
                          orderItemQr,
                          [item.order_id],
                          function (err2, rows1, fields) {
                            if (err2) {
                              console.log(err2);
                              item.image = "";
                              var nullObj = {};
                              next(null, nullObj);
                            } else {
                              if (rows1.length > 0) {
                                //****  order items found  ****//
                                if (rows1[0].json != "") {
                                  var jsonData = JSON.parse(rows1[0].json);
                                  item.image =
                                    jsonData.data.orderItemDetail.image;
                                  next(null, item);
                                } else {
                                  item.image = "";
                                  next(null, item);
                                }
                              } else {
                                item.image = "";
                                next(null, item);
                              }
                            }
                          }
                        );
                      },
                      function (err, transformedItems) {
                        data.total = userData[0].total;
                        data.data = userData1;
                        message = languages.success[lang];
                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    );
                  } else {
                    data.total = userData[0].total;
                    data.data = userData1;
                    message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              }
            );
          }
        }
      );
    }
  });

  /**
     * @api {put} /orderStatusChangeByDriver/ driver change order status
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName orderStatusChangeByDriver
     * @apiGroup Driver
     * @apiParam {String} userId user id.   
     * @apiParam {String} orderId order id
     * @apiParam {String} status (3 => food on the way, 4 => food delivered)
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": 
     *       {
     
     }
     *     }
     *
     */

  api.put("/orderStatusChangeByDriver", function (req, res) {
    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        orderId: { type: "string" },
        status: { type: "string" },
      },
    };
    var data = {};
    var message = "";
    var updateOrderStatus;
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      if (user.orderKey == "callcenter_orders") {
        var checkstatus =
          "select status from callcenter_orders where order_id=?";
        var currStatus;
        connection.query(checkstatus, [user.orderId], function (err, resp) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            currStatus = resp[0].status;

            if (user.status == "3") {
              if (currStatus == "2") {
                updateOrderStatus =
                  "update callcenter_orders set status=?,food_picked_at=now() where driver_id=? and order_id=? ";
              } else {
                var qry =
                  "select * from callcenter_order_status_logs where order_status = 'Food is Ready' and order_id = ?";
                connection.query(qry, [user.orderId], function (err, resp) {
                  if (err) {
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    if (resp.length == 0) {
                      var insertccOrderLog = `insert into callcenter_order_status_logs set order_id = ?,order_status = ?,created_at = NOW(),updated_at = NOW()`;
                      connection.query(
                        insertccOrderLog,
                        [user.orderId, "Food is Ready"],
                        function (err, result) { }
                      );
                    }
                  }
                });
              }
              updateOrderStatus =
                "update callcenter_orders set status=?,food_picked_at=now() where driver_id=? and order_id=? ";
            } else {
              updateOrderStatus =
                "update callcenter_orders set status=? where driver_id=? and order_id=?";
            }
            connection.query(
              updateOrderStatus,
              [user.status, user.userId, user.orderId],
              function (err, result) {
                if (err) {
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  //CODE FOR PUSH NOTIFICATION FOR USER AND DRIVER
                  //code for user push notification
                  //fetching order details
                  connection.query(
                    "select order_id,user_id,is_guest_user,pickup_type from callcenter_orders where order_id =?",
                    [user.orderId],
                    function (orderErr, orderResult) {
                      if (err) {
                        console.log("order" + orderErr);
                      } else {
                        var order_status = "";
                        if (user.status == 3) {
                          order_status = "Order Picked";
                        } else if (user.status == 4) {
                          order_status = "Delivered";
                        }

                        var query1 =
                          "INSERT INTO callcenter_order_status_logs SET order_id = ?, order_status = ?, created_at = now(), updated_at = now()";
                        connection.query(
                          query1,
                          [user.orderId, order_status],
                          function (err1, rows1, fields1) {
                            if (err1) {
                              console.log(err1);
                            } else {
                              console.log("insert log");
                            }
                          }
                        );
                      }
                    }
                  );

                  //send push to Driver on order completion
                  if (user.status == "4") {
                    // Push Notification to driver on order delivered.
                    connection.query(
                      "select id,device_type,device_token from tbl_driver where id =?",
                      [user.userId],
                      function (driverErr, driverResult) {
                        if (driverErr) {
                          console.log("driver error" + driverErr);
                        } else {
                          //                                        console.log('-guest_user' + JSON.stringify(guestUserResult));
                          var device_token = driverResult[0].device_token;
                          var title = "CafeJavas";
                          var message =
                            "Congratulation you have successfully delivered your order " +
                            user.orderId;
                          var notificationType = "3"; //Order Delivered

                          var customData = {
                            notification_type: notificationType,
                            order_id: user.orderId,
                            user_id: driverResult[0].id, //driver id
                          };
                          var notificationParams = {
                            notification_type: notificationType,
                            message: message,
                            order_id: user.orderId,
                            user_id: driverResult[0].id, //driver id
                            send_to: "3", //driver
                          };
                          console.log("device token :" + device_token);
                          console.log("tt :" + title);
                          console.log("msg :" + message);
                          console.log("notif type token :" + notificationType);
                          if (driverResult[0].device_type == "1") {
                            //CODE FOR IOS PUSH NOTIFICATION

                            Utils.sendiOSPush(
                              connection,
                              notificationParams,
                              device_token,
                              config.CONSTANTS.DRIVER_BUNDLE_ID,
                              title,
                              message,
                              customData
                            ).then(function (pushResult, pushError) {
                              if (pushError) {
                                console.log("iOS errrorr");
                              } else {
                                console.log(
                                  "herer++++++++++********************"
                                );
                              }
                            });
                          } else {
                            //CODE FOR ANDROID PUSH NOTIFICATION

                            Utils.sendAndroidPush(
                              connection,
                              notificationParams,
                              device_token,
                              title,
                              message,
                              customData
                            ).then(function (error, response) {
                              if (error) {
                                console.log(
                                  "Android driver errrorr" +
                                  JSON.stringify(error)
                                );
                              } else {
                                //do nothing
                                console.log(
                                  "else true customer" +
                                  JSON.stringify(response)
                                );
                              }
                            });
                          }
                        }
                      }
                    );
                  }
                  if (user.status == "3") {
                    updateEstimatedSpeed(user.orderId, user.orderKey).then(
                      function (result) {
                        if (result != 0) {
                          var updateEstSpeed =
                            "update callcenter_orders set estimated_speed=? where driver_id=? and order_id=?";
                          connection.query(
                            updateEstSpeed,
                            [result, user.userId, user.orderId],
                            function (err, result1) {
                              if (err) {
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        } else {
                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  } else if (user.status == "4") {
                    updateActualSpeed(user.orderId, user.orderKey).then(
                      function (result) {
                        if (result != 0) {
                          var updateEstSpeed =
                            "update callcenter_orders set actual_speed=? where driver_id=? and order_id=?";
                          connection.query(
                            updateEstSpeed,
                            [result, user.userId, user.orderId],
                            function (err, result1) {
                              if (err) {
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        } else {
                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  } else {
                    message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              }
            );
          }
        });
      } else {
        var checkstatus = "select status from orders where order_id=?";
        var currStatus;
        var updateOrderStatus;
        connection.query(checkstatus, [user.orderId], function (err, resp) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            currStatus = resp[0].status;

            if (user.status == "3") {
              if (currStatus == "2") {
                updateOrderStatus =
                  "update orders set status=?,food_picked_at=now() where driver_id=? and order_id=? ";
              } else {
                var qry =
                  "select * from customers_order_status_logs where order_status = 'Food is Ready' and order_id = ?";
                connection.query(qry, [user.orderId], function (err, resp) {
                  if (err) {
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    if (resp.length == 0) {
                      var insertccOrderLog = `insert into customers_order_status_logs set order_id = ?,order_status = ?,created_at = NOW(),updated_at = NOW()`;
                      connection.query(
                        insertccOrderLog,
                        [user.orderId, "Food is Ready"],
                        function (err, result) { }
                      );
                    }
                  }
                });
              }
              updateOrderStatus =
                "update orders set status=?,food_picked_at=now() where driver_id=? and order_id=? ";
            } else {
              updateOrderStatus =
                "update orders set status=? where driver_id=? and order_id=?";
            }
            connection.query(
              updateOrderStatus,
              [user.status, user.userId, user.orderId],
              function (err, result) {
                if (err) {
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  //CODE FOR PUSH NOTIFICATION FOR USER AND DRIVER
                  //code for user push notification
                  //fetching order details
                  connection.query(
                    "select order_id,device_id,user_id,is_guest_user,pickup_type from orders where order_id =?",
                    [user.orderId],
                    function (orderErr, orderResult) {
                      if (err) {
                        console.log("order" + orderErr);
                      } else {
                        //                            console.log("order details ..." + orderResult)
                        //user is registered user
                        if (orderResult[0].is_guest_user == "0") {
                          var order_status = "";
                          if (user.status == 3) {
                            order_status = "Order Picked";
                          } else if (user.status == 4) {
                            order_status = "Delivered";
                          }

                          var query1 =
                            "INSERT INTO customers_order_status_logs SET order_id = ?,customer_id = ?,is_guest = ?, order_status = ?, created_at = now(), updated_at = now()";
                          connection.query(
                            query1,
                            [
                              user.orderId,
                              orderResult[0].user_id,
                              0,
                              order_status,
                            ],
                            function (err1, rows1, fields1) {
                              if (err1) {
                                console.log(err1);
                              } else {
                                console.log("insert log");
                              }
                            }
                          );
                          updateRewardcount(
                            user.orderId,
                            orderResult[0].user_id,
                            user.status
                          )
                            .then(function (rewardcheck) {
                              if (rewardcheck) {
                                connection.query(
                                  "select device_token,device_id,device_type from users where user_id =?",
                                  [orderResult[0].user_id],
                                  function (userErr, userResult) {
                                    if (userErr) {
                                      console.log("user" + userErr);
                                    } else {
                                      //                                        console.log("user id :" + user.userId);
                                      //                                        console.log('user in else' + JSON.stringify(userResult));
                                      var device_token =
                                        userResult[0].device_token;
                                      var title = "CafeJavas";
                                      if (user.status == "3") {
                                        var message =
                                          "Your order is on the way, driver will dispatch your order";
                                        var notificationType = "4"; //Order Dispatched
                                        var customData = {
                                          notification_type: notificationType,
                                          order_id: user.orderId,
                                          user_id: orderResult[0].user_id, //user id
                                        };
                                      } else if (user.status == "4") {
                                        var message =
                                          "Your order is successfully delivered,share your experience with us";
                                        var notificationType = "3"; //Order Delivered
                                        var customData = {
                                          notification_type: notificationType,
                                          order_id: user.orderId,
                                          user_id: orderResult[0].user_id, //user id
                                          pickup_type:
                                            orderResult[0].pickup_type, //pickup_type
                                        };
                                      }

                                      var notificationParams = {
                                        notification_type: notificationType,
                                        message: message,
                                        order_id: user.orderId,
                                        user_id: orderResult[0].user_id, //registered user id
                                        send_to: "1", //registered user
                                      };
                                      //                                        console.log('############' + device_token);

                                      if (userResult[0].device_type == "1") {
                                        //CODE FOR IOS PUSH NOTIFICATION

                                        Utils.sendiOSPush(
                                          connection,
                                          notificationParams,
                                          device_token,
                                          config.CONSTANTS.BUNDLE_ID,
                                          title,
                                          message,
                                          customData
                                        ).then(function (
                                          pushResult,
                                          pushError
                                        ) {
                                          if (pushError) {
                                            console.log("iOS errrorr");
                                          } else {
                                            console.log(
                                              "herer++++++++++********************"
                                            );
                                          }
                                        });
                                      } else {
                                        //CODE FOR ANDROID PUSH NOTIFICATION
                                        Utils.sendAndroidPush(
                                          connection,
                                          notificationParams,
                                          device_token,
                                          title,
                                          message,
                                          customData
                                        ).then(function (error, response) {
                                          if (error) {
                                            console.log(
                                              "Android errrorr" + error
                                            );
                                          } else {
                                            //do nothing
                                            console.log(
                                              "else true customer" +
                                              JSON.stringify(response)
                                            );
                                          }
                                        });
                                      }
                                    }
                                  }
                                );
                              } else {
                                console.log("ffHIIIIIIIIII");

                                var message =
                                  languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            })
                            .catch(function (err) {
                              console.log("errorrrr1122" + err);
                              poolConnection.rollback(function () {
                                var message =
                                  languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                                if (
                                  connection._freeConnections.indexOf(
                                    poolConnection
                                  ) == "-1"
                                ) {
                                  poolConnection.release();
                                }
                              });
                            });
                        } else {
                          // user is guest user
                          connection.query(
                            "select id,device_type,device_token from tbl_guest_user where device_id =? order by id desc limit 1",
                            [orderResult[0].device_id],
                            function (guestUserErr, guestUserResult) {
                              if (guestUserErr) {
                                console.log("guest user error" + guestUserErr);
                              } else {
                                //                                        console.log('guest_user' + JSON.stringify(guestUserResult));
                                var device_token =
                                  guestUserResult[0].device_token;
                                var title = "CafeJavas";
                                if (user.status == "3") {
                                  var message =
                                    "Your order is on the way, driver will dispatch your order";
                                  var notificationType = "4"; //Order Dispatched
                                  var customData = {
                                    notification_type: notificationType,
                                    order_id: user.orderId,
                                    user_id: guestUserResult[0].id, //user id
                                  };
                                } else if (user.status == "4") {
                                  var message =
                                    "Your order is successfully delivered,share your experience with us";
                                  var notificationType = "3"; //Order Delivered
                                  var customData = {
                                    notification_type: notificationType,
                                    order_id: user.orderId,
                                    user_id: orderResult[0].user_id, //guest user id
                                    pickup_type: orderResult[0].pickup_type, //pickup_type
                                  };
                                }

                                var notificationParams = {
                                  notification_type: notificationType,
                                  message: message,
                                  order_id: user.orderId,
                                  user_id: guestUserResult[0].id, //guest user id
                                  send_to: "2", //guest user
                                };

                                if (guestUserResult[0].device_type == "1") {
                                  //CODE FOR IOS PUSH NOTIFICATION

                                  Utils.sendiOSPush(
                                    connection,
                                    notificationParams,
                                    device_token,
                                    config.CONSTANTS.BUNDLE_ID,
                                    title,
                                    message,
                                    customData
                                  ).then(function (pushResult, pushError) {
                                    if (pushError) {
                                      console.log("iOS errrorr");
                                    } else {
                                      console.log(
                                        "herer++++++++++********************"
                                      );
                                    }
                                  });
                                } else {
                                  //CODE FOR ANDROID PUSH NOTIFICATION

                                  Utils.sendAndroidPush(
                                    connection,
                                    notificationParams,
                                    device_token,
                                    title,
                                    message,
                                    customData
                                  ).then(function (error, response) {
                                    if (error) {
                                      console.log("Android errrorr");
                                    } else {
                                      //do nothing
                                      console.log(
                                        "else true customer" +
                                        JSON.stringify(response)
                                      );
                                    }
                                  });
                                }
                              }
                            }
                          );
                        }
                      }
                    }
                  );

                  //send push to Driver on order completion
                  if (user.status == "4") {
                    // Push Notification to driver on order delivered.
                    connection.query(
                      "select id,device_type,device_token from tbl_driver where id =?",
                      [user.userId],
                      function (driverErr, driverResult) {
                        if (driverErr) {
                          console.log("driver error" + driverErr);
                        } else {
                          //                                        console.log('guest_user' + JSON.stringify(guestUserResult));
                          var device_token = driverResult[0].device_token;
                          var title = "CafeJavas";
                          var message =
                            "Congratulation you have successfully delivered your order " +
                            user.orderId;
                          var notificationType = "3"; //Order Delivered

                          var customData = {
                            notification_type: notificationType,
                            order_id: user.orderId,
                            user_id: driverResult[0].id, //driver id
                          };
                          var notificationParams = {
                            notification_type: notificationType,
                            message: message,
                            order_id: user.orderId,
                            user_id: driverResult[0].id, //driver id
                            send_to: "3", //driver
                          };
                          console.log("device token :" + device_token);
                          console.log("tt :" + title);
                          console.log("msg :" + message);
                          console.log("notif type token :" + notificationType);
                          if (driverResult[0].device_type == "1") {
                            //CODE FOR IOS PUSH NOTIFICATION

                            Utils.sendiOSPush(
                              connection,
                              notificationParams,
                              device_token,
                              config.CONSTANTS.DRIVER_BUNDLE_ID,
                              title,
                              message,
                              customData
                            ).then(function (pushResult, pushError) {
                              if (pushError) {
                                console.log("iOS errrorr");
                              } else {
                                console.log(
                                  "herer++++++++++********************"
                                );
                              }
                            });
                          } else {
                            //CODE FOR ANDROID PUSH NOTIFICATION

                            Utils.sendAndroidPush(
                              connection,
                              notificationParams,
                              device_token,
                              title,
                              message,
                              customData
                            ).then(function (error, response) {
                              if (error) {
                                console.log(
                                  "Android driver errrorr" +
                                  JSON.stringify(error)
                                );
                              } else {
                                //do nothing
                                console.log(
                                  "else true customer" +
                                  JSON.stringify(response)
                                );
                              }
                            });
                          }
                        }
                      }
                    );
                  }
                  if (user.status == "3") {
                    updateEstimatedSpeed(user.orderId, user.orderKey).then(
                      function (result) {
                        if (result != 0) {
                          var updateEstSpeed =
                            "update orders set estimated_speed=? where driver_id=? and order_id=?";
                          connection.query(
                            updateEstSpeed,
                            [result, user.userId, user.orderId],
                            function (err, result1) {
                              if (err) {
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        } else {
                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  } else if (user.status == "4") {
                    updateActualSpeed(user.orderId, user.orderKey).then(
                      function (result) {
                        if (result != 0) {
                          var updateEstSpeed =
                            "update orders set actual_speed=? where driver_id=? and order_id=?";
                          connection.query(
                            updateEstSpeed,
                            [result, user.userId, user.orderId],
                            function (err, result1) {
                              if (err) {
                                message = languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                message = languages.success[lang];
                                Utils.makeResponse(
                                  res,
                                  true,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              }
                            }
                          );
                        } else {
                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        }
                      }
                    );
                  } else {
                    message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              }
            );
          }
        });
      }
    }
  });

  /**
     * @api {put} /orderStatusChangescanner/ store change order status by scanner
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName orderStatusChangescanner
     * @apiGroup Orders
     * @apiParam {String} orderId order id
     * @apiParam {String} paymentMode (0 => Payment Not Done,1 => online, 2 => Cash)
     * @apiParam {String} status (4 => food delivered)
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Success",
     *       "AppVersion": "1.0.0",
     *       "Result": 
     *       {
     
     }
     *     }
     *
     */

  api.put("/orderStatusChangescanner", function (req, res) {
    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        orderId: { type: "string" },
        paymentMode: { type: "string" },
        status: { type: "string" },
      },
    };
    var data = {};
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var updateOrderStatus =
        "update orders set status=?, payment_mode=? where order_id=?";

      connection.query(
        updateOrderStatus,
        [user.status, user.paymentMode, user.orderId],
        function (err, result) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            //CODE FOR PUSH NOTIFICATION FOR USER
            //CASE TYPE - Pickup
            //code for user push notification
            //fetching order details
            connection.query(
              "select order_id,device_id,user_id,status,is_guest_user,pickup_type from orders where order_id =?",
              [user.orderId],
              function (orderErr, orderResult) {
                if (err) {
                  console.log("order" + orderErr);
                } else {
                  //                            console.log("order details ..." + orderResult)
                  //user is registered user
                  if (orderResult[0].is_guest_user == "0") {
                    updateRewardcount(
                      user.orderId,
                      orderResult[0].user_id,
                      user.status
                    )
                      .then(function (rewardcheck) {
                        if (rewardcheck) {
                          connection.query(
                            "select device_token,device_id,device_type from users where user_id =?",
                            [orderResult[0].user_id],
                            function (userErr, userResult) {
                              if (userErr) {
                                console.log("user" + userErr);
                              } else {
                                var device_token = userResult[0].device_token;
                                var title = "CafeJavas";

                                var message =
                                  "Your order is successfully picked up,share your experience with us";
                                var notificationType = "3"; //Order Delivered

                                var customData = {
                                  notification_type: notificationType,
                                  order_id: user.orderId,
                                  user_id: orderResult[0].user_id, //user id
                                  pickup_type: orderResult[0].pickup_type,
                                };
                                var notificationParams = {
                                  notification_type: notificationType,
                                  message: message,
                                  order_id: user.orderId,
                                  user_id: orderResult[0].user_id, //user id
                                  send_to: "1", //registered user
                                };
                                //                                        console.log('############' + device_token);

                                if (userResult[0].device_type == "1") {
                                  //CODE FOR IOS PUSH NOTIFICATION

                                  Utils.sendiOSPush(
                                    connection,
                                    notificationParams,
                                    device_token,
                                    config.CONSTANTS.BUNDLE_ID,
                                    title,
                                    message,
                                    customData
                                  ).then(function (pushResult, pushError) {
                                    if (pushError) {
                                      console.log("iOS errrorr");
                                    } else {
                                      console.log(
                                        "herer++++++++++********************"
                                      );
                                    }
                                  });
                                } else {
                                  //CODE FOR ANDROID PUSH NOTIFICATION
                                  Utils.sendAndroidPush(
                                    connection,
                                    notificationParams,
                                    device_token,
                                    title,
                                    message,
                                    customData
                                  ).then(function (error, response) {
                                    if (error) {
                                      console.log("Android errrorr" + error);
                                    } else {
                                      //do nothing
                                      console.log(
                                        "else true customer" +
                                        JSON.stringify(response)
                                      );
                                    }
                                  });
                                }
                              }
                            }
                          );
                        } else {
                          console.log("ffHIIIIIIIIII");

                          var message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        }
                      })
                      .catch(function (err) {
                        console.log("errorrrr1122" + err);
                        var message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      });
                  } else {
                    // user is guest user
                    connection.query(
                      "select id,device_id,device_token from tbl_guest_user where device_id =? order by id desc limit 1",
                      [orderResult[0].device_id],
                      function (guestUserErr, guestUserResult) {
                        if (guestUserErr) {
                          console.log("guest user error" + guestUserErr);
                        } else {
                          var device_token = guestUserResult[0].device_token;
                          var title = "CafeJavas";

                          var message =
                            "Your order is successfully picked up,share your experience with us";
                          var notificationType = "3"; //Order Delivered

                          var customData = {
                            notification_type: notificationType,
                            order_id: user.orderId,
                            user_id: guestUserResult[0].id, //user id
                            pickup_type: orderResult[0].pickup_type,
                          };
                          var notificationParams = {
                            notification_type: notificationType,
                            message: message,
                            order_id: user.orderId,
                            user_id: guestUserResult[0].id, //user id
                            send_to: "2", //guest user
                          };

                          if (guestUserResult[0].device_type == "1") {
                            //CODE FOR IOS PUSH NOTIFICATION

                            Utils.sendiOSPush(
                              connection,
                              notificationParams,
                              device_token,
                              config.CONSTANTS.BUNDLE_ID,
                              title,
                              message,
                              customData
                            ).then(function (pushResult, pushError) {
                              if (pushError) {
                                console.log("iOS errrorr");
                              } else {
                                console.log(
                                  "herer++++++++++********************"
                                );
                              }
                            });
                          } else {
                            //CODE FOR ANDROID PUSH NOTIFICATION

                            Utils.sendAndroidPush(
                              connection,
                              notificationParams,
                              device_token,
                              title,
                              message,
                              customData
                            ).then(function (error, response) {
                              if (error) {
                                console.log("Android errrorr");
                              } else {
                                //do nothing
                                console.log(
                                  "else true customer" +
                                  JSON.stringify(response)
                                );
                              }
                            });
                          }
                        }
                      }
                    );
                  }
                }
              }
            );

            message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  //notifications
  api.get("/abc", function (req, res) {
    var customData = { 1: "abc", 2: "def" };
    var success = true;
    var status = 200;
    var message = "testing api abc";
    var title = "Cafejavas";
    var device_token =
      "6ec0746844c7c5981f1a11bd592b6f853a15e29097ad2c75badc63cc8e0cdb7c";
    var device_token_android =
      "dJBYewLgjDo:APA91bEV1LB9AlHQocvV3avXWoMLn8AC2QdFBWgA2Z5SbPd-WEbVjkZkVa_30heTc_R8M6XNURbzUz8perBJUwr1phpbG_Juh0SlH_o5oc1olzCwPv-xKbWCtkR7cWuhxywdZmFIsqBr3KCu58acUJsGz5-Io8bTeQ";
    //        Utils.makeResponse(res, success, status, message, appVersion, data);
    var notificationParams = {
      notification_type: "1",
      message: message,
      order_id: "160",
      user_id: "20",
      created_at: moment().unix(),
      send_to: "1",
    };
    Utils.sendiOSPush(
      connection,
      notificationParams,
      device_token,
      config.CONSTANTS.BUNDLE_ID,
      title,
      message,
      customData
    ).then(function (pushResult, pushError) {
      if (pushError) {
        console.log("iOS errrorr");
      } else {
        console.log("herer++++++++++********************");
      }
    });
    var nnotificationParams = {
      notification_type: "2",
      message: message,
      order_id: "100",
      user_id: "200",
      created_at: moment().unix(),
      send_to: "2",
    };
    Utils.sendAndroidPush(
      connection,
      nnotificationParams,
      device_token_android,
      title,
      message,
      customData
    ).then(function (error, response) {
      if (error) {
        console.log("Android errrorr");
      } else {
        //do nothing
        console.log("else true customer");
        var data = {},
          success = true,
          status = 200,
          message = custom_message;
        Util.makeResponse(res, success, status, message, appVersion, data);
      }
    });
  });

  /**
     * @api {post} /userRating User Rating
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag 
     * @apiVersion 1.0.0
     * @apiName userRating
     * @apiGroup Users
     * @apiParam {String} foodRate food rate. 
     * @apiParam {String} driverRate driver rate (if not applicable send 0).
     * @apiParam {String} userId (user id if it is not guest user else send 0).
     * @apiParam {String} orderId order ID.
     * @apiParam {String} isGuestuser (0=NO, 1=Yes). 
     * @apiParam {String} review user review.
     * @apiParam {String} deviceId user deviceId            
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Review Saved Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     
     ]
     *     }
     *
     */

  api.post("/userRating", function (req, res) {
    logger.info('EXPRESS: post("/userRating") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        foodRate: { type: "string" },
        driverRate: { type: "string" },
        review: { type: "string" },
        orderId: { type: "string" },
        userId: { type: "string" },
        isGuestuser: { type: "string" },
        deviceId: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      // update profile query
      var feedback =
        "INSERT INTO `reviews`(`food_rate`, `driver_rate`, `review`, `order_id`,`user_id`, `is_guest_user`,`device_id`) VALUES (?,?,?,?,?,?,?)";
      connection.query(
        feedback,
        [
          user.foodRate,
          user.driverRate,
          user.review,
          user.orderId,
          user.userId,
          user.isGuestuser,
          user.deviceId,
        ],
        function (errd, successdata) {
          if (errd) {
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            message = languages.sent_review[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  // gift_card_purchase api creation start here

  /**
   * @api {post} /giftcardPurchase save user giftcard purchase transaction
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName giftcardPurchase
   * @apiGroup Orders
   * @apiParam {String} userId user id if it is guest user send 0.
   * @apiParam {String} giftcardId giftcard ID.
   * @apiParam {String} isGuestuser (0=NO, 1=Yes).
   * @apiParam {String} userMail Sender mail id.
   * @apiParam {String} receiverMail Receiver mail id.
   * @apiParam {String} price gift card amount.
   * @apiParam {String} message message by sender.
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           "transactionId" : 1
   *           }
   *      }
   *
   */

  api.post("/giftcardPurchase", function (req, res) {
    var requestParams = req.body;
    console.log("save gift card data=" + JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        giftcardId: { type: "string" },
        isGuestuser: { type: "string" },
        userMail: { type: "string" },
        receiverMail: { type: "string" },
        price: { type: "string" },
        message: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkduplicate =
        'SELECT * FROM gift_card_purchase where gift_card_id= ? and receiver_mail= ? and amount_remaining >0 and status != "1" ';

      connection.query(
        checkduplicate,
        [requestParams.giftcardId, requestParams.receiverMail],
        function (errd, checkdata) {
          if (errd) {
            //                     logger.log(errd);
            console.log("save gift card data error", errd);
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            if (checkdata.length <= 0) {
              //var query="call saveUserAddress(?,?,?,?,?,?,?,?,?)";
              var query =
                "insert into gift_card_purchase(gift_card_id,user_id,is_guest_user,user_mail,receiver_mail,price,amount_remaining,created_at,status,message)values(?,?,?,?,?,?,?,now(),?,?)";
              connection.query(
                query,
                [
                  requestParams.giftcardId,
                  requestParams.userId,
                  requestParams.isGuestuser,
                  requestParams.userMail,
                  requestParams.receiverMail,
                  requestParams.price,
                  requestParams.price,
                  "1",
                  requestParams.message,
                ],
                function (err, rows, fields) {
                  if (err) {
                    console.log("error save query  gift card: " + err);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    console.log("save gift card working fine: ");
                    data.transactionId = rows.insertId;
                    var message = languages.success[lang];

                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              );
            } else {
              message = languages.giftcard_alreay_sent[lang];
              Utils.makeResponse(res, false, 409, message, appVersion, data);
            }
          }
        }
      );
    }
  });

  // gift_card_update api creation start here

  /**
   * @api {post} /giftcardUpdate update user giftcard purchase transaction
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName giftcardUpdate
   * @apiGroup Orders
   * @apiParam {String} transactionId gift card transaction Id.
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           }
   *      }
   *
   */

  api.post("/giftcardUpdate", function (req, res) {
    var requestParams = req.body;
    console.log("update gift card data=" + JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        transactionId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());
      console.log("update gift card data= invalid");

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var updateUser1 =
        "update gift_card_purchase set status= 2,updated_at=now() where ID =?";

      connection.query(
        updateUser1,
        [requestParams.transactionId],
        function (err, rows1, fields) {
          if (err) {
            console.log("error update GF: " + err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            //next(null, item);

            var checkvalid =
              "SELECT gc.gift_card_code,gci.card_image,gc.expiry_date,gcp.price,gcp.receiver_mail FROM `gift_card_purchase` gcp join gift_card gc on gc.gift_card_id=gcp.gift_card_id join gift_card_image gci.gift_card_id=gc.gift_card_id where gcp.ID=? group by gc.gift_card_id";

            connection.query(
              checkvalid,
              [requestParams.transactionId],
              function (errd, checkdata) {
                if (errd) {
                  //                     logger.log(errd);
                  console.log("update GF card query", errd);
                  message = languages.something_went_wrong[lang];

                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  if (checkdata.length <= 0) {
                    console.log(
                      "update gift card data= invalid",
                      checkdata.length
                    );

                    message = languages.giftcard_invalid[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      409,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    var message = languages.success[lang];
                    console.log("update gift card data in else", data);
                    var mailHtml =
                      "H Hello you have received the gift card of UGX :" +
                      checkdata[0].price +
                      "you can redeem it through code :" +
                      checkdata[0].gift_card_code +
                      " before " +
                      checkdata[0].expiry_date +
                      " <img src=" +
                      checkdata[0].card_image +
                      " >";
                    Utils.sendMail(
                      checkdata[0].receiver_mail,
                      "Gift Card from CafeJavas!",
                      mailHtml
                    );
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              }
            );
          }
        }
      );
    }
  });

  // gift_card_or_promo_check api creation start here

  /**
   * @api {post} /giftCardpromoCheck check user giftcard or promocod
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName giftCardpromoCheck
   * @apiGroup Orders
   * @apiParam {String} userMail user Mail who is logged in .
   * @apiParam {String} code giftcard or promo code.
   * @apiParam {String} type (1=giftcard, 2=promo).
   * @apiParam {String} userId logged in user id.
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           "amountRemaining" : 100,
   *           "couponId": "1"
   *           }
   *      }
   *
   */

  api.post("/giftCardpromoCheck", function (req, res) {
    var requestParams = req.body;
    //console.log("data="+JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userMail: { type: "string" },
        code: { type: "string" },
        type: { type: "string" },
        userId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      if (requestParams.type == "1") {
        //if it is a gift card

        // gift card check starts here

        var checkcard =
          'SELECT *  FROM gift_card where gift_card_code=? and expiry_date>= CURDATE() and is_deleted = "0"';
        console.log(checkcard);
        connection.query(
          checkcard,
          [requestParams.code],
          function (errd, checkuserdata) {
            if (errd) {
              //                     logger.log(errd);
              message = languages.something_went_wrong[lang];
              console.log(errd);
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else {
              if (checkuserdata.length <= 0) {
                message = languages.giftcard_invalid[lang];
                Utils.makeResponse(res, false, 409, message, appVersion, data);
              } else {
                var giftId = checkuserdata[0].gift_card_id;

                var checkvalid =
                  'SELECT * FROM gift_card_purchase where gift_card_id= ? and receiver_mail= ? and amount_remaining >0 and status != "1"';

                connection.query(
                  checkvalid,
                  [giftId, requestParams.userMail],
                  function (errd, checkdata) {
                    if (errd) {
                      //                     logger.log(errd);
                      console.log(errd);
                      message = languages.something_went_wrong[lang];

                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    } else {
                      if (checkdata.length <= 0) {
                        message = languages.giftcard_invalid[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          409,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        data.amountRemaining = checkdata[0].amount_remaining;
                        data.couponId = checkdata[0].ID;
                        var message = languages.success[lang];
                        console.log(data);
                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    }
                  }
                );
              }
            }
          }
        );
        // gift card check ends here
      } else {
        // promo code check starts here

        var checkpromo =
          'SELECT *  FROM promocode where promocode_code=? and expiry_date>= CURDATE() and is_deleted = "0"';

        connection.query(
          checkpromo,
          [requestParams.code],
          function (errd, checkuserdata) {
            if (errd) {
              //                     logger.log(errd);
              message = languages.something_went_wrong[lang];
              console.log(errd);
              Utils.makeResponse(res, false, 400, message, appVersion, data);
            } else {
              if (checkuserdata.length <= 0) {
                message = languages.promocode_invalid[lang];
                Utils.makeResponse(res, false, 409, message, appVersion, data);
              } else {
                var promoId = checkuserdata[0].id;
                var amount = checkuserdata[0].amount;

                var checkvalid =
                  'SELECT * FROM promocode_users where promocode_id= ? and user_id= ? and is_claimed ="0"';

                connection.query(
                  checkvalid,
                  [promoId, requestParams.userId],
                  function (errd, checkdata) {
                    if (errd) {
                      //                     logger.log(errd);
                      console.log(errd);
                      message = languages.something_went_wrong[lang];

                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    } else {
                      if (checkdata.length <= 0) {
                        message = languages.promocode_invalid[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          409,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        data.amountRemaining = amount;
                        data.couponId = checkdata[0].id;
                        var message = languages.success[lang];
                        console.log(data);
                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    }
                  }
                );
              }
            }
          }
        );

        // promo code check ends here
      }
    }
  });

  /**
     * @api {get} /getOrderHistoryDetails Get order details
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getOrderHistoryDetails
     * @apiGroup Orders       
     * @apiParam {Number} orderId ID of order
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     {
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "data": [
     {
     "quantity": 1,
     "subtotal": 21000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "one",
     "labelOption": 1,
     "labelOptions": [
     {
     "labelId": 32,
     "labelOptionId": 49,
     "optionName": "dosa",
     "price": "1000"
     }
     ],
     "labelType": 1,
     "topLabelId": 32
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     },
     {
     "quantity": 6,
     "subtotal": 150000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "premium",
     "labelOption": 2,
     "labelOptions": [
     {
     "labelId": 33,
     "labelOptionId": 50,
     "optionName": "mix dosa",
     "price": "5000"
     }
     ],
     "labelType": 1,
     "topLabelId": 33
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     }
     ],
     "order_date": "2018-06-27 18:28:30",
     "order_num":"CAFEJAVAS_1",
     "payment_mode": "Payment Not Done",
     "deliveryFee": 0,
     "subtotal": 100000,
     "totalPrice": 171000,
     "gift_amount": 3300,
     "promo_amount": 33000,
     "vatAmount":2000,
     "loyaltyAmount":2000,
     }
     }
     *
     */
  api.get("/getOrderHistoryDetails", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        orderId: { type: "Number" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      //**** getting order details  ****//
      //var pageNo=requestData.pageNo || 1;
      //var offset=(pageNo-1) * pageLimit;
      if (requestData.orderKey == "callcenter_orders") {
        //Call Center Order Starts
        var orderQr =
          "select order_id,delivery_fee,service_fee,subtotal,gift_amount,promo_amount,loyalty_amount,order_num,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode from callcenter_orders where order_id=?";
        var paramArray = [requestData.orderId];

        connection.query(orderQr, paramArray, function (err, rows, fields) {
          if (err) {
            console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, finalData);
          } else {
            var totalPrice = 0;
            var serviceFee = 0;
            var deliveryFee = 0;
            var gift_amount = 0;
            var promo_amount = 0;
            var subtotal = 0;
            var vatAmount = 0;
            var loyaltyAmount = 0;
            if (rows.length > 0) {
              var paymentMode = rows[0].payment_mode;
              var allOrderItems = [];
              gift_amount = rows[0].gift_amount;
              promo_amount = rows[0].promo_amount;
              subtotal = rows[0].subtotal;
              vatAmount = rows[0].service_fee;
              loyaltyAmount = rows[0].loyalty_amount;
              deliveryFee = rows[0].delivery_fee;
              //****  getting total cost of order  ****//
              var orderItemQr =
                "select quantity,is_free_reward,basic_product_cost,subtotal,json from callcenter_order_items where order_id=?";
              connection.query(
                orderItemQr,
                [requestData.orderId],
                function (err1, rows1, fields) {
                  if (err1) {
                    console.log(err1);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      finalData
                    );
                  } else {
                    var totalPrice = 0;
                    var serviceFee = 0;

                    if (rows1.length > 0) {
                      //****  order items found  ****//
                      synceach(
                        rows1,
                        function (item, next) {
                          if (item.is_free_reward == "1") {
                            var quantityCount = item.quantity - 1;
                          } else {
                            var quantityCount = item.quantity;
                          }
                          var itemTotalCost = quantityCount * item.subtotal;
                          totalPrice = totalPrice + itemTotalCost;
                          item.subtotal = itemTotalCost;
                          item.json = JSON.parse(item.json);
                          next(null, item);
                        },
                        function (err, transformedItems) {
                          finalData.data = rows1;
                          //finalData.totalItems=rows0[0].total;
                          finalData.order_date = rows[0].created_at;
                          finalData.order_num = rows[0].order_num;
                          finalData.payment_mode = rows[0].payment_mode;
                          finalData.deliveryFee = deliveryFee;
                          finalData.subtotal = subtotal;
                          finalData.totalPrice =
                            totalPrice +
                            deliveryFee -
                            (gift_amount + promo_amount + loyaltyAmount);
                          finalData.gift_amount = gift_amount;
                          finalData.promo_amount = promo_amount;
                          finalData.vatAmount = vatAmount;
                          finalData.loyaltyAmount = loyaltyAmount;
                          var message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      );
                    } else {
                      //****  order items not found  ****//
                      finalData.data = rows1;
                      // finalData.totalItems=0;
                      finalData.order_date = rows[0].created_at;
                      finalData.order_num = rows[0].order_num;
                      finalData.payment_mode = rows[0].payment_mode;
                      finalData.deliveryFee = deliveryFee;
                      finalData.subtotal = subtotal;
                      finalData.totalPrice =
                        totalPrice +
                        deliveryFee -
                        (gift_amount + promo_amount + loyaltyAmount);
                      finalData.gift_amount = gift_amount;
                      finalData.promo_amount = promo_amount;
                      finalData.vatAmount = vatAmount;
                      finalData.loyaltyAmount = loyaltyAmount;
                      var message = languages.success[lang];
                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  }
                }
              );
            } else {
              //****  Order not found  ****//
              finalData.data = rows;
              //   finalData.totalItems=0;
              finalData.order_date = "";
              finalData.order_num = "";
              finalData.payment_mode = "";
              finalData.deliveryFee = deliveryFee;
              finalData.subtotal = subtotal;
              finalData.totalPrice = totalPrice;
              finalData.gift_amount = gift_amount;
              finalData.promo_amount = promo_amount;
              finalData.vatAmount = vatAmount;
              finalData.loyaltyAmount = loyaltyAmount;
              var message = languages.success[lang];
              Utils.makeResponse(
                res,
                true,
                200,
                message,
                appVersion,
                finalData
              );
            }
          }
        });
        //Call Center Order Ends
      } else {
        var orderQr =
          "select order_id,delivery_fee,service_fee,subtotal,gift_amount,promo_amount,loyalty_amount,order_num,created_at,(CASE WHEN payment_mode = '0' THEN 'Payment Not Done' WHEN payment_mode = '1' THEN 'Online' WHEN payment_mode = '2' THEN 'Cash' END) as payment_mode, order_notes as orderNotes from orders where order_id=?";
        var paramArray = [requestData.orderId];
        console.log("Order History--->", paramArray);

        //            var orderItemCountQr = "select count(ID) as total from order_items where order_id=?";
        //            connection.query(orderItemCountQr,[requestData.orderId], function (err0, rows0, fields) {
        //            if (err0) {
        //                console.log(err0);
        //                message = languages.something_went_wrong[lang];
        //                Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        //            }
        //            else
        //            {
        console.log("WWWWWWWWWWWWWWWW");
        connection.query(orderQr, paramArray, function (err, rows, fields) {
          if (err) {
            console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, finalData);
          } else {
            console.log("GGGGGGGGGGGGGG");
            var totalPrice = 0;
            var serviceFee = 0;
            var deliveryFee = 0;
            var gift_amount = 0;
            var promo_amount = 0;
            var subtotal = 0;
            var vatAmount = 0;
            var loyaltyAmount = 0;
            if (rows.length > 0) {
              console.log("$$$$$$$$$$$$$$$$4");
              var paymentMode = rows[0].payment_mode;
              var allOrderItems = [];
              gift_amount = rows[0].gift_amount;
              promo_amount = rows[0].promo_amount;
              subtotal = rows[0].subtotal;
              vatAmount = rows[0].service_fee;
              loyaltyAmount = rows[0].loyalty_amount;
              deliveryFee = rows[0].delivery_fee;
              //****  getting total cost of order  ****//
              var orderItemQr =
                "select quantity,is_free_reward,basic_product_cost,subtotal,json from order_items where order_id=?";
              connection.query(
                orderItemQr,
                [requestData.orderId],
                function (err1, rows1, fields) {
                  if (err1) {
                    console.log(err1);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      finalData
                    );
                  } else {
                    console.log("**************88");
                    var totalPrice = 0;
                    var serviceFee = 0;

                    if (rows1.length > 0) {
                      console.log("OOOOOOOOOOOOOOOOOO");
                      //****  order items found  ****//
                      synceach(
                        rows1,
                        function (item, next) {
                          if (item.is_free_reward == "1") {
                            var quantityCount = item.quantity - 1;
                          } else {
                            var quantityCount = item.quantity;
                          }
                          var itemTotalCost = quantityCount * item.subtotal;
                          totalPrice = totalPrice + itemTotalCost;
                          item.subtotal = itemTotalCost;
                          item.json = JSON.parse(item.json);
                          next(null, item);
                        },
                        function (err, transformedItems) {
                          finalData.data = rows1;
                          //finalData.totalItems=rows0[0].total;
                          finalData.order_date = rows[0].created_at;
                          finalData.order_num = rows[0].order_num;
                          finalData.payment_mode = rows[0].payment_mode;
                          finalData.order_notes = rows[0].orderNotes;
                          finalData.deliveryFee = deliveryFee;
                          finalData.subtotal = subtotal;
                          finalData.totalPrice =
                            totalPrice +
                            deliveryFee -
                            (gift_amount + promo_amount + loyaltyAmount);
                          finalData.gift_amount = gift_amount;
                          finalData.promo_amount = promo_amount;
                          finalData.vatAmount = vatAmount;
                          finalData.loyaltyAmount = loyaltyAmount;
                          var message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      );
                    } else {
                      //****  order items not found  ****//
                      finalData.data = rows1;
                      // finalData.totalItems=0;
                      finalData.order_date = rows[0].created_at;
                      finalData.order_num = rows[0].order_num;
                      finalData.payment_mode = rows[0].payment_mode;
                      finalData.order_notes = rows[0].orderNotes;
                      finalData.deliveryFee = deliveryFee;
                      finalData.subtotal = subtotal;
                      finalData.totalPrice =
                        totalPrice +
                        deliveryFee -
                        (gift_amount + promo_amount + loyaltyAmount);
                      finalData.gift_amount = gift_amount;
                      finalData.promo_amount = promo_amount;
                      finalData.vatAmount = vatAmount;
                      finalData.loyaltyAmount = loyaltyAmount;
                      var message = languages.success[lang];
                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  }
                }
              );
            } else {
              //****  Order not found  ****//
              finalData.data = rows;
              //   finalData.totalItems=0;
              finalData.order_date = "";
              finalData.order_num = "";
              finalData.payment_mode = "";
              finalData.deliveryFee = deliveryFee;
              finalData.subtotal = subtotal;
              finalData.totalPrice = totalPrice;
              finalData.gift_amount = gift_amount;
              finalData.promo_amount = promo_amount;
              finalData.vatAmount = vatAmount;
              finalData.loyaltyAmount = loyaltyAmount;
              var message = languages.success[lang];
              Utils.makeResponse(
                res,
                true,
                200,
                message,
                appVersion,
                finalData
              );
            }
          }
        });
        //            }
        //
        //            });
      }
    }
  });

  /**
   * @api {get} /checkClosingTime check Cafe Javas is closed or open.
   * @apiName checkClosingTime
   * @apiGroup Info Pages
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *   "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result": {
   *     "isOpen":"1"
   *
   *   }
   * }
   *
   */
  api.get("/checkClosingTime", function (req, res) {
    logger.info('EXPRESS: get("/checkClosingTime") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        // userId: {type: 'string'}
      },
    };

    //   var b = moment.tz("France, Europe/Paris");

    //moment.tz.setDefault("Africa/Kampala");

    //   console.log("$$$$$$$$$$$$$$");
    //   var d = new Date();
    //   var abc = moment(d).tz('Africa/Kampala').format('YYYY-MM-DD HH:mm ZZ')

    var d = new Date();
    var day = d.getDay();
    var hour = d.getHours();
    hour = hour + 3;
    var isOpen = 1;
    if (day == 1 || day == 2 || day == 3 || day == 4) {
      if (hour >= 6 && hour < 23) {
        isOpen = 1;
      } else {
        isOpen = 0;
      }
    } else if (day == 5 || day == 6) {
      if (hour >= 6 && hour < 24) {
        isOpen = 1;
      } else {
        isOpen = 0;
      }
    } else {
      if (hour >= 6 && hour < 22) {
        isOpen = 1;
      } else {
        isOpen = 0;
      }
    }
    Utils.makeResponse(res, true, 200, message, appVersion, {
      isOpen: isOpen,
      hour: hour,
    });
  });

  // ---------------------------------------------------------
  // route middleware to authenticate and check token
  // ---------------------------------------------------------

  /*
   * Middleware to authenticate or verify token
   */
  api.use(function (req, res, next) {
    var token = req.headers["x-cafejavas-token"]; // set jwt token
    lang = req.headers["language"];
    var getuserid = req.headers["x-cafejavas-userid"]; // set userid
    var isguestuser = req.headers["x-cafejavas-isguestuser"]; // set userid
    var data = [];
    // check language key getting in header or not and assign language
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }

    if (token) {
      // verify jwt token
      Auth.verifyJWTToken(token).then(function (tokenresp) {
        if (tokenresp || token == "nitin_token") {
          if (getuserid && isguestuser == "0") {
            // check user is registered in app  before sending request to api
            Utils.checkValidUser(connection, getuserid).then(function (d) {
              if (d) {
                if (d[0].status == "1") {
                  console.log("bb");
                  req.decoded = tokenresp;
                  next();
                } else {
                  console.log("ssss");
                  Utils.makeResponse(
                    res,
                    true,
                    401,
                    languages.user_deactivated[lang],
                    appVersion,
                    data
                  );
                }
              } else {
                console.log("ssss");
                Utils.makeResponse(
                  res,
                  true,
                  401,
                  languages.invalid_user[lang],
                  appVersion,
                  data
                );
              }
            });
          } else if (isguestuser == "1") {
            console.log("bb");
            req.decoded = tokenresp;
            next();
          } else {
            console.log("ssss");
            Utils.makeResponse(
              res,
              true,
              401,
              languages.invalid_user[lang],
              appVersion,
              data
            );
          }
        } else {
          //                    Auth.generateJWTToken('86','ss.sharma@gmail.com','86461634454').then(function (tokenresp) {
          //                                logger.log(tokenresp);
          //                            });
          console.log(token);
          console.log(tokenresp);
          Utils.makeResponse(
            res,
            false,
            401,
            languages.invalid_token[lang],
            appVersion,
            data
          );
        }
      });
    } else {
      Utils.makeResponse(
        res,
        true,
        403,
        languages.no_token[lang],
        appVersion,
        data
      );
    }
  });

  // ---------------------------------------------------------
  // authenticated routes
  // ---------------------------------------------------------

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {post} /createOrder createOrder
   * @apiDescription Insert order details
   * @apiGroup Orders
   * @apiName createOrder
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {String} userId  user id(0 in case of guest user)
   * @apiParam (Expected parameters) {String} deviceId  device id(unique device id of user)
   * @apiParam (Expected parameters) {String} pickUpType  order pick up type(0 in case of delivery, 1 in case of take away)
   * @apiParam (Expected parameters) {Number} addressId  address id
   * @apiParam (Expected parameters) {String} paymentMode  payment Mode (1 in case of online, 2 in case of cash)
   * @apiParam (Expected parameters) {String} giftcardId  gift card purchase id (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} promocodeId  promo code id (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} giftcardAmount  gift card Amount (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} promocodeAmount  promo code Amount (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} orderSubtotal  order Subtotal
   * @apiParam (Expected parameters) {String} vatAmount  order Service fee (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} loyaltyAmount  loyalty amount (0 in case it is not applicable)
   * @apiParam (Expected parameters) {String} loyaltyRefno  loyalty refference no (don't provide this parameter if not applicable)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *              "orderNumber": "CAFEJAVAS_20",
   *              "orderId" : 1,
   *              "pickUpType" : 1,
   *              "totalAmount" : 100
   *           }
   *      }
   * @apiVersion 0.0.1
   */
  //    order.post('/createOrder', function (req, res, next) {
  //        connection.beginTransaction(function(err) {
  //        if (err)
  //        {
  //            message = languages.something_went_wrong[lang];
  //            Utils.makeResponse(res, false, 400, message, appVersion, data);
  //        }
  //        else
  //        {
  //
  //            var query = 'insert into deals(category_id,deal_type,deal_price,title,created_at,updated_at) values(?,?,?,?,now(),now())';
  //            connection.query(query,[1,2,30,'30% off'], function(err, result) {
  //            if (err) {
  //              connection.rollback(function() {
  //                  message = languages.something_went_wrong[lang];
  //                  Utils.makeResponse(res, false, 400, message, appVersion, data);
  //
  //              });
  //            }
  //            else
  //            {
  //                var log = result.insertId;
  //                var query = 'insert into general_settings(min_order_price1,Address,phone) values(?,?,?)';
  //                connection.query(query, [2,'aas','956'], function(err, result) {
  //                  if (err) {
  //                    connection.rollback(function() {
  //                        message = languages.something_went_wrong[lang];
  //                        Utils.makeResponse(res, false, 400, message, appVersion, data);
  //
  //                    });
  //                  }
  //                  connection.commit(function(err) {
  //                    if (err) {
  //                      connection.rollback(function() {
  //                          message = languages.something_went_wrong[lang];
  //                          Utils.makeResponse(res, false, 400, message, appVersion, data);
  //
  //                      });
  //                    }
  //                    else
  //                    {
  //                    console.log('Transaction Complete.');
  //                    connection.end();
  //                    message = languages.success[lang];
  //                    Utils.makeResponse(res, true, 200, message, appVersion, data);
  //                    }
  //                  });
  //                });
  //            }
  //
  //
  //          });
  //        }
  //
  //      });
  //
  //
  //    });

  api.post("/createOrder", function (req, res, next) {
    var requestData = req.body;
    console.log("Request : ", requestData);
    var message = "";
    var data = {};
    var schema = {
      type: "object",
      properties: {
        userId: { type: "String" },
        deviceId: { type: "string" },
        pickUpType: { type: "string" },
        addressId: { type: "number" },
        paymentMode: { type: "string" },
        giftcardId: { type: "string" },
        promocodeId: { type: "string" },
        giftcardAmount: { type: "string" },
        promocodeAmount: { type: "string" },
        orderSubtotal: { type: "string" },
        vatAmount: { type: "string" },
        loyaltyAmount: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);
    if (!validationresult.valid) {
      message = languages.bad_request[lang];

      logger.log(validationresult.format());
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      console.log("RequestData : ", requestData);
      var currentHour = moment().add(3, "hours").format("HH"); // Current Hour (HRS) in Uganda
      console.log("Current Hour : ", currentHour);
      var currentMin = moment().add(3, "hours").format("mm"); // Current Min (mm) in Uganda
      console.log("Current Min : ", currentMin);
      var currentDay = moment().add(3, "hours").isoWeekday();
      console.log("Current Day : ", currentDay);

      if (requestData.pickUpType == 0) {
        if (currentHour >= 6 && currentHour < 23) {
          if (
            currentDay == 1 ||
            currentDay == 2 ||
            currentDay == 3 ||
            currentDay == 4 ||
            currentDay == 7
          ) {
            if (currentHour == 22) {
              if (currentMin < 30) {
                connection.getConnection(function (err, poolConnection) {
                  if (err) {
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    poolConnection.beginTransaction(function (err) {
                      if (err) {
                        console.log(err);
                        var message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        console.log(
                          "requestData===" + JSON.stringify(requestData)
                        );

                        var userId = requestData.userId;
                        var deviceId = requestData.deviceId;
                        var pickUpType = requestData.pickUpType;
                        var addressId = requestData.addressId;
                        var paymentMode = requestData.paymentMode;
                        var giftcardId = requestData.giftcardId;
                        var promocodeId = requestData.promocodeId;
                        var giftcardAmount = requestData.giftcardAmount;
                        var promocodeAmount = requestData.promocodeAmount;
                        var orderSubtotal = parseInt(requestData.orderSubtotal);
                        var vatAmount = requestData.vatAmount;
                        var loyaltyAmount = requestData.loyaltyAmount;
                        var loyaltyRefno = requestData.loyaltyRefno || "";
                        var branch_id = requestData.branch_id;
                        var orderNotes = requestData.order_notes;
                        var rewardDeductionAmount =
                          requestData.rewardDeductionAmount;

                        checkCartForBreakFastItems(userId).then(
                          (bitemCount) => {
                            console.log("bitemCount : ", bitemCount);
                            if (bitemCount > 0) {
                              var message =
                                "Breakfast products are available before 12PM only.";
                              Utils.makeResponse(
                                res,
                                false,
                                200,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              checkCartForGenerousBigMealsItems(userId).then(
                                (gitemCount) => {
                                  console.log("gitemCount : ", gitemCount);
                                  if (gitemCount > 0) {
                                    var message =
                                      "Generous Big Meal products are available after 11AM only.";
                                    Utils.makeResponse(
                                      res,
                                      false,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    if (userId == 0) {
                                      var isGuestUser = "1";
                                    } else {
                                      var isGuestUser = "0";
                                    }
                                    var deliveryAmount = 0;
                                    if (
                                      requestData.deliveryAmount != undefined ||
                                      requestData.deliveryAmount != ""
                                    ) {
                                      deliveryAmount =
                                        requestData.deliveryAmount;
                                    }
                                    if (pickUpType == 0) {
                                      //****  In case of dilevery, later admin will update from admin panel  ****//
                                      var branchId = branch_id;
                                    } else {
                                      //****  In case of take away  ****//
                                      var branchId = addressId;
                                    }
                                    console.log("pickUpType : ", pickUpType);
                                    console.log(
                                      "orderSubtotal : ",
                                      orderSubtotal
                                    );
                                    if (
                                      pickUpType == 0 &&
                                      orderSubtotal +
                                      rewardDeductionAmount +
                                      loyaltyAmount +
                                      promocodeAmount +
                                      giftcardAmount <
                                      10500
                                    ) {
                                      var message =
                                        "Minimum order value for delivery to be 10,500 UGX!";
                                      console.log(message);
                                      Utils.makeResponse(
                                        res,
                                        false,
                                        200,
                                        message,
                                        appVersion,
                                        data
                                      );
                                      return false;
                                    }

                                    getDriverIncentive().then(function (
                                      incentive
                                    ) {
                                      checkCartForBreakFastItems(
                                        userId,
                                        deviceId
                                      ).then((itemCount) => {
                                        // var status;
                                        console.log("Incentive : ", incentive);
                                        console.log("itemCount : ", itemCount);

                                        if (itemCount > 0) {
                                          var message =
                                            "Breakfast products are available before 12PM only.";
                                          Utils.makeResponse(
                                            res,
                                            false,
                                            200,
                                            message,
                                            appVersion,
                                            data
                                          );
                                        } else {
                                          if (paymentMode == 1) {
                                            var query =
                                              "insert into temp_orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                          } else {
                                            var query =
                                              "insert into orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                          }
                                          if (pickUpType == 1) {
                                            incentive = 0;
                                          }
                                          poolConnection.query(
                                            query,
                                            [
                                              userId,
                                              "0",
                                              "0",
                                              "0",
                                              addressId,
                                              branchId,
                                              isGuestUser,
                                              deviceId,
                                              "0",
                                              paymentMode,
                                              pickUpType,
                                              "0",
                                              "2",
                                              "0",
                                              "0",
                                              "0",
                                              "0",
                                              giftcardId,
                                              promocodeId,
                                              loyaltyRefno,
                                              giftcardAmount,
                                              promocodeAmount,
                                              loyaltyAmount,
                                              incentive,
                                              orderNotes,
                                              rewardDeductionAmount,
                                            ],
                                            function (err, result) {
                                              //poolConnection.query(query, [userId, driverId, '0', status, addressId, branchId, isGuestUser, deviceId, '0', paymentMode, pickUpType, '0', '2', '0', '0', '0', '0', giftcardId, promocodeId, loyaltyRefno, giftcardAmount, promocodeAmount, loyaltyAmount, incentive], function (err, result) {
                                              if (err) {
                                                console.log("err1=" + err);
                                                return false;
                                                poolConnection.rollback(
                                                  function () {
                                                    if (
                                                      connection._freeConnections.indexOf(
                                                        poolConnection
                                                      ) == "-1"
                                                    ) {
                                                      poolConnection.release();
                                                    }
                                                    var message =
                                                      languages
                                                        .something_went_wrong[
                                                      lang
                                                      ];
                                                    Utils.makeResponse(
                                                      res,
                                                      false,
                                                      400,
                                                      message,
                                                      appVersion,
                                                      data
                                                    );
                                                  }
                                                );
                                              } else {
                                                var orderId = result.insertId;
                                                console.log(
                                                  "orderId : ",
                                                  orderId
                                                );

                                                var guest;
                                                if (userId == 0) {
                                                  guest = 1;
                                                } else {
                                                  guest = 0;
                                                }
                                                // if(driverId != 0){
                                                //     var query = 'insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now()),(?,?,?,?,now(),now())';
                                                //     var params = [orderId, userId, guest, 'Placed', orderId, userId, guest, 'Assigned To Driver'];
                                                // }else{
                                                var query =
                                                  "insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now())";
                                                var params = [
                                                  orderId,
                                                  userId,
                                                  guest,
                                                  "Placed",
                                                ];
                                                // }

                                                poolConnection.query(
                                                  query,
                                                  params,
                                                  function (err, result) {
                                                    if (err) {
                                                      console.log(
                                                        "err1=" + err
                                                      );
                                                      poolConnection.rollback(
                                                        function () {
                                                          if (
                                                            connection._freeConnections.indexOf(
                                                              poolConnection
                                                            ) == "-1"
                                                          ) {
                                                            poolConnection.release();
                                                          }
                                                          var message =
                                                            languages
                                                              .something_went_wrong[
                                                            lang
                                                            ];
                                                          Utils.makeResponse(
                                                            res,
                                                            false,
                                                            400,
                                                            message,
                                                            appVersion,
                                                            data
                                                          );
                                                        }
                                                      );
                                                    } else {
                                                      // if(driverId > 0){

                                                      //     poolConnection.query("select id, user_type, device_type, device_token from tbl_driver where id =?", [driverId], function (err, result) {
                                                      //         if (err) {
                                                      //             console.log(err);
                                                      //         } else {
                                                      //             var device_token = result[0].device_token;
                                                      //             var title = "CafeJavas";
                                                      //             var message = " You have 1 new order to deliver.";
                                                      //             var customData = {
                                                      //                 "notification_type": '11', //Assigned to Driver
                                                      //                 "order_id": orderId,
                                                      //                 "user_id": result[0].id,
                                                      //             };
                                                      //             var notificationParams = {
                                                      //                 "notification_type": '11', //Assigned to Driver
                                                      //                 "message": message,
                                                      //                 "order_id": orderId,
                                                      //                 "user_id": result[0].id,
                                                      //                 "send_to": "3"
                                                      //             };

                                                      //             if (result[0].device_type == '1') {
                                                      //                 //CODE FOR IOS PUSH NOTIFICATION

                                                      //                 Utils.sendiOSPush(poolConnection, notificationParams, device_token, config.CONSTANTS.BUNDLE_ID, title, message, customData).then(function (pushResult, pushError) {
                                                      //                     if (pushError) {
                                                      //                         console.log("iOS errrorr");

                                                      //                     } else {
                                                      //                         console.log("herer++++++++++********************");
                                                      //                     }
                                                      //                 });

                                                      //             } else {
                                                      //                 //CODE FOR ANDROID PUSH NOTIFICATION

                                                      //                 Utils.sendAndroidPush(poolConnection, notificationParams, device_token, title, message, customData).then(function (error, response) {
                                                      //                     if (error) {
                                                      //                         console.log("Android errrorr");

                                                      //                     } else {
                                                      //                         //do nothing
                                                      //                         console.log("else true customer");
                                                      //                         var data = {},
                                                      //                                 success = true,
                                                      //                                 status = 200,
                                                      //                                 message = custom_message;
                                                      //                         Util.makeResponse(res, success, status, message, appVersion, data);
                                                      //                     }
                                                      //                 })

                                                      //             }

                                                      //         }
                                                      //     });

                                                      // }

                                                      if (
                                                        requestData.isCouponApplied ==
                                                        "1"
                                                      ) {
                                                      }
                                                      console.log(result);

                                                      console.log(
                                                        result.insertId
                                                      );

                                                      if (userId == 0) {
                                                        //****  In case of guest user  ****//
                                                        if (paymentMode == 1) {
                                                          var query =
                                                            "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.device_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                          var paramArray = [
                                                            orderId,
                                                            deviceId,
                                                          ];
                                                        } else {
                                                          var query =
                                                            "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.device_id=?  and oi.is_delete='0' and oi.order_id='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                          var paramArray = [
                                                            orderId,
                                                            deviceId,
                                                          ];
                                                        }
                                                      } else {
                                                        if (paymentMode == 1) {
                                                          var query =
                                                            "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.user_id=?  and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                          var paramArray = [
                                                            orderId,
                                                            userId,
                                                          ];
                                                        } else {
                                                          var query =
                                                            "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                          var paramArray = [
                                                            orderId,
                                                            userId,
                                                          ];
                                                        }
                                                      }

                                                      //  console.log(query+paramArray);
                                                      poolConnection.query(
                                                        query,
                                                        paramArray,
                                                        function (err, result) {
                                                          if (err) {
                                                            console.log("sss");
                                                            console.log(err);
                                                            poolConnection.rollback(
                                                              function () {
                                                                var message =
                                                                  languages
                                                                    .something_went_wrong[
                                                                  lang
                                                                  ];
                                                                Utils.makeResponse(
                                                                  res,
                                                                  false,
                                                                  400,
                                                                  message,
                                                                  appVersion,
                                                                  data
                                                                );
                                                                if (
                                                                  connection._freeConnections.indexOf(
                                                                    poolConnection
                                                                  ) == "-1"
                                                                ) {
                                                                  poolConnection.release();
                                                                }
                                                              }
                                                            );
                                                          } else {
                                                            console.log(result);
                                                            getGuestUserId(
                                                              userId,
                                                              deviceId,
                                                              loyaltyAmount
                                                            )
                                                              .then(function (
                                                                newUserId
                                                              ) {
                                                                console.log(
                                                                  "RahulID"
                                                                );
                                                                console.log(
                                                                  newUserId
                                                                );
                                                                console.log(
                                                                  "RahulID"
                                                                );
                                                                if (
                                                                  newUserId ||
                                                                  newUserId == 0
                                                                ) {
                                                                  if (
                                                                    paymentMode ==
                                                                    1
                                                                  ) {
                                                                    var query =
                                                                      "select sum(subtotal * quantity) as subtotal from order_items where temp_order_id=?";
                                                                  } else {
                                                                    var query =
                                                                      "select sum(subtotal * quantity) as subtotal from order_items where order_id=?";
                                                                  }
                                                                  poolConnection.query(
                                                                    query,
                                                                    [orderId],
                                                                    function (
                                                                      err,
                                                                      result0
                                                                    ) {
                                                                      if (err) {
                                                                        console.log(
                                                                          "bb"
                                                                        );
                                                                        console.log(
                                                                          err
                                                                        );
                                                                        poolConnection.rollback(
                                                                          function () {
                                                                            var message =
                                                                              languages
                                                                                .something_went_wrong[
                                                                              lang
                                                                              ];
                                                                            Utils.makeResponse(
                                                                              res,
                                                                              false,
                                                                              400,
                                                                              message,
                                                                              appVersion,
                                                                              data
                                                                            );
                                                                            if (
                                                                              connection._freeConnections.indexOf(
                                                                                poolConnection
                                                                              ) ==
                                                                              "-1"
                                                                            ) {
                                                                              poolConnection.release();
                                                                            }
                                                                          }
                                                                        );
                                                                      } else {
                                                                        console.log(
                                                                          result0
                                                                        );

                                                                        var orderNumber =
                                                                          "CAFEJAVAS_" +
                                                                          orderId;
                                                                        //****  total will be subtotal + service fee + delivery fee(deliver fee and service fee will be added later by admin panel)  ****//
                                                                        if (
                                                                          paymentMode ==
                                                                          1
                                                                        ) {
                                                                          var query =
                                                                            "update temp_orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=? where temp_order_id=? ";
                                                                        } else {
                                                                          var query =
                                                                            "update orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=?, payment_status='1' where order_id=? ";
                                                                        }
                                                                        console.log(
                                                                          result0
                                                                        );
                                                                        //                                                            var totalAmount = parseInt(result0[0].subtotal) - (parseInt(giftcardAmount) + parseInt(loyaltyAmount) + parseInt(promocodeAmount));
                                                                        var totalAmount =
                                                                          parseInt(
                                                                            result0[0]
                                                                              .subtotal
                                                                          ) -
                                                                          parseInt(
                                                                            rewardDeductionAmount
                                                                          ) +
                                                                          parseInt(
                                                                            deliveryAmount
                                                                          ) -
                                                                          (parseInt(
                                                                            giftcardAmount
                                                                          ) +
                                                                            parseInt(
                                                                              loyaltyAmount
                                                                            ) +
                                                                            parseInt(
                                                                              promocodeAmount
                                                                            ));
                                                                        console.log(
                                                                          "SubtotalAmount==" +
                                                                          result0[0]
                                                                            .subtotal
                                                                        );
                                                                        console.log(
                                                                          "giftcardAmount==" +
                                                                          giftcardAmount
                                                                        );
                                                                        console.log(
                                                                          "promocodeAmount==" +
                                                                          promocodeAmount
                                                                        );
                                                                        console.log(
                                                                          "totalAmount==" +
                                                                          totalAmount
                                                                        );
                                                                        console.log(
                                                                          "orderSubtotal==" +
                                                                          orderSubtotal
                                                                        );
                                                                        console.log(
                                                                          "deliveryAmount==" +
                                                                          deliveryAmount
                                                                        );
                                                                        console.log(
                                                                          "vatAmount==" +
                                                                          vatAmount
                                                                        );
                                                                        if (
                                                                          parseInt(
                                                                            totalAmount
                                                                          ) ==
                                                                          parseInt(
                                                                            orderSubtotal
                                                                          )
                                                                        ) {
                                                                          poolConnection.query(
                                                                            query,
                                                                            [
                                                                              orderNumber,
                                                                              newUserId,
                                                                              vatAmount,
                                                                              result0[0]
                                                                                .subtotal -
                                                                              parseInt(
                                                                                rewardDeductionAmount
                                                                              ),
                                                                              totalAmount,
                                                                              parseInt(
                                                                                deliveryAmount
                                                                              ),
                                                                              orderId,
                                                                            ],
                                                                            function (
                                                                              err,
                                                                              result
                                                                            ) {
                                                                              if (
                                                                                err
                                                                              ) {
                                                                                //     console.log("err3="+err);
                                                                                poolConnection.rollback(
                                                                                  function () {
                                                                                    var message =
                                                                                      languages
                                                                                        .something_went_wrong[
                                                                                      lang
                                                                                      ];
                                                                                    Utils.makeResponse(
                                                                                      res,
                                                                                      false,
                                                                                      400,
                                                                                      message,
                                                                                      appVersion,
                                                                                      data
                                                                                    );
                                                                                    if (
                                                                                      connection._freeConnections.indexOf(
                                                                                        poolConnection
                                                                                      ) ==
                                                                                      "-1"
                                                                                    ) {
                                                                                      poolConnection.release();
                                                                                    }
                                                                                  }
                                                                                );
                                                                              } else {
                                                                                console.log(
                                                                                  "aaa"
                                                                                );
                                                                                getGiftdeduction(
                                                                                  giftcardId,
                                                                                  giftcardAmount,
                                                                                  paymentMode,
                                                                                  userId
                                                                                )
                                                                                  .then(
                                                                                    function (
                                                                                      giftcheck
                                                                                    ) {
                                                                                      if (
                                                                                        giftcheck
                                                                                      ) {
                                                                                        getpromodeduction(
                                                                                          promocodeId,
                                                                                          promocodeAmount,
                                                                                          paymentMode,
                                                                                          userId
                                                                                        )
                                                                                          .then(
                                                                                            function (
                                                                                              promocheck
                                                                                            ) {
                                                                                              if (
                                                                                                promocheck
                                                                                              ) {
                                                                                                poolConnection.commit(
                                                                                                  function (
                                                                                                    err
                                                                                                  ) {
                                                                                                    if (
                                                                                                      err
                                                                                                    ) {
                                                                                                      poolConnection.rollback(
                                                                                                        function () {
                                                                                                          if (
                                                                                                            connection._freeConnections.indexOf(
                                                                                                              poolConnection
                                                                                                            ) ==
                                                                                                            "-1"
                                                                                                          ) {
                                                                                                            poolConnection.release();
                                                                                                          }
                                                                                                          var message =
                                                                                                            languages
                                                                                                              .something_went_wrong[
                                                                                                            lang
                                                                                                            ];
                                                                                                          Utils.makeResponse(
                                                                                                            res,
                                                                                                            false,
                                                                                                            400,
                                                                                                            message,
                                                                                                            appVersion,
                                                                                                            data
                                                                                                          );
                                                                                                        }
                                                                                                      );
                                                                                                    } else {
                                                                                                      if (
                                                                                                        paymentMode ==
                                                                                                        2
                                                                                                      ) {
                                                                                                        console.log(
                                                                                                          "check of reward product start"
                                                                                                        );
                                                                                                        // updateRewardcount(orderId,userId).then(function (rewardcheck) {
                                                                                                        //     if (rewardcheck) {
                                                                                                        //push notification for guest user
                                                                                                        if (
                                                                                                          userId ==
                                                                                                          0
                                                                                                        ) {
                                                                                                          poolConnection.query(
                                                                                                            "select id,device_token,device_id,device_type from tbl_guest_user where device_id =? order by id desc limit 1",
                                                                                                            [
                                                                                                              deviceId,
                                                                                                            ],
                                                                                                            function (
                                                                                                              err,
                                                                                                              result
                                                                                                            ) {
                                                                                                              if (
                                                                                                                err
                                                                                                              ) {
                                                                                                                console.log(
                                                                                                                  "guest_user" +
                                                                                                                  err
                                                                                                                );
                                                                                                              } else {
                                                                                                                var device_token =
                                                                                                                  result[0]
                                                                                                                    .device_token;
                                                                                                                var title =
                                                                                                                  "CafeJavas";
                                                                                                                var message =
                                                                                                                  "Congratulations ! You have successfully placed your order ID " +
                                                                                                                  orderId +
                                                                                                                  ".";
                                                                                                                var customData =
                                                                                                                {
                                                                                                                  notification_type:
                                                                                                                    "1", //order placed
                                                                                                                  order_id:
                                                                                                                    orderId, //order id
                                                                                                                  user_id:
                                                                                                                    result[0]
                                                                                                                      .id, //guest user id
                                                                                                                };
                                                                                                                var notificationParams =
                                                                                                                {
                                                                                                                  notification_type:
                                                                                                                    "1", //order placed
                                                                                                                  message:
                                                                                                                    message,
                                                                                                                  order_id:
                                                                                                                    orderId, //order id
                                                                                                                  user_id:
                                                                                                                    result[0]
                                                                                                                      .id, //guest user id
                                                                                                                  send_to:
                                                                                                                    "2", //guest user
                                                                                                                };

                                                                                                                if (
                                                                                                                  result[0]
                                                                                                                    .device_type ==
                                                                                                                  "1"
                                                                                                                ) {
                                                                                                                  //CODE FOR IOS PUSH NOTIFICATION

                                                                                                                  Utils.sendiOSPush(
                                                                                                                    poolConnection,
                                                                                                                    notificationParams,
                                                                                                                    device_token,
                                                                                                                    config
                                                                                                                      .CONSTANTS
                                                                                                                      .BUNDLE_ID,
                                                                                                                    title,
                                                                                                                    message,
                                                                                                                    customData
                                                                                                                  ).then(
                                                                                                                    function (
                                                                                                                      pushResult,
                                                                                                                      pushError
                                                                                                                    ) {
                                                                                                                      if (
                                                                                                                        pushError
                                                                                                                      ) {
                                                                                                                        console.log(
                                                                                                                          "iOS errrorr"
                                                                                                                        );
                                                                                                                      } else {
                                                                                                                        console.log(
                                                                                                                          "herer++++++++++********************"
                                                                                                                        );
                                                                                                                      }
                                                                                                                    }
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //CODE FOR ANDROID PUSH NOTIFICATION

                                                                                                                  Utils.sendAndroidPush(
                                                                                                                    poolConnection,
                                                                                                                    notificationParams,
                                                                                                                    device_token,
                                                                                                                    title,
                                                                                                                    message,
                                                                                                                    customData
                                                                                                                  ).then(
                                                                                                                    function (
                                                                                                                      error,
                                                                                                                      response
                                                                                                                    ) {
                                                                                                                      if (
                                                                                                                        error
                                                                                                                      ) {
                                                                                                                        console.log(
                                                                                                                          "Android errrorr"
                                                                                                                        );
                                                                                                                      } else {
                                                                                                                        //do nothing
                                                                                                                        console.log(
                                                                                                                          "else true customer"
                                                                                                                        );
                                                                                                                        var data =
                                                                                                                          {},
                                                                                                                          success = true,
                                                                                                                          status = 200,
                                                                                                                          message =
                                                                                                                            custom_message;
                                                                                                                        Util.makeResponse(
                                                                                                                          res,
                                                                                                                          success,
                                                                                                                          status,
                                                                                                                          message,
                                                                                                                          appVersion,
                                                                                                                          data
                                                                                                                        );
                                                                                                                      }
                                                                                                                    }
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            }
                                                                                                          );
                                                                                                        } else {
                                                                                                          //push notification for registered user
                                                                                                          poolConnection.query(
                                                                                                            "select device_token,device_id,device_type from users where user_id =?",
                                                                                                            [
                                                                                                              userId,
                                                                                                            ],
                                                                                                            function (
                                                                                                              err,
                                                                                                              result
                                                                                                            ) {
                                                                                                              if (
                                                                                                                err
                                                                                                              ) {
                                                                                                                console.log(
                                                                                                                  "user" +
                                                                                                                  err
                                                                                                                );
                                                                                                              } else {
                                                                                                                console.log(
                                                                                                                  " -user" +
                                                                                                                  JSON.stringify(
                                                                                                                    result
                                                                                                                  )
                                                                                                                );
                                                                                                                var device_token =
                                                                                                                  result[0]
                                                                                                                    .device_token;
                                                                                                                var title =
                                                                                                                  "CafeJavas";
                                                                                                                var message =
                                                                                                                  "Congratulations......You have successfully placed your order ID " +
                                                                                                                  orderId;
                                                                                                                var customData =
                                                                                                                {
                                                                                                                  notification_type:
                                                                                                                    "1", //order placed
                                                                                                                  order_id:
                                                                                                                    orderId, //order id
                                                                                                                  user_id:
                                                                                                                    userId, //registered user id
                                                                                                                };
                                                                                                                var notificationParams =
                                                                                                                {
                                                                                                                  notification_type:
                                                                                                                    "1", //order placed
                                                                                                                  message:
                                                                                                                    message,
                                                                                                                  order_id:
                                                                                                                    orderId, // order id
                                                                                                                  user_id:
                                                                                                                    userId, //registered user id
                                                                                                                  send_to:
                                                                                                                    "1", //registered user
                                                                                                                };

                                                                                                                if (
                                                                                                                  result[0]
                                                                                                                    .device_type ==
                                                                                                                  "1"
                                                                                                                ) {
                                                                                                                  //CODE FOR IOS PUSH NOTIFICATION

                                                                                                                  Utils.sendiOSPush(
                                                                                                                    poolConnection,
                                                                                                                    notificationParams,
                                                                                                                    device_token,
                                                                                                                    config
                                                                                                                      .CONSTANTS
                                                                                                                      .BUNDLE_ID,
                                                                                                                    title,
                                                                                                                    message,
                                                                                                                    customData
                                                                                                                  ).then(
                                                                                                                    function (
                                                                                                                      pushResult,
                                                                                                                      pushError
                                                                                                                    ) {
                                                                                                                      if (
                                                                                                                        pushError
                                                                                                                      ) {
                                                                                                                        console.log(
                                                                                                                          "iOS errrorr"
                                                                                                                        );
                                                                                                                      } else {
                                                                                                                        console.log(
                                                                                                                          "herer++++++++++********************"
                                                                                                                        );
                                                                                                                      }
                                                                                                                    }
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //CODE FOR ANDROID PUSH NOTIFICATION
                                                                                                                  //device_token = 'fLEvYLJnXXI:APA91bF4TkEPB1TFIYLfXSa9DCJd8QBq2sRLSW2btXoV_HnMVU6A9G1Hts9UwERmCWEpoxInZqHazE21gbnBYfiOZf5vXXOBV2PTfPd0hDB4kO0xFsdDZc-lDQ5VSsM-XVfZYonazJWC7IF9TdN0wFfLdzaDra-HYQ';
                                                                                                                  Utils.sendAndroidPush(
                                                                                                                    poolConnection,
                                                                                                                    notificationParams,
                                                                                                                    device_token,
                                                                                                                    title,
                                                                                                                    message,
                                                                                                                    customData
                                                                                                                  ).then(
                                                                                                                    function (
                                                                                                                      error,
                                                                                                                      response
                                                                                                                    ) {
                                                                                                                      if (
                                                                                                                        error
                                                                                                                      ) {
                                                                                                                        console.log(
                                                                                                                          "Android errrorr" +
                                                                                                                          error
                                                                                                                        );
                                                                                                                      } else {
                                                                                                                        //do nothing
                                                                                                                        console.log(
                                                                                                                          "else true customer"
                                                                                                                        );
                                                                                                                        var data =
                                                                                                                          {},
                                                                                                                          success = true,
                                                                                                                          status = 200,
                                                                                                                          message =
                                                                                                                            custom_message;
                                                                                                                        Util.makeResponse(
                                                                                                                          res,
                                                                                                                          success,
                                                                                                                          status,
                                                                                                                          message,
                                                                                                                          appVersion,
                                                                                                                          data
                                                                                                                        );
                                                                                                                      }
                                                                                                                    }
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            }
                                                                                                          );
                                                                                                        }

                                                                                                        //                                                                                    } else {
                                                                                                        //                                                                                        console.log('ffHIIIIIIIIII');
                                                                                                        //
                                                                                                        //                                                                                        var message = languages.something_went_wrong[lang];
                                                                                                        //                                                                                        Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                        //
                                                                                                        //                                                                                    }

                                                                                                        //                                                                                }).catch(function (err) {
                                                                                                        //                                                                                    console.log("errorrrr1122" + err);
                                                                                                        //                                                                                    poolConnection.rollback(function () {
                                                                                                        //                                                                                    var message = languages.something_went_wrong[lang];
                                                                                                        //                                                                                    Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                        //                                                                                    if (connection._freeConnections.indexOf(poolConnection) == '-1')
                                                                                                        //                                                                                    {
                                                                                                        //                                                                                        poolConnection.release();
                                                                                                        //                                                                                    }
                                                                                                        //
                                                                                                        //                                                                                    });
                                                                                                        //                                                                                });
                                                                                                      }

                                                                                                      // console.log('Transaction Complete.');
                                                                                                      if (
                                                                                                        connection._freeConnections.indexOf(
                                                                                                          poolConnection
                                                                                                        ) ==
                                                                                                        "-1"
                                                                                                      ) {
                                                                                                        poolConnection.release();
                                                                                                      }

                                                                                                      data.orderNumber =
                                                                                                        orderNumber;
                                                                                                      data.orderId =
                                                                                                        orderId;
                                                                                                      data.pickUpType =
                                                                                                        pickUpType;
                                                                                                      data.totalAmount =
                                                                                                        totalAmount;
                                                                                                      var message =
                                                                                                        languages
                                                                                                          .success[
                                                                                                        lang
                                                                                                        ];
                                                                                                      Utils.makeResponse(
                                                                                                        res,
                                                                                                        true,
                                                                                                        200,
                                                                                                        message,
                                                                                                        appVersion,
                                                                                                        data
                                                                                                      );
                                                                                                    }
                                                                                                  }
                                                                                                );
                                                                                              } else {
                                                                                                poolConnection.rollback(
                                                                                                  function () {
                                                                                                    console.log(
                                                                                                      "dd"
                                                                                                    );
                                                                                                    //console.log(err);
                                                                                                    var message =
                                                                                                      languages
                                                                                                        .something_went_wrong[
                                                                                                      lang
                                                                                                      ];
                                                                                                    Utils.makeResponse(
                                                                                                      res,
                                                                                                      false,
                                                                                                      400,
                                                                                                      message,
                                                                                                      appVersion,
                                                                                                      data
                                                                                                    );
                                                                                                    if (
                                                                                                      connection._freeConnections.indexOf(
                                                                                                        poolConnection
                                                                                                      ) ==
                                                                                                      "-1"
                                                                                                    ) {
                                                                                                      poolConnection.release();
                                                                                                    }
                                                                                                    return false;
                                                                                                  }
                                                                                                );
                                                                                              }
                                                                                            }
                                                                                          )
                                                                                          .catch(
                                                                                            function (
                                                                                              err
                                                                                            ) {
                                                                                              console.log(
                                                                                                "errorrrr11AA" +
                                                                                                err
                                                                                              );
                                                                                              poolConnection.rollback(
                                                                                                function () {
                                                                                                  var message =
                                                                                                    languages
                                                                                                      .something_went_wrong[
                                                                                                    lang
                                                                                                    ];
                                                                                                  Utils.makeResponse(
                                                                                                    res,
                                                                                                    false,
                                                                                                    400,
                                                                                                    message,
                                                                                                    appVersion,
                                                                                                    data
                                                                                                  );
                                                                                                  if (
                                                                                                    connection._freeConnections.indexOf(
                                                                                                      poolConnection
                                                                                                    ) ==
                                                                                                    "-1"
                                                                                                  ) {
                                                                                                    poolConnection.release();
                                                                                                  }
                                                                                                }
                                                                                              );
                                                                                            }
                                                                                          );
                                                                                      } else {
                                                                                        poolConnection.rollback(
                                                                                          function () {
                                                                                            console.log(
                                                                                              "dd"
                                                                                            );
                                                                                            //console.log(err);
                                                                                            var message =
                                                                                              languages
                                                                                                .something_went_wrong[
                                                                                              lang
                                                                                              ];
                                                                                            Utils.makeResponse(
                                                                                              res,
                                                                                              false,
                                                                                              400,
                                                                                              message,
                                                                                              appVersion,
                                                                                              data
                                                                                            );
                                                                                            if (
                                                                                              connection._freeConnections.indexOf(
                                                                                                poolConnection
                                                                                              ) ==
                                                                                              "-1"
                                                                                            ) {
                                                                                              poolConnection.release();
                                                                                            }
                                                                                            return false;
                                                                                          }
                                                                                        );
                                                                                      }
                                                                                    }
                                                                                  )
                                                                                  .catch(
                                                                                    function (
                                                                                      err
                                                                                    ) {
                                                                                      console.log(
                                                                                        "errorrrr1122" +
                                                                                        err
                                                                                      );
                                                                                      poolConnection.rollback(
                                                                                        function () {
                                                                                          var message =
                                                                                            languages
                                                                                              .something_went_wrong[
                                                                                            lang
                                                                                            ];
                                                                                          Utils.makeResponse(
                                                                                            res,
                                                                                            false,
                                                                                            400,
                                                                                            message,
                                                                                            appVersion,
                                                                                            data
                                                                                          );
                                                                                          if (
                                                                                            connection._freeConnections.indexOf(
                                                                                              poolConnection
                                                                                            ) ==
                                                                                            "-1"
                                                                                          ) {
                                                                                            poolConnection.release();
                                                                                          }
                                                                                        }
                                                                                      );
                                                                                    }
                                                                                  );
                                                                              }
                                                                            }
                                                                          );

                                                                          //
                                                                        } else {
                                                                          console.log(
                                                                            "ee"
                                                                          );
                                                                          //console.log(err);
                                                                          poolConnection.rollback(
                                                                            function () {
                                                                              var message =
                                                                                languages
                                                                                  .something_went_wrong[
                                                                                lang
                                                                                ];
                                                                              Utils.makeResponse(
                                                                                res,
                                                                                false,
                                                                                400,
                                                                                message,
                                                                                appVersion,
                                                                                data
                                                                              );
                                                                              if (
                                                                                connection._freeConnections.indexOf(
                                                                                  poolConnection
                                                                                ) ==
                                                                                "-1"
                                                                              ) {
                                                                                poolConnection.release();
                                                                              }
                                                                              return false;
                                                                            }
                                                                          );
                                                                        }
                                                                      }
                                                                    }
                                                                  );
                                                                } else {
                                                                  console.log(
                                                                    "ff"
                                                                  );
                                                                  //console.log(err);
                                                                  poolConnection.rollback(
                                                                    function () {
                                                                      var message =
                                                                        languages
                                                                          .something_went_wrong[
                                                                        lang
                                                                        ];
                                                                      Utils.makeResponse(
                                                                        res,
                                                                        false,
                                                                        400,
                                                                        message,
                                                                        appVersion,
                                                                        data
                                                                      );
                                                                      if (
                                                                        connection._freeConnections.indexOf(
                                                                          poolConnection
                                                                        ) ==
                                                                        "-1"
                                                                      ) {
                                                                        poolConnection.release();
                                                                      }
                                                                      return false;
                                                                    }
                                                                  );
                                                                }
                                                              })
                                                              .catch(function (
                                                                err
                                                              ) {
                                                                console.log(
                                                                  "errorrrr1133" +
                                                                  err
                                                                );
                                                                poolConnection.rollback(
                                                                  function () {
                                                                    var message =
                                                                      languages
                                                                        .something_went_wrong[
                                                                      lang
                                                                      ];
                                                                    Utils.makeResponse(
                                                                      res,
                                                                      false,
                                                                      400,
                                                                      message,
                                                                      appVersion,
                                                                      data
                                                                    );
                                                                    if (
                                                                      connection._freeConnections.indexOf(
                                                                        poolConnection
                                                                      ) == "-1"
                                                                    ) {
                                                                      poolConnection.release();
                                                                    }
                                                                  }
                                                                );
                                                              });
                                                          }
                                                        }
                                                      );
                                                    }
                                                  }
                                                );
                                              }

                                              //});
                                            }
                                          );
                                        }
                                      });
                                    });
                                  }
                                }
                              );
                            }
                          }
                        );
                      }
                    });

                    //});
                  }
                });
              } else {
                var message =
                  "We are closed for the day. Please order your favorite meal @ 6:00AM tomorrow!";
                Utils.makeResponse(res, false, 400, message, appVersion, data);
                return false;
              }
            } else {
              connection.getConnection(function (err, poolConnection) {
                if (err) {
                  var message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  poolConnection.beginTransaction(function (err) {
                    if (err) {
                      console.log(err);
                      var message = languages.something_went_wrong[lang];
                      Utils.makeResponse(
                        res,
                        false,
                        400,
                        message,
                        appVersion,
                        data
                      );
                    } else {
                      console.log(
                        "requestData===" + JSON.stringify(requestData)
                      );

                      var userId = requestData.userId;
                      var deviceId = requestData.deviceId;
                      var pickUpType = requestData.pickUpType;
                      var addressId = requestData.addressId;
                      var paymentMode = requestData.paymentMode;
                      var giftcardId = requestData.giftcardId;
                      var promocodeId = requestData.promocodeId;
                      var giftcardAmount = requestData.giftcardAmount;
                      var promocodeAmount = requestData.promocodeAmount;
                      var orderSubtotal = parseInt(requestData.orderSubtotal);
                      var vatAmount = requestData.vatAmount;
                      var loyaltyAmount = requestData.loyaltyAmount;
                      var loyaltyRefno = requestData.loyaltyRefno || "";
                      var branch_id = requestData.branch_id;
                      var orderNotes = requestData.order_notes;
                      var rewardDeductionAmount =
                        requestData.rewardDeductionAmount;

                      checkCartForBreakFastItems(userId).then((bitemCount) => {
                        console.log("bitemCount : ", bitemCount);
                        if (bitemCount > 0) {
                          var message =
                            "Breakfast products are available before 12PM only.";
                          Utils.makeResponse(
                            res,
                            false,
                            200,
                            message,
                            appVersion,
                            data
                          );
                        } else {
                          checkCartForGenerousBigMealsItems(userId).then(
                            (gitemCount) => {
                              console.log("gitemCount : ", gitemCount);
                              if (gitemCount > 0) {
                                var message =
                                  "Generous Big Meal products are available after 11AM only.";
                                Utils.makeResponse(
                                  res,
                                  false,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                              } else {
                                if (userId == 0) {
                                  var isGuestUser = "1";
                                } else {
                                  var isGuestUser = "0";
                                }
                                var deliveryAmount = 0;
                                if (
                                  requestData.deliveryAmount != undefined ||
                                  requestData.deliveryAmount != ""
                                ) {
                                  deliveryAmount = requestData.deliveryAmount;
                                }
                                if (pickUpType == 0) {
                                  //****  In case of dilevery, later admin will update from admin panel  ****//
                                  var branchId = branch_id;
                                } else {
                                  //****  In case of take away  ****//
                                  var branchId = addressId;
                                }
                                console.log("pickUpType : ", pickUpType);
                                console.log("orderSubtotal : ", orderSubtotal);
                                if (
                                  pickUpType == 0 &&
                                  orderSubtotal +
                                  rewardDeductionAmount +
                                  loyaltyAmount +
                                  promocodeAmount +
                                  giftcardAmount <
                                  10500
                                ) {
                                  var message =
                                    "Minimum order value for delivery to be 10,500 UGX!";
                                  console.log(message);
                                  Utils.makeResponse(
                                    res,
                                    false,
                                    200,
                                    message,
                                    appVersion,
                                    data
                                  );
                                  return false;
                                }

                                getDriverIncentive().then(function (incentive) {
                                  checkCartForBreakFastItems(
                                    userId,
                                    deviceId
                                  ).then((itemCount) => {
                                    // var status;
                                    console.log("Incentive : ", incentive);
                                    console.log("itemCount : ", itemCount);

                                    if (itemCount > 0) {
                                      var message =
                                        "Breakfast products are available before 12PM only.";
                                      Utils.makeResponse(
                                        res,
                                        false,
                                        200,
                                        message,
                                        appVersion,
                                        data
                                      );
                                    } else {
                                      if (paymentMode == 1) {
                                        var query =
                                          "insert into temp_orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                      } else {
                                        var query =
                                          "insert into orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                      }
                                      if (pickUpType == 1) {
                                        incentive = 0;
                                      }
                                      poolConnection.query(
                                        query,
                                        [
                                          userId,
                                          "0",
                                          "0",
                                          "0",
                                          addressId,
                                          branchId,
                                          isGuestUser,
                                          deviceId,
                                          "0",
                                          paymentMode,
                                          pickUpType,
                                          "0",
                                          "2",
                                          "0",
                                          "0",
                                          "0",
                                          "0",
                                          giftcardId,
                                          promocodeId,
                                          loyaltyRefno,
                                          giftcardAmount,
                                          promocodeAmount,
                                          loyaltyAmount,
                                          incentive,
                                          orderNotes,
                                          rewardDeductionAmount,
                                        ],
                                        function (err, result) {
                                          //poolConnection.query(query, [userId, driverId, '0', status, addressId, branchId, isGuestUser, deviceId, '0', paymentMode, pickUpType, '0', '2', '0', '0', '0', '0', giftcardId, promocodeId, loyaltyRefno, giftcardAmount, promocodeAmount, loyaltyAmount, incentive], function (err, result) {
                                          if (err) {
                                            console.log("err1=" + err);
                                            return false;
                                            poolConnection.rollback(
                                              function () {
                                                if (
                                                  connection._freeConnections.indexOf(
                                                    poolConnection
                                                  ) == "-1"
                                                ) {
                                                  poolConnection.release();
                                                }
                                                var message =
                                                  languages
                                                    .something_went_wrong[lang];
                                                Utils.makeResponse(
                                                  res,
                                                  false,
                                                  400,
                                                  message,
                                                  appVersion,
                                                  data
                                                );
                                              }
                                            );
                                          } else {
                                            var orderId = result.insertId;
                                            console.log("orderId : ", orderId);

                                            var guest;
                                            if (userId == 0) {
                                              guest = 1;
                                            } else {
                                              guest = 0;
                                            }
                                            // if(driverId != 0){
                                            //     var query = 'insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now()),(?,?,?,?,now(),now())';
                                            //     var params = [orderId, userId, guest, 'Placed', orderId, userId, guest, 'Assigned To Driver'];
                                            // }else{
                                            var query =
                                              "insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now())";
                                            var params = [
                                              orderId,
                                              userId,
                                              guest,
                                              "Placed",
                                            ];
                                            // }

                                            poolConnection.query(
                                              query,
                                              params,
                                              function (err, result) {
                                                if (err) {
                                                  console.log("err1=" + err);
                                                  poolConnection.rollback(
                                                    function () {
                                                      if (
                                                        connection._freeConnections.indexOf(
                                                          poolConnection
                                                        ) == "-1"
                                                      ) {
                                                        poolConnection.release();
                                                      }
                                                      var message =
                                                        languages
                                                          .something_went_wrong[
                                                        lang
                                                        ];
                                                      Utils.makeResponse(
                                                        res,
                                                        false,
                                                        400,
                                                        message,
                                                        appVersion,
                                                        data
                                                      );
                                                    }
                                                  );
                                                } else {
                                                  // if(driverId > 0){

                                                  //     poolConnection.query("select id, user_type, device_type, device_token from tbl_driver where id =?", [driverId], function (err, result) {
                                                  //         if (err) {
                                                  //             console.log(err);
                                                  //         } else {
                                                  //             var device_token = result[0].device_token;
                                                  //             var title = "CafeJavas";
                                                  //             var message = " You have 1 new order to deliver.";
                                                  //             var customData = {
                                                  //                 "notification_type": '11', //Assigned to Driver
                                                  //                 "order_id": orderId,
                                                  //                 "user_id": result[0].id,
                                                  //             };
                                                  //             var notificationParams = {
                                                  //                 "notification_type": '11', //Assigned to Driver
                                                  //                 "message": message,
                                                  //                 "order_id": orderId,
                                                  //                 "user_id": result[0].id,
                                                  //                 "send_to": "3"
                                                  //             };

                                                  //             if (result[0].device_type == '1') {
                                                  //                 //CODE FOR IOS PUSH NOTIFICATION

                                                  //                 Utils.sendiOSPush(poolConnection, notificationParams, device_token, config.CONSTANTS.BUNDLE_ID, title, message, customData).then(function (pushResult, pushError) {
                                                  //                     if (pushError) {
                                                  //                         console.log("iOS errrorr");

                                                  //                     } else {
                                                  //                         console.log("herer++++++++++********************");
                                                  //                     }
                                                  //                 });

                                                  //             } else {
                                                  //                 //CODE FOR ANDROID PUSH NOTIFICATION

                                                  //                 Utils.sendAndroidPush(poolConnection, notificationParams, device_token, title, message, customData).then(function (error, response) {
                                                  //                     if (error) {
                                                  //                         console.log("Android errrorr");

                                                  //                     } else {
                                                  //                         //do nothing
                                                  //                         console.log("else true customer");
                                                  //                         var data = {},
                                                  //                                 success = true,
                                                  //                                 status = 200,
                                                  //                                 message = custom_message;
                                                  //                         Util.makeResponse(res, success, status, message, appVersion, data);
                                                  //                     }
                                                  //                 })

                                                  //             }

                                                  //         }
                                                  //     });

                                                  // }

                                                  if (
                                                    requestData.isCouponApplied ==
                                                    "1"
                                                  ) {
                                                  }
                                                  console.log(result);

                                                  console.log(result.insertId);

                                                  if (userId == 0) {
                                                    //****  In case of guest user  ****//
                                                    if (paymentMode == 1) {
                                                      var query =
                                                        "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.device_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                      var paramArray = [
                                                        orderId,
                                                        deviceId,
                                                      ];
                                                    } else {
                                                      var query =
                                                        "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.device_id=?  and oi.is_delete='0' and oi.order_id='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                      var paramArray = [
                                                        orderId,
                                                        deviceId,
                                                      ];
                                                    }
                                                  } else {
                                                    if (paymentMode == 1) {
                                                      var query =
                                                        "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.user_id=?  and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                      var paramArray = [
                                                        orderId,
                                                        userId,
                                                      ];
                                                    } else {
                                                      var query =
                                                        "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                      var paramArray = [
                                                        orderId,
                                                        userId,
                                                      ];
                                                    }
                                                  }

                                                  //  console.log(query+paramArray);
                                                  poolConnection.query(
                                                    query,
                                                    paramArray,
                                                    function (err, result) {
                                                      if (err) {
                                                        console.log("sss");
                                                        console.log(err);
                                                        poolConnection.rollback(
                                                          function () {
                                                            var message =
                                                              languages
                                                                .something_went_wrong[
                                                              lang
                                                              ];
                                                            Utils.makeResponse(
                                                              res,
                                                              false,
                                                              400,
                                                              message,
                                                              appVersion,
                                                              data
                                                            );
                                                            if (
                                                              connection._freeConnections.indexOf(
                                                                poolConnection
                                                              ) == "-1"
                                                            ) {
                                                              poolConnection.release();
                                                            }
                                                          }
                                                        );
                                                      } else {
                                                        console.log(result);
                                                        getGuestUserId(
                                                          userId,
                                                          deviceId,
                                                          loyaltyAmount
                                                        )
                                                          .then(function (
                                                            newUserId
                                                          ) {
                                                            console.log(
                                                              "RahulID"
                                                            );
                                                            console.log(
                                                              newUserId
                                                            );
                                                            console.log(
                                                              "RahulID"
                                                            );
                                                            if (
                                                              newUserId ||
                                                              newUserId == 0
                                                            ) {
                                                              if (
                                                                paymentMode == 1
                                                              ) {
                                                                var query =
                                                                  "select sum(subtotal * quantity) as subtotal from order_items where temp_order_id=?";
                                                              } else {
                                                                var query =
                                                                  "select sum(subtotal * quantity) as subtotal from order_items where order_id=?";
                                                              }
                                                              poolConnection.query(
                                                                query,
                                                                [orderId],
                                                                function (
                                                                  err,
                                                                  result0
                                                                ) {
                                                                  if (err) {
                                                                    console.log(
                                                                      "bb"
                                                                    );
                                                                    console.log(
                                                                      err
                                                                    );
                                                                    poolConnection.rollback(
                                                                      function () {
                                                                        var message =
                                                                          languages
                                                                            .something_went_wrong[
                                                                          lang
                                                                          ];
                                                                        Utils.makeResponse(
                                                                          res,
                                                                          false,
                                                                          400,
                                                                          message,
                                                                          appVersion,
                                                                          data
                                                                        );
                                                                        if (
                                                                          connection._freeConnections.indexOf(
                                                                            poolConnection
                                                                          ) ==
                                                                          "-1"
                                                                        ) {
                                                                          poolConnection.release();
                                                                        }
                                                                      }
                                                                    );
                                                                  } else {
                                                                    console.log(
                                                                      result0
                                                                    );

                                                                    var orderNumber =
                                                                      "CAFEJAVAS_" +
                                                                      orderId;
                                                                    //****  total will be subtotal + service fee + delivery fee(deliver fee and service fee will be added later by admin panel)  ****//
                                                                    if (
                                                                      paymentMode ==
                                                                      1
                                                                    ) {
                                                                      var query =
                                                                        "update temp_orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=? where temp_order_id=? ";
                                                                    } else {
                                                                      var query =
                                                                        "update orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=?, payment_status='1' where order_id=? ";
                                                                    }
                                                                    console.log(
                                                                      result0
                                                                    );
                                                                    //                                                            var totalAmount = parseInt(result0[0].subtotal) - (parseInt(giftcardAmount) + parseInt(loyaltyAmount) + parseInt(promocodeAmount));
                                                                    var totalAmount =
                                                                      parseInt(
                                                                        result0[0]
                                                                          .subtotal
                                                                      ) -
                                                                      parseInt(
                                                                        rewardDeductionAmount
                                                                      ) +
                                                                      parseInt(
                                                                        deliveryAmount
                                                                      ) -
                                                                      (parseInt(
                                                                        giftcardAmount
                                                                      ) +
                                                                        parseInt(
                                                                          loyaltyAmount
                                                                        ) +
                                                                        parseInt(
                                                                          promocodeAmount
                                                                        ));
                                                                    console.log(
                                                                      "SubtotalAmount==" +
                                                                      result0[0]
                                                                        .subtotal
                                                                    );
                                                                    console.log(
                                                                      "giftcardAmount==" +
                                                                      giftcardAmount
                                                                    );
                                                                    console.log(
                                                                      "promocodeAmount==" +
                                                                      promocodeAmount
                                                                    );
                                                                    console.log(
                                                                      "totalAmount==" +
                                                                      totalAmount
                                                                    );
                                                                    console.log(
                                                                      "orderSubtotal==" +
                                                                      orderSubtotal
                                                                    );
                                                                    console.log(
                                                                      "deliveryAmount==" +
                                                                      deliveryAmount
                                                                    );
                                                                    console.log(
                                                                      "vatAmount==" +
                                                                      vatAmount
                                                                    );
                                                                    if (
                                                                      parseInt(
                                                                        totalAmount
                                                                      ) ==
                                                                      parseInt(
                                                                        orderSubtotal
                                                                      )
                                                                    ) {
                                                                      poolConnection.query(
                                                                        query,
                                                                        [
                                                                          orderNumber,
                                                                          newUserId,
                                                                          vatAmount,
                                                                          result0[0]
                                                                            .subtotal -
                                                                          parseInt(
                                                                            rewardDeductionAmount
                                                                          ),
                                                                          totalAmount,
                                                                          parseInt(
                                                                            deliveryAmount
                                                                          ),
                                                                          orderId,
                                                                        ],
                                                                        function (
                                                                          err,
                                                                          result
                                                                        ) {
                                                                          if (
                                                                            err
                                                                          ) {
                                                                            //     console.log("err3="+err);
                                                                            poolConnection.rollback(
                                                                              function () {
                                                                                var message =
                                                                                  languages
                                                                                    .something_went_wrong[
                                                                                  lang
                                                                                  ];
                                                                                Utils.makeResponse(
                                                                                  res,
                                                                                  false,
                                                                                  400,
                                                                                  message,
                                                                                  appVersion,
                                                                                  data
                                                                                );
                                                                                if (
                                                                                  connection._freeConnections.indexOf(
                                                                                    poolConnection
                                                                                  ) ==
                                                                                  "-1"
                                                                                ) {
                                                                                  poolConnection.release();
                                                                                }
                                                                              }
                                                                            );
                                                                          } else {
                                                                            console.log(
                                                                              "aaa"
                                                                            );
                                                                            getGiftdeduction(
                                                                              giftcardId,
                                                                              giftcardAmount,
                                                                              paymentMode,
                                                                              userId
                                                                            )
                                                                              .then(
                                                                                function (
                                                                                  giftcheck
                                                                                ) {
                                                                                  if (
                                                                                    giftcheck
                                                                                  ) {
                                                                                    getpromodeduction(
                                                                                      promocodeId,
                                                                                      promocodeAmount,
                                                                                      paymentMode,
                                                                                      userId
                                                                                    )
                                                                                      .then(
                                                                                        function (
                                                                                          promocheck
                                                                                        ) {
                                                                                          if (
                                                                                            promocheck
                                                                                          ) {
                                                                                            poolConnection.commit(
                                                                                              function (
                                                                                                err
                                                                                              ) {
                                                                                                if (
                                                                                                  err
                                                                                                ) {
                                                                                                  poolConnection.rollback(
                                                                                                    function () {
                                                                                                      if (
                                                                                                        connection._freeConnections.indexOf(
                                                                                                          poolConnection
                                                                                                        ) ==
                                                                                                        "-1"
                                                                                                      ) {
                                                                                                        poolConnection.release();
                                                                                                      }
                                                                                                      var message =
                                                                                                        languages
                                                                                                          .something_went_wrong[
                                                                                                        lang
                                                                                                        ];
                                                                                                      Utils.makeResponse(
                                                                                                        res,
                                                                                                        false,
                                                                                                        400,
                                                                                                        message,
                                                                                                        appVersion,
                                                                                                        data
                                                                                                      );
                                                                                                    }
                                                                                                  );
                                                                                                } else {
                                                                                                  if (
                                                                                                    paymentMode ==
                                                                                                    2
                                                                                                  ) {
                                                                                                    console.log(
                                                                                                      "check of reward product start"
                                                                                                    );
                                                                                                    // updateRewardcount(orderId,userId).then(function (rewardcheck) {
                                                                                                    //     if (rewardcheck) {
                                                                                                    //push notification for guest user
                                                                                                    if (
                                                                                                      userId ==
                                                                                                      0
                                                                                                    ) {
                                                                                                      poolConnection.query(
                                                                                                        "select id,device_token,device_id,device_type from tbl_guest_user where device_id =? order by id desc limit 1",
                                                                                                        [
                                                                                                          deviceId,
                                                                                                        ],
                                                                                                        function (
                                                                                                          err,
                                                                                                          result
                                                                                                        ) {
                                                                                                          if (
                                                                                                            err
                                                                                                          ) {
                                                                                                            console.log(
                                                                                                              "guest_user" +
                                                                                                              err
                                                                                                            );
                                                                                                          } else {
                                                                                                            var device_token =
                                                                                                              result[0]
                                                                                                                .device_token;
                                                                                                            var title =
                                                                                                              "CafeJavas";
                                                                                                            var message =
                                                                                                              "Congratulations ! You have successfully placed your order ID " +
                                                                                                              orderId +
                                                                                                              ".";
                                                                                                            var customData =
                                                                                                            {
                                                                                                              notification_type:
                                                                                                                "1", //order placed
                                                                                                              order_id:
                                                                                                                orderId, //order id
                                                                                                              user_id:
                                                                                                                result[0]
                                                                                                                  .id, //guest user id
                                                                                                            };
                                                                                                            var notificationParams =
                                                                                                            {
                                                                                                              notification_type:
                                                                                                                "1", //order placed
                                                                                                              message:
                                                                                                                message,
                                                                                                              order_id:
                                                                                                                orderId, //order id
                                                                                                              user_id:
                                                                                                                result[0]
                                                                                                                  .id, //guest user id
                                                                                                              send_to:
                                                                                                                "2", //guest user
                                                                                                            };

                                                                                                            if (
                                                                                                              result[0]
                                                                                                                .device_type ==
                                                                                                              "1"
                                                                                                            ) {
                                                                                                              //CODE FOR IOS PUSH NOTIFICATION

                                                                                                              Utils.sendiOSPush(
                                                                                                                poolConnection,
                                                                                                                notificationParams,
                                                                                                                device_token,
                                                                                                                config
                                                                                                                  .CONSTANTS
                                                                                                                  .BUNDLE_ID,
                                                                                                                title,
                                                                                                                message,
                                                                                                                customData
                                                                                                              ).then(
                                                                                                                function (
                                                                                                                  pushResult,
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  if (
                                                                                                                    pushError
                                                                                                                  ) {
                                                                                                                    console.log(
                                                                                                                      "iOS errrorr"
                                                                                                                    );
                                                                                                                  } else {
                                                                                                                    console.log(
                                                                                                                      "herer++++++++++********************"
                                                                                                                    );
                                                                                                                  }
                                                                                                                }
                                                                                                              );
                                                                                                            } else {
                                                                                                              //CODE FOR ANDROID PUSH NOTIFICATION

                                                                                                              Utils.sendAndroidPush(
                                                                                                                poolConnection,
                                                                                                                notificationParams,
                                                                                                                device_token,
                                                                                                                title,
                                                                                                                message,
                                                                                                                customData
                                                                                                              ).then(
                                                                                                                function (
                                                                                                                  error,
                                                                                                                  response
                                                                                                                ) {
                                                                                                                  if (
                                                                                                                    error
                                                                                                                  ) {
                                                                                                                    console.log(
                                                                                                                      "Android errrorr"
                                                                                                                    );
                                                                                                                  } else {
                                                                                                                    //do nothing
                                                                                                                    console.log(
                                                                                                                      "else true customer"
                                                                                                                    );
                                                                                                                    var data =
                                                                                                                      {},
                                                                                                                      success = true,
                                                                                                                      status = 200,
                                                                                                                      message =
                                                                                                                        custom_message;
                                                                                                                    Util.makeResponse(
                                                                                                                      res,
                                                                                                                      success,
                                                                                                                      status,
                                                                                                                      message,
                                                                                                                      appVersion,
                                                                                                                      data
                                                                                                                    );
                                                                                                                  }
                                                                                                                }
                                                                                                              );
                                                                                                            }
                                                                                                          }
                                                                                                        }
                                                                                                      );
                                                                                                    } else {
                                                                                                      //push notification for registered user
                                                                                                      poolConnection.query(
                                                                                                        "select device_token,device_id,device_type from users where user_id =?",
                                                                                                        [
                                                                                                          userId,
                                                                                                        ],
                                                                                                        function (
                                                                                                          err,
                                                                                                          result
                                                                                                        ) {
                                                                                                          if (
                                                                                                            err
                                                                                                          ) {
                                                                                                            console.log(
                                                                                                              "user" +
                                                                                                              err
                                                                                                            );
                                                                                                          } else {
                                                                                                            console.log(
                                                                                                              " -user" +
                                                                                                              JSON.stringify(
                                                                                                                result
                                                                                                              )
                                                                                                            );
                                                                                                            var device_token =
                                                                                                              result[0]
                                                                                                                .device_token;
                                                                                                            var title =
                                                                                                              "CafeJavas";
                                                                                                            var message =
                                                                                                              "Congratulations......You have successfully placed your order ID " +
                                                                                                              orderId;
                                                                                                            var customData =
                                                                                                            {
                                                                                                              notification_type:
                                                                                                                "1", //order placed
                                                                                                              order_id:
                                                                                                                orderId, //order id
                                                                                                              user_id:
                                                                                                                userId, //registered user id
                                                                                                            };
                                                                                                            var notificationParams =
                                                                                                            {
                                                                                                              notification_type:
                                                                                                                "1", //order placed
                                                                                                              message:
                                                                                                                message,
                                                                                                              order_id:
                                                                                                                orderId, // order id
                                                                                                              user_id:
                                                                                                                userId, //registered user id
                                                                                                              send_to:
                                                                                                                "1", //registered user
                                                                                                            };

                                                                                                            if (
                                                                                                              result[0]
                                                                                                                .device_type ==
                                                                                                              "1"
                                                                                                            ) {
                                                                                                              //CODE FOR IOS PUSH NOTIFICATION

                                                                                                              Utils.sendiOSPush(
                                                                                                                poolConnection,
                                                                                                                notificationParams,
                                                                                                                device_token,
                                                                                                                config
                                                                                                                  .CONSTANTS
                                                                                                                  .BUNDLE_ID,
                                                                                                                title,
                                                                                                                message,
                                                                                                                customData
                                                                                                              ).then(
                                                                                                                function (
                                                                                                                  pushResult,
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  if (
                                                                                                                    pushError
                                                                                                                  ) {
                                                                                                                    console.log(
                                                                                                                      "iOS errrorr"
                                                                                                                    );
                                                                                                                  } else {
                                                                                                                    console.log(
                                                                                                                      "herer++++++++++********************"
                                                                                                                    );
                                                                                                                  }
                                                                                                                }
                                                                                                              );
                                                                                                            } else {
                                                                                                              //CODE FOR ANDROID PUSH NOTIFICATION
                                                                                                              //device_token = 'fLEvYLJnXXI:APA91bF4TkEPB1TFIYLfXSa9DCJd8QBq2sRLSW2btXoV_HnMVU6A9G1Hts9UwERmCWEpoxInZqHazE21gbnBYfiOZf5vXXOBV2PTfPd0hDB4kO0xFsdDZc-lDQ5VSsM-XVfZYonazJWC7IF9TdN0wFfLdzaDra-HYQ';
                                                                                                              Utils.sendAndroidPush(
                                                                                                                poolConnection,
                                                                                                                notificationParams,
                                                                                                                device_token,
                                                                                                                title,
                                                                                                                message,
                                                                                                                customData
                                                                                                              ).then(
                                                                                                                function (
                                                                                                                  error,
                                                                                                                  response
                                                                                                                ) {
                                                                                                                  if (
                                                                                                                    error
                                                                                                                  ) {
                                                                                                                    console.log(
                                                                                                                      "Android errrorr" +
                                                                                                                      error
                                                                                                                    );
                                                                                                                  } else {
                                                                                                                    //do nothing
                                                                                                                    console.log(
                                                                                                                      "else true customer"
                                                                                                                    );
                                                                                                                    var data =
                                                                                                                      {},
                                                                                                                      success = true,
                                                                                                                      status = 200,
                                                                                                                      message =
                                                                                                                        custom_message;
                                                                                                                    Util.makeResponse(
                                                                                                                      res,
                                                                                                                      success,
                                                                                                                      status,
                                                                                                                      message,
                                                                                                                      appVersion,
                                                                                                                      data
                                                                                                                    );
                                                                                                                  }
                                                                                                                }
                                                                                                              );
                                                                                                            }
                                                                                                          }
                                                                                                        }
                                                                                                      );
                                                                                                    }

                                                                                                    //                                                                                    } else {
                                                                                                    //                                                                                        console.log('ffHIIIIIIIIII');
                                                                                                    //
                                                                                                    //                                                                                        var message = languages.something_went_wrong[lang];
                                                                                                    //                                                                                        Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                    //
                                                                                                    //                                                                                    }

                                                                                                    //                                                                                }).catch(function (err) {
                                                                                                    //                                                                                    console.log("errorrrr1122" + err);
                                                                                                    //                                                                                    poolConnection.rollback(function () {
                                                                                                    //                                                                                    var message = languages.something_went_wrong[lang];
                                                                                                    //                                                                                    Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                    //                                                                                    if (connection._freeConnections.indexOf(poolConnection) == '-1')
                                                                                                    //                                                                                    {
                                                                                                    //                                                                                        poolConnection.release();
                                                                                                    //                                                                                    }
                                                                                                    //
                                                                                                    //                                                                                    });
                                                                                                    //                                                                                });
                                                                                                  }

                                                                                                  // console.log('Transaction Complete.');
                                                                                                  if (
                                                                                                    connection._freeConnections.indexOf(
                                                                                                      poolConnection
                                                                                                    ) ==
                                                                                                    "-1"
                                                                                                  ) {
                                                                                                    poolConnection.release();
                                                                                                  }

                                                                                                  data.orderNumber =
                                                                                                    orderNumber;
                                                                                                  data.orderId =
                                                                                                    orderId;
                                                                                                  data.pickUpType =
                                                                                                    pickUpType;
                                                                                                  data.totalAmount =
                                                                                                    totalAmount;
                                                                                                  var message =
                                                                                                    languages
                                                                                                      .success[
                                                                                                    lang
                                                                                                    ];
                                                                                                  Utils.makeResponse(
                                                                                                    res,
                                                                                                    true,
                                                                                                    200,
                                                                                                    message,
                                                                                                    appVersion,
                                                                                                    data
                                                                                                  );
                                                                                                }
                                                                                              }
                                                                                            );
                                                                                          } else {
                                                                                            poolConnection.rollback(
                                                                                              function () {
                                                                                                console.log(
                                                                                                  "dd"
                                                                                                );
                                                                                                //console.log(err);
                                                                                                var message =
                                                                                                  languages
                                                                                                    .something_went_wrong[
                                                                                                  lang
                                                                                                  ];
                                                                                                Utils.makeResponse(
                                                                                                  res,
                                                                                                  false,
                                                                                                  400,
                                                                                                  message,
                                                                                                  appVersion,
                                                                                                  data
                                                                                                );
                                                                                                if (
                                                                                                  connection._freeConnections.indexOf(
                                                                                                    poolConnection
                                                                                                  ) ==
                                                                                                  "-1"
                                                                                                ) {
                                                                                                  poolConnection.release();
                                                                                                }
                                                                                                return false;
                                                                                              }
                                                                                            );
                                                                                          }
                                                                                        }
                                                                                      )
                                                                                      .catch(
                                                                                        function (
                                                                                          err
                                                                                        ) {
                                                                                          console.log(
                                                                                            "errorrrr11AA" +
                                                                                            err
                                                                                          );
                                                                                          poolConnection.rollback(
                                                                                            function () {
                                                                                              var message =
                                                                                                languages
                                                                                                  .something_went_wrong[
                                                                                                lang
                                                                                                ];
                                                                                              Utils.makeResponse(
                                                                                                res,
                                                                                                false,
                                                                                                400,
                                                                                                message,
                                                                                                appVersion,
                                                                                                data
                                                                                              );
                                                                                              if (
                                                                                                connection._freeConnections.indexOf(
                                                                                                  poolConnection
                                                                                                ) ==
                                                                                                "-1"
                                                                                              ) {
                                                                                                poolConnection.release();
                                                                                              }
                                                                                            }
                                                                                          );
                                                                                        }
                                                                                      );
                                                                                  } else {
                                                                                    poolConnection.rollback(
                                                                                      function () {
                                                                                        console.log(
                                                                                          "dd"
                                                                                        );
                                                                                        //console.log(err);
                                                                                        var message =
                                                                                          languages
                                                                                            .something_went_wrong[
                                                                                          lang
                                                                                          ];
                                                                                        Utils.makeResponse(
                                                                                          res,
                                                                                          false,
                                                                                          400,
                                                                                          message,
                                                                                          appVersion,
                                                                                          data
                                                                                        );
                                                                                        if (
                                                                                          connection._freeConnections.indexOf(
                                                                                            poolConnection
                                                                                          ) ==
                                                                                          "-1"
                                                                                        ) {
                                                                                          poolConnection.release();
                                                                                        }
                                                                                        return false;
                                                                                      }
                                                                                    );
                                                                                  }
                                                                                }
                                                                              )
                                                                              .catch(
                                                                                function (
                                                                                  err
                                                                                ) {
                                                                                  console.log(
                                                                                    "errorrrr1122" +
                                                                                    err
                                                                                  );
                                                                                  poolConnection.rollback(
                                                                                    function () {
                                                                                      var message =
                                                                                        languages
                                                                                          .something_went_wrong[
                                                                                        lang
                                                                                        ];
                                                                                      Utils.makeResponse(
                                                                                        res,
                                                                                        false,
                                                                                        400,
                                                                                        message,
                                                                                        appVersion,
                                                                                        data
                                                                                      );
                                                                                      if (
                                                                                        connection._freeConnections.indexOf(
                                                                                          poolConnection
                                                                                        ) ==
                                                                                        "-1"
                                                                                      ) {
                                                                                        poolConnection.release();
                                                                                      }
                                                                                    }
                                                                                  );
                                                                                }
                                                                              );
                                                                          }
                                                                        }
                                                                      );

                                                                      //
                                                                    } else {
                                                                      console.log(
                                                                        "ee"
                                                                      );
                                                                      //console.log(err);
                                                                      poolConnection.rollback(
                                                                        function () {
                                                                          var message =
                                                                            languages
                                                                              .something_went_wrong[
                                                                            lang
                                                                            ];
                                                                          Utils.makeResponse(
                                                                            res,
                                                                            false,
                                                                            400,
                                                                            message,
                                                                            appVersion,
                                                                            data
                                                                          );
                                                                          if (
                                                                            connection._freeConnections.indexOf(
                                                                              poolConnection
                                                                            ) ==
                                                                            "-1"
                                                                          ) {
                                                                            poolConnection.release();
                                                                          }
                                                                          return false;
                                                                        }
                                                                      );
                                                                    }
                                                                  }
                                                                }
                                                              );
                                                            } else {
                                                              console.log("ff");
                                                              //console.log(err);
                                                              poolConnection.rollback(
                                                                function () {
                                                                  var message =
                                                                    languages
                                                                      .something_went_wrong[
                                                                    lang
                                                                    ];
                                                                  Utils.makeResponse(
                                                                    res,
                                                                    false,
                                                                    400,
                                                                    message,
                                                                    appVersion,
                                                                    data
                                                                  );
                                                                  if (
                                                                    connection._freeConnections.indexOf(
                                                                      poolConnection
                                                                    ) == "-1"
                                                                  ) {
                                                                    poolConnection.release();
                                                                  }
                                                                  return false;
                                                                }
                                                              );
                                                            }
                                                          })
                                                          .catch(function (
                                                            err
                                                          ) {
                                                            console.log(
                                                              "errorrrr1133" +
                                                              err
                                                            );
                                                            poolConnection.rollback(
                                                              function () {
                                                                var message =
                                                                  languages
                                                                    .something_went_wrong[
                                                                  lang
                                                                  ];
                                                                Utils.makeResponse(
                                                                  res,
                                                                  false,
                                                                  400,
                                                                  message,
                                                                  appVersion,
                                                                  data
                                                                );
                                                                if (
                                                                  connection._freeConnections.indexOf(
                                                                    poolConnection
                                                                  ) == "-1"
                                                                ) {
                                                                  poolConnection.release();
                                                                }
                                                              }
                                                            );
                                                          });
                                                      }
                                                    }
                                                  );
                                                }
                                              }
                                            );
                                          }

                                          //});
                                        }
                                      );
                                    }
                                  });
                                });
                              }
                            }
                          );
                        }
                      });
                    }
                  });

                  //});
                }
              });
            }
          } else {
            connection.getConnection(function (err, poolConnection) {
              if (err) {
                var message = languages.something_went_wrong[lang];
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                poolConnection.beginTransaction(function (err) {
                  if (err) {
                    console.log(err);
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    console.log("requestData===" + JSON.stringify(requestData));

                    var userId = requestData.userId;
                    var deviceId = requestData.deviceId;
                    var pickUpType = requestData.pickUpType;
                    var addressId = requestData.addressId;
                    var paymentMode = requestData.paymentMode;
                    var giftcardId = requestData.giftcardId;
                    var promocodeId = requestData.promocodeId;
                    var giftcardAmount = requestData.giftcardAmount;
                    var promocodeAmount = requestData.promocodeAmount;
                    var orderSubtotal = parseInt(requestData.orderSubtotal);
                    var vatAmount = requestData.vatAmount;
                    var loyaltyAmount = requestData.loyaltyAmount;
                    var loyaltyRefno = requestData.loyaltyRefno || "";
                    var branch_id = requestData.branch_id;
                    var orderNotes = requestData.order_notes;
                    var rewardDeductionAmount =
                      requestData.rewardDeductionAmount;

                    checkCartForBreakFastItems(userId).then((bitemCount) => {
                      console.log("bitemCount : ", bitemCount);
                      if (bitemCount > 0) {
                        var message =
                          "Breakfast products are available before 12PM only.";
                        Utils.makeResponse(
                          res,
                          false,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        checkCartForGenerousBigMealsItems(userId).then(
                          (gitemCount) => {
                            console.log("gitemCount : ", gitemCount);
                            if (gitemCount > 0) {
                              var message =
                                "Generous Big Meal products are available after 11AM only.";
                              Utils.makeResponse(
                                res,
                                false,
                                200,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              if (userId == 0) {
                                var isGuestUser = "1";
                              } else {
                                var isGuestUser = "0";
                              }
                              var deliveryAmount = 0;
                              if (
                                requestData.deliveryAmount != undefined ||
                                requestData.deliveryAmount != ""
                              ) {
                                deliveryAmount = requestData.deliveryAmount;
                              }
                              if (pickUpType == 0) {
                                //****  In case of dilevery, later admin will update from admin panel  ****//
                                var branchId = branch_id;
                              } else {
                                //****  In case of take away  ****//
                                var branchId = addressId;
                              }
                              console.log("pickUpType : ", pickUpType);
                              console.log("orderSubtotal : ", orderSubtotal);
                              if (
                                pickUpType == 0 &&
                                orderSubtotal +
                                rewardDeductionAmount +
                                loyaltyAmount +
                                promocodeAmount +
                                giftcardAmount <
                                10500
                              ) {
                                var message =
                                  "Minimum order value for delivery to be 10,500 UGX!";
                                console.log(message);
                                Utils.makeResponse(
                                  res,
                                  false,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                                return false;
                              }

                              getDriverIncentive().then(function (incentive) {
                                checkCartForBreakFastItems(
                                  userId,
                                  deviceId
                                ).then((itemCount) => {
                                  // var status;
                                  console.log("Incentive : ", incentive);
                                  console.log("itemCount : ", itemCount);

                                  if (itemCount > 0) {
                                    var message =
                                      "Breakfast products are available before 12PM only.";
                                    Utils.makeResponse(
                                      res,
                                      false,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    if (paymentMode == 1) {
                                      var query =
                                        "insert into temp_orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    } else {
                                      var query =
                                        "insert into orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    }
                                    if (pickUpType == 1) {
                                      incentive = 0;
                                    }
                                    poolConnection.query(
                                      query,
                                      [
                                        userId,
                                        "0",
                                        "0",
                                        "0",
                                        addressId,
                                        branchId,
                                        isGuestUser,
                                        deviceId,
                                        "0",
                                        paymentMode,
                                        pickUpType,
                                        "0",
                                        "2",
                                        "0",
                                        "0",
                                        "0",
                                        "0",
                                        giftcardId,
                                        promocodeId,
                                        loyaltyRefno,
                                        giftcardAmount,
                                        promocodeAmount,
                                        loyaltyAmount,
                                        incentive,
                                        orderNotes,
                                        rewardDeductionAmount,
                                      ],
                                      function (err, result) {
                                        //poolConnection.query(query, [userId, driverId, '0', status, addressId, branchId, isGuestUser, deviceId, '0', paymentMode, pickUpType, '0', '2', '0', '0', '0', '0', giftcardId, promocodeId, loyaltyRefno, giftcardAmount, promocodeAmount, loyaltyAmount, incentive], function (err, result) {
                                        if (err) {
                                          console.log("err1=" + err);
                                          return false;
                                          poolConnection.rollback(function () {
                                            if (
                                              connection._freeConnections.indexOf(
                                                poolConnection
                                              ) == "-1"
                                            ) {
                                              poolConnection.release();
                                            }
                                            var message =
                                              languages.something_went_wrong[
                                              lang
                                              ];
                                            Utils.makeResponse(
                                              res,
                                              false,
                                              400,
                                              message,
                                              appVersion,
                                              data
                                            );
                                          });
                                        } else {
                                          var orderId = result.insertId;
                                          console.log("orderId : ", orderId);

                                          var guest;
                                          if (userId == 0) {
                                            guest = 1;
                                          } else {
                                            guest = 0;
                                          }
                                          // if(driverId != 0){
                                          //     var query = 'insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now()),(?,?,?,?,now(),now())';
                                          //     var params = [orderId, userId, guest, 'Placed', orderId, userId, guest, 'Assigned To Driver'];
                                          // }else{
                                          var query =
                                            "insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now())";
                                          var params = [
                                            orderId,
                                            userId,
                                            guest,
                                            "Placed",
                                          ];
                                          // }

                                          poolConnection.query(
                                            query,
                                            params,
                                            function (err, result) {
                                              if (err) {
                                                console.log("err1=" + err);
                                                poolConnection.rollback(
                                                  function () {
                                                    if (
                                                      connection._freeConnections.indexOf(
                                                        poolConnection
                                                      ) == "-1"
                                                    ) {
                                                      poolConnection.release();
                                                    }
                                                    var message =
                                                      languages
                                                        .something_went_wrong[
                                                      lang
                                                      ];
                                                    Utils.makeResponse(
                                                      res,
                                                      false,
                                                      400,
                                                      message,
                                                      appVersion,
                                                      data
                                                    );
                                                  }
                                                );
                                              } else {
                                                // if(driverId > 0){

                                                //     poolConnection.query("select id, user_type, device_type, device_token from tbl_driver where id =?", [driverId], function (err, result) {
                                                //         if (err) {
                                                //             console.log(err);
                                                //         } else {
                                                //             var device_token = result[0].device_token;
                                                //             var title = "CafeJavas";
                                                //             var message = " You have 1 new order to deliver.";
                                                //             var customData = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //             };
                                                //             var notificationParams = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "message": message,
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //                 "send_to": "3"
                                                //             };

                                                //             if (result[0].device_type == '1') {
                                                //                 //CODE FOR IOS PUSH NOTIFICATION

                                                //                 Utils.sendiOSPush(poolConnection, notificationParams, device_token, config.CONSTANTS.BUNDLE_ID, title, message, customData).then(function (pushResult, pushError) {
                                                //                     if (pushError) {
                                                //                         console.log("iOS errrorr");

                                                //                     } else {
                                                //                         console.log("herer++++++++++********************");
                                                //                     }
                                                //                 });

                                                //             } else {
                                                //                 //CODE FOR ANDROID PUSH NOTIFICATION

                                                //                 Utils.sendAndroidPush(poolConnection, notificationParams, device_token, title, message, customData).then(function (error, response) {
                                                //                     if (error) {
                                                //                         console.log("Android errrorr");

                                                //                     } else {
                                                //                         //do nothing
                                                //                         console.log("else true customer");
                                                //                         var data = {},
                                                //                                 success = true,
                                                //                                 status = 200,
                                                //                                 message = custom_message;
                                                //                         Util.makeResponse(res, success, status, message, appVersion, data);
                                                //                     }
                                                //                 })

                                                //             }

                                                //         }
                                                //     });

                                                // }

                                                if (
                                                  requestData.isCouponApplied ==
                                                  "1"
                                                ) {
                                                }
                                                console.log(result);

                                                console.log(result.insertId);

                                                if (userId == 0) {
                                                  //****  In case of guest user  ****//
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.device_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.device_id=?  and oi.is_delete='0' and oi.order_id='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  }
                                                } else {
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.user_id=?  and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  }
                                                }

                                                //  console.log(query+paramArray);
                                                poolConnection.query(
                                                  query,
                                                  paramArray,
                                                  function (err, result) {
                                                    if (err) {
                                                      console.log("sss");
                                                      console.log(err);
                                                      poolConnection.rollback(
                                                        function () {
                                                          var message =
                                                            languages
                                                              .something_went_wrong[
                                                            lang
                                                            ];
                                                          Utils.makeResponse(
                                                            res,
                                                            false,
                                                            400,
                                                            message,
                                                            appVersion,
                                                            data
                                                          );
                                                          if (
                                                            connection._freeConnections.indexOf(
                                                              poolConnection
                                                            ) == "-1"
                                                          ) {
                                                            poolConnection.release();
                                                          }
                                                        }
                                                      );
                                                    } else {
                                                      console.log(result);
                                                      getGuestUserId(
                                                        userId,
                                                        deviceId,
                                                        loyaltyAmount
                                                      )
                                                        .then(function (
                                                          newUserId
                                                        ) {
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          console.log(
                                                            newUserId
                                                          );
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          if (
                                                            newUserId ||
                                                            newUserId == 0
                                                          ) {
                                                            if (
                                                              paymentMode == 1
                                                            ) {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where temp_order_id=?";
                                                            } else {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where order_id=?";
                                                            }
                                                            poolConnection.query(
                                                              query,
                                                              [orderId],
                                                              function (
                                                                err,
                                                                result0
                                                              ) {
                                                                if (err) {
                                                                  console.log(
                                                                    "bb"
                                                                  );
                                                                  console.log(
                                                                    err
                                                                  );
                                                                  poolConnection.rollback(
                                                                    function () {
                                                                      var message =
                                                                        languages
                                                                          .something_went_wrong[
                                                                        lang
                                                                        ];
                                                                      Utils.makeResponse(
                                                                        res,
                                                                        false,
                                                                        400,
                                                                        message,
                                                                        appVersion,
                                                                        data
                                                                      );
                                                                      if (
                                                                        connection._freeConnections.indexOf(
                                                                          poolConnection
                                                                        ) ==
                                                                        "-1"
                                                                      ) {
                                                                        poolConnection.release();
                                                                      }
                                                                    }
                                                                  );
                                                                } else {
                                                                  console.log(
                                                                    result0
                                                                  );

                                                                  var orderNumber =
                                                                    "CAFEJAVAS_" +
                                                                    orderId;
                                                                  //****  total will be subtotal + service fee + delivery fee(deliver fee and service fee will be added later by admin panel)  ****//
                                                                  if (
                                                                    paymentMode ==
                                                                    1
                                                                  ) {
                                                                    var query =
                                                                      "update temp_orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=? where temp_order_id=? ";
                                                                  } else {
                                                                    var query =
                                                                      "update orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=?, payment_status='1' where order_id=? ";
                                                                  }
                                                                  console.log(
                                                                    result0
                                                                  );
                                                                  //                                                            var totalAmount = parseInt(result0[0].subtotal) - (parseInt(giftcardAmount) + parseInt(loyaltyAmount) + parseInt(promocodeAmount));
                                                                  var totalAmount =
                                                                    parseInt(
                                                                      result0[0]
                                                                        .subtotal
                                                                    ) -
                                                                    parseInt(
                                                                      rewardDeductionAmount
                                                                    ) +
                                                                    parseInt(
                                                                      deliveryAmount
                                                                    ) -
                                                                    (parseInt(
                                                                      giftcardAmount
                                                                    ) +
                                                                      parseInt(
                                                                        loyaltyAmount
                                                                      ) +
                                                                      parseInt(
                                                                        promocodeAmount
                                                                      ));
                                                                  console.log(
                                                                    "SubtotalAmount==" +
                                                                    result0[0]
                                                                      .subtotal
                                                                  );
                                                                  console.log(
                                                                    "giftcardAmount==" +
                                                                    giftcardAmount
                                                                  );
                                                                  console.log(
                                                                    "promocodeAmount==" +
                                                                    promocodeAmount
                                                                  );
                                                                  console.log(
                                                                    "totalAmount==" +
                                                                    totalAmount
                                                                  );
                                                                  console.log(
                                                                    "orderSubtotal==" +
                                                                    orderSubtotal
                                                                  );
                                                                  console.log(
                                                                    "deliveryAmount==" +
                                                                    deliveryAmount
                                                                  );
                                                                  console.log(
                                                                    "vatAmount==" +
                                                                    vatAmount
                                                                  );
                                                                  if (
                                                                    parseInt(
                                                                      totalAmount
                                                                    ) ==
                                                                    parseInt(
                                                                      orderSubtotal
                                                                    )
                                                                  ) {
                                                                    poolConnection.query(
                                                                      query,
                                                                      [
                                                                        orderNumber,
                                                                        newUserId,
                                                                        vatAmount,
                                                                        result0[0]
                                                                          .subtotal -
                                                                        parseInt(
                                                                          rewardDeductionAmount
                                                                        ),
                                                                        totalAmount,
                                                                        parseInt(
                                                                          deliveryAmount
                                                                        ),
                                                                        orderId,
                                                                      ],
                                                                      function (
                                                                        err,
                                                                        result
                                                                      ) {
                                                                        if (
                                                                          err
                                                                        ) {
                                                                          //     console.log("err3="+err);
                                                                          poolConnection.rollback(
                                                                            function () {
                                                                              var message =
                                                                                languages
                                                                                  .something_went_wrong[
                                                                                lang
                                                                                ];
                                                                              Utils.makeResponse(
                                                                                res,
                                                                                false,
                                                                                400,
                                                                                message,
                                                                                appVersion,
                                                                                data
                                                                              );
                                                                              if (
                                                                                connection._freeConnections.indexOf(
                                                                                  poolConnection
                                                                                ) ==
                                                                                "-1"
                                                                              ) {
                                                                                poolConnection.release();
                                                                              }
                                                                            }
                                                                          );
                                                                        } else {
                                                                          console.log(
                                                                            "aaa"
                                                                          );
                                                                          getGiftdeduction(
                                                                            giftcardId,
                                                                            giftcardAmount,
                                                                            paymentMode,
                                                                            userId
                                                                          )
                                                                            .then(
                                                                              function (
                                                                                giftcheck
                                                                              ) {
                                                                                if (
                                                                                  giftcheck
                                                                                ) {
                                                                                  getpromodeduction(
                                                                                    promocodeId,
                                                                                    promocodeAmount,
                                                                                    paymentMode,
                                                                                    userId
                                                                                  )
                                                                                    .then(
                                                                                      function (
                                                                                        promocheck
                                                                                      ) {
                                                                                        if (
                                                                                          promocheck
                                                                                        ) {
                                                                                          poolConnection.commit(
                                                                                            function (
                                                                                              err
                                                                                            ) {
                                                                                              if (
                                                                                                err
                                                                                              ) {
                                                                                                poolConnection.rollback(
                                                                                                  function () {
                                                                                                    if (
                                                                                                      connection._freeConnections.indexOf(
                                                                                                        poolConnection
                                                                                                      ) ==
                                                                                                      "-1"
                                                                                                    ) {
                                                                                                      poolConnection.release();
                                                                                                    }
                                                                                                    var message =
                                                                                                      languages
                                                                                                        .something_went_wrong[
                                                                                                      lang
                                                                                                      ];
                                                                                                    Utils.makeResponse(
                                                                                                      res,
                                                                                                      false,
                                                                                                      400,
                                                                                                      message,
                                                                                                      appVersion,
                                                                                                      data
                                                                                                    );
                                                                                                  }
                                                                                                );
                                                                                              } else {
                                                                                                if (
                                                                                                  paymentMode ==
                                                                                                  2
                                                                                                ) {
                                                                                                  console.log(
                                                                                                    "check of reward product start"
                                                                                                  );
                                                                                                  // updateRewardcount(orderId,userId).then(function (rewardcheck) {
                                                                                                  //     if (rewardcheck) {
                                                                                                  //push notification for guest user
                                                                                                  if (
                                                                                                    userId ==
                                                                                                    0
                                                                                                  ) {
                                                                                                    poolConnection.query(
                                                                                                      "select id,device_token,device_id,device_type from tbl_guest_user where device_id =? order by id desc limit 1",
                                                                                                      [
                                                                                                        deviceId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "guest_user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations ! You have successfully placed your order ID " +
                                                                                                            orderId +
                                                                                                            ".";
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                            send_to:
                                                                                                              "2", //guest user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION

                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  } else {
                                                                                                    //push notification for registered user
                                                                                                    poolConnection.query(
                                                                                                      "select device_token,device_id,device_type from users where user_id =?",
                                                                                                      [
                                                                                                        userId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          console.log(
                                                                                                            " -user" +
                                                                                                            JSON.stringify(
                                                                                                              result
                                                                                                            )
                                                                                                          );
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations......You have successfully placed your order ID " +
                                                                                                            orderId;
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, // order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                            send_to:
                                                                                                              "1", //registered user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION
                                                                                                            //device_token = 'fLEvYLJnXXI:APA91bF4TkEPB1TFIYLfXSa9DCJd8QBq2sRLSW2btXoV_HnMVU6A9G1Hts9UwERmCWEpoxInZqHazE21gbnBYfiOZf5vXXOBV2PTfPd0hDB4kO0xFsdDZc-lDQ5VSsM-XVfZYonazJWC7IF9TdN0wFfLdzaDra-HYQ';
                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr" +
                                                                                                                    error
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  }

                                                                                                  //                                                                                    } else {
                                                                                                  //                                                                                        console.log('ffHIIIIIIIIII');
                                                                                                  //
                                                                                                  //                                                                                        var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                        Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //
                                                                                                  //                                                                                    }

                                                                                                  //                                                                                }).catch(function (err) {
                                                                                                  //                                                                                    console.log("errorrrr1122" + err);
                                                                                                  //                                                                                    poolConnection.rollback(function () {
                                                                                                  //                                                                                    var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                    Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //                                                                                    if (connection._freeConnections.indexOf(poolConnection) == '-1')
                                                                                                  //                                                                                    {
                                                                                                  //                                                                                        poolConnection.release();
                                                                                                  //                                                                                    }
                                                                                                  //
                                                                                                  //                                                                                    });
                                                                                                  //                                                                                });
                                                                                                }

                                                                                                // console.log('Transaction Complete.');
                                                                                                if (
                                                                                                  connection._freeConnections.indexOf(
                                                                                                    poolConnection
                                                                                                  ) ==
                                                                                                  "-1"
                                                                                                ) {
                                                                                                  poolConnection.release();
                                                                                                }

                                                                                                data.orderNumber =
                                                                                                  orderNumber;
                                                                                                data.orderId =
                                                                                                  orderId;
                                                                                                data.pickUpType =
                                                                                                  pickUpType;
                                                                                                data.totalAmount =
                                                                                                  totalAmount;
                                                                                                var message =
                                                                                                  languages
                                                                                                    .success[
                                                                                                  lang
                                                                                                  ];
                                                                                                Utils.makeResponse(
                                                                                                  res,
                                                                                                  true,
                                                                                                  200,
                                                                                                  message,
                                                                                                  appVersion,
                                                                                                  data
                                                                                                );
                                                                                              }
                                                                                            }
                                                                                          );
                                                                                        } else {
                                                                                          poolConnection.rollback(
                                                                                            function () {
                                                                                              console.log(
                                                                                                "dd"
                                                                                              );
                                                                                              //console.log(err);
                                                                                              var message =
                                                                                                languages
                                                                                                  .something_went_wrong[
                                                                                                lang
                                                                                                ];
                                                                                              Utils.makeResponse(
                                                                                                res,
                                                                                                false,
                                                                                                400,
                                                                                                message,
                                                                                                appVersion,
                                                                                                data
                                                                                              );
                                                                                              if (
                                                                                                connection._freeConnections.indexOf(
                                                                                                  poolConnection
                                                                                                ) ==
                                                                                                "-1"
                                                                                              ) {
                                                                                                poolConnection.release();
                                                                                              }
                                                                                              return false;
                                                                                            }
                                                                                          );
                                                                                        }
                                                                                      }
                                                                                    )
                                                                                    .catch(
                                                                                      function (
                                                                                        err
                                                                                      ) {
                                                                                        console.log(
                                                                                          "errorrrr11AA" +
                                                                                          err
                                                                                        );
                                                                                        poolConnection.rollback(
                                                                                          function () {
                                                                                            var message =
                                                                                              languages
                                                                                                .something_went_wrong[
                                                                                              lang
                                                                                              ];
                                                                                            Utils.makeResponse(
                                                                                              res,
                                                                                              false,
                                                                                              400,
                                                                                              message,
                                                                                              appVersion,
                                                                                              data
                                                                                            );
                                                                                            if (
                                                                                              connection._freeConnections.indexOf(
                                                                                                poolConnection
                                                                                              ) ==
                                                                                              "-1"
                                                                                            ) {
                                                                                              poolConnection.release();
                                                                                            }
                                                                                          }
                                                                                        );
                                                                                      }
                                                                                    );
                                                                                } else {
                                                                                  poolConnection.rollback(
                                                                                    function () {
                                                                                      console.log(
                                                                                        "dd"
                                                                                      );
                                                                                      //console.log(err);
                                                                                      var message =
                                                                                        languages
                                                                                          .something_went_wrong[
                                                                                        lang
                                                                                        ];
                                                                                      Utils.makeResponse(
                                                                                        res,
                                                                                        false,
                                                                                        400,
                                                                                        message,
                                                                                        appVersion,
                                                                                        data
                                                                                      );
                                                                                      if (
                                                                                        connection._freeConnections.indexOf(
                                                                                          poolConnection
                                                                                        ) ==
                                                                                        "-1"
                                                                                      ) {
                                                                                        poolConnection.release();
                                                                                      }
                                                                                      return false;
                                                                                    }
                                                                                  );
                                                                                }
                                                                              }
                                                                            )
                                                                            .catch(
                                                                              function (
                                                                                err
                                                                              ) {
                                                                                console.log(
                                                                                  "errorrrr1122" +
                                                                                  err
                                                                                );
                                                                                poolConnection.rollback(
                                                                                  function () {
                                                                                    var message =
                                                                                      languages
                                                                                        .something_went_wrong[
                                                                                      lang
                                                                                      ];
                                                                                    Utils.makeResponse(
                                                                                      res,
                                                                                      false,
                                                                                      400,
                                                                                      message,
                                                                                      appVersion,
                                                                                      data
                                                                                    );
                                                                                    if (
                                                                                      connection._freeConnections.indexOf(
                                                                                        poolConnection
                                                                                      ) ==
                                                                                      "-1"
                                                                                    ) {
                                                                                      poolConnection.release();
                                                                                    }
                                                                                  }
                                                                                );
                                                                              }
                                                                            );
                                                                        }
                                                                      }
                                                                    );

                                                                    //
                                                                  } else {
                                                                    console.log(
                                                                      "ee"
                                                                    );
                                                                    //console.log(err);
                                                                    poolConnection.rollback(
                                                                      function () {
                                                                        var message =
                                                                          languages
                                                                            .something_went_wrong[
                                                                          lang
                                                                          ];
                                                                        Utils.makeResponse(
                                                                          res,
                                                                          false,
                                                                          400,
                                                                          message,
                                                                          appVersion,
                                                                          data
                                                                        );
                                                                        if (
                                                                          connection._freeConnections.indexOf(
                                                                            poolConnection
                                                                          ) ==
                                                                          "-1"
                                                                        ) {
                                                                          poolConnection.release();
                                                                        }
                                                                        return false;
                                                                      }
                                                                    );
                                                                  }
                                                                }
                                                              }
                                                            );
                                                          } else {
                                                            console.log("ff");
                                                            //console.log(err);
                                                            poolConnection.rollback(
                                                              function () {
                                                                var message =
                                                                  languages
                                                                    .something_went_wrong[
                                                                  lang
                                                                  ];
                                                                Utils.makeResponse(
                                                                  res,
                                                                  false,
                                                                  400,
                                                                  message,
                                                                  appVersion,
                                                                  data
                                                                );
                                                                if (
                                                                  connection._freeConnections.indexOf(
                                                                    poolConnection
                                                                  ) == "-1"
                                                                ) {
                                                                  poolConnection.release();
                                                                }
                                                                return false;
                                                              }
                                                            );
                                                          }
                                                        })
                                                        .catch(function (err) {
                                                          console.log(
                                                            "errorrrr1133" + err
                                                          );
                                                          poolConnection.rollback(
                                                            function () {
                                                              var message =
                                                                languages
                                                                  .something_went_wrong[
                                                                lang
                                                                ];
                                                              Utils.makeResponse(
                                                                res,
                                                                false,
                                                                400,
                                                                message,
                                                                appVersion,
                                                                data
                                                              );
                                                              if (
                                                                connection._freeConnections.indexOf(
                                                                  poolConnection
                                                                ) == "-1"
                                                              ) {
                                                                poolConnection.release();
                                                              }
                                                            }
                                                          );
                                                        });
                                                    }
                                                  }
                                                );
                                              }
                                            }
                                          );
                                        }

                                        //});
                                      }
                                    );
                                  }
                                });
                              });
                            }
                          }
                        );
                      }
                    });
                  }
                });

                //});
              }
            });
          }
        } else {
          var message =
            "We are closed for the day. Please order your favorite meal @ 6:00AM tomorrow!";
          Utils.makeResponse(res, false, 400, message, appVersion, data);
          return false;
        }
      } else if (requestData.pickUpType == 1) {
        if (
          currentDay == 1 ||
          currentDay == 2 ||
          currentDay == 3 ||
          currentDay == 4 ||
          currentDay == 7
        ) {
          if (currentHour >= 6 && currentHour < 23) {
            connection.getConnection(function (err, poolConnection) {
              if (err) {
                var message = languages.something_went_wrong[lang];
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                poolConnection.beginTransaction(function (err) {
                  if (err) {
                    console.log(err);
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    console.log("requestData===" + JSON.stringify(requestData));

                    var userId = requestData.userId;
                    var deviceId = requestData.deviceId;
                    var pickUpType = requestData.pickUpType;
                    var addressId = requestData.addressId;
                    var paymentMode = requestData.paymentMode;
                    var giftcardId = requestData.giftcardId;
                    var promocodeId = requestData.promocodeId;
                    var giftcardAmount = requestData.giftcardAmount;
                    var promocodeAmount = requestData.promocodeAmount;
                    var orderSubtotal = parseInt(requestData.orderSubtotal);
                    var vatAmount = requestData.vatAmount;
                    var loyaltyAmount = requestData.loyaltyAmount;
                    var loyaltyRefno = requestData.loyaltyRefno || "";
                    var branch_id = requestData.branch_id;
                    var orderNotes = requestData.order_notes;
                    var rewardDeductionAmount =
                      requestData.rewardDeductionAmount;

                    checkCartForBreakFastItems(userId).then((bitemCount) => {
                      console.log("bitemCount : ", bitemCount);
                      if (bitemCount > 0) {
                        var message =
                          "Breakfast products are available before 12PM only.";
                        Utils.makeResponse(
                          res,
                          false,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        checkCartForGenerousBigMealsItems(userId).then(
                          (gitemCount) => {
                            console.log("gitemCount : ", gitemCount);
                            if (gitemCount > 0) {
                              var message =
                                "Generous Big Meal products are available after 11AM only.";
                              Utils.makeResponse(
                                res,
                                false,
                                200,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              if (userId == 0) {
                                var isGuestUser = "1";
                              } else {
                                var isGuestUser = "0";
                              }
                              var deliveryAmount = 0;
                              if (
                                requestData.deliveryAmount != undefined ||
                                requestData.deliveryAmount != ""
                              ) {
                                deliveryAmount = requestData.deliveryAmount;
                              }
                              if (pickUpType == 0) {
                                //****  In case of dilevery, later admin will update from admin panel  ****//
                                var branchId = branch_id;
                              } else {
                                //****  In case of take away  ****//
                                var branchId = addressId;
                              }
                              console.log("pickUpType : ", pickUpType);
                              console.log("orderSubtotal : ", orderSubtotal);
                              if (
                                pickUpType == 0 &&
                                orderSubtotal +
                                rewardDeductionAmount +
                                loyaltyAmount +
                                promocodeAmount +
                                giftcardAmount <
                                10500
                              ) {
                                var message =
                                  "Minimum order value for delivery to be 10,500 UGX!";
                                console.log(message);
                                Utils.makeResponse(
                                  res,
                                  false,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                                return false;
                              }

                              getDriverIncentive().then(function (incentive) {
                                checkCartForBreakFastItems(
                                  userId,
                                  deviceId
                                ).then((itemCount) => {
                                  // var status;
                                  console.log("Incentive : ", incentive);
                                  console.log("itemCount : ", itemCount);

                                  if (itemCount > 0) {
                                    var message =
                                      "Breakfast products are available before 12PM only.";
                                    Utils.makeResponse(
                                      res,
                                      false,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    if (paymentMode == 1) {
                                      var query =
                                        "insert into temp_orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    } else {
                                      var query =
                                        "insert into orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    }
                                    if (pickUpType == 1) {
                                      incentive = 0;
                                    }
                                    poolConnection.query(
                                      query,
                                      [
                                        userId,
                                        "0",
                                        "0",
                                        "0",
                                        addressId,
                                        branchId,
                                        isGuestUser,
                                        deviceId,
                                        "0",
                                        paymentMode,
                                        pickUpType,
                                        "0",
                                        "2",
                                        "0",
                                        "0",
                                        "0",
                                        "0",
                                        giftcardId,
                                        promocodeId,
                                        loyaltyRefno,
                                        giftcardAmount,
                                        promocodeAmount,
                                        loyaltyAmount,
                                        incentive,
                                        orderNotes,
                                        rewardDeductionAmount,
                                      ],
                                      function (err, result) {
                                        //poolConnection.query(query, [userId, driverId, '0', status, addressId, branchId, isGuestUser, deviceId, '0', paymentMode, pickUpType, '0', '2', '0', '0', '0', '0', giftcardId, promocodeId, loyaltyRefno, giftcardAmount, promocodeAmount, loyaltyAmount, incentive], function (err, result) {
                                        if (err) {
                                          console.log("err1=" + err);
                                          return false;
                                          poolConnection.rollback(function () {
                                            if (
                                              connection._freeConnections.indexOf(
                                                poolConnection
                                              ) == "-1"
                                            ) {
                                              poolConnection.release();
                                            }
                                            var message =
                                              languages.something_went_wrong[
                                              lang
                                              ];
                                            Utils.makeResponse(
                                              res,
                                              false,
                                              400,
                                              message,
                                              appVersion,
                                              data
                                            );
                                          });
                                        } else {
                                          var orderId = result.insertId;
                                          console.log("orderId : ", orderId);

                                          var guest;
                                          if (userId == 0) {
                                            guest = 1;
                                          } else {
                                            guest = 0;
                                          }
                                          // if(driverId != 0){
                                          //     var query = 'insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now()),(?,?,?,?,now(),now())';
                                          //     var params = [orderId, userId, guest, 'Placed', orderId, userId, guest, 'Assigned To Driver'];
                                          // }else{
                                          var query =
                                            "insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now())";
                                          var params = [
                                            orderId,
                                            userId,
                                            guest,
                                            "Placed",
                                          ];
                                          // }

                                          poolConnection.query(
                                            query,
                                            params,
                                            function (err, result) {
                                              if (err) {
                                                console.log("err1=" + err);
                                                poolConnection.rollback(
                                                  function () {
                                                    if (
                                                      connection._freeConnections.indexOf(
                                                        poolConnection
                                                      ) == "-1"
                                                    ) {
                                                      poolConnection.release();
                                                    }
                                                    var message =
                                                      languages
                                                        .something_went_wrong[
                                                      lang
                                                      ];
                                                    Utils.makeResponse(
                                                      res,
                                                      false,
                                                      400,
                                                      message,
                                                      appVersion,
                                                      data
                                                    );
                                                  }
                                                );
                                              } else {
                                                // if(driverId > 0){

                                                //     poolConnection.query("select id, user_type, device_type, device_token from tbl_driver where id =?", [driverId], function (err, result) {
                                                //         if (err) {
                                                //             console.log(err);
                                                //         } else {
                                                //             var device_token = result[0].device_token;
                                                //             var title = "CafeJavas";
                                                //             var message = " You have 1 new order to deliver.";
                                                //             var customData = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //             };
                                                //             var notificationParams = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "message": message,
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //                 "send_to": "3"
                                                //             };

                                                //             if (result[0].device_type == '1') {
                                                //                 //CODE FOR IOS PUSH NOTIFICATION

                                                //                 Utils.sendiOSPush(poolConnection, notificationParams, device_token, config.CONSTANTS.BUNDLE_ID, title, message, customData).then(function (pushResult, pushError) {
                                                //                     if (pushError) {
                                                //                         console.log("iOS errrorr");

                                                //                     } else {
                                                //                         console.log("herer++++++++++********************");
                                                //                     }
                                                //                 });

                                                //             } else {
                                                //                 //CODE FOR ANDROID PUSH NOTIFICATION

                                                //                 Utils.sendAndroidPush(poolConnection, notificationParams, device_token, title, message, customData).then(function (error, response) {
                                                //                     if (error) {
                                                //                         console.log("Android errrorr");

                                                //                     } else {
                                                //                         //do nothing
                                                //                         console.log("else true customer");
                                                //                         var data = {},
                                                //                                 success = true,
                                                //                                 status = 200,
                                                //                                 message = custom_message;
                                                //                         Util.makeResponse(res, success, status, message, appVersion, data);
                                                //                     }
                                                //                 })

                                                //             }

                                                //         }
                                                //     });

                                                // }

                                                if (
                                                  requestData.isCouponApplied ==
                                                  "1"
                                                ) {
                                                }
                                                console.log(result);

                                                console.log(result.insertId);

                                                if (userId == 0) {
                                                  //****  In case of guest user  ****//
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.device_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.device_id=?  and oi.is_delete='0' and oi.order_id='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  }
                                                } else {
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.user_id=?  and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  }
                                                }

                                                //  console.log(query+paramArray);
                                                poolConnection.query(
                                                  query,
                                                  paramArray,
                                                  function (err, result) {
                                                    if (err) {
                                                      console.log("sss");
                                                      console.log(err);
                                                      poolConnection.rollback(
                                                        function () {
                                                          var message =
                                                            languages
                                                              .something_went_wrong[
                                                            lang
                                                            ];
                                                          Utils.makeResponse(
                                                            res,
                                                            false,
                                                            400,
                                                            message,
                                                            appVersion,
                                                            data
                                                          );
                                                          if (
                                                            connection._freeConnections.indexOf(
                                                              poolConnection
                                                            ) == "-1"
                                                          ) {
                                                            poolConnection.release();
                                                          }
                                                        }
                                                      );
                                                    } else {
                                                      console.log(result);
                                                      getGuestUserId(
                                                        userId,
                                                        deviceId,
                                                        loyaltyAmount
                                                      )
                                                        .then(function (
                                                          newUserId
                                                        ) {
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          console.log(
                                                            newUserId
                                                          );
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          if (
                                                            newUserId ||
                                                            newUserId == 0
                                                          ) {
                                                            if (
                                                              paymentMode == 1
                                                            ) {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where temp_order_id=?";
                                                            } else {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where order_id=?";
                                                            }
                                                            poolConnection.query(
                                                              query,
                                                              [orderId],
                                                              function (
                                                                err,
                                                                result0
                                                              ) {
                                                                if (err) {
                                                                  console.log(
                                                                    "bb"
                                                                  );
                                                                  console.log(
                                                                    err
                                                                  );
                                                                  poolConnection.rollback(
                                                                    function () {
                                                                      var message =
                                                                        languages
                                                                          .something_went_wrong[
                                                                        lang
                                                                        ];
                                                                      Utils.makeResponse(
                                                                        res,
                                                                        false,
                                                                        400,
                                                                        message,
                                                                        appVersion,
                                                                        data
                                                                      );
                                                                      if (
                                                                        connection._freeConnections.indexOf(
                                                                          poolConnection
                                                                        ) ==
                                                                        "-1"
                                                                      ) {
                                                                        poolConnection.release();
                                                                      }
                                                                    }
                                                                  );
                                                                } else {
                                                                  console.log(
                                                                    result0
                                                                  );

                                                                  var orderNumber =
                                                                    "CAFEJAVAS_" +
                                                                    orderId;
                                                                  //****  total will be subtotal + service fee + delivery fee(deliver fee and service fee will be added later by admin panel)  ****//
                                                                  if (
                                                                    paymentMode ==
                                                                    1
                                                                  ) {
                                                                    var query =
                                                                      "update temp_orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=? where temp_order_id=? ";
                                                                  } else {
                                                                    var query =
                                                                      "update orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=?, payment_status='1' where order_id=? ";
                                                                  }
                                                                  console.log(
                                                                    result0
                                                                  );
                                                                  //                                                            var totalAmount = parseInt(result0[0].subtotal) - (parseInt(giftcardAmount) + parseInt(loyaltyAmount) + parseInt(promocodeAmount));
                                                                  var totalAmount =
                                                                    parseInt(
                                                                      result0[0]
                                                                        .subtotal
                                                                    ) -
                                                                    parseInt(
                                                                      rewardDeductionAmount
                                                                    ) +
                                                                    parseInt(
                                                                      deliveryAmount
                                                                    ) -
                                                                    (parseInt(
                                                                      giftcardAmount
                                                                    ) +
                                                                      parseInt(
                                                                        loyaltyAmount
                                                                      ) +
                                                                      parseInt(
                                                                        promocodeAmount
                                                                      ));
                                                                  console.log(
                                                                    "SubtotalAmount==" +
                                                                    result0[0]
                                                                      .subtotal
                                                                  );
                                                                  console.log(
                                                                    "giftcardAmount==" +
                                                                    giftcardAmount
                                                                  );
                                                                  console.log(
                                                                    "promocodeAmount==" +
                                                                    promocodeAmount
                                                                  );
                                                                  console.log(
                                                                    "totalAmount==" +
                                                                    totalAmount
                                                                  );
                                                                  console.log(
                                                                    "orderSubtotal==" +
                                                                    orderSubtotal
                                                                  );
                                                                  console.log(
                                                                    "deliveryAmount==" +
                                                                    deliveryAmount
                                                                  );
                                                                  console.log(
                                                                    "vatAmount==" +
                                                                    vatAmount
                                                                  );
                                                                  if (
                                                                    parseInt(
                                                                      totalAmount
                                                                    ) ==
                                                                    parseInt(
                                                                      orderSubtotal
                                                                    )
                                                                  ) {
                                                                    poolConnection.query(
                                                                      query,
                                                                      [
                                                                        orderNumber,
                                                                        newUserId,
                                                                        vatAmount,
                                                                        result0[0]
                                                                          .subtotal -
                                                                        parseInt(
                                                                          rewardDeductionAmount
                                                                        ),
                                                                        totalAmount,
                                                                        parseInt(
                                                                          deliveryAmount
                                                                        ),
                                                                        orderId,
                                                                      ],
                                                                      function (
                                                                        err,
                                                                        result
                                                                      ) {
                                                                        if (
                                                                          err
                                                                        ) {
                                                                          //     console.log("err3="+err);
                                                                          poolConnection.rollback(
                                                                            function () {
                                                                              var message =
                                                                                languages
                                                                                  .something_went_wrong[
                                                                                lang
                                                                                ];
                                                                              Utils.makeResponse(
                                                                                res,
                                                                                false,
                                                                                400,
                                                                                message,
                                                                                appVersion,
                                                                                data
                                                                              );
                                                                              if (
                                                                                connection._freeConnections.indexOf(
                                                                                  poolConnection
                                                                                ) ==
                                                                                "-1"
                                                                              ) {
                                                                                poolConnection.release();
                                                                              }
                                                                            }
                                                                          );
                                                                        } else {
                                                                          console.log(
                                                                            "aaa"
                                                                          );
                                                                          getGiftdeduction(
                                                                            giftcardId,
                                                                            giftcardAmount,
                                                                            paymentMode,
                                                                            userId
                                                                          )
                                                                            .then(
                                                                              function (
                                                                                giftcheck
                                                                              ) {
                                                                                if (
                                                                                  giftcheck
                                                                                ) {
                                                                                  getpromodeduction(
                                                                                    promocodeId,
                                                                                    promocodeAmount,
                                                                                    paymentMode,
                                                                                    userId
                                                                                  )
                                                                                    .then(
                                                                                      function (
                                                                                        promocheck
                                                                                      ) {
                                                                                        if (
                                                                                          promocheck
                                                                                        ) {
                                                                                          poolConnection.commit(
                                                                                            function (
                                                                                              err
                                                                                            ) {
                                                                                              if (
                                                                                                err
                                                                                              ) {
                                                                                                poolConnection.rollback(
                                                                                                  function () {
                                                                                                    if (
                                                                                                      connection._freeConnections.indexOf(
                                                                                                        poolConnection
                                                                                                      ) ==
                                                                                                      "-1"
                                                                                                    ) {
                                                                                                      poolConnection.release();
                                                                                                    }
                                                                                                    var message =
                                                                                                      languages
                                                                                                        .something_went_wrong[
                                                                                                      lang
                                                                                                      ];
                                                                                                    Utils.makeResponse(
                                                                                                      res,
                                                                                                      false,
                                                                                                      400,
                                                                                                      message,
                                                                                                      appVersion,
                                                                                                      data
                                                                                                    );
                                                                                                  }
                                                                                                );
                                                                                              } else {
                                                                                                if (
                                                                                                  paymentMode ==
                                                                                                  2
                                                                                                ) {
                                                                                                  console.log(
                                                                                                    "check of reward product start"
                                                                                                  );
                                                                                                  // updateRewardcount(orderId,userId).then(function (rewardcheck) {
                                                                                                  //     if (rewardcheck) {
                                                                                                  //push notification for guest user
                                                                                                  if (
                                                                                                    userId ==
                                                                                                    0
                                                                                                  ) {
                                                                                                    poolConnection.query(
                                                                                                      "select id,device_token,device_id,device_type from tbl_guest_user where device_id =? order by id desc limit 1",
                                                                                                      [
                                                                                                        deviceId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "guest_user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations ! You have successfully placed your order ID " +
                                                                                                            orderId +
                                                                                                            ".";
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                            send_to:
                                                                                                              "2", //guest user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION

                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  } else {
                                                                                                    //push notification for registered user
                                                                                                    poolConnection.query(
                                                                                                      "select device_token,device_id,device_type from users where user_id =?",
                                                                                                      [
                                                                                                        userId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          console.log(
                                                                                                            " -user" +
                                                                                                            JSON.stringify(
                                                                                                              result
                                                                                                            )
                                                                                                          );
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations......You have successfully placed your order ID " +
                                                                                                            orderId;
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, // order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                            send_to:
                                                                                                              "1", //registered user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION
                                                                                                            //device_token = 'fLEvYLJnXXI:APA91bF4TkEPB1TFIYLfXSa9DCJd8QBq2sRLSW2btXoV_HnMVU6A9G1Hts9UwERmCWEpoxInZqHazE21gbnBYfiOZf5vXXOBV2PTfPd0hDB4kO0xFsdDZc-lDQ5VSsM-XVfZYonazJWC7IF9TdN0wFfLdzaDra-HYQ';
                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr" +
                                                                                                                    error
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  }

                                                                                                  //                                                                                    } else {
                                                                                                  //                                                                                        console.log('ffHIIIIIIIIII');
                                                                                                  //
                                                                                                  //                                                                                        var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                        Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //
                                                                                                  //                                                                                    }

                                                                                                  //                                                                                }).catch(function (err) {
                                                                                                  //                                                                                    console.log("errorrrr1122" + err);
                                                                                                  //                                                                                    poolConnection.rollback(function () {
                                                                                                  //                                                                                    var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                    Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //                                                                                    if (connection._freeConnections.indexOf(poolConnection) == '-1')
                                                                                                  //                                                                                    {
                                                                                                  //                                                                                        poolConnection.release();
                                                                                                  //                                                                                    }
                                                                                                  //
                                                                                                  //                                                                                    });
                                                                                                  //                                                                                });
                                                                                                }

                                                                                                // console.log('Transaction Complete.');
                                                                                                if (
                                                                                                  connection._freeConnections.indexOf(
                                                                                                    poolConnection
                                                                                                  ) ==
                                                                                                  "-1"
                                                                                                ) {
                                                                                                  poolConnection.release();
                                                                                                }

                                                                                                data.orderNumber =
                                                                                                  orderNumber;
                                                                                                data.orderId =
                                                                                                  orderId;
                                                                                                data.pickUpType =
                                                                                                  pickUpType;
                                                                                                data.totalAmount =
                                                                                                  totalAmount;
                                                                                                var message =
                                                                                                  languages
                                                                                                    .success[
                                                                                                  lang
                                                                                                  ];
                                                                                                Utils.makeResponse(
                                                                                                  res,
                                                                                                  true,
                                                                                                  200,
                                                                                                  message,
                                                                                                  appVersion,
                                                                                                  data
                                                                                                );
                                                                                              }
                                                                                            }
                                                                                          );
                                                                                        } else {
                                                                                          poolConnection.rollback(
                                                                                            function () {
                                                                                              console.log(
                                                                                                "dd"
                                                                                              );
                                                                                              //console.log(err);
                                                                                              var message =
                                                                                                languages
                                                                                                  .something_went_wrong[
                                                                                                lang
                                                                                                ];
                                                                                              Utils.makeResponse(
                                                                                                res,
                                                                                                false,
                                                                                                400,
                                                                                                message,
                                                                                                appVersion,
                                                                                                data
                                                                                              );
                                                                                              if (
                                                                                                connection._freeConnections.indexOf(
                                                                                                  poolConnection
                                                                                                ) ==
                                                                                                "-1"
                                                                                              ) {
                                                                                                poolConnection.release();
                                                                                              }
                                                                                              return false;
                                                                                            }
                                                                                          );
                                                                                        }
                                                                                      }
                                                                                    )
                                                                                    .catch(
                                                                                      function (
                                                                                        err
                                                                                      ) {
                                                                                        console.log(
                                                                                          "errorrrr11AA" +
                                                                                          err
                                                                                        );
                                                                                        poolConnection.rollback(
                                                                                          function () {
                                                                                            var message =
                                                                                              languages
                                                                                                .something_went_wrong[
                                                                                              lang
                                                                                              ];
                                                                                            Utils.makeResponse(
                                                                                              res,
                                                                                              false,
                                                                                              400,
                                                                                              message,
                                                                                              appVersion,
                                                                                              data
                                                                                            );
                                                                                            if (
                                                                                              connection._freeConnections.indexOf(
                                                                                                poolConnection
                                                                                              ) ==
                                                                                              "-1"
                                                                                            ) {
                                                                                              poolConnection.release();
                                                                                            }
                                                                                          }
                                                                                        );
                                                                                      }
                                                                                    );
                                                                                } else {
                                                                                  poolConnection.rollback(
                                                                                    function () {
                                                                                      console.log(
                                                                                        "dd"
                                                                                      );
                                                                                      //console.log(err);
                                                                                      var message =
                                                                                        languages
                                                                                          .something_went_wrong[
                                                                                        lang
                                                                                        ];
                                                                                      Utils.makeResponse(
                                                                                        res,
                                                                                        false,
                                                                                        400,
                                                                                        message,
                                                                                        appVersion,
                                                                                        data
                                                                                      );
                                                                                      if (
                                                                                        connection._freeConnections.indexOf(
                                                                                          poolConnection
                                                                                        ) ==
                                                                                        "-1"
                                                                                      ) {
                                                                                        poolConnection.release();
                                                                                      }
                                                                                      return false;
                                                                                    }
                                                                                  );
                                                                                }
                                                                              }
                                                                            )
                                                                            .catch(
                                                                              function (
                                                                                err
                                                                              ) {
                                                                                console.log(
                                                                                  "errorrrr1122" +
                                                                                  err
                                                                                );
                                                                                poolConnection.rollback(
                                                                                  function () {
                                                                                    var message =
                                                                                      languages
                                                                                        .something_went_wrong[
                                                                                      lang
                                                                                      ];
                                                                                    Utils.makeResponse(
                                                                                      res,
                                                                                      false,
                                                                                      400,
                                                                                      message,
                                                                                      appVersion,
                                                                                      data
                                                                                    );
                                                                                    if (
                                                                                      connection._freeConnections.indexOf(
                                                                                        poolConnection
                                                                                      ) ==
                                                                                      "-1"
                                                                                    ) {
                                                                                      poolConnection.release();
                                                                                    }
                                                                                  }
                                                                                );
                                                                              }
                                                                            );
                                                                        }
                                                                      }
                                                                    );

                                                                    //
                                                                  } else {
                                                                    console.log(
                                                                      "ee"
                                                                    );
                                                                    //console.log(err);
                                                                    poolConnection.rollback(
                                                                      function () {
                                                                        var message =
                                                                          languages
                                                                            .something_went_wrong[
                                                                          lang
                                                                          ];
                                                                        Utils.makeResponse(
                                                                          res,
                                                                          false,
                                                                          400,
                                                                          message,
                                                                          appVersion,
                                                                          data
                                                                        );
                                                                        if (
                                                                          connection._freeConnections.indexOf(
                                                                            poolConnection
                                                                          ) ==
                                                                          "-1"
                                                                        ) {
                                                                          poolConnection.release();
                                                                        }
                                                                        return false;
                                                                      }
                                                                    );
                                                                  }
                                                                }
                                                              }
                                                            );
                                                          } else {
                                                            console.log("ff");
                                                            //console.log(err);
                                                            poolConnection.rollback(
                                                              function () {
                                                                var message =
                                                                  languages
                                                                    .something_went_wrong[
                                                                  lang
                                                                  ];
                                                                Utils.makeResponse(
                                                                  res,
                                                                  false,
                                                                  400,
                                                                  message,
                                                                  appVersion,
                                                                  data
                                                                );
                                                                if (
                                                                  connection._freeConnections.indexOf(
                                                                    poolConnection
                                                                  ) == "-1"
                                                                ) {
                                                                  poolConnection.release();
                                                                }
                                                                return false;
                                                              }
                                                            );
                                                          }
                                                        })
                                                        .catch(function (err) {
                                                          console.log(
                                                            "errorrrr1133" + err
                                                          );
                                                          poolConnection.rollback(
                                                            function () {
                                                              var message =
                                                                languages
                                                                  .something_went_wrong[
                                                                lang
                                                                ];
                                                              Utils.makeResponse(
                                                                res,
                                                                false,
                                                                400,
                                                                message,
                                                                appVersion,
                                                                data
                                                              );
                                                              if (
                                                                connection._freeConnections.indexOf(
                                                                  poolConnection
                                                                ) == "-1"
                                                              ) {
                                                                poolConnection.release();
                                                              }
                                                            }
                                                          );
                                                        });
                                                    }
                                                  }
                                                );
                                              }
                                            }
                                          );
                                        }

                                        //});
                                      }
                                    );
                                  }
                                });
                              });
                            }
                          }
                        );
                      }
                    });
                  }
                });

                //});
              }
            });
          } else {
            var message =
              "We are closed for the day. Please order your favorite meal @ 6:00AM tomorrow!";
            Utils.makeResponse(res, false, 400, message, appVersion, data);
            return false;
          }
        } else {
          if (currentHour >= 6 && currentHour <= 23) {
            connection.getConnection(function (err, poolConnection) {
              if (err) {
                var message = languages.something_went_wrong[lang];
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                poolConnection.beginTransaction(function (err) {
                  if (err) {
                    console.log(err);
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    console.log("requestData===" + JSON.stringify(requestData));

                    var userId = requestData.userId;
                    var deviceId = requestData.deviceId;
                    var pickUpType = requestData.pickUpType;
                    var addressId = requestData.addressId;
                    var paymentMode = requestData.paymentMode;
                    var giftcardId = requestData.giftcardId;
                    var promocodeId = requestData.promocodeId;
                    var giftcardAmount = requestData.giftcardAmount;
                    var promocodeAmount = requestData.promocodeAmount;
                    var orderSubtotal = parseInt(requestData.orderSubtotal);
                    var vatAmount = requestData.vatAmount;
                    var loyaltyAmount = requestData.loyaltyAmount;
                    var loyaltyRefno = requestData.loyaltyRefno || "";
                    var branch_id = requestData.branch_id;
                    var orderNotes = requestData.order_notes;
                    var rewardDeductionAmount =
                      requestData.rewardDeductionAmount;

                    checkCartForBreakFastItems(userId).then((bitemCount) => {
                      console.log("bitemCount : ", bitemCount);
                      if (bitemCount > 0) {
                        var message =
                          "Breakfast products are available before 12PM only.";
                        Utils.makeResponse(
                          res,
                          false,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      } else {
                        checkCartForGenerousBigMealsItems(userId).then(
                          (gitemCount) => {
                            console.log("gitemCount : ", gitemCount);
                            if (gitemCount > 0) {
                              var message =
                                "Generous Big Meal products are available after 11AM only.";
                              Utils.makeResponse(
                                res,
                                false,
                                200,
                                message,
                                appVersion,
                                data
                              );
                            } else {
                              if (userId == 0) {
                                var isGuestUser = "1";
                              } else {
                                var isGuestUser = "0";
                              }
                              var deliveryAmount = 0;
                              if (
                                requestData.deliveryAmount != undefined ||
                                requestData.deliveryAmount != ""
                              ) {
                                deliveryAmount = requestData.deliveryAmount;
                              }
                              if (pickUpType == 0) {
                                //****  In case of dilevery, later admin will update from admin panel  ****//
                                var branchId = branch_id;
                              } else {
                                //****  In case of take away  ****//
                                var branchId = addressId;
                              }
                              console.log("pickUpType : ", pickUpType);
                              console.log("orderSubtotal : ", orderSubtotal);
                              if (
                                pickUpType == 0 &&
                                orderSubtotal +
                                rewardDeductionAmount +
                                loyaltyAmount +
                                promocodeAmount +
                                giftcardAmount <
                                10500
                              ) {
                                var message =
                                  "Minimum order value for delivery to be 10,500 UGX!";
                                console.log(message);
                                Utils.makeResponse(
                                  res,
                                  false,
                                  200,
                                  message,
                                  appVersion,
                                  data
                                );
                                return false;
                              }

                              getDriverIncentive().then(function (incentive) {
                                checkCartForBreakFastItems(
                                  userId,
                                  deviceId
                                ).then((itemCount) => {
                                  // var status;
                                  console.log("Incentive : ", incentive);
                                  console.log("itemCount : ", itemCount);

                                  if (itemCount > 0) {
                                    var message =
                                      "Breakfast products are available before 12PM only.";
                                    Utils.makeResponse(
                                      res,
                                      false,
                                      200,
                                      message,
                                      appVersion,
                                      data
                                    );
                                  } else {
                                    if (paymentMode == 1) {
                                      var query =
                                        "insert into temp_orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    } else {
                                      var query =
                                        "insert into orders(user_id,driver_id,order_num,status,address_id,branch_id,delivery_date,is_guest_user,device_id,payment_status,payment_mode,pickup_type,is_delete,created_at,service_id,service_fee,delivery_fee,subtotal,total,gift_card_id,promocode_id,redemption_reference_no,gift_amount,promo_amount,loyalty_amount,incentive,order_notes,rewardAmount) values(?,?,?,?,?,?,now(),?,?,?,?,?,?,now(),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                                    }
                                    if (pickUpType == 1) {
                                      incentive = 0;
                                    }
                                    poolConnection.query(
                                      query,
                                      [
                                        userId,
                                        "0",
                                        "0",
                                        "0",
                                        addressId,
                                        branchId,
                                        isGuestUser,
                                        deviceId,
                                        "0",
                                        paymentMode,
                                        pickUpType,
                                        "0",
                                        "2",
                                        "0",
                                        "0",
                                        "0",
                                        "0",
                                        giftcardId,
                                        promocodeId,
                                        loyaltyRefno,
                                        giftcardAmount,
                                        promocodeAmount,
                                        loyaltyAmount,
                                        incentive,
                                        orderNotes,
                                        rewardDeductionAmount,
                                      ],
                                      function (err, result) {
                                        //poolConnection.query(query, [userId, driverId, '0', status, addressId, branchId, isGuestUser, deviceId, '0', paymentMode, pickUpType, '0', '2', '0', '0', '0', '0', giftcardId, promocodeId, loyaltyRefno, giftcardAmount, promocodeAmount, loyaltyAmount, incentive], function (err, result) {
                                        if (err) {
                                          console.log("err1=" + err);
                                          return false;
                                          poolConnection.rollback(function () {
                                            if (
                                              connection._freeConnections.indexOf(
                                                poolConnection
                                              ) == "-1"
                                            ) {
                                              poolConnection.release();
                                            }
                                            var message =
                                              languages.something_went_wrong[
                                              lang
                                              ];
                                            Utils.makeResponse(
                                              res,
                                              false,
                                              400,
                                              message,
                                              appVersion,
                                              data
                                            );
                                          });
                                        } else {
                                          var orderId = result.insertId;
                                          console.log("orderId : ", orderId);

                                          var guest;
                                          if (userId == 0) {
                                            guest = 1;
                                          } else {
                                            guest = 0;
                                          }
                                          // if(driverId != 0){
                                          //     var query = 'insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now()),(?,?,?,?,now(),now())';
                                          //     var params = [orderId, userId, guest, 'Placed', orderId, userId, guest, 'Assigned To Driver'];
                                          // }else{
                                          var query =
                                            "insert into customers_order_status_logs(order_id,customer_id,is_guest,order_status,created_at,updated_at) values(?,?,?,?,now(),now())";
                                          var params = [
                                            orderId,
                                            userId,
                                            guest,
                                            "Placed",
                                          ];
                                          // }

                                          poolConnection.query(
                                            query,
                                            params,
                                            function (err, result) {
                                              if (err) {
                                                console.log("err1=" + err);
                                                poolConnection.rollback(
                                                  function () {
                                                    if (
                                                      connection._freeConnections.indexOf(
                                                        poolConnection
                                                      ) == "-1"
                                                    ) {
                                                      poolConnection.release();
                                                    }
                                                    var message =
                                                      languages
                                                        .something_went_wrong[
                                                      lang
                                                      ];
                                                    Utils.makeResponse(
                                                      res,
                                                      false,
                                                      400,
                                                      message,
                                                      appVersion,
                                                      data
                                                    );
                                                  }
                                                );
                                              } else {
                                                // if(driverId > 0){

                                                //     poolConnection.query("select id, user_type, device_type, device_token from tbl_driver where id =?", [driverId], function (err, result) {
                                                //         if (err) {
                                                //             console.log(err);
                                                //         } else {
                                                //             var device_token = result[0].device_token;
                                                //             var title = "CafeJavas";
                                                //             var message = " You have 1 new order to deliver.";
                                                //             var customData = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //             };
                                                //             var notificationParams = {
                                                //                 "notification_type": '11', //Assigned to Driver
                                                //                 "message": message,
                                                //                 "order_id": orderId,
                                                //                 "user_id": result[0].id,
                                                //                 "send_to": "3"
                                                //             };

                                                //             if (result[0].device_type == '1') {
                                                //                 //CODE FOR IOS PUSH NOTIFICATION

                                                //                 Utils.sendiOSPush(poolConnection, notificationParams, device_token, config.CONSTANTS.BUNDLE_ID, title, message, customData).then(function (pushResult, pushError) {
                                                //                     if (pushError) {
                                                //                         console.log("iOS errrorr");

                                                //                     } else {
                                                //                         console.log("herer++++++++++********************");
                                                //                     }
                                                //                 });

                                                //             } else {
                                                //                 //CODE FOR ANDROID PUSH NOTIFICATION

                                                //                 Utils.sendAndroidPush(poolConnection, notificationParams, device_token, title, message, customData).then(function (error, response) {
                                                //                     if (error) {
                                                //                         console.log("Android errrorr");

                                                //                     } else {
                                                //                         //do nothing
                                                //                         console.log("else true customer");
                                                //                         var data = {},
                                                //                                 success = true,
                                                //                                 status = 200,
                                                //                                 message = custom_message;
                                                //                         Util.makeResponse(res, success, status, message, appVersion, data);
                                                //                     }
                                                //                 })

                                                //             }

                                                //         }
                                                //     });

                                                // }

                                                if (
                                                  requestData.isCouponApplied ==
                                                  "1"
                                                ) {
                                                }
                                                console.log(result);

                                                console.log(result.insertId);

                                                if (userId == 0) {
                                                  //****  In case of guest user  ****//
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.device_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.device_id=?  and oi.is_delete='0' and oi.order_id='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      deviceId,
                                                    ];
                                                  }
                                                } else {
                                                  if (paymentMode == 1) {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.temp_order_id=? where oi.user_id=?  and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  } else {
                                                    var query =
                                                      "update order_items as oi join tbl_products_items as tpi on tpi.product_id=oi.product_id set oi.order_id=?,oi.payment_status='1' where oi.user_id=? and oi.order_id='0' and oi.is_delete='0' and tpi.status='1' and tpi.is_deleted='0'";
                                                    var paramArray = [
                                                      orderId,
                                                      userId,
                                                    ];
                                                  }
                                                }

                                                //  console.log(query+paramArray);
                                                poolConnection.query(
                                                  query,
                                                  paramArray,
                                                  function (err, result) {
                                                    if (err) {
                                                      console.log("sss");
                                                      console.log(err);
                                                      poolConnection.rollback(
                                                        function () {
                                                          var message =
                                                            languages
                                                              .something_went_wrong[
                                                            lang
                                                            ];
                                                          Utils.makeResponse(
                                                            res,
                                                            false,
                                                            400,
                                                            message,
                                                            appVersion,
                                                            data
                                                          );
                                                          if (
                                                            connection._freeConnections.indexOf(
                                                              poolConnection
                                                            ) == "-1"
                                                          ) {
                                                            poolConnection.release();
                                                          }
                                                        }
                                                      );
                                                    } else {
                                                      console.log(result);
                                                      getGuestUserId(
                                                        userId,
                                                        deviceId,
                                                        loyaltyAmount
                                                      )
                                                        .then(function (
                                                          newUserId
                                                        ) {
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          console.log(
                                                            newUserId
                                                          );
                                                          console.log(
                                                            "RahulID"
                                                          );
                                                          if (
                                                            newUserId ||
                                                            newUserId == 0
                                                          ) {
                                                            if (
                                                              paymentMode == 1
                                                            ) {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where temp_order_id=?";
                                                            } else {
                                                              var query =
                                                                "select sum(subtotal * quantity) as subtotal from order_items where order_id=?";
                                                            }
                                                            poolConnection.query(
                                                              query,
                                                              [orderId],
                                                              function (
                                                                err,
                                                                result0
                                                              ) {
                                                                if (err) {
                                                                  console.log(
                                                                    "bb"
                                                                  );
                                                                  console.log(
                                                                    err
                                                                  );
                                                                  poolConnection.rollback(
                                                                    function () {
                                                                      var message =
                                                                        languages
                                                                          .something_went_wrong[
                                                                        lang
                                                                        ];
                                                                      Utils.makeResponse(
                                                                        res,
                                                                        false,
                                                                        400,
                                                                        message,
                                                                        appVersion,
                                                                        data
                                                                      );
                                                                      if (
                                                                        connection._freeConnections.indexOf(
                                                                          poolConnection
                                                                        ) ==
                                                                        "-1"
                                                                      ) {
                                                                        poolConnection.release();
                                                                      }
                                                                    }
                                                                  );
                                                                } else {
                                                                  console.log(
                                                                    result0
                                                                  );

                                                                  var orderNumber =
                                                                    "CAFEJAVAS_" +
                                                                    orderId;
                                                                  //****  total will be subtotal + service fee + delivery fee(deliver fee and service fee will be added later by admin panel)  ****//
                                                                  if (
                                                                    paymentMode ==
                                                                    1
                                                                  ) {
                                                                    var query =
                                                                      "update temp_orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=? where temp_order_id=? ";
                                                                  } else {
                                                                    var query =
                                                                      "update orders set order_num=?,user_id=?,service_fee=?,subtotal=?,total=?, delivery_fee=?, payment_status='1' where order_id=? ";
                                                                  }
                                                                  console.log(
                                                                    result0
                                                                  );
                                                                  //                                                            var totalAmount = parseInt(result0[0].subtotal) - (parseInt(giftcardAmount) + parseInt(loyaltyAmount) + parseInt(promocodeAmount));
                                                                  var totalAmount =
                                                                    parseInt(
                                                                      result0[0]
                                                                        .subtotal
                                                                    ) -
                                                                    parseInt(
                                                                      rewardDeductionAmount
                                                                    ) +
                                                                    parseInt(
                                                                      deliveryAmount
                                                                    ) -
                                                                    (parseInt(
                                                                      giftcardAmount
                                                                    ) +
                                                                      parseInt(
                                                                        loyaltyAmount
                                                                      ) +
                                                                      parseInt(
                                                                        promocodeAmount
                                                                      ));
                                                                  console.log(
                                                                    "SubtotalAmount==" +
                                                                    result0[0]
                                                                      .subtotal
                                                                  );
                                                                  console.log(
                                                                    "giftcardAmount==" +
                                                                    giftcardAmount
                                                                  );
                                                                  console.log(
                                                                    "promocodeAmount==" +
                                                                    promocodeAmount
                                                                  );
                                                                  console.log(
                                                                    "totalAmount==" +
                                                                    totalAmount
                                                                  );
                                                                  console.log(
                                                                    "orderSubtotal==" +
                                                                    orderSubtotal
                                                                  );
                                                                  console.log(
                                                                    "deliveryAmount==" +
                                                                    deliveryAmount
                                                                  );
                                                                  console.log(
                                                                    "vatAmount==" +
                                                                    vatAmount
                                                                  );
                                                                  if (
                                                                    parseInt(
                                                                      totalAmount
                                                                    ) ==
                                                                    parseInt(
                                                                      orderSubtotal
                                                                    )
                                                                  ) {
                                                                    poolConnection.query(
                                                                      query,
                                                                      [
                                                                        orderNumber,
                                                                        newUserId,
                                                                        vatAmount,
                                                                        result0[0]
                                                                          .subtotal -
                                                                        parseInt(
                                                                          rewardDeductionAmount
                                                                        ),
                                                                        totalAmount,
                                                                        parseInt(
                                                                          deliveryAmount
                                                                        ),
                                                                        orderId,
                                                                      ],
                                                                      function (
                                                                        err,
                                                                        result
                                                                      ) {
                                                                        if (
                                                                          err
                                                                        ) {
                                                                          //     console.log("err3="+err);
                                                                          poolConnection.rollback(
                                                                            function () {
                                                                              var message =
                                                                                languages
                                                                                  .something_went_wrong[
                                                                                lang
                                                                                ];
                                                                              Utils.makeResponse(
                                                                                res,
                                                                                false,
                                                                                400,
                                                                                message,
                                                                                appVersion,
                                                                                data
                                                                              );
                                                                              if (
                                                                                connection._freeConnections.indexOf(
                                                                                  poolConnection
                                                                                ) ==
                                                                                "-1"
                                                                              ) {
                                                                                poolConnection.release();
                                                                              }
                                                                            }
                                                                          );
                                                                        } else {
                                                                          console.log(
                                                                            "aaa"
                                                                          );
                                                                          getGiftdeduction(
                                                                            giftcardId,
                                                                            giftcardAmount,
                                                                            paymentMode,
                                                                            userId
                                                                          )
                                                                            .then(
                                                                              function (
                                                                                giftcheck
                                                                              ) {
                                                                                if (
                                                                                  giftcheck
                                                                                ) {
                                                                                  getpromodeduction(
                                                                                    promocodeId,
                                                                                    promocodeAmount,
                                                                                    paymentMode,
                                                                                    userId
                                                                                  )
                                                                                    .then(
                                                                                      function (
                                                                                        promocheck
                                                                                      ) {
                                                                                        if (
                                                                                          promocheck
                                                                                        ) {
                                                                                          poolConnection.commit(
                                                                                            function (
                                                                                              err
                                                                                            ) {
                                                                                              if (
                                                                                                err
                                                                                              ) {
                                                                                                poolConnection.rollback(
                                                                                                  function () {
                                                                                                    if (
                                                                                                      connection._freeConnections.indexOf(
                                                                                                        poolConnection
                                                                                                      ) ==
                                                                                                      "-1"
                                                                                                    ) {
                                                                                                      poolConnection.release();
                                                                                                    }
                                                                                                    var message =
                                                                                                      languages
                                                                                                        .something_went_wrong[
                                                                                                      lang
                                                                                                      ];
                                                                                                    Utils.makeResponse(
                                                                                                      res,
                                                                                                      false,
                                                                                                      400,
                                                                                                      message,
                                                                                                      appVersion,
                                                                                                      data
                                                                                                    );
                                                                                                  }
                                                                                                );
                                                                                              } else {
                                                                                                if (
                                                                                                  paymentMode ==
                                                                                                  2
                                                                                                ) {
                                                                                                  console.log(
                                                                                                    "check of reward product start"
                                                                                                  );
                                                                                                  // updateRewardcount(orderId,userId).then(function (rewardcheck) {
                                                                                                  //     if (rewardcheck) {
                                                                                                  //push notification for guest user
                                                                                                  if (
                                                                                                    userId ==
                                                                                                    0
                                                                                                  ) {
                                                                                                    poolConnection.query(
                                                                                                      "select id,device_token,device_id,device_type from tbl_guest_user where device_id =? order by id desc limit 1",
                                                                                                      [
                                                                                                        deviceId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "guest_user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations ! You have successfully placed your order ID " +
                                                                                                            orderId +
                                                                                                            ".";
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              result[0]
                                                                                                                .id, //guest user id
                                                                                                            send_to:
                                                                                                              "2", //guest user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION

                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  } else {
                                                                                                    //push notification for registered user
                                                                                                    poolConnection.query(
                                                                                                      "select device_token,device_id,device_type from users where user_id =?",
                                                                                                      [
                                                                                                        userId,
                                                                                                      ],
                                                                                                      function (
                                                                                                        err,
                                                                                                        result
                                                                                                      ) {
                                                                                                        if (
                                                                                                          err
                                                                                                        ) {
                                                                                                          console.log(
                                                                                                            "user" +
                                                                                                            err
                                                                                                          );
                                                                                                        } else {
                                                                                                          console.log(
                                                                                                            " -user" +
                                                                                                            JSON.stringify(
                                                                                                              result
                                                                                                            )
                                                                                                          );
                                                                                                          var device_token =
                                                                                                            result[0]
                                                                                                              .device_token;
                                                                                                          var title =
                                                                                                            "CafeJavas";
                                                                                                          var message =
                                                                                                            "Congratulations......You have successfully placed your order ID " +
                                                                                                            orderId;
                                                                                                          var customData =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            order_id:
                                                                                                              orderId, //order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                          };
                                                                                                          var notificationParams =
                                                                                                          {
                                                                                                            notification_type:
                                                                                                              "1", //order placed
                                                                                                            message:
                                                                                                              message,
                                                                                                            order_id:
                                                                                                              orderId, // order id
                                                                                                            user_id:
                                                                                                              userId, //registered user id
                                                                                                            send_to:
                                                                                                              "1", //registered user
                                                                                                          };

                                                                                                          if (
                                                                                                            result[0]
                                                                                                              .device_type ==
                                                                                                            "1"
                                                                                                          ) {
                                                                                                            //CODE FOR IOS PUSH NOTIFICATION

                                                                                                            Utils.sendiOSPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              config
                                                                                                                .CONSTANTS
                                                                                                                .BUNDLE_ID,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                pushResult,
                                                                                                                pushError
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  pushError
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "iOS errrorr"
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  console.log(
                                                                                                                    "herer++++++++++********************"
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          } else {
                                                                                                            //CODE FOR ANDROID PUSH NOTIFICATION
                                                                                                            //device_token = 'fLEvYLJnXXI:APA91bF4TkEPB1TFIYLfXSa9DCJd8QBq2sRLSW2btXoV_HnMVU6A9G1Hts9UwERmCWEpoxInZqHazE21gbnBYfiOZf5vXXOBV2PTfPd0hDB4kO0xFsdDZc-lDQ5VSsM-XVfZYonazJWC7IF9TdN0wFfLdzaDra-HYQ';
                                                                                                            Utils.sendAndroidPush(
                                                                                                              poolConnection,
                                                                                                              notificationParams,
                                                                                                              device_token,
                                                                                                              title,
                                                                                                              message,
                                                                                                              customData
                                                                                                            ).then(
                                                                                                              function (
                                                                                                                error,
                                                                                                                response
                                                                                                              ) {
                                                                                                                if (
                                                                                                                  error
                                                                                                                ) {
                                                                                                                  console.log(
                                                                                                                    "Android errrorr" +
                                                                                                                    error
                                                                                                                  );
                                                                                                                } else {
                                                                                                                  //do nothing
                                                                                                                  console.log(
                                                                                                                    "else true customer"
                                                                                                                  );
                                                                                                                  var data =
                                                                                                                    {},
                                                                                                                    success = true,
                                                                                                                    status = 200,
                                                                                                                    message =
                                                                                                                      custom_message;
                                                                                                                  Util.makeResponse(
                                                                                                                    res,
                                                                                                                    success,
                                                                                                                    status,
                                                                                                                    message,
                                                                                                                    appVersion,
                                                                                                                    data
                                                                                                                  );
                                                                                                                }
                                                                                                              }
                                                                                                            );
                                                                                                          }
                                                                                                        }
                                                                                                      }
                                                                                                    );
                                                                                                  }

                                                                                                  //                                                                                    } else {
                                                                                                  //                                                                                        console.log('ffHIIIIIIIIII');
                                                                                                  //
                                                                                                  //                                                                                        var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                        Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //
                                                                                                  //                                                                                    }

                                                                                                  //                                                                                }).catch(function (err) {
                                                                                                  //                                                                                    console.log("errorrrr1122" + err);
                                                                                                  //                                                                                    poolConnection.rollback(function () {
                                                                                                  //                                                                                    var message = languages.something_went_wrong[lang];
                                                                                                  //                                                                                    Utils.makeResponse(res, false, 400, message, appVersion, data);
                                                                                                  //                                                                                    if (connection._freeConnections.indexOf(poolConnection) == '-1')
                                                                                                  //                                                                                    {
                                                                                                  //                                                                                        poolConnection.release();
                                                                                                  //                                                                                    }
                                                                                                  //
                                                                                                  //                                                                                    });
                                                                                                  //                                                                                });
                                                                                                }

                                                                                                // console.log('Transaction Complete.');
                                                                                                if (
                                                                                                  connection._freeConnections.indexOf(
                                                                                                    poolConnection
                                                                                                  ) ==
                                                                                                  "-1"
                                                                                                ) {
                                                                                                  poolConnection.release();
                                                                                                }

                                                                                                data.orderNumber =
                                                                                                  orderNumber;
                                                                                                data.orderId =
                                                                                                  orderId;
                                                                                                data.pickUpType =
                                                                                                  pickUpType;
                                                                                                data.totalAmount =
                                                                                                  totalAmount;
                                                                                                var message =
                                                                                                  languages
                                                                                                    .success[
                                                                                                  lang
                                                                                                  ];
                                                                                                Utils.makeResponse(
                                                                                                  res,
                                                                                                  true,
                                                                                                  200,
                                                                                                  message,
                                                                                                  appVersion,
                                                                                                  data
                                                                                                );
                                                                                              }
                                                                                            }
                                                                                          );
                                                                                        } else {
                                                                                          poolConnection.rollback(
                                                                                            function () {
                                                                                              console.log(
                                                                                                "dd"
                                                                                              );
                                                                                              //console.log(err);
                                                                                              var message =
                                                                                                languages
                                                                                                  .something_went_wrong[
                                                                                                lang
                                                                                                ];
                                                                                              Utils.makeResponse(
                                                                                                res,
                                                                                                false,
                                                                                                400,
                                                                                                message,
                                                                                                appVersion,
                                                                                                data
                                                                                              );
                                                                                              if (
                                                                                                connection._freeConnections.indexOf(
                                                                                                  poolConnection
                                                                                                ) ==
                                                                                                "-1"
                                                                                              ) {
                                                                                                poolConnection.release();
                                                                                              }
                                                                                              return false;
                                                                                            }
                                                                                          );
                                                                                        }
                                                                                      }
                                                                                    )
                                                                                    .catch(
                                                                                      function (
                                                                                        err
                                                                                      ) {
                                                                                        console.log(
                                                                                          "errorrrr11AA" +
                                                                                          err
                                                                                        );
                                                                                        poolConnection.rollback(
                                                                                          function () {
                                                                                            var message =
                                                                                              languages
                                                                                                .something_went_wrong[
                                                                                              lang
                                                                                              ];
                                                                                            Utils.makeResponse(
                                                                                              res,
                                                                                              false,
                                                                                              400,
                                                                                              message,
                                                                                              appVersion,
                                                                                              data
                                                                                            );
                                                                                            if (
                                                                                              connection._freeConnections.indexOf(
                                                                                                poolConnection
                                                                                              ) ==
                                                                                              "-1"
                                                                                            ) {
                                                                                              poolConnection.release();
                                                                                            }
                                                                                          }
                                                                                        );
                                                                                      }
                                                                                    );
                                                                                } else {
                                                                                  poolConnection.rollback(
                                                                                    function () {
                                                                                      console.log(
                                                                                        "dd"
                                                                                      );
                                                                                      //console.log(err);
                                                                                      var message =
                                                                                        languages
                                                                                          .something_went_wrong[
                                                                                        lang
                                                                                        ];
                                                                                      Utils.makeResponse(
                                                                                        res,
                                                                                        false,
                                                                                        400,
                                                                                        message,
                                                                                        appVersion,
                                                                                        data
                                                                                      );
                                                                                      if (
                                                                                        connection._freeConnections.indexOf(
                                                                                          poolConnection
                                                                                        ) ==
                                                                                        "-1"
                                                                                      ) {
                                                                                        poolConnection.release();
                                                                                      }
                                                                                      return false;
                                                                                    }
                                                                                  );
                                                                                }
                                                                              }
                                                                            )
                                                                            .catch(
                                                                              function (
                                                                                err
                                                                              ) {
                                                                                console.log(
                                                                                  "errorrrr1122" +
                                                                                  err
                                                                                );
                                                                                poolConnection.rollback(
                                                                                  function () {
                                                                                    var message =
                                                                                      languages
                                                                                        .something_went_wrong[
                                                                                      lang
                                                                                      ];
                                                                                    Utils.makeResponse(
                                                                                      res,
                                                                                      false,
                                                                                      400,
                                                                                      message,
                                                                                      appVersion,
                                                                                      data
                                                                                    );
                                                                                    if (
                                                                                      connection._freeConnections.indexOf(
                                                                                        poolConnection
                                                                                      ) ==
                                                                                      "-1"
                                                                                    ) {
                                                                                      poolConnection.release();
                                                                                    }
                                                                                  }
                                                                                );
                                                                              }
                                                                            );
                                                                        }
                                                                      }
                                                                    );

                                                                    //
                                                                  } else {
                                                                    console.log(
                                                                      "ee"
                                                                    );
                                                                    //console.log(err);
                                                                    poolConnection.rollback(
                                                                      function () {
                                                                        var message =
                                                                          languages
                                                                            .something_went_wrong[
                                                                          lang
                                                                          ];
                                                                        Utils.makeResponse(
                                                                          res,
                                                                          false,
                                                                          400,
                                                                          message,
                                                                          appVersion,
                                                                          data
                                                                        );
                                                                        if (
                                                                          connection._freeConnections.indexOf(
                                                                            poolConnection
                                                                          ) ==
                                                                          "-1"
                                                                        ) {
                                                                          poolConnection.release();
                                                                        }
                                                                        return false;
                                                                      }
                                                                    );
                                                                  }
                                                                }
                                                              }
                                                            );
                                                          } else {
                                                            console.log("ff");
                                                            //console.log(err);
                                                            poolConnection.rollback(
                                                              function () {
                                                                var message =
                                                                  languages
                                                                    .something_went_wrong[
                                                                  lang
                                                                  ];
                                                                Utils.makeResponse(
                                                                  res,
                                                                  false,
                                                                  400,
                                                                  message,
                                                                  appVersion,
                                                                  data
                                                                );
                                                                if (
                                                                  connection._freeConnections.indexOf(
                                                                    poolConnection
                                                                  ) == "-1"
                                                                ) {
                                                                  poolConnection.release();
                                                                }
                                                                return false;
                                                              }
                                                            );
                                                          }
                                                        })
                                                        .catch(function (err) {
                                                          console.log(
                                                            "errorrrr1133" + err
                                                          );
                                                          poolConnection.rollback(
                                                            function () {
                                                              var message =
                                                                languages
                                                                  .something_went_wrong[
                                                                lang
                                                                ];
                                                              Utils.makeResponse(
                                                                res,
                                                                false,
                                                                400,
                                                                message,
                                                                appVersion,
                                                                data
                                                              );
                                                              if (
                                                                connection._freeConnections.indexOf(
                                                                  poolConnection
                                                                ) == "-1"
                                                              ) {
                                                                poolConnection.release();
                                                              }
                                                            }
                                                          );
                                                        });
                                                    }
                                                  }
                                                );
                                              }
                                            }
                                          );
                                        }

                                        //});
                                      }
                                    );
                                  }
                                });
                              });
                            }
                          }
                        );
                      }
                    });
                  }
                });

                //});
              }
            });
          } else {
            var message =
              "We are closed for the day. Please order your favorite meal @ 6:00AM tomorrow!";
            Utils.makeResponse(res, false, 400, message, appVersion, data);
            return false;
          }
        }
      }
    }
  });

  /**
     * @api {get} /getCartItemSummary Get summary of items saved in cart
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getCartItemSummary
     * @apiGroup Orders       
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "data": [
     {
     "quantity": 1,
     "product_name": "sd",
     "price": 11,
     "isAvailable": 0
     },
     {
     "quantity": 2,
     "product_name": "Product 2",
     "price": 22,
     "isAvailable": 1
     }
     ],
     "totalPrice": 44
     }
     }
     
     *
     */
  api.get("/getCartItemSummary", function (req, res) {
    console.log("testvishal***************");
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {},
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      if (requestData.userId == 0) {
        var orderItem =
          "select oi.ID as id,oi.product_id,oi.quantity,tpi.product_name,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted, tpi.group_id from order_items oi,tbl_products_items tpi where oi.product_id=tpi.product_id and device_id=? and oi.order_id='0' and is_delete='0' order by oi.created_on asc";
        var paramArray = [requestData.deviceId];
      } else {
        var orderItem =
          "select oi.ID as id,oi.product_id,oi.quantity,tpi.product_name,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted, tpi.group_id from order_items oi,tbl_products_items tpi where oi.product_id=tpi.product_id and user_id=? and oi.order_id='0' and is_delete='0' order by oi.created_on asc";
        var paramArray = [requestData.userId];
      }
      console.log(orderItem + requestData.userId);
      connection.query(orderItem, paramArray, function (err, rows, fields) {
        if (err) {
          console.log("hererererererere", err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          var totalPrice = 0;
          var allOrderItems = [];
          if (rows.length > 0) {
            synceach(
              rows,
              function (item, next) {
                var orderItemData = {};
                var itemTotalCost =
                  item.quantity *
                  (item.basic_product_cost +
                    item.optional_total +
                    item.additional_total);
                orderItemData.quantity = item.quantity;
                orderItemData.product_name = item.product_name;
                orderItemData.price = itemTotalCost;
                if (item.status == 0 || item.is_deleted == 1) {
                  //**** product is either inactive or deleted by admin  ****//
                  orderItemData.isAvailable = 0;
                } else {
                  orderItemData.isAvailable = 1;
                  totalPrice = totalPrice + itemTotalCost;
                }

                allOrderItems.push(orderItemData);
                next(null, item);
              },
              function (err, transformedItems) {
                //get final result from here
                //  console.log("error : "+err);
                finalData.data = allOrderItems;
                finalData.totalPrice = totalPrice;
                message = languages.success[lang];

                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  finalData
                );
              }
            );
          } else {
            finalData.data = rows;
            finalData.totalPrice = totalPrice;
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      });
    }
  });

  /**
   * @api {post} /transaction save user transaction
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName transaction
   * @apiGroup Orders
   * @apiParam {String} userId user id.
   * @apiParam {String} orderId order ID.
   * @apiParam {String} totalAmount order total amount.
   * @apiParam {String} itemDesc item description ex - Food or giftcard.
   * @apiParam {String} isGuestuser (0=NO, 1=Yes).
   * @apiParam {String} type (1=Food, 2=giftcard)
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           "transactionId" : 1
   *           }
   *      }
   *
   */

  api.post("/transaction", function (req, res) {
    var requestParams = req.body;
    //console.log("data="+JSON.stringify(requestParams));
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        orderId: { type: "string" },
        totalAmount: { type: "string" },
        itemDesc: { type: "string" },
        isGuestuser: { type: "string" },
        type: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestParams);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      //var query="call saveUserAddress(?,?,?,?,?,?,?,?,?)";
      var type_used = requestParams.type;
      if (type_used == "1") {
        var query =
          "insert into transactions(user_id,is_guest_user,temp_order_id,type,amount,item_desc,created_at)values(?,?,?,?,?,?,now())";
      } else {
        var query =
          "insert into transactions(user_id,is_guest_user,order_id,type,amount,item_desc,created_at)values(?,?,?,?,?,?,now())";
      }
      connection.query(
        query,
        [
          requestParams.userId,
          requestParams.isGuestuser,
          requestParams.orderId,
          requestParams.type,
          requestParams.totalAmount,
          requestParams.itemDesc,
        ],
        function (err, rows, fields) {
          if (err) {
            console.log("error : " + err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            data.transactionId = rows.insertId;
            console.log("Transaction ID : ", rows.insertId);
            var message = languages.success[lang];

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  // notificationDelete api creation start here

  /**
   * @api {post} /notificationDelete delete user notification
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName notificationDelete
   * @apiGroup Orders
   * @apiParam {String} userId user id.
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Success",
   *           "AppVersion": "1.0.0",
   *           "Result": {
   *           "transactionId" : 1
   *           }
   *      }
   *
   */

  api.post("/notificationDelete", function (req, res) {
    logger.info('EXPRESS: post("/notificationDelete") --> RECEIVED'.event);

    var getrequests = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, getrequests);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      console.log("ss");
      var userId = getrequests.userId;

      // update gift_card_purchase set amount_remaining=?,status='3',updated_at=now() where ID =? and receiver_mail=? and status != '4'

      var notifications =
        'update notifications set is_delete="1" WHERE user_id = ?';

      connection.query(notifications, [userId], function (err, rows, fields) {
        if (err) {
          logger.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          // data = rows;

          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      });
    }
  });

  /**
   * @api {post} /reorder Reorder
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName reorder
   * @apiGroup Orders
   * @apiParam {String} userId ID of user(0 in case of guest user)
   * @apiParam {String} orderId order id
   * @apiParam {String} deviceId Unique device ID of user's device
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *   "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result":  {
   *      "cartItemCount" : 2
   *   }
   *   }
   *
   */
  api.post("/reorder", function (req, res) {
    var requestData = req.body;
    console.log(requestData);
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "String" },
        orderId: { type: "String" },
        deviceId: { type: "String" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      connection.getConnection(function (err, poolConnection) {
        if (err) {
          var message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          var userId = requestData.userId;
          //****  getting all items of order  ****//
          var orderItem =
            "select product_id,quantity,json from order_items where order_id=?";
          poolConnection.query(
            orderItem,
            [requestData.orderId],
            function (err, rows, fields) {
              if (err) {
                console.log(err);
                message = languages.something_went_wrong[lang];
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                poolConnection.beginTransaction(function (err) {
                  if (err) {
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    synceach(
                      rows,
                      function (item, next) {
                        var jsonData = JSON.parse(item.json);
                        console.log("Json : ", item.product_id);
                        console.log("product_id : ", jsonData);
                        console.log("userId : ", userId);

                        updateCartItemPrice(jsonData, item.product_id, userId)
                          .then(function (updatedData) {
                            if (updatedData) {
                              // item.json.data.isAvailable=updatedData[0];
                              //  console.log("updatedData========"+JSON.stringify(jsonData));
                              jsonData = JSON.stringify(updatedData[1]);
                              //                                if(updatedData[0]==1)
                              //                                {
                              var orderItem =
                                "insert into order_items(order_id,product_id,payment_status,quantity,device_id,user_id,basic_product_cost,optional_total,additional_total,subtotal,json,deal_id,created_on) values(?,?,?,?,?,?,?,?,?,?,?,?,now())";
                              connection.query(
                                orderItem,
                                [
                                  "0",
                                  item.product_id,
                                  "0",
                                  item.quantity,
                                  requestData.deviceId,
                                  requestData.userId,
                                  updatedData[2],
                                  updatedData[4],
                                  updatedData[3],
                                  updatedData[5],
                                  jsonData,
                                  "0",
                                ],
                                function (err, rows, fields) {
                                  if (err) {
                                    console.log("error2222" + err);
                                    poolConnection.rollback(function () {
                                      var message =
                                        languages.something_went_wrong[lang];
                                      Utils.makeResponse(
                                        res,
                                        false,
                                        400,
                                        message,
                                        appVersion,
                                        data
                                      );
                                      if (
                                        connection._freeConnections.indexOf(
                                          poolConnection
                                        ) == "-1"
                                      ) {
                                        poolConnection.release();
                                      }
                                      return false;
                                    });
                                  } else {
                                    //jsonData.isAvailabe=updatedData[0];
                                    next(null, item);
                                  }
                                }
                              );
                              //  }
                            } else {
                              console.log("error111111111111");
                              poolConnection.rollback(function () {
                                var message =
                                  languages.something_went_wrong[lang];
                                Utils.makeResponse(
                                  res,
                                  false,
                                  400,
                                  message,
                                  appVersion,
                                  data
                                );
                                if (
                                  connection._freeConnections.indexOf(
                                    poolConnection
                                  ) == "-1"
                                ) {
                                  poolConnection.release();
                                }
                                return false;
                              });
                            }
                          })
                          .catch(function (err) {
                            console.log("error33333" + err);
                            poolConnection.rollback(function () {
                              var message =
                                languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                              if (
                                connection._freeConnections.indexOf(
                                  poolConnection
                                ) == "-1"
                              ) {
                                poolConnection.release();
                              }
                              return false;
                            });
                          });
                      },
                      function (err, transformedItems) {
                        //  console.log("aaaaaaaaaaaaaaaaaaaaaaaaa"+err);
                        poolConnection.commit(function (err) {
                          if (err) {
                            //    console.log("%%%%%%%%%%%%%%%%%"+err);
                            poolConnection.rollback(function () {
                              if (
                                connection._freeConnections.indexOf(
                                  poolConnection
                                ) == "-1"
                              ) {
                                poolConnection.release();
                              }
                              var message =
                                languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                            });
                          } else {
                            if (
                              connection._freeConnections.indexOf(
                                poolConnection
                              ) == "-1"
                            ) {
                              poolConnection.release();
                            }
                            var message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              data
                            );
                          }
                        });
                      }
                    );
                  }
                });
              }
            }
          );
        }
      });
    }
  });

  /**
     * @api {get} /getBranchesForMap Get list of branches
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getBranchesForMap
     * @apiGroup Info Pages       
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result": 
     *   
     [
     {
     "name": "BOMBO ROAD",
     "address": "Kampala Road, Plot 24/26",
     "contactNumber": "+256 392 177284 / 0414 581911",
     "email": "javas.downtown@cafejavas.co.ug",
     "latitude": "28.6208276",
     "longitude": "77.3627677"
     },
     {
     "name": "CAERGEN HOUSE",
     "address": "Parliamentary Avenue",
     "contactNumber": "+256 200 930000 / 0393 000020",
     "email": "javas.cargen@cafejavas.co.ug",
     "latitude": "28.6150932",
     "longitude": "77.3572304"
     }
     ]
     
     * }
     *
     */
  api.get("/getBranchesForMap", function (req, res) {
    logger.info('EXPRESS: get("/getBranchesForMap") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {},
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var branchesQr =
        "select name,address,contact_number as contactNumber,email,latitude,longitude from tbl_branches where is_deleted ='0' and is_active='1'";
      connection.query(branchesQr, function (err, rows, fields) {
        //console.log(rows[0].user_id);
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          Utils.makeResponse(res, true, 200, message, appVersion, rows);
        }
      });
    }
  });

  /**
     * @api {get} /getBranchesDistanceWise Get list of branches on basis of user location
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getBranchesDistanceWise
     * @apiGroup Info Pages       
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     *  @apiParam {String} latitude latitude of user
     *  @apiParam {String} longitude longitude of user
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result": 
     *   [
     {
     "branch_id": 2,
     "name": "CAERGEN HOUSE",
     "address": "Parliamentary Avenue",
     "contactNumber": "+256 200 930000 / 0393 000020",
     "email": "javas.cargen@cafejavas.co.ug",
     "latitude": "28.6150932",
     "longitude": "77.3572304",
     "distanceInKM": "3.690"
     },
     {
     "branch_id": 1,
     "name": "BOMBO ROAD",
     "address": "Kampala Road, Plot 24/26",
     "contactNumber": "+256 392 177284 / 0414 581911",
     "email": "javas.downtown@cafejavas.co.ug",
     "latitude": "28.6208276",
     "longitude": "77.3627677",
     "distanceInKM": "4.470"
     }
     ]
     * }
     *
     */
  api.get("/getBranchesDistanceWise", function (req, res) {
    logger.info('EXPRESS: get("/getBranchesDistanceWise") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        latitude: { type: "Number" },
        longitude: { type: "Number" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var user_id = requestData.user_id;
      if (user_id != undefined && user_id != "") {
        // find cart products
        var orderItems =
          "select oi.ID as id,oi.product_id from order_items oi where  user_id=? and oi.order_id='0' and is_delete='0'";
        connection.query(orderItems, [user_id], function (err1, itemrows) {
          if (err1) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var items = [];
            itemrows.forEach(function (val, i) {
              items[i] = itemrows[i].product_id;
            });
            console.log(items);
            console.log("##############");
            //find the items availability
            var checkbranch =
              "SELECT `branch_id` FROM `tbl_branch_product_availability` WHERE `product_id` IN (" +
              items +
              ")";
            console.log(checkbranch);
            connection.query(checkbranch, [], function (err2, branchrows) {
              if (err2) {
                message = languages.something_went_wrong[lang];
                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                var checkbranch = [];
                branchrows.forEach(function (val, j) {
                  checkbranch[j] = branchrows[j].branch_id;
                });
                console.log(checkbranch);
                console.log("$$$$$$$$$");
                if (checkbranch.length > 0) {
                  var branchesQr =
                    "select branch_id,name,address,contact_number as contactNumber,email,latitude,longitude from tbl_branches where is_deleted ='0' and is_active='1' and branch_id NOT IN (" +
                    checkbranch +
                    ")";
                } else {
                  var branchesQr =
                    "select branch_id,name,address,contact_number as contactNumber,email,latitude,longitude from tbl_branches where is_deleted ='0' and is_active='1'";
                }

                //var branchesQr = "select tbl_branches.branch_id,name,address,contact_number as contactNumber,email,latitude,longitude, IF(max_distance IS NULL,0,max_distance) AS max_distance from tbl_branches LEFT JOIN delivery_charges on delivery_charges.branch_id=tbl_branches.branch_id where is_deleted ='0' and is_active='1'";
                connection.query(branchesQr, function (err, rows, fields) {
                  if (err) {
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    synceach(
                      rows,
                      function (item, next) {
                        //  getDistanceFromLatLon(parseFloat(requestData.latitude),parseFloat(requestData.longitude), parseFloat(item.latitude),parseFloat(item.longitude)).then(function (data) {
                        getDistanceFromLatLon(
                          parseFloat(requestData.latitude),
                          parseFloat(requestData.longitude),
                          parseFloat(item.latitude),
                          parseFloat(item.longitude)
                        )
                          .then(function (data) {
                            if (data) {
                              //****  Convert distance into a string, keeping only three decimals  ****//
                              item.distanceInKM = data.toFixed(3);
                              next(null, item);
                            } else {
                              item.distanceInKM = "0";
                              var nullObj = {};
                              next(null, nullObj);
                            }
                          })
                          .catch(function (err) {
                            item.distanceInKM = "0";
                            var nullObj = {};
                            next(null, nullObj);
                          });
                      },
                      function (err, transformedItems) {
                        rows.sort(function (a, b) {
                          return a.distanceInKM - b.distanceInKM;
                        });
                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          rows
                        );
                      }
                    );
                  }
                });
              }
            });
          }
        });
      } else {
        var branchesQr =
          "select branch_id,name,address,contact_number as contactNumber,email,latitude,longitude from tbl_branches where is_deleted ='0' and is_active='1'";
        //var branchesQr = "select tbl_branches.branch_id,name,address,contact_number as contactNumber,email,latitude,longitude, IF(max_distance IS NULL,0,max_distance) AS max_distance from tbl_branches LEFT JOIN delivery_charges on delivery_charges.branch_id=tbl_branches.branch_id where is_deleted ='0' and is_active='1'";
        connection.query(branchesQr, function (err, rows, fields) {
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            synceach(
              rows,
              function (item, next) {
                //  getDistanceFromLatLon(parseFloat(requestData.latitude),parseFloat(requestData.longitude), parseFloat(item.latitude),parseFloat(item.longitude)).then(function (data) {
                getDistanceFromLatLon(
                  parseFloat(requestData.latitude),
                  parseFloat(requestData.longitude),
                  parseFloat(item.latitude),
                  parseFloat(item.longitude)
                )
                  .then(function (data) {
                    if (data) {
                      //****  Convert distance into a string, keeping only three decimals  ****//
                      item.distanceInKM = data.toFixed(3);
                      next(null, item);
                    } else {
                      item.distanceInKM = "0";
                      var nullObj = {};
                      next(null, nullObj);
                    }
                  })
                  .catch(function (err) {
                    item.distanceInKM = "0";
                    var nullObj = {};
                    next(null, nullObj);
                  });
              },
              function (err, transformedItems) {
                rows.sort(function (a, b) {
                  return a.distanceInKM - b.distanceInKM;
                });
                Utils.makeResponse(res, true, 200, message, appVersion, rows);
              }
            );
          }
        });
      }
    }
  });

  /**
   * @api {put} /updateCartItem Update cart item
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName updateCartItem
   * @apiGroup Orders
   * @apiParam {Number} orderItemId Unique order item ID
   * @apiParam {Number} quantity Number of items user want for this particular product
   * @apiParam {String} userId ID of user(0 in case of guest user)
   * @apiParam {String} deviceId Unique device ID of user's device
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *   "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result":  {
   *   "totalPrice":100,
   *   "serviceFee":0,
   *   "deliveryFee":0,
   *   "itemSubtotal":20
   *   }
   *   }
   *
   */
  api.put("/updateCartItem", function (req, res) {
    var requestData = req.body;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        orderItemId: { type: "number" },
        quantity: { type: "number" },
        userId: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var updateOrderItem =
        "update order_items set quantity=?,updated_on=now() where ID=?";

      connection.query(
        updateOrderItem,
        [requestData.quantity, requestData.orderItemId],
        function (err, rows, fields) {
          if (err) {
            console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var finalData = {};
            var itemSubtotal = 0;

            var cartItem =
              "SELECT subtotal,quantity from order_items where ID=? ";

            connection.query(
              cartItem,
              [requestData.orderItemId],
              function (err1, rows1, fields) {
                if (err1) {
                  console.log(err);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  console.log(rows1);
                  console.log(rows1[0].subtotal);
                  console.log(rows1[0].quantity);
                  itemSubtotal = rows1[0].subtotal * rows1[0].quantity;

                  if (requestData.userId == 0) {
                    var orderItem =
                      "select oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted from order_items as oi,tbl_products_items as tpi where oi.product_id=tpi.product_id and oi.device_id=? and oi.order_id='0' and oi.is_delete='0'";
                    var paramArray = [requestData.deviceId];
                  } else {
                    var orderItem =
                      "select oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted from order_items as oi,tbl_products_items as tpi where oi.product_id=tpi.product_id and oi.user_id=? and oi.order_id='0' and oi.is_delete='0'";
                    var paramArray = [requestData.userId];
                  }
                  connection.query(
                    orderItem,
                    paramArray,
                    function (err, rows, fields) {
                      if (err) {
                        console.log(err);
                        message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          finalData
                        );
                      } else {
                        var totalPrice = 0;
                        var serviceFee = 0;
                        var deliveryFee = 0;
                        if (rows.length > 0) {
                          synceach(
                            rows,
                            function (item, next) {
                              if (item.status == 0 || item.is_deleted == 1) {
                                //**** product is either inactive or deleted by admin  ****//
                                next(null, item);
                              } else {
                                var itemTotalCost =
                                  item.quantity *
                                  (item.basic_product_cost +
                                    item.optional_total +
                                    item.additional_total);
                                totalPrice += itemTotalCost;
                                next(null, item);
                              }
                            },
                            function (err, transformedItems) {
                              finalData.totalPrice = totalPrice;
                              finalData.serviceFee = serviceFee;
                              finalData.deliveryFee = deliveryFee;
                              finalData.itemSubtotal = itemSubtotal;
                              var message = languages.success[lang];
                              console.log(finalData);
                              Utils.makeResponse(
                                res,
                                true,
                                200,
                                message,
                                appVersion,
                                finalData
                              );
                            }
                          );
                        } else {
                          finalData.totalPrice = totalPrice;
                          finalData.serviceFee = serviceFee;
                          finalData.deliveryFee = deliveryFee;
                          finalData.itemSubtotal = itemSubtotal;
                          var message = languages.success[lang];
                          console.log(finalData);
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      }
                    }
                  );
                }
              }
            );
          }
        }
      );
    }
  });

  /**
     * @api {put} /deleteCartItem Delete cart item
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName deleteCartItem
     * @apiGroup Orders    
     * @apiParam {Number} orderItemId Unique order item ID
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result":  {
     "totalPrice": 35,
     "serviceFee": 0,
     "deliveryFee": 0,
     "totalSuggestedProducts":2
     *   }
     *   }
     *
     */
  api.put("/deleteCartItem", function (req, res) {
    var requestData = req.body;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        orderItemId: { type: "number" },
        userId: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var updateOrderItem = "update order_items set is_delete='1' where ID=?";
      connection.query(
        updateOrderItem,
        [requestData.orderItemId],
        function (err, rows, fields) {
          if (err) {
            // console.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            if (requestData.userId == 0) {
              var orderItem =
                "select oi.product_id,oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted from order_items as oi,tbl_products_items as tpi where oi.product_id=tpi.product_id and oi.device_id=? and oi.order_id='0' and oi.is_delete='0'";
              var paramArray = [requestData.deviceId];
            } else {
              var orderItem =
                "select oi.product_id,oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,tpi.status,tpi.is_deleted from order_items as oi,tbl_products_items as tpi where oi.product_id=tpi.product_id and oi.user_id=? and oi.order_id='0' and oi.is_delete='0'";
              var paramArray = [requestData.userId];
            }
            connection.query(
              orderItem,
              paramArray,
              function (err, rows, fields) {
                if (err) {
                  console.log(err);
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    finalData
                  );
                } else {
                  var finalData = {};
                  var totalPrice = 0;
                  var serviceFee = 0;
                  var deliveryFee = 0;
                  var totalSuggestedProducts = 0;
                  var items_count = rows.length;

                  if (rows.length > 0) {
                    var productIds = "";
                    synceach(
                      rows,
                      function (item, next) {
                        var itemTotalCost =
                          item.quantity *
                          (item.basic_product_cost +
                            item.optional_total +
                            item.additional_total);

                        if (item.status == 0 || item.is_deleted == 1) {
                          //**** product is either inactive or deleted by admin  ****//
                        } else {
                          var itemTotalCost =
                            item.quantity *
                            (item.basic_product_cost +
                              item.optional_total +
                              item.additional_total);
                          totalPrice += itemTotalCost;
                        }

                        productIds = productIds + "," + item.product_id;
                        next(null, item);
                      },
                      function (err, transformedItems) {
                        productIds = productIds.substr(
                          1,
                          productIds.length - 1
                        );
                        console.log(productIds);
                        var totalProductsQr =
                          "SELECT COUNT(DISTINCT suggested_product_id) as total from tbl_suggestion as ts,tbl_products_items as tpi WHERE ts.suggested_product_id=tpi.product_id and ts.product_id in(?) and ts.is_delete = '0' and tpi.is_deleted = '0' and tpi.status='1'";

                        connection.query(
                          totalProductsQr,
                          [productIds],
                          function (err1, rows1, fields) {
                            if (err1) {
                              console.log(
                                "error while getting total suggested products : " +
                                err1
                              );
                              finalData.totalPrice = totalPrice;
                              finalData.serviceFee = serviceFee;
                              finalData.deliveryFee = deliveryFee;
                              finalData.totalSuggestedProducts =
                                totalSuggestedProducts;
                              message = languages.success[lang];

                              Utils.makeResponse(
                                res,
                                true,
                                200,
                                message,
                                appVersion,
                                finalData
                              );
                            } else {
                              finalData.totalPrice = totalPrice;
                              finalData.serviceFee = serviceFee;
                              finalData.deliveryFee = deliveryFee;
                              finalData.totalSuggestedProducts = rows1[0].total;
                              finalData.items_count = items_count;
                              var message = languages.success[lang];
                              Utils.makeResponse(
                                res,
                                true,
                                200,
                                message,
                                appVersion,
                                finalData
                              );
                            }
                          }
                        );
                      }
                    );
                  } else {
                    finalData.totalPrice = totalPrice;
                    finalData.serviceFee = serviceFee;
                    finalData.deliveryFee = deliveryFee;
                    finalData.totalSuggestedProducts = totalSuggestedProducts;
                    finalData.items_count = 0;
                    var message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      finalData
                    );
                  }
                }
              }
            );
          }
        }
      );
    }
  });

  /**
     * @api {get} /getCartItemList Get list of items saved in cart
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getCartItemList
     * @apiGroup Orders       
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *   "Success": true,
     *   "Status": 200,
     *   "Message": "Success",
     *   "AppVersion": "1.0.0",
     *   "Result":  {
     "data": [
     {
     "jsonData": {
     "data": {
     "orderItemDetail": {
     "isFavourite": 0,
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg",
     "productId": 1,
     "catId": 1,
     "subCatId": 1,
     "productName": "sd",
     "description": "asdfasdf",
     "price": "60"
     },
     "topextraItems": [
     {
     "topLabelId": 1,
     "labelNames": "Temp1",
     "labelType": 1,
     "labelOption": 1,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 1,
     "labelId": 1,
     "optionName": "Option 1"
     }
     ]
     },
     {
     "topLabelId": 5,
     "labelNames": "Temp2",
     "labelType": 1,
     "labelOption": 2,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 5,
     "labelId": 5,
     "optionName": "Option 5"
     }
     ]
     }
     ],
     "additionalItems": [
     {
     "additionalProductId": 1,
     "itemName": "sdfa",
     "price": "40"
     },
     {
     "additionalProductId": 2,
     "itemName": "Bacon Crumble",
     "price": "60"
     }
     ],
     "customizeTopLabelOptions": [
     {
     "custLabelId": 1,
     "labelNames": "Toppings"
     },
     {
     "custLabelId": 2,
     "labelNames": "Size"
     },
     {
     "custLabelId": 3,
     "labelNames": "Extra"
     }
     ],
     "verticalCustomizeOptionsWithPrice": [
     {
     "custlabelOptionId": 7,
     "labelNames": "Bacon Crumble",
     "selectedOption": [
     {
     "labelNames": "Size",
     "isSelected": 1
     },
     {
     "labelNames": "Extra",
     "isSelected": 0
     }
     ]
     },
     {
     "custlabelOptionId": 8,
     "labelNames": "Green Onions",
     "selectedOption": [
     {
     "labelNames": "Extra",
     "isSelected": 1
     },
     {
     "labelNames": "Size",
     "isSelected": 1
     }
     ]
     }
     ]
     }
     },
     "quantity": 1,
     "basicProductCost": 10,
     "optionalTotal": 0.5,
     "additionalTotal": 0.5,
     "subTotal": 11,
     "orderItemId": 5,
     "isAvailable": 0
     },
     {
     "jsonData": {
     "data": {
     "orderItemDetail": {
     "isFavourite": 0,
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg",
     "productId": 1,
     "catId": 1,
     "subCatId": 1,
     "productName": "sd",
     "description": "asdfasdf",
     "price": "60"
     },
     "topextraItems": [
     {
     "topLabelId": 1,
     "labelNames": "Temp1",
     "labelType": 1,
     "labelOption": 1,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 1,
     "labelId": 1,
     "optionName": "Option 1"
     }
     ]
     },
     {
     "topLabelId": 5,
     "labelNames": "Temp2",
     "labelType": 1,
     "labelOption": 2,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 5,
     "labelId": 5,
     "optionName": "Option 5"
     }
     ]
     }
     ],
     "additionalItems": [
     {
     "additionalProductId": 1,
     "itemName": "sdfa",
     "price": "40"
     },
     {
     "additionalProductId": 2,
     "itemName": "Bacon Crumble",
     "price": "60"
     }
     ],
     "customizeTopLabelOptions": [
     {
     "custLabelId": 1,
     "labelNames": "Toppings"
     },
     {
     "custLabelId": 2,
     "labelNames": "Size"
     },
     {
     "custLabelId": 3,
     "labelNames": "Extra"
     }
     ],
     "verticalCustomizeOptionsWithPrice": [
     {
     "custlabelOptionId": 7,
     "labelNames": "Bacon Crumble",
     "selectedOption": [
     {
     "labelNames": "Size",
     "isSelected": 1
     },
     {
     "labelNames": "Extra",
     "isSelected": 0
     }
     ]
     },
     {
     "custlabelOptionId": 8,
     "labelNames": "Green Onions",
     "selectedOption": [
     {
     "labelNames": "Extra",
     "isSelected": 1
     },
     {
     "labelNames": "Size",
     "isSelected": 1
     }
     ]
     }
     ]
     }
     },
     "quantity": 2,
     "basicProductCost": 10,
     "optionalTotal": 0.5,
     "additionalTotal": 0.5,
     "subTotal": 22,
     "orderItemId": 6,
     "isAvailable": 1
     }
     ],
     "totalPrice": 44,
     "serviceFee": 0,
     "deliveryFee": 0,
     "totalSuggestedProducts" : 2
     }
     }
     *   }
     *
     */
  api.get("/getCartItemList", function (req, res) {
    console.log("@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
    var requestData = req.query;
    var finalData = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {},
    };
    console.log("vishal");
    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      if (requestData.userId == 0) {
        var orderItem =
          "select oi.ID as id,oi.product_id,oi.deal_id,oi.payment_status,oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,oi.json,oi.is_free_reward,tpi.status,tpi.is_deleted, tpi.group_id,rpw.count from order_items as oi,tbl_products_items as tpi left join reward_product_group as rpw on rpw.id=tpi.group_id and rpw.is_active='1' and rpw.is_deleted='0' where oi.product_id=tpi.product_id and oi.device_id=? and oi.order_id='0' and oi.is_delete='0' order by oi.created_on asc";
        var paramArray = [requestData.deviceId];
      } else {
        var orderItem =
          "select oi.ID as id,oi.product_id,oi.deal_id,oi.payment_status,oi.quantity,oi.basic_product_cost,oi.optional_total,oi.additional_total,oi.subtotal,oi.json,oi.is_free_reward,tpi.status,tpi.is_deleted, tpi.group_id,rpw.count from order_items as oi,tbl_products_items as tpi left join reward_product_group as rpw on rpw.id=tpi.group_id and rpw.is_active='1' and rpw.is_deleted='0' where oi.product_id=tpi.product_id and oi.user_id=? and oi.order_id='0' and oi.is_delete='0' order by oi.created_on asc";
        var paramArray = [requestData.userId];
      }
      connection.query(orderItem, paramArray, function (err, rows, fields) {
        if (err) {
          console.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          var totalPrice = 0;
          var allOrderItems = [];
          var serviceFee = 0;
          var deliveryFee = 0;
          var totalSuggestedProducts = 0;
          if (rows.length > 0) {
            var productIds = "";
            synceach(
              rows,
              function (item, next) {
                var orderItemData = {};
                console.log(item.id);
                var itemTotalCost =
                  item.quantity *
                  (item.basic_product_cost +
                    item.optional_total +
                    item.additional_total);
                orderItemData.jsonData = JSON.parse(item.json);
                orderItemData.quantity = item.quantity;
                orderItemData.basicProductCost = item.basic_product_cost;
                orderItemData.optionalTotal = item.optional_total;
                orderItemData.additionalTotal = item.additional_total;
                orderItemData.subTotal = itemTotalCost;
                orderItemData.orderItemId = item.id;
                orderItemData.freeReward = item.is_free_reward;
                orderItemData.dealID = item.deal_id;
                orderItemData.group_id = item.group_id;
                orderItemData.count = item.count;
                console.log(
                  "$$$$$$$$$$$$$$$$$$$" + item.status + item.is_deleted
                );
                if (item.status == 0 || item.is_deleted == 1) {
                  //**** product is either inactive or deleted by admin  ****//
                  orderItemData.isAvailable = 0;
                } else {
                  orderItemData.isAvailable = 1;
                  totalPrice = totalPrice + itemTotalCost;
                }

                allOrderItems.push(orderItemData);
                productIds = productIds + "," + item.product_id;
                next(null, item);
              },
              function (err, transformedItems) {
                productIds = productIds.substr(1, productIds.length - 1);
                console.log(productIds);
                //var totalProductsQr = "SELECT suggested_product_json from tbl_product_suggestions WHERE product_id IN("+productIds+") and is_deleted = '0'";
                var totalProductsQr =
                  "SELECT COUNT(DISTINCT suggested_product_id) as total from tbl_suggestion as ts,tbl_products_items as tpi WHERE ts.suggested_product_id=tpi.product_id and ts.product_id in(?) and ts.is_delete = '0' and tpi.is_deleted = '0' and tpi.status='1'";
                console.log(totalProductsQr);
                connection.query(
                  totalProductsQr,
                  [productIds],
                  function (err1, rows1, fields) {
                    if (err1) {
                      console.log(
                        "error while getting total suggested products : " + err1
                      );
                      finalData.data = allOrderItems;
                      finalData.totalPrice = totalPrice;
                      finalData.serviceFee = serviceFee;
                      finalData.deliveryFee = deliveryFee;
                      finalData.totalSuggestedProducts = totalSuggestedProducts;
                      message = languages.success[lang];

                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    } else {
                      console.log("aaa");
                      var suggestedcount = 0;
                      //                                    if (rows1.length > 0){
                      //
                      //                                    synceach(rows1, function (items, next) {
                      //
                      //
                      //                                               //   console.log(items);
                      //                                                  var suggested = JSON.parse(items.suggested_product_json);
                      //                                                  var other = JSON.stringify(items.suggested_product_json);
                      //                                                   var jsonLenght  = _.size(suggested);
                      //
                      //
                      //                                                   ///console.log(items.suggested_product_json);
                      //                                                   //console.log(suggested.length);
                      //                                                   //console.log('test2');
                      //                                                  //
                      //
                      //                                                 // console.log(Object.keys(suggested));
                      //
                      //                                                  next(null, items);
                      //                                                }, function (err, transformedItems) {
                      //
                      //                                                    finalData.data = allOrderItems;
                      //                                                    finalData.totalPrice = totalPrice;
                      //                                                    finalData.serviceFee = serviceFee;
                      //                                                    finalData.deliveryFee = deliveryFee;
                      //                                                    finalData.totalSuggestedProducts = suggestedcount;
                      //                                               //     console.log(suggestedcount);
                      //                                                    var message = languages.success[lang];
                      //                                                    Utils.makeResponse(res, true, 200, message, appVersion, finalData);
                      //
                      //                                                });
                      //
                      //                                    }

                      finalData.data = allOrderItems;
                      finalData.totalPrice = totalPrice;
                      finalData.serviceFee = serviceFee;
                      finalData.deliveryFee = deliveryFee;
                      finalData.totalSuggestedProducts = rows1[0].total;
                      console.log(finalData);
                      var message = languages.success[lang];
                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  }
                );
              }
            );
          } else {
            finalData.data = rows;
            finalData.totalPrice = totalPrice;
            finalData.serviceFee = serviceFee;
            finalData.deliveryFee = deliveryFee;
            finalData.totalSuggestedProducts = totalSuggestedProducts;
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      });
    }
  });

  /**
   * @api {get} /dealsList List of deals.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName dealsList
   * @apiGroup Products
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": {
   *       "data": [
   *           {
   *           "dealID": 1,
   *           "dealType": 1,
   *           "dealName": off 20%,
   *           "bannerImage": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg",
   *           "productID":224
   *         },
   *         {
   *           "dealID": 2,
   *           "dealType": 1,
   *           "dealName": off 20%,
   *           "bannerImage": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_product_img_42643613.jpg",
   *           "productID":112
   *         }
   *       ]
   *     }
   *
   */

  api.get("/dealsList", function (req, res) {
    logger.info('EXPRESS: post("/dealsList") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var productrequest = req.query;
    var finalData = {};
    var allDealItems = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, productrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 11;
      if (productrequest.page == "1") offset = 0;
      else offset = (productrequest.page - 1) * limit;

      var products =
        'SELECT id as dealID,deal_type as dealType,deal_name as dealName,banner_image as bannerImage,product_id as productID from deals WHERE  is_deleted = "0" order by created_at desc limit ?,?';
      //            console.log(products);
      var q = connection.query(
        products,
        [offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (rows.length > 0) {
            var allDealItems = [];
            synceach(
              rows,
              function (item, next) {
                var dealItems = {};
                var dealID = item.dealID;
                var dealType = item.dealType;
                var dealName = item.dealName;
                var bannerImage = item.bannerImage;
                var productID = item.productID;
                dealItems.dealID = dealID;
                dealItems.dealType = dealType;
                dealItems.dealName = dealName;
                dealItems.bannerImage = bannerImage;
                dealItems.productID = productID;
                allDealItems.push(dealItems);
                next(null, item);
              },
              function (err, transformedItems) {
                finalData = allDealItems;
                message = languages.success[lang];

                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  finalData
                );
              }
            );
          } else {
            finalData = allDealItems;
            message = languages.deal_does_not_exist[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      );
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /checkSocialId ************************************************************************/
  /**
     * @api {post} /checkSocialId checkSocialId
     * @apiDescription register user into the app using socail media.
     * @apiGroup Users
     * @apiName checkSocialId
     * ***************************************************************************************************************************************************************
     * @apiParam (Expected parameters) {string}             email                                           email
     * @apiParam (Expected parameters) {string}             phone                                           phone
     * @apiParam (Expected parameters) {string}             socialType                  socialType (1=>Google, 2=>Facebook)
     * @apiParam (Expected parameters) {string}             socialId                    Social id of g+ or fb
     * @apiParam (Expected parameters) {string}             deviceToken                     deviceToken
     * @apiParam (Expected parameters) {string}             deviceType                  deviceType (1:iOS,2:android)
     * @apiParam (Expected parameters) {string}             deviceId                    deviceId 
     *****************************************************************************************************************************************************************
     * @apiSuccess {Object}                         response                            response object
     * @apiSuccess {Number=0,1}                         response.status                 response status ( 0 for error, 1 for success )
     * @apiSuccess {string}                             [response.message=null]         error message
     * @apiSuccess {Object}                             [response.data=null]            response data
     ****************************************************************************************************************************************************************
     * @apiVersion 0.0.1
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample {json} Success-Response:
     *           {
     "Success": true,
     "Status": 200,
     "Message": "user exists",
     "AppVersion": "1.0.0",
     "Result": [
     {
     "userId": 45,
     "firstName": "nitin",
     "lastName": "shukla",
     "email": "dsfasd5fa@sfa.com",
     "dob": "1994-12-31T18:30:00.000Z",
     "profilePic": "",
     "countryCode": "91",
     "phone": "125d3sdfa",
     "rewards": 0,
     "deviceToken": "sfdasdfa",
     "deviceType": "1",
     "deviceId": "sfasfa3d24sf",
     "userType": "1",
     "otp": 6042,
     "isNotification": "1" (0:Inactive,1: Active),
     "tokenExpirationTime":360,
     "userExists":1
     }
     ],
     } 
     */

  api.post("/checkSocialId", function (req, res) {
    logger.info('EXPRESS: post("/signUp") --> RECEIVED'.event);
    logger.log("%O", req.body);
    var user = req.body;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        socialType: { type: "string" },
        socialId: { type: "string" },
        phone: { type: "string" },
        email: { type: "string", pattern: "email" },
        deviceType: { type: "string" },
        deviceToken: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, user);
    if (!validationresult.valid) {
      message = languages.bad_request[lang];
      logger.log(validationresult.format());
      Utils.makeResponse(
        res,
        false,
        400,
        message,
        appVersion,
        validationresult
      );
    } else {
      if (user.socialType == 1) {
        var checkSocialId =
          'SELECT user_id FROM users where google_social_id=? and is_delete = "0"';
      } else {
        var checkSocialId =
          'SELECT user_id FROM users where facebook_social_id=? and is_delete = "0"';
      }
      connection.query(
        checkSocialId,
        [user.socialId],
        function (errSocialCheck, socialUserData) {
          if (errSocialCheck) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (socialUserData.length > 0) {
            // user exists
            var userId = socialUserData[0]["user_id"];
            var insertUser =
              'update users set is_logged_in="1",device_token=?,device_type=? where user_id=?';
            connection.query(
              insertUser,
              [user.deviceToken, user.deviceType, userId],
              function (erru, updateuser) {
                if (!erru) {
                  //****  setting device_id=0 so that guest user will not see previous saved item  ****//
                  var insertUser =
                    "update orders set user_id=?,device_id=0 where device_id=? and user_id=0";
                  connection.query(
                    insertUser,
                    [userId, user.deviceId],
                    function (erru, updateuser1) {
                      if (!erru) {
                        connection.query(
                          "update order_items set user_id=?,device_id=0 where device_id=? and user_id=0",
                          [userId, user.deviceId],
                          function (erruser1, updateuser2) {
                            if (!erruser1) {
                              connection.query(
                                "call getUserDetailById(?)",
                                [userId],
                                function (erruser, userdata) {
                                  connection.query(
                                    "SELECT MEMBERSHIP_ID FROM T_MEMBER_DATA_MOBILE WHERE UID = ?",
                                    [userId],
                                    function (erruser3, userdata2) {
                                      if (!erruser3) {
                                        if (userdata2.length > 0) {
                                          var membershipId =
                                            userdata2[0].MEMBERSHIP_ID;
                                        } else {
                                          var membershipId = "";
                                        }
                                        userdata[0][0].guestUserId = "0";
                                        userdata[0][0].tokenExpirationTime =
                                          config.CONSTANTS.JWT_EXPIRATION_TIME; // add jwt expiration time
                                        userdata[0][0].membershipId =
                                          membershipId;
                                        userdata[0][0].userExists = 1;

                                        data = userdata[0];
                                        Utils.makeResponse(
                                          res,
                                          true,
                                          200,
                                          "user exists",
                                          appVersion,
                                          data
                                        );
                                      } else {
                                        message =
                                          languages.something_went_wrong[lang];
                                        Utils.makeResponse(
                                          res,
                                          false,
                                          400,
                                          message,
                                          appVersion,
                                          data
                                        );
                                      }
                                    }
                                  );
                                }
                              );
                            } else {
                              message = languages.something_went_wrong[lang];
                              Utils.makeResponse(
                                res,
                                false,
                                400,
                                message,
                                appVersion,
                                data
                              );
                            }
                          }
                        );
                      } e