"use strict";
//tracer

var logger = require("tracer").colorConsole({
  format: [
    "{{timestamp}} (in line: {{line}}) >> {{message}}", //default format
    {
      error:
        "{{timestamp}} <{{title}}> {{message}} (in {{file}}:{{line}})\nCall Stack:\n{{stack}}", // error format
    },
  ],
  dateformat: "HH:MM:ss.L",
  preprocess: function (data) {
    data.title = data.title.toUpperCase();
  },
});

var languages = require("../../locales/languages");
var lang;

/**** Export API V1 ****/

module.exports = function (
  app,
  express,
  connection,
  inspector,
  successStatus,
  status,
  message,
  appVersion,
  data,
  Utils
) {
  //connection.connect();
  var order = express.Router();

  /**** Route not need to check access token ****/

  order.get("/", function (req, res, next) {
    res.status(200).send("Welcome to the Cafe java server!");
  });

  order.use(function (req, res, next) {
    lang = req.headers["language"];
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }
    next();
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {get} /ordersDetail ordersDetail
   * @apiDescription Get order details by order Id and  user Id
   * @apiGroup Orders
   * @apiName ordersDetail
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string} order_id  order_id (Order Id)
   * @apiParam (Expected parameters) {string} user_id  order_id (Order Id)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}  						response       						response object
   * @apiSuccess {Number=0,1}  						response.status   				response status ( 0 for error, 1 for success )
   * @apiSuccess {string}  							[response.message=null]   		error message
   * @apiSuccess {Object}  							[response.data=null]   			response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */
  order.get("/ordersDetail", function (req, res, next) {
    var order_id = req.query.orderId;
    var user_id = req.query.userId;

    var query =
      "select order_id,user_id,driver_id,order_num,status,delivery_date,delivery_time,order_type from orders WHERE order_id=? and user_id=?";
    connection.query(query, [order_id, user_id], function (err, rows, fields) {
      if (err) {
        successStatus = false;
        status = 404;
        data = "";
        message = "" + err;
      } else {
        if (rows.length > 0) {
          var query =
            "select order_items.id,order_items.product_id as product_id,product.product_name,order_items.quantity,order_items.subtotal from order_items left join tbl_products_items as product on order_items.product_id=product.product_id WHERE order_id=?";
          connection.query(
            query,
            [order_id],
            function (error, itemRows, fields) {
              if (error) {
                successStatus = false;
                status = 404;
                data = "";
                message = "" + err;
                Utils.makeResponse(
                  res,
                  successStatus,
                  status,
                  message,
                  appVersion,
                  data
                );
              } else {
                var data = {
                  orderDetails: rows[0],
                  orderItemDetails: itemRows,
                };
                successStatus = true;
                status = 200;
                data = data;
                message = "Records found successfully.";
                Utils.makeResponse(
                  res,
                  successStatus,
                  status,
                  message,
                  appVersion,
                  data
                );
              }
            }
          );
        } else {
          successStatus = false;
          status = 404;
          data = "";
          message = "No record found!";
          Utils.makeResponse(
            res,
            successStatus,
            status,
            message,
            appVersion,
            data
          );
        }
      }
    });
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {post} /getOrderLogs getOrderLogs
   * @apiDescription Get order details by order Id and  user Id
   * @apiGroup Orders
   * @apiName getOrderLogs
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string} order_id  order_id (Order Id)
   * @apiParam (Expected parameters) {string} user_id  order_id (Order Id)
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}  						response       						response object
   * @apiSuccess {Number=0,1}  						response.status   				response status ( 0 for error, 1 for success )
   * @apiSuccess {string}  							[response.message=null]   		error message
   * @apiSuccess {Object}  							[response.data=null]   			response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */
  order.get("/getOrderLogs", function (req, res, next) {
    var order_id = req.query.orderId;

    if (order_id > 0) {
      var query =
        "SELECT * FROM `customers_order_status_logs` WHERE `order_id` = ?";
      connection.query(query, [order_id], function (error, result, fields) {
        if (error) {
          successStatus = false;
          status = 404;
          data = "";
          message = "" + error;
          Utils.makeResponse(
            res,
            successStatus,
            status,
            message,
            appVersion,
            data
          );
        } else {
          var data = {
            orderStatus: result,
          };
          successStatus = true;
          status = 200;
          data = data;
          message = "Records found successfully.";
          Utils.makeResponse(
            res,
            successStatus,
            status,
            message,
            appVersion,
            data
          );
        }
      });
    } else {
      successStatus = false;
      status = 404;
      data = "";
      message = "No record found!";
      Utils.makeResponse(res, successStatus, status, message, appVersion, data);
    }
  });

  return order;
};
