//'use strict';

//tracer
var logger = require("tracer").colorConsole({
  format: [
    "{{timestamp}} (in line: {{line}}) >> {{message}}", //default format
    {
      error:
        "{{timestamp}} <{{title}}> {{message}} (in {{file}}:{{line}})\nCall Stack:\n{{stack}}", // error format
    },
  ],
  dateformat: "HH:MM:ss.L",
  preprocess: function (data) {
    data.title = data.title.toUpperCase();
  },
});

var appVersion = "1.0.0";
var languages = require("../../locales/languages"),
  _ = require("lodash"),
  config = require("../../config/config.js"),
  Promise = require("promise");
var synceach = require("sync-each");
//Auth        = require("../../util/Auth");
var pageLimit = config.CONSTANTS.pageLimit;
var moment = require("moment");
/**** Export API V1 ****/
var lang;
module.exports = function (app, express, connection, inspector, Utils) {
  //connection.connect();
  var product = express.Router();

  product.use(function (req, res, next) {
    lang = req.headers["language"];
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }
    next();
  });

  /**
     * @api {get} /getProductCategory/ Product Category.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getProductCategory
     * @apiGroup Products  
     * @apiParam {String} userId ID of user(0 in case of guest user)
     * @apiParam {String} deviceId Unique device ID of user's device 
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     "Success": true,
     "Status": 200,
     "Message": "",
     "AppVersion": "1.0.0",
     "Result": {
     "header": "asdfsadf",
     "data": [
     {
     "catId": 18,
     "name": "checkCat1",
     "image": "http://localhost/restaurant/admin/public/upload/1526468033.jpg",
     "description": null,
     "created_on": "2018-05-16 16:23:53"
     },
     {
     "catId": 16,
     "name": "sdfsadfa",
     "image": "http://localhost/restaurant/admin/public/upload/1526399252.jpg",
     "description": null,
     "created_on": "2018-05-15 21:17:32"
     },
     {
     "catId": 12,
     "name": "asdfdf",
     "image": "http://localhost/restaurant/admin/public/upload/1526398630.jpg",
     "description": null,
     "created_on": "2018-05-15 21:07:10"
     },
     {
     "catId": 11,
     "name": "BBBBASDSD",
     "image": "http://localhost/restaurant/admin/public/upload/1526398271.jpg",
     "description": null,
     "created_on": "2018-05-15 21:01:11"
     },
     {
     "catId": 2,
     "name": "CAKES",
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_category_img_69883192.jpg",
     "description": "Bring Smile on face of your loved ones with the delicious cakes.",
     "created_on": "2018-03-05 16:13:39"
     },
     {
     "catId": 1,
     "name": "Coffee",
     "image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_category_img_25780904.jpg",
     "description": "Coffee is a brewed drink prepared from roasted coffee beans, which are the seeds of berries from the Coffea plant. The genus Coffea is native to tropical Africa, and Madagascar, the Comoros, Mauritius and Réunion in the Indian Ocean.",
     "created_on": "2018-03-05 16:13:39"
     }
     ],
     "cartItemCount": 2
     }
     }
     *
     */

  product.get("/getProductCategory", function (req, res) {
    logger.info('EXPRESS: post("/getProductCategory") --> RECEIVED'.event);
    const isSecured = req.headers['x-cafejavas-issecured']; // set userid 
    const isNewVersion = req.headers['x-cafejavas-isnewversion']; // set userid 
    const tokenresp = req.decoded;
    if(isNewVersion != 1 && tokenresp.iss == "ANDROID") {
        Utils.makeResponse(res, false, 200, languages.no_access[lang], appVersion, null);
    }
    if(isSecured != 1) {
      Utils.makeResponse(res, false, 200, languages.no_access[lang], appVersion, data);
    }
    var requestData = req.query;
    // console.log(requestData);
    let now = moment();
    let currenthours = parseInt(now.format("h")) + 3;
    let currentminutes = now.format("mm");
    let currentsecond = now.format("ss");

    //         dateFormattedNice.setHours( dateFormattedNice.getHours() + 2 );

    var currentTime = currenthours + ":" + currentminutes + ":" + currentsecond;
    //console.log(currentTime);
    //console.log("date");
    var products =
      'SELECT `id` as catId, `name`, `image`, `description`, `created_on`, start_time, end_time,created_on  FROM `tbl_product_category` where is_active = "1" and is_delete = "0" and start_time < CAST("' +
      currentTime +
      '" AS time) AND end_time > CAST("' +
      currentTime +
      '" AS time) order by created_on asc';
    //        var products = 'SELECT `id` as catId, `name`, `image`, `description`, `created_on` FROM `tbl_product_category` where is_active = "1" and is_delete = "0" order by created_on asc';
    //console.log(products);
    var data = [];
    var message = "";
    var companyId = "1";
    var note_data = "note_data";
    var header =
      'SELECT *  FROM `header_note` where note_type="' +
      companyId +
      '" limit 1';
    connection.query(
      products,
      [currentTime, currentTime],
      function (err, rows, fields) {
        if (err) {
          logger.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          //console.log('total='+rows.length);
          connection.query(header, function (err, index, fields) {
            if (err) {
              logger.log(err);
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, index);
            } else {
              //  console.log('total111='+index.length);
              if (requestData.userId == 0) {
                var orderItem =
                  "select count(*) as total from order_items where device_id=? and order_id='0' and temp_order_id = '0' and is_delete='0'";
                var paramArray = [requestData.deviceId];
              } else {
                var orderItem =
                  "select count(*) as total from order_items where user_id=? and order_id='0' and temp_order_id = '0' and is_delete='0'";
                var paramArray = [requestData.userId];
              }
              //   console.log("aaaaa="+orderItem+paramArray);

              connection.query(
                orderItem,
                paramArray,
                function (err0, rows0, fields) {
                  if (err0) {
                    //    console.log(err0);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    var data = {
                      header: index[0][note_data],
                      data: rows,
                      cartItemCount: rows0[0].total,
                    };

                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                }
              );
            }
          });
        }
      }
    );
  });

  /**
   * @api {get} /getProductSubCategory?categoryId=1 Product Sub Category.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName getProductSubCategory
   * @apiGroup Products
   * @apiParam {String} categoryId product category Id.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "subCatId": 1,
   *           "subCatname": "Marinara",
   *           "description":"",
   *           "image": ""
   *         },
   *         {
   *           "subCatId": 2,
   *           "subCatname": "Margherita",
   *           "description":"",
   *           "subCatimage": ""
   *         }
   *       ]
   *     }
   *
   */

  product.get("/getProductSubCategory", function (req, res) {
    logger.info('EXPRESS: post("/getProductSubCategory") --> RECEIVED'.event);

    var getrequests = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        categoryId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, getrequests);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var noteId = "2";
      var note_data = "note_data";
      var productCatId = getrequests.categoryId;
      if(productCatId == 55){
                var products = 'SELECT `sub_cat_id` as subCatId, `category_id` as catId, `sub_cat_name` as subCatname, `sub_cat_image` as subCatimage,description,created_on FROM `tbl_product_sub_category` WHERE category_id = ? and is_delete = "0" order by sub_cat_order asc';
            
            }else{
                var products = 'SELECT `sub_cat_id` as subCatId, `category_id` as catId, `sub_cat_name` as subCatname, `sub_cat_image` as subCatimage,description,created_on FROM `tbl_product_sub_category` WHERE category_id = ? and is_delete = "0" order by created_on desc';
            
            }
      //var products = 'SELECT `sub_cat_id` as subCatId, `category_id` as catId, `sub_cat_name` as subCatname, `sub_cat_image` as subCatimage,description,created_on FROM `tbl_product_sub_category` WHERE category_id = ? and is_delete = "0" order by created_on desc';
      var headernote =
        'SELECT *  FROM `header_note` where note_type="' + noteId + '" limit 1';
      connection.query(products, [productCatId], function (err, rows, fields) {
        if (err) {
          logger.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else {
          connection.query(headernote, function (err, index, fields) {
            if (err) {
              logger.log(err);
              message = languages.something_went_wrong[lang];
              Utils.makeResponse(res, false, 400, message, appVersion, index);
            } else {
              var data = {
                header: index[0][note_data],
                data: rows,
              };
              var message ="test";
              Utils.makeResponse(res, true, 200, message, appVersion, data);
            }
          });

          //data = rows;

          //Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      });
    }
  });

  /**
   * @api {get} /getProducts?subCatId=1 List of products.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName getProducts
   * @apiGroup Products
   * @apiParam {String} catId Category Id.
   * @apiParam {String} subCatId Subcategory Id.
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "productId": 1,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Marinara",
   *           "description":"",
   *           "image": "",
   *           "price":"50",
   *           "isNewProduct":"1" (1:Yes,0:No)
   *         },
   *         {
   *           "productId": 2,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Margherita",
   *           "description":"",
   *           "image": "",
   *           "price": "60",
   *           "isNewProduct": "0" (1:Yes,0:No)
   *         }
   *       ]
   *     }
   *
   */

  product.get("/getProducts", function (req, res) {
    logger.info('EXPRESS: post("/getProducts") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var productrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        subCatId: { type: "string" },
        catId: { type: "string" },
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, productrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 20;
      if (productrequest.page == "1") offset = 0;
      else offset = (productrequest.page - 1) * limit;

      // var products = 'SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,`product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price`, (case when DATE_ADD(created_at, INTERVAL 1 DAY) > now() then "1" else "0" end) as isNewProduct FROM `tbl_products_items` as tpi WHERE subcategory_id =? and  category_id=? and is_deleted = "0" and status="1" order by created_at desc limit ?,?';
      var products =
        'SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,`product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price`, (case when DATE_ADD(created_at, INTERVAL 1 DAY) > now() then "1" else "0" end) as isNewProduct,tpi.sequence  FROM `tbl_products_items` as tpi WHERE subcategory_id =? and  category_id=? and is_deleted = "0" and status="1" order by tpi.sequence asc limit ?,?';
      //var subCatDetails = 'SELECT sub_cat_image FROM restaurantdev.tbl_product_sub_category where sub_cat_id = ?';
      //console.log(productrequest);
      var q = connection.query(
        products,
        [productrequest.subCatId, productrequest.catId, offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          data = rows;
          if (rows.length > 0) {
            message = languages.success[lang];
          } else {
            message = languages.no_product_found[lang];
          }

          Utils.makeResponse(res, true, 200, message, appVersion, data);

          // connection.query(subCatDetails,[productrequest.subCatId], function (err, index, fields) {
          //     console.log('In here');
          //     if (err) {
          //         logger.log(err);
          //         message = languages.something_went_wrong[lang];
          //         Utils.makeResponse(res, false, 400, message, appVersion, data);
          //     } else {
          //         if (rows.length > 0) {
          //             message = languages.success[lang];

          //             var data = {
          //                "header": index[0].sub_cat_image,
          //                "data": rows
          //             };

          //             Utils.makeResponse(res, true, 200, message, appVersion, data);
          //         } else {
          //             message = languages.no_product_found[lang];
          //             Utils.makeResponse(res, true, 200, message, appVersion, data);

          //         }
          //     }
          // });
        }
      );
    }
  });

  /**
     * @api {get} /getProductDetails?productId=1 Product Details.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName getProductDetails
     * @apiGroup Products  
     * @apiParam {String} productId product Id.   
     * @apiParam {String} userId user Id.
     * @apiParam {String} dealId deal Id (0 in case if it is not coming from deal section).   
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *  {
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "productDetail": {
     "isFavourite": 0,
     "image": "",
     "productId": 1,
     "catId": 1,
     "subCatId": 1,
     "productName": "sd",
     "description": "asdfasdf",
     "price": "50"
     },
     "topextraItems": [
     {
     "topLabelId": 1,
     "productId": 1,
     "labelNames": "Temp1",
     "labelType": 1,
     "labelOption": 1,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 1,
     "labelId": 1,
     "productId": 1,
     "optionName": "Option 1"
     },
     {
     "price": "40",
     "labelOptionId": 2,
     "labelId": 1,
     "productId": 1,
     "optionName": "Option 2"
     }
     ]
     },
     {
     "topLabelId": 5,
     "productId": 1,
     "labelNames": "Temp2",
     "labelType": 1,
     "labelOption": 2,
     "labelOptions": [
     {
     "price": "50",
     "labelOptionId": 5,
     "labelId": 5,
     "productId": 1,
     "optionName": "Option 5"
     },
     {
     "price": "50",
     "labelOptionId": 6,
     "labelId": 5,
     "productId": 1,
     "optionName": "Option 6"
     }
     ]
     }
     ],
     "additionalItems": [
     {
     "additionalProductId": 1,
     "productId": 1,
     "itemName": "sdfa",
     "price": "40"
     }
     ],
     "customizeTopLabelOptions": [
     {
     "custLabelId": 1,
     "productId": 1,
     "labelNames": "Toppings"
     },
     {
     "custLabelId": 2,
     "productId": 1,
     "labelNames": "Size"
     },
     {
     "custLabelId": 3,
     "productId": 1,
     "labelNames": "Extra"
     }
     ],
     "verticalCustomizeOptionsWithPrice": [
     {
     "custlabelOptionId": 7,
     "productId": 1,
     "labelNames": "Bacon Crumble",
     "prices": [
     {
     "labelNames": "Size",
     "custlabelOptionPriceId": 1,
     "productId": 1,
     "amount": "0",
     "custLabelId": 2,
     "custlabelOptionId": 7
     },
     {
     "labelNames": "Extra",
     "custlabelOptionPriceId": 2,
     "productId": 1,
     "amount": "0",
     "custLabelId": 3,
     "custlabelOptionId": 7
     }
     ]
     },
     {
     "custlabelOptionId": 8,
     "productId": 1,
     "labelNames": "Green Onions",
     "prices": [
     {
     "labelNames": "Extra",
     "custlabelOptionPriceId": 3,
     "productId": 1,
     "amount": "0",
     "custLabelId": 3,
     "custlabelOptionId": 8
     },
     {
     "labelNames": "Size",
     "custlabelOptionPriceId": 4,
     "productId": 1,
     "amount": "0",
     "custLabelId": 2,
     "custlabelOptionId": 8
     }
     ]
     },
     {
     "custlabelOptionId": 9,
     "productId": 1,
     "labelNames": "Red Chillies"
     }
     ]
     }
     }
     *
     */

  product.get("/getProductDetails", function (req, res) {
    logger.info('EXPRESS: post("/getProductDetails") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var product = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        productId: { type: "string" },
        userId: { type: "string" },
        dealId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, product);

    if (!validationresult.valid) {
      // INVALID

      logger.log(validationresult.format());

      message = languages.something_went_wrong[lang];
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var products =
        'SELECT checkProductIsFavourite(?,?) as isFavourite,if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,`product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price` FROM `tbl_products_items` as tpi WHERE product_id = ? and is_deleted = "0" and status="1" ';
      //console.log(products);
      connection.query(
        products,
        [product.productId, product.userId, product.productId],
        function (err, rows, fields) {
          logger.log(rows);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          if (rows.length > 0) {
            //console.log(rows);
            var productTopLabelOptions = Utils.getTopSubproducts(
              connection,
              product.productId
            );
            var additionalProducts = Utils.additionalProducts(
              connection,
              product.productId
            );
            // var customizeItem =[];
            var customizeItem = Utils.customizeProducts(
              connection,
              product.productId
            );
            //console.log(customizeItem);

            Promise.all([
              productTopLabelOptions,
              additionalProducts,
              customizeItem,
            ]).then(function (data) {
              var [topextraItems, additionalItems, customizeItems] = data;
              var [customizelabeloptions, customizeoptionwithprice] =
                customizeItems;
              synceach(
                additionalItems,
                function (item, next) {
                  var findComma = item.itemName.indexOf(",");
                  if (findComma > -1) {
                    //****  itemName column conatins',' and we will find out price  ****//
                    item.price = item.itemName.substr(
                      findComma + 1,
                      item.itemName.length - (findComma + 1)
                    );
                    item.itemName = item.itemName.substr(0, findComma);
                  } else {
                    item.price = 0;
                  }
                  next(null, item);
                },
                function (err, transformedItems) {
                  if (product.dealId > 0) {
                    var deal =
                      'SELECT `deal_type` as dealType, `deal_name` as dealName, `product_id` as productId, `product_id_free_cost` as productIdfreeCost, `flat_discount_price` as flatDiscountPrice, `discount_percentage` as discountPercentage FROM `deals` WHERE id =? and is_deleted = "0" ';
                    //console.log(products);
                    connection.query(
                      deal,
                      [product.dealId],
                      function (err, rowsdata, fields) {
                        //                logger.log(q);
                        //console.log(rowsdata[0]);
                        //console.log(err);
                        if (err) {
                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        }
                        if (rowsdata.length > 0) {
                          if (rowsdata[0].dealType == "1") {
                            var freeProduct =
                              'SELECT `product_id` as freeProductid, `product_name` as productName,if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as freeProductimage FROM `tbl_products_items` as tpi WHERE product_id = ? and is_deleted = "0" and status="1" ';

                            connection.query(
                              freeProduct,
                              [rowsdata[0].productIdfreeCost],
                              function (err, rows2, fields) {
                                if (err) {
                                  message =
                                    languages.something_went_wrong[lang];
                                  Utils.makeResponse(
                                    res,
                                    false,
                                    400,
                                    message,
                                    appVersion,
                                    data
                                  );
                                }
                                if (rows2.length > 0) {
                                  rows[0].dealType = rowsdata[0].dealType;
                                  rows[0].dealId = product.dealId;
                                  rows[0].dealName = rowsdata[0].dealName;
                                  rows[0].freeProductid =
                                    rows2[0].freeProductid;
                                  rows[0].freeProductname =
                                    rows2[0].productName;
                                  rows[0].freeProductimage =
                                    rows2[0].freeProductimage;
                                  var result = {
                                    productDetail: rows[0],
                                    topextraItems: topextraItems,
                                    additionalItems: additionalItems,
                                    customizeTopLabelOptions:
                                      customizelabeloptions,
                                    verticalCustomizeOptionsWithPrice:
                                      customizeoptionwithprice,
                                  };
                                  //console.log(result);
                                  message = languages.success[lang];
                                  Utils.makeResponse(
                                    res,
                                    true,
                                    200,
                                    message,
                                    appVersion,
                                    result
                                  );
                                } else {
                                  var result = {
                                    productDetail: rows[0],
                                    topextraItems: topextraItems,
                                    additionalItems: additionalItems,
                                    customizeTopLabelOptions:
                                      customizelabeloptions,
                                    verticalCustomizeOptionsWithPrice:
                                      customizeoptionwithprice,
                                  };
                                  //console.log(result);
                                  message = languages.success[lang];
                                  Utils.makeResponse(
                                    res,
                                    true,
                                    200,
                                    message,
                                    appVersion,
                                    result
                                  );
                                }
                              }
                            );
                          } else if (rowsdata[0].dealType == "2") {
                            rows[0].dealType = rowsdata[0].dealType;
                            rows[0].dealId = product.dealId;
                            rows[0].dealName = rowsdata[0].dealName;
                            rows[0].Originalprice = String(
                              parseInt(rows[0].price)
                            );
                            rows[0].price = String(
                              parseInt(rows[0].price) -
                                parseInt(rowsdata[0].flatDiscountPrice)
                            );

                            var result = {
                              productDetail: rows[0],
                              topextraItems: topextraItems,
                              additionalItems: additionalItems,
                              customizeTopLabelOptions: customizelabeloptions,
                              verticalCustomizeOptionsWithPrice:
                                customizeoptionwithprice,
                            };
                            //console.log(result);
                            message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              result
                            );
                          } else if (rowsdata[0].dealType == "3") {
                            rows[0].dealType = rowsdata[0].dealType;
                            rows[0].dealId = product.dealId;
                            rows[0].dealName = rowsdata[0].dealName;
                            rows[0].Originalprice = String(
                              parseInt(rows[0].price)
                            );
                            rows[0].price = String(
                              parseInt(rows[0].price) -
                                parseInt(
                                  (rows[0].price / 100) *
                                    rowsdata[0].discountPercentage
                                )
                            );

                            var result = {
                              productDetail: rows[0],
                              topextraItems: topextraItems,
                              additionalItems: additionalItems,
                              customizeTopLabelOptions: customizelabeloptions,
                              verticalCustomizeOptionsWithPrice:
                                customizeoptionwithprice,
                            };
                            //console.log(result);
                            message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              result
                            );
                          }
                        } else {
                          rows[0].dealId = product.dealId;
                          var result = {
                            productDetail: rows[0],
                            topextraItems: topextraItems,
                            additionalItems: additionalItems,
                            customizeTopLabelOptions: customizelabeloptions,
                            verticalCustomizeOptionsWithPrice:
                              customizeoptionwithprice,
                          };

                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            result
                          );
                        }
                      }
                    );
                  } else {
                    rows[0].dealId = product.dealId;
                    var result = {
                      productDetail: rows[0],
                      topextraItems: topextraItems,
                      additionalItems: additionalItems,
                      customizeTopLabelOptions: customizelabeloptions,
                      verticalCustomizeOptionsWithPrice:
                        customizeoptionwithprice,
                    };

                    message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      result
                    );
                  }
                }
              );
            });
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });
  product.get("/getProductDetailsWeb", function (req, res) {
    logger.info('EXPRESS: post("/getProductDetails") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var product = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        productId: { type: "string" },
        userId: { type: "string" },
        dealId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, product);

    if (!validationresult.valid) {
      // INVALID

      logger.log(validationresult.format());

      message = languages.something_went_wrong[lang];
      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var products =
        'SELECT checkProductIsFavourite(?,?) as isFavourite,(select image_url from tbl_product_images where product_id = tpi.product_id limit 1) as image,(select image_second_url from tbl_product_images where product_id = tpi.product_id limit 1) as image2, ( SELECT image_for_app FROM tbl_product_images WHERE product_id = tpi.product_id LIMIT 1 ) AS imageApp, `product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price` ,`combo_name`, `combo_price` FROM `tbl_products_items` as tpi WHERE product_id = ? and is_deleted = "0" and status="1" ';
      //console.log(products);
      connection.query(
        products,
        [product.productId, product.userId, product.productId],
        function (err, rows, fields) {
          logger.log(rows);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          // if(rows!=undefined){
          if (rows.length > 0) {
            //console.log(rows);
            var productTopLabelOptions = Utils.getTopSubproducts(
              connection,
              product.productId
            );
            var additionalProducts = Utils.additionalProducts(
              connection,
              product.productId
            );
            // var customizeItem =[];
            var customizeItem = Utils.customizeProducts(
              connection,
              product.productId
            );
            //console.log(customizeItem);

            Promise.all([
              productTopLabelOptions,
              additionalProducts,
              customizeItem,
            ]).then(function (data) {
              var [topextraItems, additionalItems, customizeItems] = data;
              var [customizelabeloptions, customizeoptionwithprice] =
                customizeItems;
              synceach(
                additionalItems,
                function (item, next) {
                  var findComma = item.itemName.indexOf(",");
                  if (findComma > -1) {
                    //****  itemName column conatins',' and we will find out price  ****//
                    item.price = item.itemName.substr(
                      findComma + 1,
                      item.itemName.length - (findComma + 1)
                    );
                    item.itemName = item.itemName.substr(0, findComma);
                  } else {
                    item.price = 0;
                  }
                  next(null, item);
                },
                function (err, transformedItems) {
                  //console.log('erqwtrtert');
                  //console.log(transformedItems);
                  if (product.dealId > 0) {
                    var deal =
                      'SELECT `deal_type` as dealType, `deal_name` as dealName, `product_id` as productId, `product_id_free_cost` as productIdfreeCost, `flat_discount_price` as flatDiscountPrice, `discount_percentage` as discountPercentage FROM `deals` WHERE id =? and is_deleted = "0" ';
                    //console.log(products);
                    connection.query(
                      deal,
                      [product.dealId],
                      function (err, rowsdata, fields) {
                        //                logger.log(q);
                        //console.log(rowsdata[0]);
                        //console.log(err);
                        if (err) {
                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            data
                          );
                        }
                        if (rowsdata.length > 0) {
                          if (rowsdata[0].dealType == "1") {
                            var freeProduct =
                              'SELECT `product_id` as freeProductid, `product_name` as productName,if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as freeProductimage FROM `tbl_products_items` as tpi WHERE product_id = ? and is_deleted = "0" and status="1" ';

                            connection.query(
                              freeProduct,
                              [rowsdata[0].productIdfreeCost],
                              function (err, rows2, fields) {
                                if (err) {
                                  message =
                                    languages.something_went_wrong[lang];
                                  Utils.makeResponse(
                                    res,
                                    false,
                                    400,
                                    message,
                                    appVersion,
                                    data
                                  );
                                }
                                if (rows2.length > 0) {
                                  rows[0].dealType = rowsdata[0].dealType;
                                  rows[0].dealId = product.dealId;
                                  rows[0].dealName = rowsdata[0].dealName;
                                  rows[0].freeProductid =
                                    rows2[0].freeProductid;
                                  rows[0].freeProductname =
                                    rows2[0].productName;
                                  rows[0].freeProductimage =
                                    rows2[0].freeProductimage;
                                  var result = {
                                    productDetail: rows[0],
                                    topextraItems: topextraItems,
                                    additionalItems: additionalItems,
                                    customizeTopLabelOptions:
                                      customizelabeloptions,
                                    verticalCustomizeOptionsWithPrice:
                                      customizeoptionwithprice,
                                  };
                                  //console.log(result);
                                  message = languages.success[lang];
                                  Utils.makeResponse(
                                    res,
                                    true,
                                    200,
                                    message,
                                    appVersion,
                                    result
                                  );
                                } else {
                                  var result = {
                                    productDetail: rows[0],
                                    topextraItems: topextraItems,
                                    additionalItems: additionalItems,
                                    customizeTopLabelOptions:
                                      customizelabeloptions,
                                    verticalCustomizeOptionsWithPrice:
                                      customizeoptionwithprice,
                                  };
                                  //console.log(result);
                                  message = languages.success[lang];
                                  Utils.makeResponse(
                                    res,
                                    true,
                                    200,
                                    message,
                                    appVersion,
                                    result
                                  );
                                }
                              }
                            );
                          } else if (rowsdata[0].dealType == "2") {
                            rows[0].dealType = rowsdata[0].dealType;
                            rows[0].dealId = product.dealId;
                            rows[0].dealName = rowsdata[0].dealName;
                            rows[0].Originalprice = String(
                              parseInt(rows[0].price)
                            );
                            rows[0].price = String(
                              parseInt(rows[0].price) -
                                parseInt(rowsdata[0].flatDiscountPrice)
                            );

                            var result = {
                              productDetail: rows[0],
                              topextraItems: topextraItems,
                              additionalItems: additionalItems,
                              customizeTopLabelOptions: customizelabeloptions,
                              verticalCustomizeOptionsWithPrice:
                                customizeoptionwithprice,
                            };
                            //console.log(result);
                            message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              result
                            );
                          } else if (rowsdata[0].dealType == "3") {
                            rows[0].dealType = rowsdata[0].dealType;
                            rows[0].dealId = product.dealId;
                            rows[0].dealName = rowsdata[0].dealName;
                            rows[0].Originalprice = String(
                              parseInt(rows[0].price)
                            );
                            rows[0].price = String(
                              parseInt(rows[0].price) -
                                parseInt(
                                  (rows[0].price / 100) *
                                    rowsdata[0].discountPercentage
                                )
                            );

                            var result = {
                              productDetail: rows[0],
                              topextraItems: topextraItems,
                              additionalItems: additionalItems,
                              customizeTopLabelOptions: customizelabeloptions,
                              verticalCustomizeOptionsWithPrice:
                                customizeoptionwithprice,
                            };
                            //console.log(result);
                            message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              result
                            );
                          }
                        } else {
                          rows[0].dealId = product.dealId;
                          var result = {
                            productDetail: rows[0],
                            topextraItems: topextraItems,
                            additionalItems: additionalItems,
                            customizeTopLabelOptions: customizelabeloptions,
                            verticalCustomizeOptionsWithPrice:
                              customizeoptionwithprice,
                          };

                          message = languages.success[lang];
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            result
                          );
                        }
                      }
                    );
                  } else {
                    rows[0].dealId = product.dealId;
                    var result = {
                      productDetail: rows[0],
                      topextraItems: topextraItems,
                      additionalItems: additionalItems,
                      customizeTopLabelOptions: customizelabeloptions,
                      verticalCustomizeOptionsWithPrice:
                        customizeoptionwithprice,
                    };

                    message = languages.success[lang];
                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      result
                    );
                  }
                }
              );
            });
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
          // }else {
          //     message = languages.no_product_found[lang];
          //     Utils.makeResponse(res, true, 200, message, appVersion, data);
          // }
        }
      );
    }
  });

  /**
   * @api {get} /featuredProducts List of featured products.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName featuredProducts
   * @apiGroup Products
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "productId": 1,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Marinara",
   *           "description":"",
   *           "image": "",
   *           "price":"50",
   *           "isNewProduct":"1" (1:Yes,0:No)
   *         },
   *         {
   *           "productId": 2,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Margherita",
   *           "description":"",
   *           "image": "",
   *           "price": "60",
   *           "isNewProduct": "0" (1:Yes,0:No)
   *         }
   *       ]
   *     }
   *
   */

  product.get("/featuredProducts", function (req, res) {
    logger.info('EXPRESS: post("/featuredProducts") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var productrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, productrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 11;
      if (productrequest.page == "1") offset = 0;
      else offset = (productrequest.page - 1) * limit;

      var products =
        'SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,`product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price`, (case when DATE_ADD(created_at, INTERVAL 1 DAY) > now() then "1" else "0" end) as isNewProduct  FROM `tbl_products_items` as tpi WHERE  is_deleted = "0" and status="1" and is_featured = "1" order by created_at desc limit ?,?';
      //            console.log(products);
      var q = connection.query(
        products,
        [offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (rows.length > 0) {
            message = languages.success[lang];
            data = rows;

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /*
     product.get('/productSuggestions', function (req, res) {
     logger.info('EXPRESS: post("/productSuggestions") --> RECEIVED'.event);
     logger.log('%O', req.query);
     var productrequest = req.query;
     var data = [];
     var message = "";
     var schema = {
     type: 'object',
     properties: {              
     productId:{type: 'any'},
     page:{type: 'string'}
     }
     };
     
     var validationresult = inspector.validate(schema, productrequest);
     
     if (!validationresult.valid) {
     // INVALID
     message =  languages.bad_request[lang];
     
     logger.log(validationresult.format());
     
     Utils.makeResponse(res, false, 400, message, appVersion, data);
     
     } else {
     var offset = 0;
     var limit = 20;
     if(productrequest.page == '1')
     offset = 0;
     else
     offset = (productrequest.page - 1) * limit;
     
     var products = 'SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,tpi.`product_id` as productId, tpi.`category_id` as catId, tpi.`subcategory_id` as subCatId, tpi.`product_name` as productName, tpi.`description`, tpi.`price`   FROM `tbl_products_items` as tpi join tbl_product_suggestions as tps on tps.suggested_product_id	 = tpi.product_id  WHERE  tpi.is_deleted = "0" and tpi.status="1" and tps.product_id = ? and tps.status="1" order by tps.created_on desc limit ?,?';
     //            console.log(products);
     var q = connection.query(products, [productrequest.productId,offset,limit], function (err, rows, fields) {
     //                logger.log(q);
     //console.log(rows[0].user_id);
     if (err) {
     message = languages.something_went_wrong[lang];
     Utils.makeResponse(res, false, 400, message, appVersion, data);
     }
     else if (rows.length > 0) {
     
     message = languages.success[lang];;
     
     data = rows;                   
     
     Utils.makeResponse(res, true, 200, message, appVersion, data);
     } else {
     message = languages.no_product_found[lang];;
     Utils.makeResponse(res, true, 200, message, appVersion, data);
     
     }
     
     });
     
     }
     
     });
     
     */

  /**
   * @api {get} /getGiftCardList List of gift cards.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName getGiftCardList
   * @apiGroup Products
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *  "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result": [
   *     {
   *   "gift_card_id": 1,
   *   "title": "Gift Card",
   *   "card_image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_giftcard_img_48976034.jpg",
   *   "giftCardImage": []
   *   },
   *     {
   *   "gift_card_id": 2,
   *   "title": "Birthday card",
   *   "card_image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg",
   *   "giftCardImage": [
   *     {
   *   "card_image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg"
   *   },
   *     {
   *   "card_image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg"
   *   },
   *     {
   *   "card_image": "https://s3.amazonaws.com/ondemandbucket/driver/cafejavas_card_img_20953089.jpg"
   *   }
   *   ]
   *   }
   *   ]
   *   }
   *
   */

  product.get("/getGiftCardList", function (req, res) {
    logger.info('EXPRESS: post("/getGiftCardList") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var productrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, productrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = pageLimit;
      if (productrequest.page == "1") offset = 0;
      else offset = (productrequest.page - 1) * limit;

      var products =
        "select gift_card_id,gift_card_title from gift_card where DATEDIFF(expiry_date,NOW())>=0 and is_deleted = '0' order by gift_card_id limit ? offset ? ";
      // console.log(products);
      connection.query(products, [limit, offset], function (err, rows, fields) {
        //console.log(rows[0].user_id);
        if (err) {
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, data);
        } else if (rows.length > 0) {
          synceach(
            rows,
            function (item, next) {
              var giftCardImage = [];
              getGiftCardImage(item.gift_card_id)
                .then(function (imageData) {
                  if (imageData) {
                    item.giftCardImage = imageData;
                    next(null, item);
                  } else {
                    item.giftCardImage = giftCardImage;
                    var nullObj = {};
                    next(null, nullObj);
                  }
                })
                .catch(function (err) {
                  var nullObj = {};
                  next(null, nullObj);
                });
            },
            function (err, transformedItems) {
              //get final result from here
              //  console.log("error : "+err);
              message = languages.success[lang];

              Utils.makeResponse(res, true, 200, message, appVersion, rows);
            }
          );
        } else {
          message = languages.no_gift_card_found[lang];
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
        // message = languages.something_went_wrong[lang];
        // Utils.makeResponse(res, false, 400, message, appVersion, data);
      });
    }
  });

  function getGiftCardImage(giftCardId) {
    return new Promise(function (resolve, reject) {
      var products =
        "select card_image from gift_card_image where gift_card_id=? and is_deleted ='0'";
      //            console.log(products);
      connection.query(products, [giftCardId], function (err, rows, fields) {
        //console.log(rows[0].user_id);
        if (err) {
          reject(false);
        } else {
          resolve(rows);
        }
      });
    });
  }

  /**
     * @api {get} /trackOrder track order
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName trackOrder
     * @apiGroup Orders       
     * @apiParam {string} userId ID of user (0 in case of guest_user)
     * @apiParam {string} deviceId ID of device
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     {
     
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "data": [
     {
     "quantity": 1,
     "subtotal": 21000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "one",
     "labelOption": 1,
     "labelOptions": [
     {
     "labelId": 32,
     "labelOptionId": 49,
     "optionName": "dosa",
     "price": "1000"
     }
     ],
     "labelType": 1,
     "topLabelId": 32
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     },
     {
     "quantity": 6,
     "subtotal": 150000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "premium",
     "labelOption": 2,
     "labelOptions": [
     {
     "labelId": 33,
     "labelOptionId": 50,
     "optionName": "mix dosa",
     "price": "5000"
     }
     ],
     "labelType": 1,
     "topLabelId": 33
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     }
     ],
     "order_date": "2018-06-27 18:28:30",
     "order_num":"CAFEJAVAS_1",
     "payment_mode": "Payment Not Done",
     "serviceFee": 0,
     "deliveryFee": 0,
     "subtotal": 171000,    
     "totalPrice": 171000,
     "gift_amount": 171000,
     "promo_amount": 171000,
     "pickUpType":"0",
     "orderId":212    
     }
     }
     
     *
     */
  product.get("/trackOrder", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var foodstatus = "";
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        deviceId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      //**** getting order details  ****//
      //var pageNo=requestData.pageNo || 1;
      //var offset=(pageNo-1) * pageLimit;
      //  if()
      if (requestData.userId == "0") {
        var orderQr =
          "select order_id,order_num,status,driver_id,delivery_time,pickup_type,service_fee,delivery_fee,subtotal,gift_amount,promo_amount,loyalty_amount,payment_mode,created_at from orders where device_id=? and is_guest_user='1' and status !='5' and created_at >=CURDATE() order by order_id desc";
        var paramArray = [requestData.deviceId];
      } else {
        var orderQr =
          "select order_id,order_num,status,driver_id,delivery_time,pickup_type,service_fee,delivery_fee,subtotal,gift_amount,promo_amount,loyalty_amount,payment_mode,created_at from orders where user_id=? and is_guest_user='0' and status !='5' and created_at >=CURDATE() order by order_id desc";
        var paramArray = [requestData.userId];
      }

      //console.log("WWWWWWWWWWWWWWWW");
      connection.query(orderQr, paramArray, function (err, rows, fields) {
        if (err) {
          //console.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          //console.log("GGGGGGGGGGGGGG");
          var totalPrice = 0;
          var serviceFee = 0;
          var deliveryFee = 0;
          var gift_amount = 0;
          var promo_amount = 0;
          var subtotal = 0;
          var loyaltyAmount = 0;
          var allOrderItems1 = [];
          if (rows.length > 0) {
            synceach(
              rows,
              function (item, next) {
                //console.log("$$$$$$$$$$$$$$$$4");

                //****  getting total cost of order  ****//
                var orderItemQr =
                  "select quantity,is_free_reward,basic_product_cost,subtotal,json from order_items where order_id=?";
                connection.query(
                  orderItemQr,
                  [item.order_id],
                  function (err1, rows1, fields) {
                    if (err1) {
                      //console.log(err1);
                      var nullObj = {};
                      next(null, nullObj);
                    } else {
                      //console.log("**************88");
                      //console.log();
                      var paymentMode = item.payment_mode;
                      var allOrderItems = {};
                      var gift_amount = item.gift_amount;
                      var promo_amount = item.promo_amount;
                      var subtotal = item.subtotal;

                      var order_date = item.created_at;
                      var order_num = item.order_num;
                      var payment_mode = item.payment_mode;
                      var delivery_time = item.delivery_time;
                      var status = item.status;
                      var driver_id = item.driver_id;
                      var pickup_type = item.pickup_type;
                      var order_id = item.order_id;
                      var service_fee = item.service_fee;
                      var loyaltyAmount = item.loyalty_amount;

                      var totalPrice = 0;
                      var serviceFee = item.service_fee;
                      var deliveryFee = item.delivery_fee;
                      if (rows1.length > 0) {
                        //console.log("OOOOOOOOOOOOOOOOOO");
                        //****  order items found  ****//
                        synceach(
                          rows1,
                          function (item, next) {
                            if (item.is_free_reward == "1") {
                              var quantityCount = item.quantity - 1;
                            } else {
                              var quantityCount = item.quantity;
                            }
                            var itemTotalCost = quantityCount * item.subtotal;
                            totalPrice = totalPrice + itemTotalCost;
                            //   item.subtotal = itemTotalCost;
                            //    item.json = JSON.parse(item.json);
                            next(null, item);
                          },
                          function (err, transformedItems) {
                            if (rows1[0].json != "") {
                              var jsonData = JSON.parse(rows1[0].json);
                              var orderImage =
                                jsonData.data.orderItemDetail.image;
                            } else {
                              var orderImage = "";
                            }
                            //console.log(orderImage);
                            //console.log(rows1[0]);
                            //allOrderItems = status;
                            // allOrderItems.data=rows1;
                            allOrderItems.image = orderImage;
                            //finalData.totalItems=rows0[0].total;
                            allOrderItems.order_date = order_date;
                            allOrderItems.order_num = order_num;
                            allOrderItems.payment_mode = payment_mode;
                            allOrderItems.delivery_time = delivery_time;
                            allOrderItems.status = status;
                            allOrderItems.driver_id = driver_id;
                            allOrderItems.serviceFee = serviceFee;
                            allOrderItems.deliveryFee = deliveryFee;
                            allOrderItems.subtotal = subtotal;
                            allOrderItems.totalPrice =
                              totalPrice +
                              deliveryFee -
                              (gift_amount + promo_amount + loyaltyAmount);
                            allOrderItems.gift_amount = gift_amount;
                            allOrderItems.promo_amount = promo_amount;
                            allOrderItems.pickUpType = pickup_type;
                            allOrderItems.orderId = order_id;
                            allOrderItems1.push(allOrderItems);
                            next(null, item);
                          }
                        );
                      } else {
                        //****  order items not found  ****//
                        // allOrderItems.data=rows1;
                        // finalData.totalItems=0;
                        allOrderItems.image = "";
                        allOrderItems.order_date = order_date;
                        allOrderItems.order_num = order_num;
                        allOrderItems.payment_mode = payment_mode;
                        allOrderItems.delivery_time = delivery_time;
                        allOrderItems.status = status;
                        allOrderItems.driver_id = driver_id;
                        allOrderItems.serviceFee = serviceFee;
                        allOrderItems.deliveryFee = deliveryFee;
                        allOrderItems.subtotal = subtotal;
                        allOrderItems.totalPrice =
                          totalPrice +
                          deliveryFee -
                          (gift_amount + promo_amount + loyaltyAmount);
                        allOrderItems.gift_amount = gift_amount;
                        allOrderItems.promo_amount = promo_amount;
                        allOrderItems.pickUpType = pickup_type;
                        allOrderItems.orderId = order_id;
                        allOrderItems1.push(allOrderItems);
                        next(null, item);
                      }
                    }
                  }
                );
              },
              function (err, transformedItems) {
                finalData = allOrderItems1;
                //    finalData.total = rows0.length;
                message = languages.success[lang];

                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  finalData
                );
              }
            );
          } else {
            //****  Order not found  ****//
            //   finalData.data=rows;
            //   finalData.totalItems=0;
            var finalData = [];
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      });
      //            }
      //
      //            });
    }
  });

  /**
     * @api {get} /trackOrderdetail track order detail
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName trackOrderdetail
     * @apiGroup Orders       
     * @apiParam {string} orderId order id 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     {
     
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "data": [
     {
     "quantity": 1,
     "subtotal": 21000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "one",
     "labelOption": 1,
     "labelOptions": [
     {
     "labelId": 32,
     "labelOptionId": 49,
     "optionName": "dosa",
     "price": "1000"
     }
     ],
     "labelType": 1,
     "topLabelId": 32
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     },
     {
     "quantity": 6,
     "subtotal": 150000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "premium",
     "labelOption": 2,
     "labelOptions": [
     {
     "labelId": 33,
     "labelOptionId": 50,
     "optionName": "mix dosa",
     "price": "5000"
     }
     ],
     "labelType": 1,
     "topLabelId": 33
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     }
     ],
     "order_date": "2018-06-27 18:28:30",
     "order_num":"CAFEJAVAS_1",
     "payment_mode": "Payment Not Done",
     "serviceFee": 0,
     "deliveryFee": 0,
     "subtotal": 171000,    
     "totalPrice": 171000,
     "gift_amount": 171000,
     "promo_amount": 171000,
     "pickUpType":"0",
     "orderId":212    
     }
     }
     
     *
     */
  product.get("/trackOrderdetail", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var foodstatus = "";
    var message = "";
    var schema = {
      type: "object",
      properties: {
        orderId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      var orderQr =
        "select o.order_id as order_id,o.order_num as order_num,o.status as status,IF( o.delivery_time='00:00:00','',DATE_FORMAT(ADDTIME(o.created_at,ADDTIME(TIMEDIFF(o.accept_reject_datetime,o.created_at),o.delivery_time)),'%m-%d-%Y %H:%i:%s ')) as delivery_time,o.pickup_type as pickup_type,o.service_fee as service_fee,o.subtotal as subtotal,o.gift_amount as gift_amount,o.promo_amount as promo_amount,o.loyalty_amount as loyalty_amount,o.payment_mode as payment_mode,o.created_at as created_at,o.is_guest_user as guestUser,o.user_id as userId,o.address_id as addressId,td.vehicle_no as vehicle_no from orders o left join tbl_driver as td on driver_id = td.id where order_id=? ";
      var paramArray = [requestData.orderId];

      connection.query(orderQr, paramArray, function (err, rows, fields) {
        if (err) {
          //console.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          var totalPrice = 0;
          var serviceFee = 0;
          var deliveryFee = 0;
          var gift_amount = 0;
          var promo_amount = 0;
          var subtotal = 0;
          var service_fee = 0;
          var loyaltyAmount = 0;
          var vechicleno = "";
          if (rows.length > 0) {
            var paymentMode = rows[0].payment_mode;
            var allOrderItems = [];
            gift_amount = rows[0].gift_amount;
            promo_amount = rows[0].promo_amount;
            subtotal = rows[0].subtotal;
            service_fee = rows[0].service_fee;
            loyaltyAmount = rows[0].loyalty_amount;
            vechicleno = rows[0].vehicle_no || "";

            getUserAddress(rows[0].userId, rows[0].guestUser, rows[0].addressId)
              .then(function (addressVal) {
                if (addressVal) {
                  //****  getting total cost of order  ****//
                  var orderItemQr =
                    "select quantity,subtotal,is_free_reward,basic_product_cost,json from order_items where order_id=?";
                  connection.query(
                    orderItemQr,
                    [rows[0].order_id],
                    function (err1, rows1, fields) {
                      if (err1) {
                        //console.log(err1);
                        message = languages.something_went_wrong[lang];
                        Utils.makeResponse(
                          res,
                          false,
                          400,
                          message,
                          appVersion,
                          finalData
                        );
                      } else {
                        var totalPrice = 0;
                        var serviceFee = 0;
                        var deliveryFee = 0;
                        if (rows1.length > 0) {
                          getOrderStatusTimings(requestData.orderId).then(
                            function (re) {
                              if (re) {
                                finalData.statusTimings = re;
                              } else {
                                finalData.statusTimings = [];
                              }

                              //****  order items found  ****//
                              synceach(
                                rows1,
                                function (item, next) {
                                  //console.log("run");
                                  if (item.is_free_reward == "1") {
                                    var quantityCount = item.quantity - 1;
                                  } else {
                                    var quantityCount = item.quantity;
                                  }
                                  var itemTotalCost =
                                    quantityCount * item.subtotal;
                                  totalPrice = totalPrice + itemTotalCost;
                                  item.subtotal = itemTotalCost;
                                  item.json = JSON.parse(item.json);
                                  next(null, item);
                                },
                                function (err, transformedItems) {
                                  //console.log("error", err)

                                  foodstatus = rows[0].status;
                                  finalData.data = rows1;
                                  //finalData.totalItems=rows0[0].total;
                                  finalData.order_date = rows[0].created_at;
                                  finalData.order_num = rows[0].order_num;
                                  finalData.payment_mode = rows[0].payment_mode;
                                  finalData.delivery_time =
                                    rows[0].delivery_time;
                                  finalData.status = rows[0].status;
                                  finalData.serviceFee = rows[0].service_fee;
                                  finalData.deliveryFee = deliveryFee;
                                  finalData.subtotal = subtotal;
                                  finalData.totalPrice =
                                    totalPrice +
                                    rows[0].delivery_fee -
                                    (gift_amount +
                                      promo_amount +
                                      loyaltyAmount);
                                  finalData.gift_amount = gift_amount;
                                  finalData.promo_amount = promo_amount;
                                  finalData.pickUpType = rows[0].pickup_type;
                                  finalData.orderId = rows[0].order_id;
                                  finalData.vechicleno = vechicleno;
                                  finalData.addressVal = addressVal;
                                  var message = languages.success[lang];

                                  Utils.makeResponse(
                                    res,
                                    true,
                                    200,
                                    message,
                                    appVersion,
                                    finalData
                                  );
                                  //console.log("dddd");
                                  //console.log(finalData);
                                }
                              );
                            }
                          );
                        } else {
                          //****  order items not found  ****//
                          finalData.data = rows1;
                          // finalData.totalItems=0;
                          finalData.order_date = rows[0].created_at;
                          finalData.order_num = rows[0].order_num;
                          finalData.payment_mode = rows[0].payment_mode;
                          finalData.delivery_time = rows[0].delivery_time;
                          finalData.status = rows[0].status;
                          finalData.serviceFee = rows[0].service_fee;
                          finalData.deliveryFee = deliveryFee;
                          finalData.subtotal = subtotal;
                          finalData.totalPrice =
                            totalPrice +
                            rows[0].delivery_fee -
                            (gift_amount + promo_amount + loyaltyAmount);
                          finalData.gift_amount = gift_amount;
                          finalData.promo_amount = promo_amount;
                          finalData.pickUpType = rows[0].pickup_type;
                          finalData.orderId = rows[0].order_id;
                          finalData.vechicleno = vechicleno;
                          finalData.addressVal = addressVal;
                          var message = languages.success[lang];
                          //console.log("eee");
                          //console.log(finalData);
                          Utils.makeResponse(
                            res,
                            true,
                            200,
                            message,
                            appVersion,
                            finalData
                          );
                        }
                      }
                    }
                  );
                } else {
                  //console.log('ff');
                  //console.log(err);

                  var message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    finalData
                  );

                  return false;
                }
              })
              .catch(function (err) {
                //console.log("errorrrr1133" + err);

                var message = languages.something_went_wrong[lang];
                Utils.makeResponse(
                  res,
                  false,
                  400,
                  message,
                  appVersion,
                  finalData
                );
              });
          } else {
            //****  Order not found  ****//
            finalData.data = rows;
            //   finalData.totalItems=0;
            finalData.order_date = "";
            finalData.order_num = "";
            finalData.payment_mode = "";
            finalData.delivery_time = "";
            finalData.serviceFee = serviceFee;
            finalData.status = "";
            finalData.deliveryFee = deliveryFee;
            finalData.subtotal = subtotal;
            finalData.totalPrice = totalPrice + deliveryFee;
            finalData.gift_amount = gift_amount;
            finalData.promo_amount = promo_amount;
            finalData.pickUpType = "";
            finalData.orderId = "";
            finalData.vechicleno = "";
            finalData.addressVal = {};
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      });
      //            }
      //
      //            });
    }
  });

  function getOrderStatusTimings(orderId) {
    return new Promise(function (resolve, reject) {
      //console.log("coming")
      var resp = {},
        result = [];
      var getUserIdQr =
        "select order_status,created_at from customers_order_status_logs where order_id=?";
      connection.query(getUserIdQr, [orderId], function (err, rows, fields) {
        if (err) {
          reject(false);
        } else {
          //console.log("result; ", rows)
          if (rows.length > 0) {
            synceach(
              rows,
              function (item, next) {
                //perform async operation with item
                // resp['status'] = item.order_status;
                //resp['timestamp'] = new Date(item.created_at).getTime() / 1000;
                //  resp['timestamp'] = item.id;
                item.timestamp = new Date(item.created_at).getTime() / 1000;
                item.order_status = item.order_status;

                //result[i] = res;
                next(null, item);
              },
              function (err, transformedItems) {
                resolve(transformedItems);
                //console.log("result new ", transformedItems)
              }
            );
            // rows.forEach(function (val, i) {
            //     res['status'] = rows[i].order_status;
            //     res['timestamp'] = new Date(rows[i].created_at).getTime() / 1000;
            //     result[i] = res;
            // });
          } else {
            //console.log("here coming")
            resolve(result);
          }
        }
      });
    });
  }

  function getUserAddress(userId, guestUser, addressId) {
    return new Promise(function (resolve, reject) {
      var address = {};
      if (guestUser == "0") {
        //****  Case get user address  ****//
        var getUserIdQr =
          "select latitude,longitude from user_address where id=? and userId=? order by id desc limit 1";
        connection.query(
          getUserIdQr,
          [addressId, userId],
          function (err, rows, fields) {
            if (err) {
              reject(false);
            } else {
              address.latitude = rows[0].latitude;
              address.longitude = rows[0].longitude;
              //console.log("sss");
              //console.log(address);
              resolve(address);
            }
          }
        );
      } else {
        var getUserIdQr =
          "select latitude,longitude from user_address where id=? order by id desc limit 1";
        connection.query(
          getUserIdQr,
          [addressId],
          function (err, rows, fields) {
            if (err) {
              reject(false);
            } else {
              address.latitude = rows[0].latitude;
              address.longitude = rows[0].longitude;
              resolve(address);
            }
          }
        );
      }
    });
  }

  /**
     * @api {get} /trackOrderdetailWeb track order detail
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiVersion 1.0.0
     * @apiName trackOrderdetailWeb
     * @apiGroup Orders       
     * @apiParam {string} orderId order id 
     * @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     {
     
     "Success": true,
     "Status": 200,
     "Message": "Success",
     "AppVersion": "1.0.0",
     "Result": {
     "data": [
     {
     "quantity": 1,
     "subtotal": 21000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "one",
     "labelOption": 1,
     "labelOptions": [
     {
     "labelId": 32,
     "labelOptionId": 49,
     "optionName": "dosa",
     "price": "1000"
     }
     ],
     "labelType": 1,
     "topLabelId": 32
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     },
     {
     "quantity": 6,
     "subtotal": 150000,
     "json": {
     "data": {
     "additionalItems": [],
     "customizeTopLabelOptions": [],
     "orderItemDetail": {
     "catId": 10,
     "description": "Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth. Various foods Foods from plant sources Food is any substance[1] consumed to provide nutritional support for an organism. It is usually of plant or animal origin, and contains essential nutrients, such as carbohydrates, fats, proteins, vitamins, or minerals. The substance is ingested by an organism and assimilated by the organism's cells to provide energy, maintain life, or stimulate growth.",
     "image": "http://203.123.36.134/restaurant/admin/public/upload/1530097464.jpeg",
     "isFavourite": 1,
     "price": "20000",
     "productId": 86,
     "productName": "Dosa",
     "subCatId": 48
     },
     "topextraItems": [
     {
     "labelNames": "premium",
     "labelOption": 2,
     "labelOptions": [
     {
     "labelId": 33,
     "labelOptionId": 50,
     "optionName": "mix dosa",
     "price": "5000"
     }
     ],
     "labelType": 1,
     "topLabelId": 33
     }
     ],
     "verticalCustomizeOptionsWithPrice": []
     }
     }
     }
     ],
     "order_date": "2018-06-27 18:28:30",
     "order_num":"CAFEJAVAS_1",
     "payment_mode": "Payment Not Done",
     "serviceFee": 0,
     "deliveryFee": 0,
     "subtotal": 171000,    
     "totalPrice": 171000,
     "gift_amount": 171000,
     "promo_amount": 171000,
     "pickUpType":"0",
     "orderId":212    
     }
     }
     
     *
     */
  product.get("/trackOrderdetailWeb", function (req, res) {
    var requestData = req.query;
    var finalData = {};
    var foodstatus = "";
    var message = "";
    var schema = {
      type: "object",
      properties: {
        orderId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];
      logger.log(validationresult.format());
      Utils.makeResponse(res, false, 400, message, appVersion, finalData);
    } else {
      //**** getting order details  ****//
      var orderQr =
        "select o.order_id as order_id,o.order_num as order_num,o.status as status,IF( o.delivery_time='00:00:00','',DATE_FORMAT(ADDTIME(o.created_at,ADDTIME(TIMEDIFF(o.accept_reject_datetime,o.created_at),o.delivery_time)),'%m-%d-%Y %H:%i:%s ')) as delivery_time,o.pickup_type as pickup_type,o.service_fee as service_fee,o.subtotal as subtotal,o.gift_amount as gift_amount,o.promo_amount as promo_amount,o.loyalty_amount as loyalty_amount,o.payment_mode as payment_mode,o.created_at as created_at,o.is_guest_user as guestUser,o.user_id as userId,o.address_id as addressId,td.vehicle_no as vehicle_no,CONCAT(td.first_name, ' ', td.last_name) AS driverName,td.id AS driverId, td.image AS driverImage,o.delivery_fee AS delivery_fee,estimated_speed as estimated_speed,actual_speed as actual_speed, order_notes as order_notes from orders o left join tbl_driver as td on driver_id = td.id where order_id=? ";
      var paramArray = [requestData.orderId];
      connection.query(orderQr, paramArray, function (err, rows, fields) {
        if (err) {
          //console.log(err);
          message = languages.something_went_wrong[lang];
          Utils.makeResponse(res, false, 400, message, appVersion, finalData);
        } else {
          //console.log(orderQr);
          //console.log(fields);

          var totalPrice = 0;
          var serviceFee = 0;
          var deliveryFee = 0;
          var gift_amount = 0;
          var promo_amount = 0;
          var subtotal = 0;
          var service_fee = 0;
          var loyaltyAmount = 0;
          var vechicleno = "";
          if (rows.length > 0) {
            var paymentMode = rows[0].payment_mode;
            var allOrderItems = [];
            gift_amount = rows[0].gift_amount;
            promo_amount = rows[0].promo_amount;
            subtotal = rows[0].subtotal;
            service_fee = rows[0].service_fee;
            loyaltyAmount = rows[0].loyalty_amount;
            vechicleno = rows[0].vehicle_no || "";
            driverId = rows[0].driverId || 0;
            driverName = rows[0].driverName || "";
            driverImage = rows[0].driverImage || "";
            deliveryFee = rows[0].delivery_fee;
            var pickup_type = rows[0].pickup_type;
            var ios_delivery_time =
              new Date(rows[0].delivery_time).getTime() / 1000;

            if (pickup_type == 1) {
              var orderItemQr =
                "select quantity,subtotal,is_free_reward,basic_product_cost,json from order_items where order_id=?";
              connection.query(
                orderItemQr,
                [rows[0].order_id],
                function (err1, rows1, fields) {
                  if (err1) {
                    //console.log(err1);
                    message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      finalData
                    );
                  } else {
                    var totalPrice = 0;
                    var serviceFee = 0;
                    if (rows1.length > 0) {
                      //****  order items found  ****//

                      getOrderStatusTimings(rows[0].order_id).then(function (
                        re
                      ) {
                        if (re) {
                          finalData.statusTimings = re;
                        } else {
                          finalData.statusTimings = [];
                        }

                        console.log("############################");
                        console.log("############################");
                        console.log(re);
                        console.log("############################");
                        console.log("############################");
                        //****  order items found  ****//
                        synceach(
                          rows1,
                          function (item, next) {
                            if (item.is_free_reward == "1") {
                              var quantityCount = item.quantity - 1;
                            } else {
                              var quantityCount = item.quantity;
                            }
                            var itemTotalCost = quantityCount * item.subtotal;
                            totalPrice = totalPrice + itemTotalCost;
                            item.subtotal = itemTotalCost;
                            item.json = JSON.parse(item.json);
                            next(null, item);
                          },
                          function (err, transformedItems) {
                            foodstatus = rows[0].status;
                            finalData.data = rows1;
                            finalData.order_date = rows[0].created_at;
                            finalData.order_num = rows[0].order_num;
                            finalData.payment_mode = rows[0].payment_mode;
                            finalData.delivery_time = rows[0].delivery_time;
                            finalData.status = rows[0].status;
                            finalData.serviceFee = rows[0].service_fee;
                            finalData.deliveryFee = rows[0].delivery_fee;
                            finalData.subtotal = subtotal;
                            finalData.totalPrice =
                              totalPrice +
                              rows[0].delivery_fee -
                              (gift_amount + promo_amount + loyaltyAmount);
                            finalData.gift_amount = gift_amount;
                            finalData.promo_amount = promo_amount;
                            finalData.pickUpType = rows[0].pickup_type;
                            finalData.orderId = rows[0].order_id;
                            finalData.vechicleno = vechicleno;
                            finalData.driverId = driverId;
                            finalData.driverName = driverName;
                            finalData.driverImage = driverImage;
                            finalData.addressVal = {};
                            finalData.ios_delivery_time = ios_delivery_time;
                            finalData.estimatedSpeed = rows[0].estimated_speed;
                            finalData.actualSpeed = rows[0].actual_speed;
                            finalData.order_notes = rows[0].order_notes;
                            var message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              finalData
                            );
                          }
                        );
                      });
                    } else {
                      //****  order items not found  ****//
                      finalData.data = rows1;
                      finalData.order_date = rows[0].created_at;
                      finalData.order_num = rows[0].order_num;
                      finalData.payment_mode = rows[0].payment_mode;
                      finalData.delivery_time = rows[0].delivery_time;
                      finalData.status = rows[0].status;
                      finalData.serviceFee = rows[0].service_fee;
                      finalData.deliveryFee = rows[0].delivery_fee;
                      finalData.subtotal = subtotal;
                      finalData.totalPrice =
                        totalPrice +
                        rows[0].delivery_fee -
                        (gift_amount + promo_amount + loyaltyAmount);
                      finalData.gift_amount = gift_amount;
                      finalData.promo_amount = promo_amount;
                      finalData.pickUpType = rows[0].pickup_type;
                      finalData.orderId = rows[0].order_id;
                      finalData.vechicleno = vechicleno;
                      finalData.driverId = driverId;
                      finalData.driverName = driverName;
                      finalData.driverImage = driverImage;
                      finalData.addressVal = {};
                      finalData.ios_delivery_time = ios_delivery_time;
                      finalData.estimatedSpeed = rows[0].estimated_speed;
                      finalData.actualSpeed = rows[0].actual_speed;
                      finalData.order_notes = rows[0].order_notes;
                      var message = languages.success[lang];
                      Utils.makeResponse(
                        res,
                        true,
                        200,
                        message,
                        appVersion,
                        finalData
                      );
                    }
                  }
                }
              );
            } else {
              getUserAddress(
                rows[0].userId,
                rows[0].guestUser,
                rows[0].addressId
              )
                .then(function (addressVal) {
                  if (addressVal) {
                    //****  getting total cost of order  ****//
                    var orderItemQr =
                      "select quantity,subtotal,is_free_reward,basic_product_cost,json from order_items where order_id=?";
                    connection.query(
                      orderItemQr,
                      [rows[0].order_id],
                      function (err1, rows1, fields) {
                        if (err1) {
                          //console.log(err1);
                          message = languages.something_went_wrong[lang];
                          Utils.makeResponse(
                            res,
                            false,
                            400,
                            message,
                            appVersion,
                            finalData
                          );
                        } else {
                          var totalPrice = 0;
                          var serviceFee = 0;
                          var deliveryFee = 0;
                          if (rows1.length > 0) {
                            getOrderStatusTimings(requestData.orderId).then(
                              function (re) {
                                if (re) {
                                  finalData.statusTimings = re;
                                } else {
                                  finalData.statusTimings = [];
                                }
                                //****  order items found  ****//
                                synceach(
                                  rows1,
                                  function (item, next) {
                                    if (item.is_free_reward == "1") {
                                      var quantityCount = item.quantity - 1;
                                    } else {
                                      var quantityCount = item.quantity;
                                    }
                                    var itemTotalCost =
                                      quantityCount * item.subtotal;
                                    totalPrice = totalPrice + itemTotalCost;
                                    item.subtotal = itemTotalCost;
                                    item.json = JSON.parse(item.json);
                                    next(null, item);
                                  },
                                  function (err, transformedItems) {
                                    foodstatus = rows[0].status;
                                    finalData.data = rows1;
                                    finalData.order_date = rows[0].created_at;
                                    finalData.order_num = rows[0].order_num;
                                    finalData.payment_mode =
                                      rows[0].payment_mode;
                                    finalData.delivery_time =
                                      rows[0].delivery_time;
                                    finalData.status = rows[0].status;
                                    finalData.serviceFee = rows[0].service_fee;
                                    finalData.deliveryFee =
                                      rows[0].delivery_fee;
                                    finalData.subtotal = subtotal;
                                    finalData.totalPrice =
                                      totalPrice +
                                      rows[0].delivery_fee -
                                      (gift_amount +
                                        promo_amount +
                                        loyaltyAmount);
                                    finalData.gift_amount = gift_amount;
                                    finalData.promo_amount = promo_amount;
                                    finalData.pickUpType = rows[0].pickup_type;
                                    finalData.orderId = rows[0].order_id;
                                    finalData.vechicleno = vechicleno;
                                    finalData.driverId = driverId;
                                    finalData.driverName = driverName;
                                    finalData.driverImage = driverImage;
                                    finalData.addressVal = addressVal;
                                    finalData.ios_delivery_time =
                                      ios_delivery_time;
                                    finalData.estimatedSpeed =
                                      rows[0].estimated_speed;
                                    finalData.actualSpeed =
                                      rows[0].actual_speed;
                                    finalData.order_notes = rows[0].order_notes;
                                    var message = languages.success[lang];
                                    Utils.makeResponse(
                                      res,
                                      true,
                                      200,
                                      message,
                                      appVersion,
                                      finalData
                                    );
                                  }
                                );
                              }
                            );
                          } else {
                            //****  order items not found  ****//
                            finalData.data = rows1;
                            finalData.order_date = rows[0].created_at;
                            finalData.order_num = rows[0].order_num;
                            finalData.payment_mode = rows[0].payment_mode;
                            finalData.delivery_time = rows[0].delivery_time;
                            finalData.status = rows[0].status;
                            finalData.serviceFee = rows[0].service_fee;
                            finalData.deliveryFee = rows[0].delivery_fee;
                            finalData.subtotal = subtotal;
                            finalData.totalPrice =
                              totalPrice +
                              rows[0].delivery_fee -
                              (gift_amount + promo_amount + loyaltyAmount);
                            finalData.gift_amount = gift_amount;
                            finalData.promo_amount = promo_amount;
                            finalData.pickUpType = rows[0].pickup_type;
                            finalData.orderId = rows[0].order_id;
                            finalData.vechicleno = vechicleno;
                            finalData.driverId = driverId;
                            finalData.driverName = driverName;
                            finalData.driverImage = driverImage;
                            finalData.addressVal = addressVal;
                            finalData.ios_delivery_time = ios_delivery_time;
                            finalData.estimatedSpeed = rows[0].estimated_speed;
                            finalData.actualSpeed = rows[0].actual_speed;
                            finalData.order_notes = rows[0].order_notes;
                            var message = languages.success[lang];
                            Utils.makeResponse(
                              res,
                              true,
                              200,
                              message,
                              appVersion,
                              finalData
                            );
                          }
                        }
                      }
                    );
                  } else {
                    var message = languages.something_went_wrong[lang];
                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      finalData
                    );
                    return false;
                  }
                })
                .catch(function (err) {
                  var message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    finalData
                  );
                });
            }
          } else {
            //****  Order not found  ****//
            finalData.data = rows;
            finalData.order_date = "";
            finalData.order_num = "";
            finalData.payment_mode = "";
            finalData.delivery_time = "";
            finalData.serviceFee = serviceFee;
            finalData.status = "";
            finalData.deliveryFee = deliveryFee;
            finalData.subtotal = subtotal;
            finalData.totalPrice = totalPrice;
            finalData.gift_amount = gift_amount;
            finalData.promo_amount = promo_amount;
            finalData.pickUpType = "";
            finalData.orderId = "";
            finalData.vechicleno = "";
            finalData.driverId = "";
            finalData.driverName = "";
            finalData.driverImage = "";
            finalData.addressVal = {};
            finalData.ios_delivery_time = "";
            finalData.estimatedSpeed = "";
            finalData.actualSpeed = "";
            finalData.order_notes = "";
            var message = languages.success[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, finalData);
          }
        }
      });
    }
  });

  /**
   * @api {get} /featuredProductsWeb List of featured products.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName featuredProducts
   * @apiGroup Products
   * @apiParam {String} page Page number for pagination (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "productId": 1,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Marinara",
   *           "description":"",
   *           "image": "",
   *           "price":"50",
   *           "isNewProduct":"1" (1:Yes,0:No)
   *         },
   *         {
   *           "productId": 2,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "productName": "Margherita",
   *           "description":"",
   *           "image": "",
   *           "price": "60",
   *           "isNewProduct": "0" (1:Yes,0:No)
   *         }
   *       ]
   *     }
   *
   */

  product.get("/featuredProductsWeb", function (req, res) {
    logger.info('EXPRESS: post("/featuredProductsWeb") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var productrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, productrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 11;
      if (productrequest.page == "1") offset = 0;
      else offset = (productrequest.page - 1) * limit;

      //            var products = 'SELECT if((select image_url from tbl_product_images where product_id = tpi.product_id limit 1) is null,"",(select image_url from tbl_product_images where product_id = tpi.product_id limit 1)) as image,`product_id` as productId, `category_id` as catId, `subcategory_id` as subCatId, `product_name` as productName, `description`, `price`, (case when DATE_ADD(created_at, INTERVAL 1 DAY) > now() then "1" else "0" end) as isNewProduct  FROM `tbl_products_items` as tpi WHERE  is_deleted = "0" and status="1" and is_featured = "1" order by created_at desc limit ?,?';
      var products =
        "SELECT IF((SELECT image_url FROM tbl_product_images WHERE product_id = tpi.product_id LIMIT 1) IS NULL,'',(SELECT image_url FROM tbl_product_images WHERE product_id = tpi.product_id LIMIT 1)) AS image, `product_id` AS productId, tpi.category_id AS catId, tpc.name AS categoryName, `subcategory_id` AS subCatId, tpsc.sub_cat_name AS subCategoryName, `product_name` AS productName, tpi.description, `price`, (CASE WHEN DATE_ADD(created_at, INTERVAL 1 DAY) > NOW() THEN '1' ELSE '0' END) AS isNewProduct FROM `tbl_products_items` AS tpi JOIN `tbl_product_category` AS tpc on tpi.category_id = tpc.id JOIN `tbl_product_sub_category` AS tpsc on tpi.subcategory_id = tpsc.sub_cat_id WHERE is_deleted = '0' AND status = '1' AND is_featured = '1' AND show_product = '1' ORDER BY created_at DESC LIMIT ?,?";
      //            console.log(products);
      var q = connection.query(
        products,
        [offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (rows.length > 0) {
            message = languages.success[lang];
            data = rows;

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  product.get("/getOrderTrackLogs", function (req, res, next) {
    var order_id = req.query.orderId;
    if (order_id > 0) {
      var query =
        "select * from customers_order_status_logs where order_id=? order by id DESC";
      connection.query(query, [order_id], function (error, rows, fields) {
        if (error) {
          successStatus = false;
          status = 404;
          data = "";
          message = "" + error;
          //                    Utils.makeResponse(res, successStatus, status, message, appVersion, data);
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        } else {
          //                       Utils.makeResponse(res, true, 200, '', appVersion, rows);
          if (rows.length > 0) {
            synceach(
              rows,
              function (item, next) {
                item.timestamp = new Date(item.created_at).getTime() / 1000;
                item.order_status = item.order_status;

                //result[i] = res;
                next(null, item);
              },
              function (err, transformedItems) {
                message = "Records found successfully.";
                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  transformedItems
                );
              }
            );
          } else {
            message = "No record found!";
            //                        Utils.makeResponse(res, successStatus, status, message, appVersion, data);
            Utils.makeResponse(res, true, 200, message, appVersion, "");
          }
        }
      });
    } else {
      successStatus = false;
      status = 404;
      data = "";
      message = "No record found!";
      Utils.makeResponse(res, successStatus, status, message, appVersion, data);
    }
  });

  product.get("/getCallcenterOrderTrackLogs", function (req, res, next) {
    var order_id = req.query.orderId;
    if (order_id > 0) {
      var query =
        "select * from callcenter_order_status_logs where order_id=? order by id DESC";
      connection.query(query, [order_id], function (error, rows, fields) {
        if (error) {
          successStatus = false;
          status = 404;
          data = "";
          message = "" + error;
          //                    Utils.makeResponse(res, successStatus, status, message, appVersion, data);
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        } else {
          //                       Utils.makeResponse(res, true, 200, '', appVersion, rows);
          if (rows.length > 0) {
            synceach(
              rows,
              function (item, next) {
                item.timestamp = new Date(item.created_at).getTime() / 1000;
                item.order_status = item.order_status;

                //result[i] = res;
                next(null, item);
              },
              function (err, transformedItems) {
                message = "Records found successfully.";
                Utils.makeResponse(
                  res,
                  true,
                  200,
                  message,
                  appVersion,
                  transformedItems
                );
              }
            );
          } else {
            message = "No record found!";
            //                        Utils.makeResponse(res, successStatus, status, message, appVersion, data);
            Utils.makeResponse(res, true, 200, message, appVersion, "");
          }
        }
      });
    } else {
      successStatus = false;
      status = 404;
      data = "";
      message = "No record found!";
      Utils.makeResponse(res, successStatus, status, message, appVersion, data);
    }
  });
  return product;
};
