"use strict";

//tracer
var logger = require("tracer").colorConsole({
  format: [
    "{{timestamp}} (in line: {{line}}) >> {{message}}", //default format
    {
      error:
        "{{timestamp}} <{{title}}> {{message}} (in {{file}}:{{line}})\nCall Stack:\n{{stack}}", // error format
    },
  ],
  dateformat: "HH:MM:ss.L",
  preprocess: function (data) {
    data.title = data.title.toUpperCase();
  },
});

var appVersion = "1.0.0";
var languages = require("../../locales/languages"),
  Auth = require("../../util/Auth");
const AesEncryptionDecryption = require("../../util/AesEncryptionDecryption");
/**** Export API V1 ****/
var lang;

module.exports = function (app, express, connection, inspector, Utils) {
  //connection.connect();
  var user = express.Router();

  /*
   * Middleware to authenticate or verify token
   */
  user.use(async function (req, res, next) {
    var token = req.headers["x-cafejavas-token"]; // set jwt token
    lang = req.headers["language"];
    var getuserid = req.headers["x-cafejavas-userid"]; // set userid
    var isguestuser = req.headers["x-cafejavas-isguestuser"]; // set userid
    const isSecured = req.headers['x-cafejavas-issecured']; // set userid 
    const isApiV2 = req.headers['x-cafejavas-api-v2']; // set isSecured 

    //decryption of jwt token
    if (isApiV2 == '1') { token = await AesEncryptionDecryption.decryptCipherTextWithRandomIV(token) };

    var data = [];
    // check language key getting in header or not and assign language
    if (lang && languages.avail_lang[lang]) {
      lang = languages.avail_lang[lang];
    } else {
      lang = "en";
    }

    if (token) {
      // verify jwt token
      Auth.verifyJWTToken(token).then(function (tokenresp) {
        if (tokenresp || token == "nitin_token") {
          if (getuserid) {
            // check user is registered in app  before sending request to api
            Utils.checkValidUser(connection, getuserid).then(function (d) {
              if (d) {
                if (d[0].status == "1") {
                  req.decoded = tokenresp;
                  if (isSecured != 1) {
                    if (tokenresp.iss == 'IOS' || tokenresp.iss == 'Android') {
                      Utils.makeResponse(res, false, 200, languages.no_access[lang], appVersion, data);
                    }
                  }
                  next();
                } else {
                  Utils.makeResponse(
                    res,
                    true,
                    401,
                    languages.user_deactivated[lang],
                    appVersion,
                    data
                  );
                }
              } else {
                Utils.makeResponse(
                  res,
                  true,
                  401,
                  languages.invalid_user[lang],
                  appVersion,
                  data
                );
              }
            });
          } else {
            Utils.makeResponse(
              res,
              true,
              401,
              languages.invalid_user[lang],
              appVersion,
              data
            );
          }
        } else {
          //                    Auth.generateJWTToken('86','ss.sharma@gmail.com','86461634454').then(function (tokenresp) {
          //                                logger.log(tokenresp);
          //                            });
          Utils.makeResponse(
            res,
            false,
            401,
            languages.invalid_token[lang],
            appVersion,
            data
          );
        }
      });
    } else {
      Utils.makeResponse(
        res,
        true,
        403,
        languages.no_token[lang],
        appVersion,
        data
      );
    }
  });
  //

  /***************************************************************************************************************************************************************/
  /************************************************************************ / ************************************************************************/

  /**
     * @api {post} /updateSetting/ update user setting.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiHeader {String} x-cafejavas-userid send userid which using the api
     * @apiHeader {String} x-cafejavas-token send jwt token
     * @apiVersion 1.0.0
     * @apiName updateSetting
     * @apiGroup Users API (After Login)
     * @apiParam {String} userId user id.    
     * @apiParam {String} isNotification Notification toggle (1:Active,0:Inactive).    
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Setting updated Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result": [ { isNotification: '1', userId: '98' }
     ]
     *     }
     *
     */

  user.post("/updateSetting", function (req, res) {
    logger.info('EXPRESS: post("/updateSetting") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
        isNotification: { type: "any" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var updateUser =
        "UPDATE `tbl_users_setting` SET `is_notification`= ? WHERE  user_id=?";
      connection.query(
        updateUser,
        [user.isNotification, user.userId],
        function (err, sucmessage) {
          message = languages.Setting_updated[lang];
          data[0] = user;
          Utils.makeResponse(res, true, 200, message, appVersion, data);
        }
      );
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ / ************************************************************************/

  /**
     * @api {get} /myAccount/ User Profile Information.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiHeader {String} x-cafejavas-userid send userid which using the api
     * @apiHeader {String} x-cafejavas-token send jwt token
     * @apiVersion 1.0.0
     * @apiName myAccount
     * @apiGroup Users API (After Login)
     * @apiParam {String} userId user id.
     * @apiParam {String} deviceToken user deviceToken.            
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Setting updated Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     {
     "isNotification": 1,
     "userId": 86,
     "profilePic": "xyz",
     "firstName": "Ajay",
     "lastName": "Singh",
     "email": "ss.sharma@gmail.com",
     "dob": "1994-03-06",
     "countryCode": "+91",
     "phone": "86461634454",
     "rewards": 0,
     "deviceToken": "",
     "deviceType": "1",
     "deviceId": "8341f8f5ba42747",
     "userType": "1",
     "otp": 1234
     }
     ]
     *     }
     *
     */

  user.get("/myAccount", function (req, res) {
    logger.info('EXPRESS: post("/myAccount") --> RECEIVED'.event);

    logger.log("%O", req.query);
    var user = req.query;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var deviceToken = user.deviceToken || false;
      updateUserdeviceToken(user.userId, deviceToken)
        .then(function (checkUser) {
          if (checkUser) {
            // update profile query
            var userloyaltyID =
              "select MEMBERSHIP_ID as memberId from T_MEMBER_DATA_MOBILE where UID = ? ";
            connection.query(
              userloyaltyID,
              [user.userId],
              function (err, rows, fields) {
                if (err) {
                  logger.log(err);
                  message = languages.something_went_wrong[lang];

                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  if (rows.length > 0) {
                    var membershipId = rows[0].memberId;
                    var userdetail = "call getUserDetailById(?) ";
                    connection.query(
                      userdetail,
                      [user.userId],
                      function (err, userdata) {
                        message = languages.profile_updated[lang];
                        userdata[0][0].membershipId = membershipId;
                        data = userdata[0];

                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    );
                  } else {
                    var membershipId = "";
                    var userdetail = "call getUserDetailById(?) ";
                    connection.query(
                      userdetail,
                      [user.userId],
                      function (err, userdata) {
                        message = languages.profile_updated[lang];
                        userdata[0][0].membershipId = membershipId;
                        console.log(userdata[0]);
                        data = userdata[0];

                        Utils.makeResponse(
                          res,
                          true,
                          200,
                          message,
                          appVersion,
                          data
                        );
                      }
                    );
                  }
                }
              }
            );
          } else {
            console.log("ffHIIIIIIIIII");

            var message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
        })
        .catch(function (err) {
          console.log("errorrrr1133" + err);
          poolConnection.rollback(function () {
            var message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
            if (connection._freeConnections.indexOf(poolConnection) == "-1") {
              poolConnection.release();
            }
          });
        });
    }
  });

  function updateUserdeviceToken(userId, deviceToken) {
    return new Promise(function (resolve, reject) {
      if (deviceToken) {
        var getUserIdQr = "update users set device_token=? WHERE user_id = ?";
        connection.query(
          getUserIdQr,
          [deviceToken, userId],
          function (err, rows, fields) {
            if (err) {
              console.log(err);
              reject(false);
            } else {
              resolve(1);
            }
          }
        );
      } else {
        resolve(1);
      }
    });
  }

  /**
     * @api {post} /updateProfile/ Update User Profile.
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiHeader {String} x-cafejavas-userid send userid which using the api
     * @apiHeader {String} x-cafejavas-token send jwt token
     * @apiVersion 1.0.0
     * @apiName updateProfile
     * @apiGroup Users API (After Login)
     * @apiParam {String} userId user id.            
     * @apiParam {String} firstName First Name.            
     * @apiParam {String} lastName Last Name.            
     * @apiParam {String} dob Date of Birth.            
     * @apiParam {String} profilePic Profile Pic.            
     * @apiParam {String} userId user id.            
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Profile updated Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     {
     "isNotification": 1,
     "userId": 86,
     "profilePic": "xyz",
     "firstName": "Ajay",
     "lastName": "Singh",
     "email": "ss.sharma@gmail.com",
     "dob": "1994-03-06",
     "countryCode": "+91",
     "phone": "86461634454",
     "rewards": 0,
     "deviceToken": "",
     "deviceType": "1",
     "deviceId": "8341f8f5ba42747",
     "userType": "1",
     "otp": 1234
     }
     ]
     *     }
     *
     */

  user.post("/updateProfile", function (req, res) {
    logger.info('EXPRESS: post("/updateProfile") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
        firstName: { type: "string" },
        lastName: { type: "string" },
        dob: { type: "string" },
        profilePic: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      if (user.profilePic.startsWith('https://restaurentapp.s3-eu-west-1.amazonaws.com')) {
        user.profilePic = user.profilePic.replace('https://restaurentapp.s3-eu-west-1.amazonaws.com', 'https://media.cafejavas.co.ug');
      } else if (user.profilePic.startsWith('https://cafejavasmedia.s3.af-south-1.amazonaws.com')) {
        user.profilePic = user.profilePic.replace('https://cafejavasmedia.s3.af-south-1.amazonaws.com', 'https://media.cjs.co.ke');
      }
      // update profile query
      var updateprofile =
        "UPDATE `users` SET `first_name`=?,`last_name`=?,`dob`=?,`profile_pic`=? WHERE  user_id = ?";
      connection.query(
        updateprofile,
        [user.firstName, user.lastName, user.dob, user.profilePic, user.userId],
        function (err, succ) {
          if (err) {
            logger.log(err);
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            // get user information
            var userdetail = "call getUserDetailById(?) ";
            connection.query(
              userdetail,
              [user.userId],
              function (err, userdata) {
                message = languages.profile_updated[lang];
                data = userdata[0];

                Utils.makeResponse(res, true, 200, message, appVersion, data);
              }
            );
          }
        }
      );
    }
  });


  /**
   * @api {put} /deleteUser Delete User Account
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiVersion 1.0.0
   * @apiName deleteUser
   * @apiGroup Users
   * @apiParam {Number} userId Unique user ID
   * @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *   "Success": true,
   *   "Status": 200,
   *   "Message": "Success",
   *   "AppVersion": "1.0.0",
   *   "Result":  {
   *   "addressType": "1"
   *   }
   *   }
   *
   */
  user.post("/deleteUser", function (req, res) {
    logger.info('EXPRESS: post("/deleteUser") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      // update profile query
      console.log(user.userId);
      var updateprofile =
        "UPDATE `users` SET `is_delete`='1' WHERE  user_id = ?";
      connection.query(
        updateprofile,
        [user.userId],
        function (err, succ) {
          if (err) {
            logger.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else {
            var message = languages.success[lang];
            Utils.makeResponse(
              res,
              true,
              200,
              message,
              appVersion,
              data
            );
          }
        }
      );
    }
  });

  /**
     * @api {post} /changePassword/ Change Password
     * @apiHeader {String} Content-Type multipart/form-data.
     * @apiHeader {String} language send language flag
     * @apiHeader {String} x-cafejavas-userid send userid which using the api
     * @apiHeader {String} x-cafejavas-token send jwt token
     * @apiVersion 1.0.0
     * @apiName changePassword
     * @apiGroup Users API (After Login)
     * @apiParam {String} userId user id.            
     * @apiParam {String} oldPassword User Old Passowrd.            
     * @apiParam {String} newPassword User New Passowrd.                     
     * @apiParam {String} userId user id.            
     * @apiSuccess {Boolean} Success Success status either true or false. 
     * @apiSuccess {Number}  Status status code.
     * @apiSuccess {String}  Message string.
     * @apiSuccess {Object}  Response data.
     *  @apiExample {curl} Example usage:
     *     curl -i http://staging.techaheadcorp.com:3000/api/v1
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *      "Success": true,
     *       "Status": 200,
     *       "Message": "Password Changed Successfully",
     *       "AppVersion": "1.0.0",
     *       "Result":  [
     
     ]
     *     }
     *
     */

  user.post("/changePassword", function (req, res) {
    logger.info('EXPRESS: post("/changePassword") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        userId: { type: "any" },
        oldPassword: { type: "string" },
        newPassword: { type: "string" },
      },
    };
    var data = [];
    var message = "";
    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      //            message = validationresult.format();

      //            logger.log(validationresult.format());

      message = languages.bad_request[lang];

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var checkuser =
        "select count(user_id) as totalrec from users where user_id = ? and password = md5(?)";
      connection.query(
        checkuser,
        [user.userId, user.oldPassword],
        function (err, userresp) {
          if (err) {
            message = languages.something_went_wrong[lang];

            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (userresp[0].totalrec > 0) {
            // update profile query
        
            var updateprofile =
              "UPDATE `users` SET password = md5(?) WHERE  user_id = ?";
            connection.query(
              updateprofile,
              [user.newPassword, user.userId],
              function (errd, successdata) {
                if (errd) {
                  message = languages.something_went_wrong[lang];

                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  message = languages.password_changed[lang];
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              }
            );
          } else {
            message = languages.invalid_userID_or_oldPassword[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /***************************************************************************************************************************************************************/
  /************************************************************************ /userLogin ************************************************************************/
  /**
   * @api {post} /addAddress addAddress
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiDescription addAddress user into the app.
   * @apiGroup Users
   * @apiName addAddress
   * ***************************************************************************************************************************************************************
   * @apiParam (Expected parameters) {string} 			first_name 					first_name (user email)
   * @apiParam (Expected parameters) {string} 			last_name 					last_name
   * @apiParam (Expected parameters) {string} 			email                                           email
   * @apiParam (Expected parameters) {string} 			password 					password
   * @apiParam (Expected parameters) {string} 			device_token 					device_token
   * @apiParam (Expected parameters) {string} 			device_type 					device_type
   *****************************************************************************************************************************************************************
   * @apiSuccess {Object}  						response       						response object
   * @apiSuccess {Number=0,1}  						response.status   				response status ( 0 for error, 1 for success )
   * @apiSuccess {string}  							[response.message=null]   		error message
   * @apiSuccess {Object}  							[response.data=null]   			response data
   * ***************************************************************************************************************************************************************
   * @apiVersion 0.0.1
   */

  user.post("/addAddress", function (req, res) {
    logger.info('EXPRESS: post("/addAddress") --> RECEIVED'.event);

    logger.log("%O", req.body);
    var user = req.body;

    var schema = {
      type: "object",
      properties: {
        user_id: { type: "string" },
        address: { type: "string" },
        lat: { type: "float" },
        lng: { type: "float" },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      message = validationresult.format();

      logger.log(validationresult.format());

      makeResponse(res, successStatus, status, message, appVersion, data);
    } else {
      connection.query(
        "call saveAddress(?,?,?,?)",
        [user.user_id, user.address, user.lat, user.lng],
        function (err, lastInsertId, fields) {
          //console.log(JSON.stringify(lastInsertId));
          //console.log(JSON.stringify(lastInsertId[0][0]));

          if (err) {
            throw err;
            message = "Something went wrong";
            makeResponse(res, successStatus, status, message, appVersion, data);
          } else {
            status = 200;
            successStatus = true;
            message = "address saved successfully";

            makeResponse(res, successStatus, status, message, appVersion, data);
          }
        }
      );
    }
  });

  user.get("/getAddressByUser/:user_id", function (req, res) {
    logger.info('EXPRESS: post("/getAddressByUser") --> RECEIVED'.event);
    logger.log("%O", req.params);

    var user = req.params;
    var schema = {
      type: "object",
      properties: {
        user_id: { type: "string", minLength: 1 },
      },
    };

    var validationresult = inspector.validate(schema, user);

    if (!validationresult.valid) {
      // INVALID
      message = validationresult.format();

      logger.log(validationresult.format());

      makeResponse(res, successStatus, status, message, appVersion, data);
    } else {
      var address = "SELECT * FROM user_address where user_id=?";

      connection.query(address, [user.user_id], function (err, rows, fields) {
        //console.log(rows[0].user_id);
        if (err) {
          message = "Something went wrong";
        } else {
          if (rows.length > 0) {
            status = 200;
            message = "Address list";
            successStatus = true;
            data = rows;
            makeResponse(res, successStatus, status, message, appVersion, data);
          } else {
            message = "No products found.";
            makeResponse(res, successStatus, status, message, appVersion, data);
          }
        }
      });
    }
  });

  // Check is user register with cafejava

  user.get("/isUserExists", function (req, res) {
    var message = "";
    var data = [];
    logger.info('EXPRESS: get("/isUserExists") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var requestData = req.query;
    var schema = {
      type: "object",
      properties: {
        email: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, requestData);

    if (!validationresult.valid) {
      // INVALID
      message = validationresult.format();

      logger.log(validationresult.format());

      Utils.makeResponse(res, successStatus, status, message, appVersion, data);
    } else {
      let email = requestData.email.replace(/\/$/, "");
      let checkUser =
        "SELECT user_id FROM users where email=? and is_delete=0 and user_verified=1";
      connection.query(checkUser, [email], function (err, rows, fields) {
        if (err) {
          message = "Something went wrong";
          Utils.makeResponse(res, false, 500, message, appVersion, data);
        } else {
          if (rows.length > 0) {
            let status = 200;
            message = "User exists in the system.";
            let successStatus = true;
            data = rows;
            Utils.makeResponse(
              res,
              successStatus,
              status,
              message,
              appVersion,
              data
            );
          } else {
            message = "User Not Found";
            Utils.makeResponse(res, false, 404, message, appVersion, data);
          }
        }
      });
    }
  });

  /**
   * @api {post} /favUnFavProduct Favourite and unfavourite product.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName favUnFavProduct
   * @apiGroup Users API (After Login)
   * @apiParam {String} productId product Id.
   * @apiParam {String} userId userId.
   * @apiParam {String} status favourite or unfavourite status (1:Favourite,0:Unfavourite).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *      {
   *           "Success": true,
   *           "Status": 200,
   *           "Message": "Successfully added as Favourite !",
   *           "AppVersion": "1.0.0",
   *           "Result": {"status":"1"}
   *      }
   *
   */

  user.post("/favUnFavProduct", function (req, res) {
    logger.info('EXPRESS: post("/favUnFavProduct") --> RECEIVED'.event);

    var getrequests = req.body;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        productId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, getrequests);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var products =
        "SELECT count(product_id) as numprod FROM `tbl_products_items` WHERE product_id = ?";
      connection.query(
        products,
        [getrequests.productId],
        function (err, rows, fields) {
          if (err) {
            logger.log(err);
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          } else if (rows[0].numprod > 0) {
            var favouritequery =
              "INSERT INTO `tbl_favourite_products`( `product_id`, `user_id`) VALUES (?,?)";
            message = languages.favourite_product_success[lang];
            var status = 1;
            if (getrequests.status == "0") {
              favouritequery =
                "delete from tbl_favourite_products where  `product_id`=? and `user_id`=?";
              message = languages.unfavourite_product_success[lang];
              status = 0;
            }

            connection.query(
              favouritequery,
              [getrequests.productId, getrequests.userId],
              function (perr, prows, pfields) {
                if (perr) {
                  message = languages.something_went_wrong[lang];
                  Utils.makeResponse(
                    res,
                    false,
                    400,
                    message,
                    appVersion,
                    data
                  );
                } else {
                  data.status = status;
                  Utils.makeResponse(res, true, 200, message, appVersion, data);
                }
              }
            );
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, false, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
   * @api {get} /favouriteProducts Favourite Products Listing.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName favouriteProducts
   * @apiGroup Products
   * @apiParam {String} userId user Id.
   * @apiParam {String} page page number (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "productId": 1,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "userId":1,
   *           "productName": "Marinara",
   *           "description":"",
   *           "image": "",
   *           "price":"50"
   *         },
   *         {
   *           "productId": 2,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "userId":1,
   *           "productName": "Margherita",
   *           "description":"",
   *           "image": "",
   *           "price": "60"
   *         }
   *       ]
   *     }
   *
   */

  user.get("/favouriteProducts", function (req, res) {
    logger.info('EXPRESS: post("/getProducts") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var userrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, userrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 20;
      if (userrequest.page == "1") offset = 0;
      else offset = (userrequest.page - 1) * limit;

      var products =
        'SELECT (select image_url from tbl_product_images where product_id = p.product_id limit 1) as image,p.product_id as productId, p.category_id as catId, p.subcategory_id as subCatId, p.product_name as productName, p.description, p.price FROM `tbl_products_items` as p join tbl_favourite_products as fp on p.product_id = fp.product_id WHERE fp.user_id = ? and p.is_deleted = "0" and p.status="1" order by p.created_at desc limit ?,?';
      //console.log(products);
      var q = connection.query(
        products,
        [userrequest.userId, offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          if (rows.length > 0) {
            message = languages.success[lang];
            data = rows;

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
   * @api {get} /rewardPage Reward Page Data.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName rewardPage
   * @apiGroup Users
   * @apiParam {String} userId user Id.
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": {
   *           "usertotal": 1,
   *           "userRewardpoint": 1,
   *           "groupName": 1,
   *           "groupCount":1,
   *           "productName": "Marinara",
   *           "goldAmount":"",
   *           "platinumAmount": "",
   *           "silverAmount": ""
   *
   *       }
   *     }
   *
   */

  user.get("/rewardPage", function (req, res) {
    //  logger.info('EXPRESS: post("/getProducts") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var userrequest = req.query;
    var data = {};
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, userrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var userQry =
        "SELECT sum(o.total) as usertotal,u.reward_points as userRewardpoint FROM users as u left join orders as o on u.user_id = o.user_id WHERE u.user_id = ? and o.is_guest_user = '0' and u.is_delete='0'";
      //console.log(products);
      var q = connection.query(
        userQry,
        [userrequest.userId],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          if (rows.length > 0) {
            var groupQry =
              "select group_name as groupName,count groupCount from reward_product_group where is_active='1' and is_deleted='0' order by id desc limit 1";
            connection.query(groupQry, [], function (err, rows1, fields) {
              if (err) {
                logger.log(err);
                message = languages.something_went_wrong[lang];

                Utils.makeResponse(res, false, 400, message, appVersion, data);
              } else {
                var levelQry =
                  "select gold_amount as goldAmount,platinum_amount as platinumAmount,silver_amount as silverAmount from level order by id desc limit 1";
                connection.query(levelQry, [], function (err, rows2, fields) {
                  if (err) {
                    logger.log(err);
                    message = languages.something_went_wrong[lang];

                    Utils.makeResponse(
                      res,
                      false,
                      400,
                      message,
                      appVersion,
                      data
                    );
                  } else {
                    message = languages.success[lang];
                    data.usertotal = rows[0].usertotal;
                    data.userRewardpoint = rows[0].userRewardpoint;
                    data.groupName = rows1[0].groupName;
                    data.groupCount = rows1[0].groupCount;
                    data.goldAmount = rows2[0].goldAmount;
                    data.platinumAmount = rows2[0].platinumAmount;
                    data.silverAmount = rows2[0].silverAmount;

                    Utils.makeResponse(
                      res,
                      true,
                      200,
                      message,
                      appVersion,
                      data
                    );
                  }
                });
              }
            });
          } else {
            message = languages.user_deactivated[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  /**
   * @api {get} /favouriteProductsWeb Favourite Products Listing.
   * @apiHeader {String} Content-Type multipart/form-data.
   * @apiHeader {String} language send language flag
   * @apiHeader {String} x-cafejavas-userid send userid which using the api
   * @apiHeader {String} x-cafejavas-token send jwt token
   * @apiVersion 1.0.0
   * @apiName favouriteProducts
   * @apiGroup Products
   * @apiParam {String} userId user Id.
   * @apiParam {String} page page number (start with page number 1).
   *  @apiExample {curl} Example usage:
   *     curl -i http://staging.techaheadcorp.com:3000/api/v1
   * @apiSuccess {Boolean} Success Success status either true or false.
   * @apiSuccess {Number}  Status status code.
   * @apiSuccess {String}  Message string.
   * @apiSuccess {Object}  Response data.
   * @apiSuccessExample Success-Response:
   *   HTTP/1.1 200 OK
   *   {
   *      "Success": true,
   *       "Status": 200,
   *       "Message": "",
   *       "AppVersion": "1.0.0",
   *       "Result": [
   *         {
   *           "productId": 1,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "userId":1,
   *           "productName": "Marinara",
   *           "description":"",
   *           "image": "",
   *           "price":"50"
   *         },
   *         {
   *           "productId": 2,
   *           "catId": 1,
   *           "subCatId": 1,
   *           "userId":1,
   *           "productName": "Margherita",
   *           "description":"",
   *           "image": "",
   *           "price": "60"
   *         }
   *       ]
   *     }
   *
   */

  user.get("/favouriteProductsWeb", function (req, res) {
    logger.info('EXPRESS: post("/favouriteProductsWeb") --> RECEIVED'.event);
    logger.log("%O", req.query);
    var userrequest = req.query;
    var data = [];
    var message = "";
    var schema = {
      type: "object",
      properties: {
        userId: { type: "string" },
        page: { type: "string" },
      },
    };

    var validationresult = inspector.validate(schema, userrequest);

    if (!validationresult.valid) {
      // INVALID
      message = languages.bad_request[lang];

      logger.log(validationresult.format());

      Utils.makeResponse(res, false, 400, message, appVersion, data);
    } else {
      var offset = 0;
      var limit = 20;
      if (userrequest.page == "1") offset = 0;
      else offset = (userrequest.page - 1) * limit;

      //            var products = 'SELECT (select image_url from tbl_product_images where product_id = p.product_id limit 1) as image,p.product_id as productId, p.category_id as catId, p.subcategory_id as subCatId, p.product_name as productName, p.description, p.price FROM `tbl_products_items` as p join tbl_favourite_products as fp on p.product_id = fp.product_id WHERE fp.user_id = ? and p.is_deleted = "0" and p.status="1" order by p.created_at desc limit ?,?';
      var products =
        'SELECT (select image_url from tbl_product_images where product_id = p.product_id limit 1) as image,p.product_id as productId, p.category_id as catId, p.subcategory_id as subCatId, p.product_name as productName, p.description, p.price, tpc.name AS categoryName, tpsc.sub_cat_name AS subCategoryName FROM `tbl_products_items` as p join tbl_favourite_products as fp on p.product_id = fp.product_id JOIN `tbl_product_category` AS tpc on p.category_id = tpc.id JOIN `tbl_product_sub_category` AS tpsc on p.subcategory_id = tpsc.sub_cat_id WHERE fp.user_id = ? and p.is_deleted = "0" and p.status="1" order by p.created_at desc limit ?,?';
      //console.log(products);
      var q = connection.query(
        products,
        [userrequest.userId, offset, limit],
        function (err, rows, fields) {
          //                logger.log(q);
          //console.log(rows[0].user_id);
          if (err) {
            message = languages.something_went_wrong[lang];
            Utils.makeResponse(res, false, 400, message, appVersion, data);
          }
          if (rows.length > 0) {
            message = languages.success[lang];
            data = rows;

            Utils.makeResponse(res, true, 200, message, appVersion, data);
          } else {
            message = languages.no_product_found[lang];
            Utils.makeResponse(res, true, 200, message, appVersion, data);
          }
        }
      );
    }
  });

  return user;
};
