"use strict";

require("events").EventEmitter.defaultMaxListeners = Infinity;

// get the packages we need
var fs = require("fs"), //use to handle file I/O opreations
  express = require("express"), //use to define framework
  https = require("https"), // https server
  app = express(), //taking express object for whole project
  bodyParser = require("body-parser"), //it is use to handle post reuqests
  morgan = require("morgan"), //use morgan to for development env
  config = require("./config/config"), // get our config file
  db_client = require("./config/appDb.js"),
  session = require("express-session"),
  fileUpload = require("express-fileupload"),
  Utils = require("./util/custom_functions"),
  expressValidator = require("express-validator"),
  inspector = require("schema-inspector");
app.use(expressValidator());

app.use(
  bodyParser.json({
    limit: "50mb",
    type: "application/json",
  })
);

app.use(
  bodyParser.urlencoded({
    extended: false,
  })
);
app.use(fileUpload());

// Setting Secret code globally
app.set("superSecret", config.CONSTANTS.secret);

// use body parser so we can get info from POST and/or URL parameters

app.use(bodyParser.urlencoded({ extended: false }));

//enabling bodyparser to accept json also
app.use(bodyParser.json());
app.use(
  session({
    resave: false, // don't save session if unmodified
    saveUninitialized: false, // don't create session until something stored
    secret: "darf2121d0hgj45",
  })
);

// use morgan to log requests to the console
app.use(morgan("dev"));

//define public folder as a static folder
app.use(express.static(__dirname + "/public"));

app.use(express.static(__dirname + "/uploads"));

// Switch off the default 'X-Powered-By: Express' header
app.disable("x-powered-by");

//create custom headers to our custom headers
function customHeaders(req, res, next) {
  // OR set your own header here
  res.setHeader("x-cafejavas-App-Version", "v1.0.0");
  next();
}

//adding customHeaders function in middleware
app.use(customHeaders);

//app.engine('ejs', require('ejs').renderFile);

//Adding route for home page
app.get("/", function (req, res) {
  res.send(
    '<html><head></head><body style="bg-color:#ccc;"><center><h2><b>Cafe Javas Kenya SSL</i></b></h2></center></body></html>'
  );
});

//app.set('views', path.join(__dirname, './app/views'));
//app.set('view engine', 'ejs');

//Adding route for docs
app.get("/docs", function (req, res) {
  app.use(express.static(__dirname + "/docs"));
  res.sendFile("./public/docs/index.html", { root: __dirname });
});

var successStatus = false,
  message,
  appVersion = "1.0.0",
  status = 400,
  data;
// Define apiv1 for version v1 api routes and require routes based file
var api1 = require("./routes/v1/index")(
  app,
  express,
  db_client,
  inspector,
  Utils
);
var product = require("./routes/v1/product")(
  app,
  express,
  db_client,
  inspector,
  Utils
);
var user = require("./routes/v1/user")(
  app,
  express,
  db_client,
  inspector,
  Utils
);
var driver = require("./routes/v1/driver")(
  app,
  express,
  db_client,
  inspector,
  successStatus,
  status,
  message,
  appVersion,
  data,
  Utils
);
var order = require("./routes/v1/order")(
  app,
  express,
  db_client,
  inspector,
  successStatus,
  status,
  message,
  appVersion,
  data,
  Utils
);

//Adding middleware for api v1
app.use("/api/v1", api1);
app.use("/api/v1", product);
app.use("/api/v1", user);
app.use("/api/v1", driver);
app.use("/api/v1", order);

// Handle admin routes
//var admin = require('./admin2/index')(app, db_client);
//app.use('/admin', admin);

// Handle merchant routes
//
//var merchant = require('./merchant/index')(app, db_client);
//app.use('/merchant', merchant);

// starting server at define port
//app.listen(config.CONSTANTS.PORT);

https
  .createServer(
    {
      key: fs.readFileSync("/etc/ssl/sslcrt/dev.cjs.co.ke.key"),
      cert: fs.readFileSync("/etc/ssl/sslcrt/dev.cjs.co.ke.crt"),
    },
    app
  )
  .listen(config.CONSTANTS.PORT, function () {
    console.log(
      "Server running at " + config.CONSTANTS.HTTP + ":" + config.CONSTANTS.PORT
    );
  });

// Catch errors and save as file in log folder
process.on("uncaughtException", function (err) {
  var stack = err.stack;
  var timeout = 1;
  console.log(stack);
  // save log to timestamped log file
  var filename = "crash_" + new Date() + ".log";
  console.log("LOGGING ERROR TO " + filename);
  console.log(stack);
});
