var jwt = require('jsonwebtoken');
var bcrypt = require('bcrypt');
var promise = require('promise');
var config = require('../config/config');

//Generate jwt token 
exports.generateJWTToken = function(userId,email,userPhone){
    
    return new Promise(function(resolve, reject) {
        
        var payload = {
          userPhone:userPhone,
          userId:userId,
          email:email
        };
        
        var token = jwt.sign(payload, config.CONSTANTS.secretKey, {
          expiresIn: config.CONSTANTS.JWT_EXPIRATION_TIME  // expires in 6 hours
        });
       
        resolve(token);

    }); 
}


//verify jwt token 
exports.verifyJWTToken = function(token){
    return new Promise(function(resolve, reject) {
        
        jwt.verify(token, config.CONSTANTS.secretKey, function (err, decoded) {
            if (err) {
               resolve(false);                
            } else {
               
                resolve(decoded);
            }
        });
       

    }); 
}


