
var     bcrypt          = require('bcrypt-nodejs'),
        config          = require('../config/config.js'),
        promise         = require('promise'),
        forEach         = require('async-foreach').forEach,
        apn             = require('apn'),
        fs              = require("fs"),
        db_client = require('../config/appDb.js'),
        nodemailer      = require('nodemailer');
var emailjs = require('emailjs');
var moment      = require('moment-timezone');
moment.tz.setDefault("Etc/Universal");
var synceach    = require('sync-each');
var FCM = require('fcm-node');
var http = require('http');
var querystring = require('querystring');
var Request = require("request");
const sgMail = require('@sendgrid/mail')
sgMail.setApiKey(config.CONSTANTS.SENDGRID_KEY);
           
//iniatiate a Object
function custom_func() {
    
}

console.log(moment(new Date()).unix());

/***** randomString - START  ****/

exports.randomString = function () {
    var text = "";
    var possible = "abcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < 9; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}

/**** getUnix - START  ****/

exports.getUnix = function () {

    return  moment().unix();
}

/**** getCurrentUtcTime - START  ****/

exports.getCurrentUtcTime = function (){

    return  moment().format("YYYY-MM-DD H:mm:ss");
}


/**** makeResponse - START  ****/
exports.makeResponse = function (res, successStatus, status, message, appVersion, data) {
    
    // response
        res.set('Access-Control-Allow-Origin', '*');
        res.status(status).json({
            Success: successStatus,
            Status: status,
            Message: message,
            AppVersion: appVersion,
            Result: data

        });
    
}


/**** Find user detail by id  ****/
exports.findUserById = function (connection,userId) {
    
   return new promise(function(resolve,reject){
       var query = "call(getUserDetailById("+userId+")) ";
       connection.query(query,function(err,userdata){
           if(err)
           {
               resolve(false);
           }
           else
           {
            resolve(userdata);   
           }
           
       });
   });
    
}


/**** Find user detail by id  ****/
exports.checkValidUser = function (connection,userId) {
    
   return new promise(function(resolve,reject){
       var query = "select count(user_id) as totalrec,status from users where user_id = ? and is_delete = '0' and status = '1' and user_verified = '1' ";
       connection.query(query,[userId],function(err,userdata){
           
           if(err)
           {
               resolve(false);
           }
           else if(userdata[0].totalrec > 0)
           {
                resolve(userdata);   
           }
           else
           {
               resolve(false);
           }
           
       });
   });
    
}


/**** checkArray - START  ****/

exports.checkArrayResponse = function (arr) {
    var res = {
        status: (arr.length > 0) ? 200 : 200,
        message: (arr.length > 0) ? "Success" : "Data not found",
        result: arr
    }
    return res;
}

/**** customHeaders - START  ****/

exports.customHeaders = function (app, req, res, next) {
// Switch off the default 'X-Powered-By: Express' header
    app.disable('x-powered-by');
    // OR set your own header here
    res.setHeader('X-MedMe-App-Version', 'v1.0.0');
    // .. other headers here
    next();
}

/**** checknull - START  ****/

exports.checknull = function (value) {
    return (value == null) ? "" : value
}


/**** convertToBool - START  ****/

exports.convertToBool = function (value) {
    return (value === 0 || value === '0' || value === "true" || value === true) ? 1 : 0
}

/**** generateHash - START  ****/

exports.generateHash = function (password) {
    return bcrypt.hashSync(password, bcrypt.genSaltSync(8), null);
};



/**** verifyPassword - START ****/

exports.verifyPassword = function (password, dbPassword) {
    return bcrypt.compareSync(password, dbPassword);
};


/**** getRandomInteger - START  ****/

exports.getRandomInteger = function (min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
}



/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~ MAIL sendMail - START ~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

exports.sendMail = function (toEmail, subject, message) {
    console.log(toEmail);
    const data = {
        to: toEmail, // Change to your recipient
        from: 'noreply@cjs.co.ke', // Change to your verified sender
        subject: subject,
        // text: 'and easy to do anywhere, even with Node.js',
        html: message,
    }
    sgMail.send(data).then(() => {
        console.log('Email sent...:)');
    }).catch((error) => {
        console.log('error in sending email', error);
        console.error(error)
    })
};
/*
exports.sendMail = function (to, subject, message) {
    console.log(to);
    var server = emailjs.server.connect({
        user: "AKIAVQEAKIS66P4K5IN6",
        password: "BCGdxIVQqHdetyofnJm6niolq3II7rrkfO1U0ViqWaF/",
        host: "email-smtp.eu-west-1.amazonaws.com",
        tls: true
    });
    server.send({
        text: message,
        from: "CafeJavas <noreply@cafejavas.co.ug>",
        to: to,
        subject: subject,
        attachment: [{
                data: message,
                alternative: true
            }]
    },
    function (err, message)
    {
        console.log(err);
    });
};
*/
/*~~~~~~~~~~~~~~~ MAIL sendMail - END  ~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Top Products with options and price ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/********************************************************************************
 * Create dropdown list options with value by label 
 * 
 ********************************************************************************/

var arrayCreateForTopOption = function(connection,productId){
    
    return function(topProductLabels) {       
        
        return new promise(function(resolve,reject){
          var q = connection.query("SELECT if(tplo.amount is NULL,0,tplo.amount) as price,tplo.`id` as labelOptionId, tplo.`label_id` as labelId, tplo.`product_id` as productId, tplo.`name` as optionName FROM `tbl_product_label_options` as tplo  WHERE tplo.product_id = ? and tplo.label_id = ?",[productId,topProductLabels.topLabelId],function(err,result){
              if(err)
              { 
                  var lableoptions= [];
                topProductLabels.labelOptions = lableoptions;
              }
              {
                  topProductLabels.labelOptions = result;
                  resolve(topProductLabels);
              }
                    
                 
             });
        });
    };
}


/********************************************************************************
 * Generate top level products label name 
 * 
 ********************************************************************************/

exports.getTopSubproducts = function(connection,productId){
    return new promise(function(resolve,reject){
        connection.query("SELECT `id` as topLabelId, `product_id` as productId, `label_names` as labelNames, `label_type` as labelType, `label_option_type` as labelOption, IFNULL(label_price,0) as label_price FROM `tbl_products_labels` WHERE product_id = ? and label_type = '1' ",[productId],function(err,result){
           return promise.all(result.map(arrayCreateForTopOption(connection,productId))).then(function(data){   
               console.log("------------completed--------------");
//               console.log(data);
                resolve(data);
            });
        });
    }); 
};



/********************************************************************************
 * Generate customize product label names with prices
 * 
 ********************************************************************************/

exports.arrayCreateForCustomOption = function(connection,productId){
     return function(customizeProductLabels) {       
        
        return new promise(function(resolve,reject){
            var q = connection.query("SELECT tplop.amount as price,tplo.`id` as labelOptionId, tplo.`label_id` as labelId, tplo.`product_id` as productId, tplo.`name` as optionName FROM `tbl_products_customize_labels` as tplo join tbl_customize_product_label_options_price as tplop on tplo.id = tplop.label_option_id WHERE tplo.product_id = ? and tplo.label_id = ?",[productId,customizeProductLabels.topLabelId],function(err,result){
              if(err)
              { 
                  var lableoptions= [];
                customizeProductLabels.labelOptions = lableoptions;
              }
              {
                  customizeProductLabels.labelOptions = result;
                  resolve(customizeProductLabels);
              }
                    
                 
             });
        });
    };
};


/********************************************************************************
 * Additional products
 * 
 ********************************************************************************/


exports.additionalProducts = function(connection,productId){
    return new promise(function(resolve,reject){
        connection.query("SELECT `id` as additionalProductId, `product_id` as productId, `item_name` as itemName FROM `tbl_product_additional_items` WHERE  product_id = ? and is_delete='0' order by id asc",[productId],function(err,data){ 
                console.log("data:"+ JSON.stringify(data) + "error : "+err);
                resolve(data);               
        });
    }); 
};


/********************************************************************************
 * Customize products top horizontal label name
 * 
 ********************************************************************************/


exports.customizeProducts = function(connection,productId){    
   
        
        var getcustomizelabels =   new Promise(function(resolve, reject){
                connection.query("SELECT `id` as custLabelId, `product_id` as productId, `label_names` as labelNames FROM `tbl_products_customize_labels` WHERE product_id = ?  ",[productId],function(err,result){
                    
                resolve(result);
                
            });
        });   
     
     /*
        var customizeoptions =  new Promise(function (resolve, reject) {
           var q = connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ?   ", [productId], function (err1, result1) {
                
                if(result1.length > 0)
                {
                    var items = result1;
                   forEach(result1,function(val,index,itemoptions){
                      
                        var q1 = connection.query("SELECT tpcl.label_names as labelNames,tcplo.`id` as custlabelOptionPriceId, tcplo.`product_id` as productId,tcplo.amount,tcplo.label_id as custLabelId,tcplo.label_option_id as custlabelOptionId FROM `tbl_customize_product_label_options_price` as tcplo join tbl_products_customize_labels as tpcl on tpcl.id=tcplo.label_id WHERE tcplo.label_option_id = ?   ", [val.custlabelOptionId], function (err1, result2) {
                            items[index]['prices'] = result2;
                            if(index == result1.length-1)
                            {                                
                                resolve(itemoptions);
                            }

                            
                        });
                       
                   }); 
                }
                else
                {
                    resolve(result1);
                }
           });

       });
            */
            /*
            console.log("----------------------------");
            var customizeoptions =  new Promise(function (resolve, reject) {
                connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ?   ", [productId], function (err1, result1) {
                
                if(result1.length > 0)
                {
                   
                    synceach(result1, function (item, next) { 
                            connection.query("SELECT tpcl.label_names as labelNames,tcplo.`id` as custlabelOptionPriceId, tcplo.`product_id` as productId,tcplo.amount,tcplo.label_id as custLabelId,tcplo.label_option_id as custlabelOptionId FROM `tbl_customize_product_label_options_price` as tcplo join tbl_products_customize_labels as tpcl on tpcl.id=tcplo.label_id WHERE tcplo.label_option_id = ?   ", [item.custlabelOptionId], function (err1, result2) {
                            if(err1)
                            {
                                item.prices=[];
                                next(null, item);
                            }
                            else
                            {
                                item.prices = result2;
                                next(null, item);
                                
                                
                            }    
                            
                            
                        });
                    

                    }, function (err, transformedItems) { 
                        resolve(result1);
                     });
                   
                }
                else
                {
                    resolve(result1);
                }
           });

       });
*/
        var customizeoptions =  new Promise(function (resolve, reject) {
                connection.query("SELECT `id` as custLabelId, `product_id` as productId, `label_names` as labelNames FROM `tbl_products_customize_labels` WHERE product_id = ?  ",[productId],function(err,result){
                    if(err)
                    {
                        var dataArray=[];
                        resolve(dataArray); 
                    } 
                    else
                    {
                        if(result.length > 0)
                        {

                            connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ? ",[productId],function(err1,result1){
                            if(err)
                            {
                                var dataArray=[];
                                resolve(dataArray); 
                            } 
                            else
                            {
                                if(result1.length > 0)
                                {

                                    var priceContent1={};
                                    var priceContent2={};
                                    synceach(result1, function (item, next) {
                                        var price=[];
                                        priceContent1.labelNames=result[1].labelNames;
                                        priceContent2.labelNames=result[2].labelNames;
                                        price.push(priceContent1);
                                        price.push(priceContent2);
                                        console.log(price);
                                        item.prices=price;
                                        next(null, item);

                                    }, function (err, transformedItems) { 
                                        resolve(result1);
                                     });

                                }
                                else
                                {
                                    var dataArray=[];
                                    resolve(dataArray); 
                                }
                            }    

                    });
            
            
                        }
                        else
                        {
                            var dataArray=[];
                            resolve(dataArray); 
                        }
                    }    
                
            });
               


       }); 
            

        return promise.all([getcustomizelabels,customizeoptions]);
          
            
//        });
  
};

     /** send android push  */
exports.sendAndroidPush = function (client, notificationParams, device_token, title, message, customData) {
   
    var fcm = new FCM(config.CONSTANTS.FCM_KEY);
    console.log("fcm key : "+config.CONSTANTS.FCM_KEY);
    var custom_message = {
            to: device_token, // required fill with device token or topics
            collapse_key: '',
            data: customData,
            notification: {
                title: title,
                body: message
            }
            
        };

    console.log(JSON.stringify(custom_message));
        
    return new Promise(function (resolve, reject) {
        client.query("INSERT INTO notifications SET ? ", [notificationParams], function (notificationErr, notificationRess) {
                if (notificationErr) {
                    console.log("query error");
                } else {
                        console.log('custom message :'+JSON.stringify(custom_message));
                        fcm.send(custom_message, function (err, response) {
                                if (err) {
                                    console.log("natasha==Something has gone wrong!");
                                    console.error("********************"+err);
                                    resolve(false);
                                } else {
                                    console.log("hererr");
                                    console.log("natasha==Successfully sent with response: ", response);
                                    resolve(true);
                                }
                            });
                        resolve(true);

                }
            })

    });
};

/** send android push  */
//exports.sendiOSPush = function (client, notificationParams, customerNotificationStatus, device_token, bundleId  , title, message, custom_payload) {
exports.sendiOSPush = function (client,notificationParams,deviceToken,bundleId  , title, message, custom_payload) {
    var options = {
        token: {
            key: "AuthKey_C3KBU266JQ.p8",
            keyId: config.CONSTANTS.IOS_APN_KEY_ID,
            teamId: config.CONSTANTS.IOS_APN_KEY_TEAM_ID
        },
        /*proxy: {
            host: "192.168.10.92",
            port: 8080
        },*/
        production: true
    };
    
    var apnProvider = new apn.Provider(options);

    var note = new apn.Notification();

    note.expiry = Math.floor(Date.now() / 1000) + 3600; // Expires 1 hour from now.
    note.badge = 1;
    note.sound = "ping.aiff";
    note.alert = message; //message
    note.payload = custom_payload; //data
    note.topic = bundleId;
    note.title = title;
    console.log("note:"+JSON.stringify(note));
    console.log("credentials"+ JSON.stringify(options));
    console.log("apnProvider:"+JSON.stringify(apnProvider));
    
     return new Promise(function (resolve, reject) {
        client.query("INSERT INTO notifications SET ? ", [notificationParams], function (notificationErr, notificationRess) {
                if (notificationErr) {
                    console.log("query error");
                } else {
                        apnProvider.send(note, deviceToken).then((result) => {
                                if(result) {
                                    console.log("herrerre"+JSON.stringify(result));
                                    resolve(result);
                                }
                            })
                            .catch(function (err) {
                                console.log("error");
                                reject(false);
                            })
                }
            })
    })
 
   
};



/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~ sendOtpToMobile - START ~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    exports.sendOtpToMobile = function (phone, otp) {
       // console.log("inside sendOtpToMobile");
      phone = phone.replace(/^0+/, '');
      // Request.get("https://orderstatus.cafejavas.co.ug/user/sendSms/"+phone+"/"+otp, (error, response, body) => {
      // Request.get("http://localhost/cafejava_kenya/admin/public/user/sendSms/"+phone+"/"+otp, (error, response, body) => {
      Request.get("https://cjs.co.ke/user/sendSms/"+phone+"/"+otp, (error, response, body) => {
        if (error) {
            //console.log("========inside error part===========");
             console.error(error)
          return
        } else {
          //console.log("========inside response part===========");
          console.log(response)
        }
      });
//            const postData = querystring.stringify({
//           'Mocean-Username': 'citytyre',
//           'Mocean-Password': 'city2018',
//           'Mocean-From': 'CafeJavas',
// //          'Mocean-From': 'CityTyres',
//           'Mocean-To': '256'+phone,
//           'Mocean-Coding': '1',
//           'Mocean-Url-Text': '<#> Your CafeJava otp is '+otp+' 2eQpcFezydX'
//         });

//         const options = {
//           hostname: 'sms.smsone.co.ug',
//           port: 8866,
//           path: '/cgi-bin/sendsms',
//           method: 'POST',
//           headers: {
//             'Content-Type': 'application/x-www-form-urlencoded',
//             'Content-Length': Buffer.byteLength(postData)
//           }
//         };

//         const req = http.request(options, (res) => {
//         //  console.log(`STATUS: ${res.statusCode}`);
//         //  console.log(`HEADERS: ${JSON.stringify(res.headers)}`);
//           res.setEncoding('utf8');
//           res.on('data', (chunk) => {
//         //    console.log(`BODY: ${chunk}`);
//           });
//           res.on('end', () => {
//             console.log('No more data in response.');
//           });
//         });

//         req.on('error', (e) => {
//           console.error(`problem with request: ${e.message}`);
//         });

//         // write data to request body
//         req.write(postData);
//         req.end();
};
/*~~~~~~~~~~~~~~~ sendOtpToMobile - END  ~~~~~~~~~~~~~~~~~~*/


/**** Find userID by orderID  ****/
exports.getUserIdByOrderId = function (connection,orderId) {
    
    var query = "select user_id, is_guest_user from orders where order_id = ?";
    connection.query(query,[orderId],function(err,orderdata){
           
      if(err) {
        return 0;
      }
      else if(orderdata[0].is_guest_user == 1){
        return 0;
      } else {
        return orderdata[0].user_id;
      }     
    });
    
}

/**** Find userID by orderID  ****/
exports.getDriverIdByOrderId = function (connection,orderId) {
    
    var query = "select driver_id from orders where order_id = ?";
    connection.query(query,[orderId],function(err,orderdata){
           
      if(err) {
        return 0;
      }
      else {
        return orderdata[0].driver_id;
      }     
    });
    
}


     /** send android push  */
exports.loyaltyCashBurner = function (userId,loyaltyAmount) {
   
       
    return new Promise(function (resolve, reject) {
            var query = "select MEMBERSHIP_ID from T_MEMBER_DATA_MOBILE where UID = ?";
            db_client.query(query,[userId],function(err,memberData){
                   
              if(err) {
                return reject(err);
              }
              else {
                if(memberData[0].MEMBERSHIP_ID){
                  console.log(memberData[0].MEMBERSHIP_ID);


                  Request.post({
                      "headers": { "content-type": "application/json" ,"Authorization":"Basic Q0pQckRBZG1pTjpDSiNQckRAMTMy"},
                      "url": "https://81.199.139.82/Live_services/StandardAPI/RestAPI/EncashBurnerRestAPI.svc/EncashBurner",
                      "body": JSON.stringify({
                          "ObjEncashBurnerDetails":{"EncashValue":loyaltyAmount,"MembershipId":memberData[0].MEMBERSHIP_ID},"Token":"db70f2e351b5805d9ccf04513c32","UniqueID":" "
                      })
                  }, (error, response, body) => {
                      if (error) {
                      console.log("error========");
                      console.log(error);
                      console.log("error========");
                      return reject(error);
                      }
                      
                      let statusCheck = JSON.parse(body);

                      if(statusCheck.ResponseCode ==='001'){
                      	return resolve(statusCheck.RedemptionReferenceNumber);

                      }else if(statusCheck.ResponseCode ==='002'){
                      	return reject("Invalid Source URL");

                      }else if(statusCheck.ResponseCode ==='003'){
                      	return reject("Invalid Source Token");
                      	
                      }else if(statusCheck.ResponseCode ==='004'){
                      	return reject("Network connection error");
                      	
                      }else if(statusCheck.ResponseCode ==='005'){
                      	return reject("Service Down");
                      	
                      }else if(statusCheck.ResponseCode ==='006'){
                      	return reject("Mandatory Field Missing ");
                      	
                      }else if(statusCheck.ResponseCode ==='007'){
                      	return reject("Invalid/Bad Request Data");
                      	
                      }else if(statusCheck.ResponseCode ==='008'){
                      	return reject("Internal server Error");
                      	
                      }else if(statusCheck.ResponseCode ==='009'){
                      	return reject("Unique ID Already Exist");
                      	
                      }else if(statusCheck.ResponseCode ==='010'){
                      	return reject("Member Does Not Exist");
                      	
                      }else if(statusCheck.ResponseCode ==='011'){
                      	return reject("Transaction is locked for some time due to security reason");
                      	
                      }else if(statusCheck.ResponseCode ==='012'){
                      	return reject("Unique id Required");
                      	
                      }else {
                      	return reject("Invoice No already Exit");
                      	
                      }

                      //return resolve(memberData[0].MEMBERSHIP_ID);
                  });



                }else{

                  return resolve("memeber_not_found");

                }
                
              }     
            });

    });
};

exports.generateNextOrderIdAlias = (latestAlias) => {
    // If there's no alias yet for today, start with A001
    if (!latestAlias) {
        return 'A001';
    }

    // Split the latest alias into its letter and number parts
    let letterPart = latestAlias.charAt(0);
    let numberPart = parseInt(latestAlias.substring(1), 10);

    // Increment the number part
    if (numberPart < 400) {
        numberPart += 1;
    } else {
        // If number exceeds 400, reset to 001 and move to the next letter
        numberPart = 1;
        letterPart = letterPart < 'Z' ? String.fromCharCode(letterPart.charCodeAt(0) + 1) : 'A';
    }

    // Format the new alias with leading zeros
    return `${letterPart}${numberPart.toString().padStart(3, '0')}`;
};

/**** CODE END ****/

