var     bcrypt          = require('bcrypt-nodejs'),
        config          = require('../config/config.js'),
        promise         = require('promise'),
        forEach         = require('async-foreach').forEach,
        apn             = require('apn'),
        fs              = require("fs"),
        nodemailer      = require('nodemailer');
        var moment      = require('moment-timezone');
        moment.tz.setDefault("Etc/Universal");
        var synceach    = require('sync-each');
        
//iniatiate a Object
function custom_func() {
    
}

console.log(moment(new Date()).unix());

/***** randomString - START  ****/

exports.randomString = function () {
    var text = "";
    var possible = "abcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < 9; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}

/**** getUnix - START  ****/

exports.getUnix = function () {

    return  moment().unix();
}

/**** getCurrentUtcTime - START  ****/

exports.getCurrentUtcTime = function (){

    return  moment().format("YYYY-MM-DD H:mm:ss");
}


/**** makeResponse - START  ****/
exports.makeResponse = function (res, successStatus, status, message, appVersion, data) {
    
    // response
        res.set('Access-Control-Allow-Origin', '*');
        res.status(status).json({
            Success: successStatus,
            Status: status,
            Message: message,
            AppVersion: appVersion,
            Result: data

        });
    
}


/**** Find user detail by id  ****/
exports.findUserById = function (connection,userId) {
    
   return new promise(function(resolve,reject){
       var query = "call(getUserDetailById("+userId+")) ";
       connection.query(query,function(err,userdata){
           if(err)
           {
               resolve(false);
           }
           else
           {
            resolve(userdata);   
           }
           
       });
   });
    
}


/**** Find user detail by id  ****/
exports.checkValidUser = function (connection,userId) {
    
   return new promise(function(resolve,reject){
       var query = "select count(user_id) as totalrec from users where user_id = ? and is_delete = '0' and user_verified = '1' ";
       connection.query(query,[userId],function(err,userdata){
           
           if(err)
           {
               resolve(false);
           }
           else if(userdata[0].totalrec > 0)
           {
                resolve(true);   
           }
           else
           {
               resolve(false);
           }
           
       });
   });
    
}


/**** checkArray - START  ****/

exports.checkArrayResponse = function (arr) {
    var res = {
        status: (arr.length > 0) ? 200 : 200,
        message: (arr.length > 0) ? "Success" : "Data not found",
        result: arr
    }
    return res;
}

/**** customHeaders - START  ****/

exports.customHeaders = function (app, req, res, next) {
// Switch off the default 'X-Powered-By: Express' header
    app.disable('x-powered-by');
    // OR set your own header here
    res.setHeader('X-MedMe-App-Version', 'v1.0.0');
    // .. other headers here
    next();
}

/**** checknull - START  ****/

exports.checknull = function (value) {
    return (value == null) ? "" : value
}


/**** convertToBool - START  ****/

exports.convertToBool = function (value) {
    return (value === 0 || value === '0' || value === "true" || value === true) ? 1 : 0
}

/**** generateHash - START  ****/

exports.generateHash = function (password) {
    return bcrypt.hashSync(password, bcrypt.genSaltSync(8), null);
};



/**** verifyPassword - START ****/

exports.verifyPassword = function (password, dbPassword) {
    return bcrypt.compareSync(password, dbPassword);
};


/**** getRandomInteger - START  ****/

exports.getRandomInteger = function (min, max) {
    min = Math.ceil(min);
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min + 1)) + min;
}



/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~ MAIL sendMail - START ~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
exports.sendMail = function (to, subject, message) {
    var smtpConfig = {        
//        host: config.CONSTANTS.SMTP_HOST,
//        port: config.CONSTANTS.SMTP_PORT,
//        secure: false, // true for 465, false for other ports
        service: "Gmail",
        auth: {
            user: config.CONSTANTS.SMTP_USERNAME, // generated ethereal user
            pass: config.CONSTANTS.SMTP_PASSWORD // generated ethereal password
        }
    };
    console.log(smtpConfig);
    var transporter = nodemailer.createTransport(smtpConfig);
    var mailOptions = {
        from: config.CONSTANTS.SMTP_FROM, // sender address
        to: to, // list of receivers
        subject: subject, // Subject line
        //text: 'Hello world ?', // plaintext body
        html: message // html body
    };


    transporter.sendMail(mailOptions, function (error, info) {
        if (error) {
           console.log(error);
        } else {
            console.log(info.response);
        }
    });
};
/*~~~~~~~~~~~~~~~ MAIL sendMail - END  ~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Top Products with options and price ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/********************************************************************************
 * Create dropdown list options with value by label 
 * 
 ********************************************************************************/

var arrayCreateForTopOption = function(connection,productId){
    
    return function(topProductLabels) {       
        
        return new promise(function(resolve,reject){
          var q = connection.query("SELECT if(tplo.amount is NULL,0,tplo.amount) as price,tplo.`id` as labelOptionId, tplo.`label_id` as labelId, tplo.`product_id` as productId, tplo.`name` as optionName FROM `tbl_product_label_options` as tplo  WHERE tplo.product_id = ? and tplo.label_id = ?",[productId,topProductLabels.topLabelId],function(err,result){
              if(err)
              { 
                  var lableoptions= [];
                topProductLabels.labelOptions = lableoptions;
              }
              {
                  topProductLabels.labelOptions = result;
                  resolve(topProductLabels);
              }
                    
                 
             });
        });
    };
}


/********************************************************************************
 * Generate top level products label name 
 * 
 ********************************************************************************/

exports.getTopSubproducts = function(connection,productId){
    return new promise(function(resolve,reject){
        connection.query("SELECT `id` as topLabelId, `product_id` as productId, `label_names` as labelNames, `label_type` as labelType, `label_option_type` as labelOption FROM `tbl_products_labels` WHERE product_id = ? and label_type = '1' ",[productId],function(err,result){
           return promise.all(result.map(arrayCreateForTopOption(connection,productId))).then(function(data){   
               console.log("------------completed--------------");
//               console.log(data);
                resolve(data);
            });
        });
    }); 
};



/********************************************************************************
 * Generate customize product label names with prices
 * 
 ********************************************************************************/

exports.arrayCreateForCustomOption = function(connection,productId){
     return function(customizeProductLabels) {       
        
        return new promise(function(resolve,reject){
            var q = connection.query("SELECT tplop.amount as price,tplo.`id` as labelOptionId, tplo.`label_id` as labelId, tplo.`product_id` as productId, tplo.`name` as optionName FROM `tbl_products_customize_labels` as tplo join tbl_customize_product_label_options_price as tplop on tplo.id = tplop.label_option_id WHERE tplo.product_id = ? and tplo.label_id = ?",[productId,customizeProductLabels.topLabelId],function(err,result){
              if(err)
              { 
                  var lableoptions= [];
                customizeProductLabels.labelOptions = lableoptions;
              }
              {
                  customizeProductLabels.labelOptions = result;
                  resolve(customizeProductLabels);
              }
                    
                 
             });
        });
    };
};


/********************************************************************************
 * Additional products
 * 
 ********************************************************************************/


exports.additionalProducts = function(connection,productId){
    return new promise(function(resolve,reject){
        connection.query("SELECT `id` as additionalProductId, `product_id` as productId, `item_name` as itemName FROM `tbl_product_additional_items` WHERE  product_id = ? and is_delete='0' order by id desc",[productId],function(err,data){ 
                resolve(data);               
        });
    }); 
};


/********************************************************************************
 * Customize products top horizontal label name
 * 
 ********************************************************************************/


exports.customizeProducts = function(connection,productId){    
   
        
        var getcustomizelabels =   new Promise(function(resolve, reject){
                connection.query("SELECT `id` as custLabelId, `product_id` as productId, `label_names` as labelNames FROM `tbl_products_customize_labels` WHERE product_id = ?  ",[productId],function(err,result){
                    
                resolve(result);
                
            });
        });   
     
     /*
        var customizeoptions =  new Promise(function (resolve, reject) {
           var q = connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ?   ", [productId], function (err1, result1) {
                
                if(result1.length > 0)
                {
                    var items = result1;
                   forEach(result1,function(val,index,itemoptions){
                      
                        var q1 = connection.query("SELECT tpcl.label_names as labelNames,tcplo.`id` as custlabelOptionPriceId, tcplo.`product_id` as productId,tcplo.amount,tcplo.label_id as custLabelId,tcplo.label_option_id as custlabelOptionId FROM `tbl_customize_product_label_options_price` as tcplo join tbl_products_customize_labels as tpcl on tpcl.id=tcplo.label_id WHERE tcplo.label_option_id = ?   ", [val.custlabelOptionId], function (err1, result2) {
                            items[index]['prices'] = result2;
                            if(index == result1.length-1)
                            {                                
                                resolve(itemoptions);
                            }

                            
                        });
                       
                   }); 
                }
                else
                {
                    resolve(result1);
                }
           });

       });
          
       */

/*
console.log(".......................");
       var customizeoptions =  new Promise(function (resolve, reject) {
                connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ?   ", [productId], function (err1, result1) {
                
                if(result1.length > 0)
                {
                   
                    synceach(result1, function (item, next) { 
                            connection.query("SELECT tpcl.label_names as labelNames,tcplo.`id` as custlabelOptionPriceId, tcplo.`product_id` as productId,tcplo.amount,tcplo.label_id as custLabelId,tcplo.label_option_id as custlabelOptionId FROM `tbl_customize_product_label_options_price` as tcplo join tbl_products_customize_labels as tpcl on tpcl.id=tcplo.label_id WHERE tcplo.label_option_id = ?   ", [item.custlabelOptionId], function (err1, result2) {
                            if(err1)
                            {
                                item.prices=[];
                                next(null, item);
                            }
                            else
                            {
                                item.prices = result2;
                                next(null, item);
                                
                                
                            }    
                            
                            
                        });
                    

                    }, function (err, transformedItems) { 
                        resolve(result1);
                     });
                   
                }
                else
                {
                    resolve(result1);
                }
           });

       });     

*/


    var customizeoptions =  new Promise(function (resolve, reject) {
                connection.query("SELECT `id` as custLabelId, `product_id` as productId, `label_names` as labelNames FROM `tbl_products_customize_labels` WHERE product_id = ?  ",[productId],function(err,result){
                    if(err)
                    {
                        var dataArray=[];
                        resolve(dataArray); 
                    } 
                    else
                    {
                        if(result.length > 0)
                        {
                            
                            connection.query("SELECT `id` as custlabelOptionId, `product_id` as productId, `name` as labelNames FROM `tbl_product_customize_label_options` WHERE product_id = ? ",[productId],function(err1,result1){
                            if(err)
                            {
                                var dataArray=[];
                                resolve(dataArray); 
                            } 
                            else
                            {
                                if(result1.length > 0)
                                {
                                   
                                    var priceContent1={};
                                    var priceContent2={};
                                    synceach(result1, function (item, next) {
                                        var price=[];
                                        priceContent1.labelNames=result[1].labelNames;
                                        priceContent2.labelNames=result[2].labelNames;
                                        price.push(priceContent1);
                                        price.push(priceContent2);
                                        console.log(price);
                                        item.prices=price;
                                        next(null, item);

                                    }, function (err, transformedItems) { 
                                        resolve(result1);
                                     });

                                }
                                else
                                {
                                    var dataArray=[];
                                    resolve(dataArray); 
                                }
                            }    

                    });
            
            
                        }
                        else
                        {
                            var dataArray=[];
                            resolve(dataArray); 
                        }
                    }    
                
            });
               


       }); 
            


        return promise.all([getcustomizelabels,customizeoptions]);
          
            
//        });
  
};



/**** CODE END ****/
